/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.csv;

import com.github.jlangch.venice.VncException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVReader {
    private final String separator;
    private final String quote;
    private final String doubleQuotes;
    private final Matcher matcher;

    public CSVReader() {
        this(',', '\"');
    }

    public CSVReader(char separator, char quote) {
        this.separator = String.valueOf(separator);
        this.quote = String.valueOf(quote);
        this.doubleQuotes = this.quote + this.quote;
        this.matcher = Pattern.compile(this.makeRegex()).matcher("");
    }

    public List<List<String>> parse(String csv) {
        return this.parse(new StringReader(csv));
    }

    public List<List<String>> parse(InputStream is, String encoding) {
        try {
            return this.parse(new InputStreamReader(is, encoding == null ? "utf-8" : encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new VncException("Unsupported encoding '" + encoding + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<String>> parse(Reader reader) {
        ArrayList<List<String>> records = new ArrayList<List<String>>();
        try (Reader rd = reader;){
            BufferedReader br = new BufferedReader(rd);
            String l = br.readLine();
            while (true) {
                int ii;
                ArrayList<String> parsedItems;
                List<String> items;
                if (l != null) {
                    items = this.split(l);
                    parsedItems = new ArrayList<String>();
                    ii = 0;
                } else {
                    ArrayList<List<String>> arrayList = records;
                    return arrayList;
                }
                while (ii < items.size()) {
                    String v = items.get(ii);
                    if (v.equals(this.separator)) {
                        parsedItems.add(null);
                        ++ii;
                        continue;
                    }
                    parsedItems.add(this.unquote(v));
                    ii += 2;
                }
                records.add(parsedItems);
                l = br.readLine();
            }
        }
        catch (Exception ex) {
            throw new VncException("Failed to parse CSV", ex);
        }
    }

    public List<String> split(String line) {
        this.matcher.reset(line);
        ArrayList<String> items = new ArrayList<String>();
        while (this.matcher.find()) {
            items.add(this.unquote(this.matcher.group()));
        }
        return items;
    }

    private String unquote(String item) {
        if (item.startsWith(this.quote) && item.endsWith(this.quote)) {
            return item.substring(1, item.length() - 1).replace(this.doubleQuotes, this.quote);
        }
        return item;
    }

    private String makeRegex() {
        return String.format("[%s]|[^%s%s]+|[%s](?:[^%s]|[%s][%s])*[%s]", this.separator, this.separator, this.quote, this.quote, this.quote, this.quote, this.quote, this.quote);
    }
}

