/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.impl.util.reflect.ReflectionTypes;
import com.github.jlangch.venice.impl.util.reflect.ScopedEnumValue;
import java.nio.ByteBuffer;

public class ArgTypeMatcher {
    public static boolean isCongruent(Class<?>[] params, Object[] args, boolean exactMatch, boolean varargs) {
        if (args == null) {
            return params.length == 0;
        }
        if (params.length == args.length) {
            for (int ii = 0; ii < params.length; ++ii) {
                boolean match;
                Object arg = args[ii];
                Class<?> argType = arg == null ? null : arg.getClass();
                Class<?> paramType = params[ii];
                if (ReflectionTypes.isEnumType(paramType)) {
                    if (arg == null) continue;
                    if (arg instanceof String) {
                        ScopedEnumValue scopedEnum = new ScopedEnumValue((String)arg);
                        if (!scopedEnum.isScoped() || scopedEnum.isCompatible(paramType)) continue;
                        return false;
                    }
                    return false;
                }
                boolean bl = match = exactMatch ? ArgTypeMatcher.paramArgTypeMatchExact(paramType, argType) : ArgTypeMatcher.paramArgTypeMatch(paramType, argType);
                if (match) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean paramArgTypeMatchExact(Class<?> paramType, Class<?> argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Byte.TYPE || paramType == Byte.class || paramType == Short.TYPE || paramType == Short.class || paramType == Integer.TYPE || paramType == Integer.class || paramType == Long.TYPE || paramType == Long.class) {
            return argType == Byte.class || argType == Short.class || argType == Integer.class || argType == Long.class;
        }
        if (paramType == Float.TYPE || paramType == Float.class || paramType == Double.TYPE || paramType == Double.class) {
            return argType == Float.class || argType == Double.class;
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return argType == Boolean.class;
        }
        return false;
    }

    private static boolean paramArgTypeMatch(Class<?> paramType, Class<?> argType) {
        if (argType == null) {
            return !paramType.isPrimitive();
        }
        if (paramType == argType || paramType.isAssignableFrom(argType)) {
            return true;
        }
        if (paramType == Byte.TYPE || paramType == Byte.class || paramType == Short.TYPE || paramType == Short.class || paramType == Integer.TYPE || paramType == Integer.class || paramType == Long.TYPE || paramType == Long.class || paramType == Float.TYPE || paramType == Float.class || paramType == Double.TYPE || paramType == Double.class) {
            return argType == Byte.class || argType == Short.class || argType == Integer.class || argType == Long.class || argType == Float.class || argType == Double.class;
        }
        if (paramType == Character.TYPE || paramType == Character.class) {
            return argType == Character.class;
        }
        if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            return argType == Boolean.class;
        }
        if (ReflectionTypes.isArrayType(paramType)) {
            Class<?> paramComponentType = paramType.getComponentType();
            if (paramComponentType == Byte.TYPE) {
                if (argType == String.class) {
                    return true;
                }
                if (ByteBuffer.class.isAssignableFrom(argType)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

