/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.pdf;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfString;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.pdf.DefaultPDFCreationListener;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class PdfMetaDataCreationListener
extends DefaultPDFCreationListener {
    final Properties headMetaTags = new Properties();

    public PdfMetaDataCreationListener parseMetaTags(Document sourceXHTML) {
        Element titleTag;
        Element headTag = (Element)sourceXHTML.getDocumentElement().getElementsByTagName("head").item(0);
        if (headTag == null) {
            return this;
        }
        NodeList metaTags = headTag.getElementsByTagName("meta");
        if (metaTags == null) {
            return this;
        }
        for (int ii = 0; ii < metaTags.getLength(); ++ii) {
            Element tag = (Element)metaTags.item(ii);
            String name = tag.getAttribute("name");
            String content = tag.getAttribute("content");
            if (name.isEmpty() || content.isEmpty()) continue;
            this.headMetaTags.setProperty(name, content);
        }
        if (this.headMetaTags.getProperty("title") == null && (titleTag = (Element)headTag.getElementsByTagName("title").item(0)) != null) {
            this.headMetaTags.setProperty("title", titleTag.getTextContent());
        }
        return this;
    }

    public void preOpen(ITextRenderer iTextRenderer) {
        Enumeration<?> e = this.headMetaTags.propertyNames();
        block16: while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            PdfString val = new PdfString(this.headMetaTags.getProperty(key), "UnicodeBig");
            iTextRenderer.getWriter().setViewerPreferences(131072);
            switch (key) {
                case "title": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.TITLE, (PdfObject)val);
                    continue block16;
                }
                case "author": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.AUTHOR, (PdfObject)val);
                    continue block16;
                }
                case "subject": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.SUBJECT, (PdfObject)val);
                    continue block16;
                }
                case "creator": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.CREATOR, (PdfObject)val);
                    continue block16;
                }
                case "description": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.DESC, (PdfObject)val);
                    continue block16;
                }
                case "keywords": {
                    iTextRenderer.getWriter().getInfo().put(PdfName.KEYWORDS, (PdfObject)val);
                    continue block16;
                }
            }
            iTextRenderer.getWriter().getInfo().put(new PdfName(key), (PdfObject)val);
        }
    }
}

