/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.AnonymousFnArgs;
import com.github.jlangch.venice.impl.AutoGenSym;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.Token;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncTinyVector;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Reader {
    private static final Pattern atom_pattern = Pattern.compile("(?s)(^-?[0-9]+$)|(^-?[0-9]+I$)|(^-?[0-9][0-9.]*$)|(^-?[0-9][0-9.]*M$)|(^nil$)|(^true$)|(^false$)|^\"{3}(.*)\"{3}$|^\"(.*)\"$|:(.*)|(^[^\"]*$)");
    private static final Pattern tokenize_pattern = Pattern.compile("[\\s ,]*(~@|\\^|[\\[\\]{}()'`~@]|\"{3}(?:[\\s\\S]*?)\"{3}|\"{3}(?:[\\s\\S]*)|\"(?:[\\\\].|[^\\\\\"])*\"|\"(?:[\\\\].|[^\\\\\"])*|;.*|[^\\s \\[\\]{}()'\"`~@,;]*)");
    private final String filename;
    private final String form;
    private ArrayList<Token> tokens;
    private int position;
    private final AnonymousFnArgs anonymousFnArgs = new AnonymousFnArgs();
    private final AutoGenSym autoGenSym = new AutoGenSym();

    private Reader(String filename, String form, ArrayList<Token> formTokens) {
        this.filename = filename;
        this.form = form;
        this.tokens = formTokens;
        this.position = 0;
    }

    public static Reader reader(String str, String filename) {
        return new Reader(filename, str, Reader.tokenize(str, filename));
    }

    public static VncVal read_str(String str, String filename) {
        return Reader.read_form(Reader.reader(str, filename));
    }

    public String unprocessedRest() {
        return this.lastReadPos() < 0 ? this.form : this.form.substring(this.lastReadPos());
    }

    public int lastReadPos() {
        return this.position == 0 ? -1 : this.tokens.get(this.position - 1).getFileEndPos();
    }

    public String toString() {
        return this.tokens.stream().map(t -> String.format("%-8s %s", String.format("%d,%d:", t.getLine(), t.getColumn()), t.getToken())).collect(Collectors.joining("\n"));
    }

    private Token peek() {
        return this.position >= this.tokens.size() ? null : this.tokens.get(this.position);
    }

    private Token next() {
        return this.tokens.get(this.position++);
    }

    public static ArrayList<Token> tokenize(String str, String filename) {
        return Reader.tokenize(str, filename, true);
    }

    public static ArrayList<Token> tokenize(String str, String filename, boolean errorOnUnbalancedStringQuotes) {
        char[] strArr = str.toCharArray();
        Matcher matcher = tokenize_pattern.matcher(str);
        int[] lastPos = new int[]{1, 1};
        int lastStartPos = 0;
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (matcher.find()) {
            int[] pos;
            int tokenStartPos;
            String token = matcher.group(1);
            if (token == null || token.equals("")) continue;
            if (token.startsWith("\"\"\"") && !token.endsWith("\"\"\"") && errorOnUnbalancedStringQuotes) {
                tokenStartPos = matcher.start(1);
                pos = Reader.getTextPosition(strArr, tokenStartPos, lastStartPos, lastPos[0], lastPos[1]);
                throw new EofException(Reader.formatParseError(new Token(token, filename, tokenStartPos, pos[0], pos[1]), "Expected closing \"\"\" for triple quoted string but got EOF", new Object[0]));
            }
            if (token.startsWith("\"") && !token.endsWith("\"") && errorOnUnbalancedStringQuotes) {
                tokenStartPos = matcher.start(1);
                pos = Reader.getTextPosition(strArr, tokenStartPos, lastStartPos, lastPos[0], lastPos[1]);
                throw new ParseError(Reader.formatParseError(new Token(token, filename, tokenStartPos, pos[0], pos[1]), "Expected closing \" for single quoted string but got EOL", new Object[0]));
            }
            if (token.charAt(0) == ';') continue;
            tokenStartPos = matcher.start(1);
            pos = Reader.getTextPosition(strArr, tokenStartPos, lastStartPos, lastPos[0], lastPos[1]);
            tokens.add(new Token(token, filename, tokenStartPos, pos[0], pos[1]));
            lastStartPos = tokenStartPos;
            lastPos = pos;
        }
        return tokens;
    }

    private static VncVal read_atom(Reader rdr) {
        Token token = rdr.next();
        Matcher matcher = atom_pattern.matcher(token.getToken());
        if (!matcher.find()) {
            throw new ParseError(Reader.formatParseError(token, "Unrecognized token '%s'", token.getToken()));
        }
        if (matcher.group(1) != null) {
            return new VncLong(Long.parseLong(matcher.group(1)), MetaUtil.toMeta(token));
        }
        if (matcher.group(2) != null) {
            String intVal = matcher.group(2);
            intVal = intVal.substring(0, intVal.length() - 1);
            return new VncInteger(Integer.parseInt(intVal), MetaUtil.toMeta(token));
        }
        if (matcher.group(3) != null) {
            return new VncDouble(Double.parseDouble(matcher.group(3)), MetaUtil.toMeta(token));
        }
        if (matcher.group(4) != null) {
            String dec = matcher.group(4);
            dec = dec.substring(0, dec.length() - 1);
            return new VncBigDecimal(new BigDecimal(dec), MetaUtil.toMeta(token));
        }
        if (matcher.group(5) != null) {
            return Constants.Nil;
        }
        if (matcher.group(6) != null) {
            return VncBoolean.True;
        }
        if (matcher.group(7) != null) {
            return VncBoolean.False;
        }
        if (matcher.group(8) != null) {
            String s = StringUtil.stripIndentIfFirstLineEmpty(Reader.unescapeAndDecodeUnicode(matcher.group(8)));
            return Reader.interpolate(s, rdr.filename, token.getLine(), token.getColumn()).withMeta(MetaUtil.toMeta(token));
        }
        if (matcher.group(9) != null) {
            String s = Reader.unescapeAndDecodeUnicode(matcher.group(9));
            return Reader.interpolate(s, rdr.filename, token.getLine(), token.getColumn()).withMeta(MetaUtil.toMeta(token));
        }
        if (matcher.group(10) != null) {
            return new VncKeyword(matcher.group(10), MetaUtil.toMeta(token));
        }
        if (matcher.group(11) != null) {
            VncSymbol sym = new VncSymbol(matcher.group(11));
            if (rdr.autoGenSym.isWithinSyntaxQuote() && rdr.autoGenSym.isAutoGenSymbol(sym)) {
                return rdr.autoGenSym.lookup(sym);
            }
            rdr.anonymousFnArgs.addSymbol(sym);
            return sym.withMeta(MetaUtil.toMeta(token));
        }
        throw new ParseError(Reader.formatParseError(token, "Unrecognized '%s'", matcher.group(0)));
    }

    private static VncSequence read_list(Reader rdr, VncSequence lst, char start, char end) {
        Token lstToken = rdr.next();
        if (lstToken.charAt(0) != start) {
            throw new ParseError(Reader.formatParseError(lstToken, "Expected '%c'", Character.valueOf(start)));
        }
        ArrayList<VncVal> items = new ArrayList<VncVal>();
        Token token = lstToken;
        while ((token = rdr.peek()) != null && token.charAt(0) != end) {
            items.add(Reader.read_form(rdr));
        }
        if (token == null) {
            throw new EofException(Reader.formatParseError(token, "Expected '%c', got EOF", Character.valueOf(end)));
        }
        rdr.next();
        return lst.withValues(items, MetaUtil.toMeta(lstToken));
    }

    private static VncHashMap read_hash_map(Reader rdr) {
        Token refToken = rdr.peek();
        VncSequence lst = Reader.read_list(rdr, VncTinyList.empty(), '{', '}');
        return VncHashMap.ofAll(lst).withMeta(MetaUtil.toMeta(refToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VncVal read_form(Reader rdr) {
        VncVal form;
        Token token = rdr.peek();
        if (token == null) {
            throw new ContinueException();
        }
        switch (token.charAt(0)) {
            case '\'': {
                rdr.next();
                return VncTinyList.of(new VncSymbol("quote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '`': {
                rdr.next();
                try {
                    rdr.autoGenSym.enterSyntaxQuote();
                    VncList vncList = VncTinyList.of(new VncSymbol("quasiquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
                    return vncList;
                }
                finally {
                    rdr.autoGenSym.leaveSyntaxQuote();
                }
            }
            case '~': {
                if (token.equals("~")) {
                    rdr.next();
                    return VncTinyList.of(new VncSymbol("unquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
                }
                rdr.next();
                return VncTinyList.of(new VncSymbol("splice-unquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '^': {
                rdr.next();
                Token metaToken = rdr.peek();
                VncVal meta = Reader.read_form(rdr);
                if (Types.isVncKeyword(meta)) {
                    meta = VncHashMap.of(meta, VncBoolean.True);
                }
                if (Types.isVncMap(meta)) {
                    Token symToken = rdr.peek();
                    return Reader.read_form(rdr).withMeta(MetaUtil.mergeMeta(meta, MetaUtil.toMeta(symToken)));
                }
                throw new ParseError(Reader.formatParseError(metaToken, "Invalid meta data type %s", Types.getType(meta)));
            }
            case '@': {
                rdr.next();
                return VncTinyList.of(new VncSymbol("deref"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '#': {
                rdr.next();
                Token t = rdr.peek();
                if (t.charAt(0) == '{') {
                    form = VncHashSet.ofAll(Reader.read_list(rdr, VncTinyList.empty(), '{', '}'));
                    break;
                }
                if (t.charAt(0) == '(') {
                    VncVal meta = MetaUtil.toMeta(t);
                    if (rdr.anonymousFnArgs.isCapturing()) {
                        throw new ParseError(Reader.formatParseError(t, " #() forms cannot be nested", new Object[0]));
                    }
                    rdr.anonymousFnArgs.startCapture();
                    VncSequence body = Reader.read_list(rdr, VncTinyList.empty(), '(', ')').withMeta(meta);
                    VncVector argsDef = rdr.anonymousFnArgs.buildArgDef().withMeta(meta);
                    form = VncTinyList.of(new VncSymbol("fn", meta), argsDef, body);
                    rdr.anonymousFnArgs.stopCapture();
                    break;
                }
                throw new ParseError(Reader.formatParseError(t, "Expected '{' or '('", new Object[0]));
            }
            case '(': {
                form = Reader.read_list(rdr, VncTinyList.empty(), '(', ')');
                break;
            }
            case ')': {
                throw new ParseError(Reader.formatParseError(token, "Unexpected ')'", new Object[0]));
            }
            case '[': {
                form = Reader.read_list(rdr, VncTinyVector.empty(), '[', ']');
                break;
            }
            case ']': {
                throw new ParseError(Reader.formatParseError(token, "Unexpected ']'", new Object[0]));
            }
            case '{': {
                form = Reader.read_hash_map(rdr);
                break;
            }
            case '}': {
                throw new ParseError(Reader.formatParseError(token, "Unexpected '}'", new Object[0]));
            }
            default: {
                form = Reader.read_atom(rdr);
            }
        }
        return form;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VncVal interpolate(String s, String filename, int line, int column) {
        int pos = Reader.getFirstInterpolationFormStartPos(s);
        if (pos < 0) {
            return new VncString(s);
        }
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        list.add(CoreFunctions.str);
        String str = s;
        while (true) {
            String tail;
            String rest;
            if (pos > 0) {
                list.add(new VncString(str.substring(0, pos)));
            }
            if ((rest = str.substring(pos)).startsWith("~(")) {
                String s_ = rest.substring(1);
                Reader rdr = new Reader(filename, s_, Reader.tokenize(s_, filename, false));
                list.add(Reader.read_list(rdr, VncTinyList.empty(), '(', ')'));
                tail = rdr.unprocessedRest().substring(1);
            } else {
                if (!rest.startsWith("~{")) throw new ParseError(Reader.formatParseError(filename, line, column, "Interpolation error. Expected \"~(\" or \"~{\"", new Object[0]));
                int endPos = rest.indexOf(125);
                if (endPos <= 2) throw new ParseError(Reader.formatParseError(filename, line, column, "Invalid value interpolation expression\"~{..}\" ", new Object[0]));
                String expr = rest.substring(2, endPos);
                Reader rdr = Reader.reader(expr, filename);
                list.add(Reader.read_form(rdr));
                tail = rest.substring(endPos + 1);
            }
            pos = Reader.getFirstInterpolationFormStartPos(tail);
            if (pos < 0) {
                if (tail.isEmpty()) return new VncList(list);
                list.add(new VncString(tail));
                return new VncList(list);
            }
            str = tail;
        }
    }

    public static VncVal interpolate_(String s, String filename) {
        int pos = Reader.getFirstInterpolationFormStartPos(s);
        if (pos < 0) {
            return new VncString(s);
        }
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        list.add(CoreFunctions.str);
        String str = s;
        while (true) {
            String rest;
            if (pos > 0) {
                list.add(new VncString(str.substring(0, pos)));
            }
            int offset = (rest = str.substring(pos)).startsWith("~{") ? 2 : 1;
            Reader rdr = Reader.reader(rest.substring(offset), filename);
            list.add(Reader.read_form(rdr));
            String tail = rdr.unprocessedRest().substring(offset);
            pos = Reader.getFirstInterpolationFormStartPos(tail);
            if (pos < 0) {
                if (!tail.isEmpty()) {
                    list.add(new VncString(tail));
                }
                return new VncList(list);
            }
            str = tail;
        }
    }

    private static int getFirstInterpolationFormStartPos(String s) {
        int p1 = s.indexOf("~{");
        int p2 = s.indexOf("~(");
        return p1 < 0 || p2 < 0 ? Math.max(p1, p2) : Math.min(p1, p2);
    }

    private static String unescapeAndDecodeUnicode(String s) {
        return Reader.unescape(StringUtil.decodeUnicode(s));
    }

    private static String unescape(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = text.toCharArray();
        int len = chars.length;
        int ii = 0;
        block10: while (ii < len) {
            char c;
            if ((c = chars[ii++]) == '\\' && ii < len) {
                switch (chars[ii++]) {
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                    case '\r': {
                        if (ii < len && chars[ii] == '\n') {
                            ++ii;
                            continue block10;
                        }
                        sb.append("\\\r");
                        continue block10;
                    }
                    case '\n': {
                        continue block10;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int[] getTextPosition(char[] text, int pos, int startPos, int startRow, int startCol) {
        int row = startRow;
        int col = startCol;
        block5: for (int ii = startPos; ii < pos; ++ii) {
            switch (text[ii]) {
                case '\n': {
                    ++row;
                    col = 1;
                    continue block5;
                }
                case '\r': {
                    continue block5;
                }
                case '\t': {
                    col += 4;
                    continue block5;
                }
                default: {
                    ++col;
                }
            }
        }
        return new int[]{row, col};
    }

    private static String formatParseError(Token token, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(token);
    }

    private static String formatParseError(String filename, int line, int column, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(filename, line, column);
    }
}

