/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.util.NullOutputStream;
import java.io.PrintStream;
import org.jline.terminal.Terminal;

public class ReplPrintStream
extends PrintStream {
    private final Terminal terminal;
    private final String colorEscape;

    public ReplPrintStream(Terminal terminal, String colorEscape) {
        super(new NullOutputStream());
        this.terminal = terminal;
        this.colorEscape = colorEscape;
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.print(csq == null ? "null" : csq.toString());
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.print(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public PrintStream append(char c) {
        this.print(c);
        return this;
    }

    @Override
    public void print(boolean x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(int x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(long x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(float x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(double x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(char[] x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(Object x) {
        this.print(String.valueOf(x));
    }

    @Override
    public void print(String s) {
        this.printToTerminal(s);
    }

    @Override
    public void println() {
        this.println("");
    }

    @Override
    public void println(boolean x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(int x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(long x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(float x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(double x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(char[] x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    @Override
    public void println(String s) {
        this.printToTerminal(s + "\n");
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        throw new RuntimeException("Method write(byte[],int,int) is not supported");
    }

    @Override
    public void write(int b) {
        throw new RuntimeException("Method write(int) is not supported");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printToTerminal(String s) {
        ReplPrintStream replPrintStream = this;
        synchronized (replPrintStream) {
            if (this.colorEscape != null) {
                this.terminal.writer().print(this.colorEscape);
            }
            this.terminal.writer().print(s);
            if (this.colorEscape != null) {
                this.terminal.writer().print("\u001b[0m");
            }
            this.terminal.flush();
        }
    }
}

