/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.ValueException;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import java.util.function.Consumer;
import org.jline.terminal.Terminal;

public class TerminalPrinter {
    private final Terminal terminal;
    private final boolean dumbTerminal;
    private final ReplConfig config;
    private boolean printJavaEx;

    public TerminalPrinter(ReplConfig config, Terminal terminal, boolean dumbTerminal, boolean printJavaEx) {
        this.config = config;
        this.terminal = terminal;
        this.dumbTerminal = dumbTerminal;
        this.printJavaEx = printJavaEx;
    }

    public void setPrintJavaEx(boolean printJavaEx) {
        this.printJavaEx = printJavaEx;
    }

    public void print(String colorID, Consumer<Terminal> fn) {
        String color = this.getColor(colorID);
        if (color != null) {
            this.terminal.writer().print(color);
        }
        fn.accept(this.terminal);
        if (color != null) {
            this.terminal.writer().print("\u001b[0m");
        }
        this.terminal.flush();
    }

    public void println() {
        this.terminal.writer().println();
        this.terminal.flush();
    }

    public void println(String colorID, String text) {
        this.print(colorID, t -> t.writer().print(text));
        this.terminal.writer().println();
        this.terminal.flush();
    }

    public void printex(String colorID, Throwable ex) {
        try {
            if (ex instanceof ValueException) {
                this.print(colorID, t -> ((ValueException)ex).printVeniceStackTrace(t.writer()));
                this.println(colorID, "Thrown value: " + Printer.pr_str(((ValueException)ex).getValue(), false));
            } else if (ex instanceof VncException) {
                if (this.printJavaEx) {
                    this.print(colorID, t -> ex.printStackTrace(t.writer()));
                } else {
                    this.print(colorID, t -> ((VncException)ex).printVeniceStackTrace(t.writer()));
                }
            } else {
                this.print(colorID, t -> ex.printStackTrace(t.writer()));
            }
        }
        catch (Throwable e) {
            System.out.println("Internal REPL error while printing exception.");
            e.printStackTrace();
        }
    }

    private String getColor(String colorID) {
        return this.dumbTerminal ? null : this.config.getColor(colorID);
    }
}

