/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.SpecialForms;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.custom.VncChoiceTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.Doc;

public class DocForm {
    public static VncString doc(VncVal ref, Env env) {
        if (Types.isVncSymbol(ref)) {
            return DocForm.docForSymbol((VncSymbol)ref, env);
        }
        if (Types.isVncKeyword(ref)) {
            return DocForm.docForCustomType((VncKeyword)ref, env);
        }
        if (Types.isVncString(ref)) {
            return DocForm.docForSymbol(((VncString)ref).toSymbol(), env);
        }
        VncString name = (VncString)CoreFunctions.name.apply(VncTinyList.of(ref));
        return DocForm.docForSymbol(name.toSymbol(), env);
    }

    private static VncString docForSymbol(VncSymbol sym, Env env) {
        VncVal docVal = SpecialForms.ns.get(sym);
        if (docVal == null) {
            docVal = env.get(sym);
        }
        return Doc.getDoc(docVal);
    }

    private static VncString docForCustomType(VncKeyword type, Env env) {
        VncVal tdef = env.getGlobalOrNull(type.toSymbol());
        if (tdef == null) {
            if (Namespaces.isQualified(type)) {
                throw new VncException(String.format(":%s is not a custom type. No documentation available!", type.getValue()));
            }
            throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
        }
        if (tdef instanceof VncCustomTypeDef) {
            VncCustomTypeDef typeDef = (VncCustomTypeDef)tdef;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom type :%s\n", type.getValue()));
            sb.append("Fields: \n");
            typeDef.getFieldDefs().forEach(f -> sb.append(String.format("   %s :%s\n", f.getName().getValue(), f.getType().getValue())));
            if (typeDef.getValidationFn() != null) {
                sb.append(String.format("Validation function: :%s\n", typeDef.getValidationFn().getQualifiedName()));
            }
            return new VncString(sb.toString());
        }
        if (tdef instanceof VncWrappingTypeDef) {
            VncWrappingTypeDef typeDef = (VncWrappingTypeDef)tdef;
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom wrapped type :%s\n", type.getValue()));
            sb.append(String.format("Base type :%s\n", typeDef.getBaseType().getValue()));
            if (typeDef.getValidationFn() != null) {
                sb.append(String.format("Validation function: :%s\n", typeDef.getValidationFn().getQualifiedName()));
            }
            return new VncString(sb.toString());
        }
        if (tdef instanceof VncChoiceTypeDef) {
            VncChoiceTypeDef typeDef = (VncChoiceTypeDef)tdef;
            VncSet types = typeDef.typesOnly();
            VncSet values = typeDef.valuesOnly();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Custom choice type :%s\n", type.getValue()));
            if (!types.isEmpty()) {
                sb.append("Types: \n");
                typeDef.typesOnly().getList().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
            }
            if (!values.isEmpty()) {
                sb.append("Values: \n");
                typeDef.valuesOnly().getList().forEach(v -> sb.append(String.format("   %s\n", v.toString())));
            }
            return new VncString(sb.toString());
        }
        throw new VncException(String.format(":%s is not a custom type. Please qualify the type with its namespace!", type.getValue()));
    }
}

