/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VncCustomType
extends VncMap {
    public static final VncKeyword TYPE = new VncKeyword(":core/custom-type");
    private static final long serialVersionUID = -1848883965231344442L;
    private final VncKeyword type;
    private final VncCustomTypeDef typeDef;
    private final VncMap values;

    public VncCustomType(VncCustomTypeDef typeDef, VncMap values, VncVal meta) {
        this(typeDef, values, null, meta);
    }

    public VncCustomType(VncCustomTypeDef typeDef, VncMap values, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.type = typeDef.getType();
        this.typeDef = typeDef;
        this.values = values;
    }

    @Override
    public VncCustomType emptyWithMeta() {
        throw new VncException("not supported");
    }

    @Override
    public VncCustomType withValues(Map<VncVal, VncVal> replaceVals) {
        throw new VncException("not supported");
    }

    @Override
    public VncCustomType withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        throw new VncException("not supported");
    }

    @Override
    public VncCustomType wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncCustomType(this.typeDef, this.values, wrappingTypeDef, meta);
    }

    @Override
    public VncCustomType withMeta(VncVal meta) {
        return new VncCustomType(this.typeDef, this.values, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.type;
    }

    @Override
    public VncKeyword getSupertype() {
        return TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(TYPE, VncMap.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    public VncCustomTypeDef getTypeDef() {
        return this.typeDef;
    }

    @Override
    public Map<VncVal, VncVal> getMap() {
        return this.values.getMap();
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return this.values.containsKey(key);
    }

    @Override
    public VncVal get(VncVal key) {
        return this.values.get(key);
    }

    @Override
    public VncList keys() {
        return new VncList(new ArrayList<VncVal>(this.getMap().keySet()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.getMap().entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncMap putAll(VncMap map) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap assoc(VncVal ... mvs) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap assoc(VncSequence mvs) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap dissoc(VncVal ... keys) {
        throw new VncException("not supported");
    }

    @Override
    public VncMap dissoc(VncSequence keys) {
        throw new VncException("not supported");
    }

    @Override
    public VncList toVncList() {
        return this.values.toVncList();
    }

    @Override
    public VncVector toVncVector() {
        return this.values.toVncVector();
    }

    public VncMap toVncMap() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.CUSTOMTYPE;
    }

    @Override
    public Object convertToJavaObject() {
        return this.values.convertToJavaObject();
    }

    @Override
    public int compareTo(VncVal o) {
        return this.values.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncCustomType other = (VncCustomType)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    public String toString() {
        return "#:" + this.type.getValue() + this.values.toString();
    }

    @Override
    public String toString(boolean print_readably) {
        return "#:" + this.type.getValue() + this.values.toString(print_readably);
    }
}

