/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.MathOp;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Numeric {
    public static VncInteger toInteger(VncVal val) {
        if (Types.isVncInteger(val)) {
            return (VncInteger)val;
        }
        if (Types.isVncLong(val)) {
            return Numeric.longToInt((VncLong)val);
        }
        if (Types.isVncDouble(val)) {
            return Numeric.doubleToInt((VncDouble)val);
        }
        if (Types.isVncBigDecimal(val)) {
            return Numeric.decimalToInt((VncBigDecimal)val);
        }
        throw new VncException(String.format("Cannot convert value of type %s to long", Types.getType(val)));
    }

    public static VncLong toLong(VncVal val) {
        if (Types.isVncLong(val)) {
            return (VncLong)val;
        }
        if (Types.isVncInteger(val)) {
            return Numeric.intToLong((VncInteger)val);
        }
        if (Types.isVncDouble(val)) {
            return Numeric.doubleToLong((VncDouble)val);
        }
        if (Types.isVncBigDecimal(val)) {
            return Numeric.decimalToLong((VncBigDecimal)val);
        }
        throw new VncException(String.format("Cannot convert value of type %s to long", Types.getType(val)));
    }

    public static VncDouble toDouble(VncVal val) {
        if (Types.isVncLong(val)) {
            return Numeric.longToDouble((VncLong)val);
        }
        if (Types.isVncInteger(val)) {
            return Numeric.intToDouble((VncInteger)val);
        }
        if (Types.isVncDouble(val)) {
            return (VncDouble)val;
        }
        if (Types.isVncBigDecimal(val)) {
            return Numeric.decimalToDouble((VncBigDecimal)val);
        }
        throw new VncException(String.format("Cannot convert value of type %s to double", Types.getType(val)));
    }

    public static VncBigDecimal toDecimal(VncVal val) {
        if (Types.isVncLong(val)) {
            return Numeric.longToDecimal((VncLong)val);
        }
        if (Types.isVncInteger(val)) {
            return Numeric.intToDecimal((VncInteger)val);
        }
        if (Types.isVncDouble(val)) {
            return Numeric.doubleToDecimal((VncDouble)val);
        }
        if (Types.isVncBigDecimal(val)) {
            return (VncBigDecimal)val;
        }
        throw new VncException(String.format("Cannot convert value of type %s to decimal", Types.getType(val)));
    }

    public static VncLong intToLong(VncInteger val) {
        return new VncLong(val.getValue());
    }

    public static VncDouble intToDouble(VncInteger val) {
        return new VncDouble(val.getValue().doubleValue());
    }

    public static VncBigDecimal intToDecimal(VncInteger val) {
        return new VncBigDecimal(new BigDecimal(val.getValue()));
    }

    public static VncBigDecimal intToDecimal(VncInteger val, int scale) {
        return new VncBigDecimal(new BigDecimal(val.getValue()).setScale(scale));
    }

    public static VncInteger longToInt(VncLong val) {
        return new VncInteger(val.getValue());
    }

    public static VncDouble longToDouble(VncLong val) {
        return new VncDouble(val.getValue().doubleValue());
    }

    public static VncBigDecimal longToDecimal(VncLong val) {
        return new VncBigDecimal(new BigDecimal(val.getValue()));
    }

    public static VncBigDecimal longToDecimal(VncLong val, int scale) {
        return new VncBigDecimal(new BigDecimal(val.getValue()).setScale(scale));
    }

    public static VncInteger doubleToInt(VncDouble val) {
        return new VncInteger(val.getValue().intValue());
    }

    public static VncLong doubleToLong(VncDouble val) {
        return new VncLong(val.getValue().longValue());
    }

    public static VncBigDecimal doubleToDecimal(VncDouble val) {
        return new VncBigDecimal(new BigDecimal(val.getValue()));
    }

    public static VncInteger decimalToInt(VncBigDecimal val) {
        return new VncInteger(val.getValue().intValue());
    }

    public static VncLong decimalToLong(VncBigDecimal val) {
        return new VncLong(val.getValue().longValue());
    }

    public static VncDouble decimalToDouble(VncBigDecimal val) {
        return new VncDouble(val.getValue().doubleValue());
    }

    public static VncVal calc(MathOp op, VncVal op1, VncVal op2) {
        try {
            if (Types.isVncLong(op1)) {
                if (Types.isVncLong(op2)) {
                    return Numeric.calcLong(op, ((VncLong)op1).getValue(), ((VncLong)op2).getValue());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.calcLong(op, ((VncLong)op1).getValue(), ((VncInteger)op2).getLongValue());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.calcDouble(op, Numeric.longToDouble((VncLong)op1).getValue(), ((VncDouble)op2).getValue());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.calcDecimal(op, Numeric.longToDecimal((VncLong)op1).getValue(), ((VncBigDecimal)op2).getValue());
                }
            } else if (Types.isVncDouble(op1)) {
                if (Types.isVncDouble(op2)) {
                    return Numeric.calcDouble(op, ((VncDouble)op1).getValue(), ((VncDouble)op2).getValue());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.calcDouble(op, ((VncDouble)op1).getValue(), Numeric.longToDouble((VncLong)op2).getValue());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.calcDouble(op, ((VncDouble)op1).getValue(), Numeric.intToDouble((VncInteger)op2).getValue());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.calcDecimal(op, Numeric.doubleToDecimal((VncDouble)op1).getValue(), ((VncBigDecimal)op2).getValue());
                }
            } else if (Types.isVncBigDecimal(op1)) {
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.calcDecimal(op, ((VncBigDecimal)op1).getValue(), ((VncBigDecimal)op2).getValue());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.calcDecimal(op, ((VncBigDecimal)op1).getValue(), Numeric.longToDecimal((VncLong)op2).getValue());
                }
                if (Types.isVncInteger(op2)) {
                    return Numeric.calcDecimal(op, ((VncBigDecimal)op1).getValue(), Numeric.intToDecimal((VncInteger)op2).getValue());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.calcDecimal(op, ((VncBigDecimal)op1).getValue(), Numeric.doubleToDecimal((VncDouble)op2).getValue());
                }
            } else if (Types.isVncInteger(op1)) {
                if (Types.isVncInteger(op2)) {
                    return Numeric.calcInteger(op, ((VncInteger)op1).getValue(), ((VncInteger)op2).getValue());
                }
                if (Types.isVncLong(op2)) {
                    return Numeric.calcLong(op, ((VncInteger)op1).getLongValue(), ((VncLong)op2).getValue());
                }
                if (Types.isVncDouble(op2)) {
                    return Numeric.calcDouble(op, Numeric.intToDouble((VncInteger)op1).getValue(), ((VncDouble)op2).getValue());
                }
                if (Types.isVncBigDecimal(op2)) {
                    return Numeric.calcDecimal(op, Numeric.intToDecimal((VncInteger)op1).getValue(), ((VncBigDecimal)op2).getValue());
                }
            }
            Numeric.validateNumericTypes(op, op1, op2);
        }
        catch (ArithmeticException ex) {
            throw new VncException(ex.getMessage(), ex);
        }
        throw new RuntimeException("Unexpected outcome");
    }

    public static VncVal square(VncVal val) {
        return Numeric.calc(MathOp.MUL, val, val);
    }

    public static VncVal sqrt(VncVal val) {
        if (Types.isVncLong(val)) {
            return new VncDouble(Math.sqrt(((VncLong)val).getValue().doubleValue()));
        }
        if (Types.isVncInteger(val)) {
            return new VncDouble(Math.sqrt(((VncInteger)val).getValue().doubleValue()));
        }
        if (Types.isVncDouble(val)) {
            return new VncDouble(Math.sqrt(((VncDouble)val).getValue()));
        }
        if (Types.isVncBigDecimal(val)) {
            return new VncBigDecimal(new BigDecimal(Math.sqrt(Coerce.toVncBigDecimal(val).getValue().doubleValue())));
        }
        throw new VncException(String.format("Invalid argument type %s while calling function 'sqrt'", Types.getType(val)));
    }

    private static VncVal calcInteger(MathOp op, Integer op1, Integer op2) {
        switch (op) {
            case EQU: {
                return VncBoolean.of(op1.compareTo(op2) == 0);
            }
            case ADD: {
                return new VncInteger(op1 + op2);
            }
            case SUB: {
                return new VncInteger(op1 - op2);
            }
            case MUL: {
                return new VncInteger(op1 * op2);
            }
            case DIV: {
                return new VncInteger(op1 / op2);
            }
        }
        throw new RuntimeException("Invalid integer math operation '" + (Object)((Object)op) + "'");
    }

    private static VncVal calcLong(MathOp op, Long op1, Long op2) {
        switch (op) {
            case EQU: {
                return VncBoolean.of(op1.compareTo(op2) == 0);
            }
            case ADD: {
                return new VncLong(op1 + op2);
            }
            case SUB: {
                return new VncLong(op1 - op2);
            }
            case MUL: {
                return new VncLong(op1 * op2);
            }
            case DIV: {
                return new VncLong(op1 / op2);
            }
        }
        throw new RuntimeException("Invalid integer math operation '" + (Object)((Object)op) + "'");
    }

    private static VncVal calcDouble(MathOp op, Double op1, Double op2) {
        switch (op) {
            case EQU: {
                return VncBoolean.of(op1.compareTo(op2) == 0);
            }
            case ADD: {
                return new VncDouble(op1 + op2);
            }
            case SUB: {
                return new VncDouble(op1 - op2);
            }
            case MUL: {
                return new VncDouble(op1 * op2);
            }
            case DIV: {
                return new VncDouble(op1 / op2);
            }
        }
        throw new RuntimeException("Invalid double math operation '" + (Object)((Object)op) + "'");
    }

    private static VncVal calcDecimal(MathOp op, BigDecimal op1, BigDecimal op2) {
        switch (op) {
            case EQU: {
                return VncBoolean.of(op1.compareTo(op2) == 0);
            }
            case ADD: {
                return new VncBigDecimal(op1.add(op2));
            }
            case SUB: {
                return new VncBigDecimal(op1.subtract(op2));
            }
            case MUL: {
                return new VncBigDecimal(op1.multiply(op2));
            }
            case DIV: {
                return new VncBigDecimal(op1.divide(op2, 16, RoundingMode.HALF_UP));
            }
        }
        throw new RuntimeException("Invalid big decimal math operation '" + (Object)((Object)op) + "'");
    }

    private static void validateNumericTypes(MathOp op, VncVal op1, VncVal op2) {
        if (!Types.isVncNumber(op1)) {
            throw new VncException(String.format("Function '%s' operand 1 (%s) is not a numeric type", op.getFnName(), Types.getType(op1)));
        }
        if (!Types.isVncNumber(op2)) {
            throw new VncException(String.format("Function '%s' operand 2 (%s) is not a numeric type", op.getFnName(), Types.getType(op2)));
        }
    }
}

