/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.ansi.AnsiColorTheme;
import com.github.jlangch.venice.impl.ansi.AnsiColorThemes;
import com.github.jlangch.venice.impl.reader.HighlightItem;
import com.github.jlangch.venice.impl.reader.HighlightParser;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import java.util.regex.Pattern;
import org.repackage.org.jline.reader.Highlighter;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.utils.AttributedString;
import org.repackage.org.jline.utils.AttributedStringBuilder;

public class ReplHighlighter
implements Highlighter {
    private final AnsiColorTheme theme;
    private boolean enabled = true;

    public ReplHighlighter(ReplConfig config) {
        this.theme = this.getAnsiColorTheme(config.getColorMode());
    }

    public void enable(boolean val) {
        this.enabled = val;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        AttributedStringBuilder sb = new AttributedStringBuilder();
        if (this.enabled && !this.isReplCommand(buffer)) {
            HighlightParser.parse(buffer).forEach(it -> sb.ansiAppend(this.highlight((HighlightItem)it)));
        } else {
            sb.append(buffer);
        }
        return sb.toAttributedString();
    }

    @Override
    public void setErrorPattern(Pattern errorPattern) {
    }

    @Override
    public void setErrorIndex(int errorIndex) {
    }

    private String highlight(HighlightItem item) {
        return this.theme == null ? item.getForm() : this.theme.style(item.getForm(), item.getClazz());
    }

    private AnsiColorTheme getAnsiColorTheme(ReplConfig.ColorMode mode) {
        switch (mode) {
            case Light: {
                return AnsiColorThemes.getLightTheme();
            }
            case Dark: {
                return AnsiColorThemes.getDarkTheme();
            }
            case None: {
                return null;
            }
        }
        return null;
    }

    private boolean isReplCommand(String buffer) {
        return buffer.startsWith("!");
    }
}

