/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.List;

public class VncLong
extends VncVal {
    public static final VncKeyword TYPE = new VncKeyword(":core/long");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Long value;

    public VncLong(Long v) {
        this(v, null, Constants.Nil);
    }

    public VncLong(Integer v) {
        this(v.longValue(), null, Constants.Nil);
    }

    public VncLong(Long v, VncVal meta) {
        this(v, null, meta);
    }

    public VncLong(Long v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    @Override
    public VncLong withMeta(VncVal meta) {
        return new VncLong(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncLong wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncLong(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncLong negate() {
        return new VncLong(this.value * -1L);
    }

    public Long getValue() {
        return this.value;
    }

    public Integer getIntValue() {
        return this.value.intValue();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LONG;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).getLongValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToLong((VncDouble)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToLong((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncLong other = (VncLong)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

