/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VncMap
extends VncCollection
implements IVncFunction {
    public static final VncKeyword TYPE = new VncKeyword(":core/map");
    private static final long serialVersionUID = -1848883965231344442L;

    public VncMap(VncVal meta) {
        super(meta);
    }

    public VncMap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("map", args, 1, 2);
        VncVal first = args.first();
        if (args.size() == 1) {
            return this.get(args.first());
        }
        if (VncBoolean.isTrue(this.containsKey(first))) {
            return this.get(args.first());
        }
        return args.second();
    }

    @Override
    public abstract VncMap emptyWithMeta();

    public abstract VncMap withValues(Map<VncVal, VncVal> var1);

    public abstract VncMap withValues(Map<VncVal, VncVal> var1, VncVal var2);

    @Override
    public abstract VncMap withMeta(VncVal var1);

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncCollection.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncCollection.TYPE, VncVal.TYPE);
    }

    public abstract Map<VncVal, VncVal> getMap();

    public abstract VncVal get(VncVal var1);

    public VncVal get(VncVal key, VncVal defaultValue) {
        VncVal val = this.get(key);
        return val == Constants.Nil ? defaultValue : val;
    }

    public abstract VncVal containsKey(VncVal var1);

    public abstract VncList keys();

    public abstract List<VncMapEntry> entries();

    public abstract VncMap putAll(VncMap var1);

    public abstract VncMap assoc(VncVal ... var1);

    public abstract VncMap assoc(VncSequence var1);

    public abstract VncMap dissoc(VncVal ... var1);

    public abstract VncMap dissoc(VncSequence var1);

    @Override
    public Object convertToJavaObject() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (VncMapEntry e : this.entries()) {
            map.put(e.getKey().convertToJavaObject(), e.getValue().convertToJavaObject());
        }
        return map;
    }
}

