/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.ansi;

import com.github.jlangch.venice.impl.ansi.AnsiColorTheme;
import com.github.jlangch.venice.impl.reader.HighlightClass;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.HashMap;

public class AnsiColorThemes {
    private static String LIC_PURPLE = "\u001b[38;5;128m";
    private static String LIC_GREY = "\u001b[38;5;235m";
    private static String LIC_GREY_LIGHT = "\u001b[38;5;245m";
    private static String LIC_BLUE = "\u001b[38;5;20m";
    private static String LIC_GREEN = "\u001b[38;5;28m";
    private static String LIC_ORANGE = "\u001b[38;5;130m";
    private static String DAC_PURPLE = "\u001b[38;5;140m";
    private static String DAC_GREY = "\u001b[38;5;252m";
    private static String DAC_GREY_DARK = "\u001b[38;5;244m";
    private static String DAC_BLUE = "\u001b[38;5;111m";
    private static String DAC_GREEN = "\u001b[38;5;157m";
    private static String DAC_ORANGE = "\u001b[38;5;216m";

    public static AnsiColorTheme getTheme(String name) {
        switch (StringUtil.trimToEmpty(name)) {
            case "light": {
                return AnsiColorThemes.getLightTheme();
            }
            case "dark": {
                return AnsiColorThemes.getDarkTheme();
            }
        }
        return null;
    }

    public static AnsiColorTheme getLightTheme() {
        HashMap<VncKeyword, String> colors = new HashMap<VncKeyword, String>();
        colors.put(AnsiColorThemes.map(HighlightClass.COMMENT), LIC_GREY_LIGHT);
        colors.put(AnsiColorThemes.map(HighlightClass.WHITESPACES), null);
        colors.put(AnsiColorThemes.map(HighlightClass.STRING), LIC_GREEN);
        colors.put(AnsiColorThemes.map(HighlightClass.NUMBER), LIC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.CONSTANT), LIC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.KEYWORD), LIC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL_SPECIAL_FORM), LIC_PURPLE);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL_FUNCTION_NAME), LIC_BLUE);
        colors.put(AnsiColorThemes.map(HighlightClass.QUOTE), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.QUASI_QUOTE), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNQUOTE), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNQUOTE_SPLICING), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.META), LIC_GREY_LIGHT);
        colors.put(AnsiColorThemes.map(HighlightClass.AT), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.HASH), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACE_BEGIN), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACE_END), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACKET_BEGIN), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACKET_END), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.PARENTHESIS_BEGIN), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.PARENTHESIS_END), LIC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNKNOWN), LIC_GREY);
        return new AnsiColorTheme("light", colors);
    }

    public static AnsiColorTheme getDarkTheme() {
        HashMap<VncKeyword, String> colors = new HashMap<VncKeyword, String>();
        colors.put(AnsiColorThemes.map(HighlightClass.COMMENT), DAC_GREY_DARK);
        colors.put(AnsiColorThemes.map(HighlightClass.WHITESPACES), null);
        colors.put(AnsiColorThemes.map(HighlightClass.STRING), DAC_GREEN);
        colors.put(AnsiColorThemes.map(HighlightClass.NUMBER), DAC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.CONSTANT), DAC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.KEYWORD), DAC_ORANGE);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL_SPECIAL_FORM), DAC_PURPLE);
        colors.put(AnsiColorThemes.map(HighlightClass.SYMBOL_FUNCTION_NAME), DAC_BLUE);
        colors.put(AnsiColorThemes.map(HighlightClass.QUOTE), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.QUASI_QUOTE), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNQUOTE), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNQUOTE_SPLICING), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.META), DAC_GREY_DARK);
        colors.put(AnsiColorThemes.map(HighlightClass.AT), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.HASH), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACE_BEGIN), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACE_END), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACKET_BEGIN), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.BRACKET_END), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.PARENTHESIS_BEGIN), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.PARENTHESIS_END), DAC_GREY);
        colors.put(AnsiColorThemes.map(HighlightClass.UNKNOWN), DAC_GREY);
        return new AnsiColorTheme("dark", colors);
    }

    private static VncKeyword map(HighlightClass clazz) {
        return new VncKeyword(clazz.name().toLowerCase().replace('_', '-'));
    }
}

