/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.repackage.org.jline.reader.EndOfFileException;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;
import org.repackage.org.jline.utils.OSUtils;

public class CustomREPL {
    private static final String DEFAULT_PROMPT_PRIMARY = "venice> ";
    private static final String DEFAULT_PROMPT_SECONDARY = "      | ";
    private final List<String> loadPaths;
    private final File app;
    private String prompt = "venice> ";
    private String secondaryPrompt = "      | ";
    private Consumer<String> cmdHandler;
    private ReplConfig config;
    private IInterceptor interceptor;
    private boolean macroexpand = false;
    private boolean ansiTerminal = false;

    public CustomREPL(IInterceptor interceptor, List<String> loadPaths, File app) {
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
        this.app = app;
    }

    public void run(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        try {
            this.config = ReplConfig.load(cli);
            boolean setupMode = this.isSetupMode(cli);
            Level jlineLogLevel = this.config.getJLineLogLevel();
            if (jlineLogLevel != null) {
                Logger.getLogger("org.repackage.org.jline").setLevel(jlineLogLevel);
            }
            String jansiVersion = this.config.getJansiVersion();
            boolean dumbTerminal = OSUtils.IS_WINDOWS && jansiVersion == null || cli.switchPresent("-dumb") || this.config.isJLineDumbTerminal();
            boolean bl = this.ansiTerminal = !dumbTerminal;
            if (OSUtils.IS_WINDOWS) {
                if (jansiVersion != null) {
                    System.out.println("Using Jansi V" + jansiVersion);
                } else if (!setupMode) {
                    System.out.print("--------------------------------------------------------------------\nThe Venice REPL requires the jansi library on Windows.              \nPlease download the jar artifact 'org.fusesource.jansi:jansi:1.18'  \nfrom a Maven repo and put it on the classpath.                      \n--------------------------------------------------------------------\n\n");
                }
            }
            System.out.println("Loading configuration from " + this.config.getConfigSource());
            System.out.println(this.getTerminalInfo());
            System.out.println("Venice custom REPL: V" + Venice.getVersion() + (setupMode ? " (setup mode)" : ""));
            if (!setupMode) {
                System.out.println("Type '!' for help.");
            }
            this.repl(cli);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setHandler(Consumer<String> handler) {
        this.cmdHandler = handler;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.secondaryPrompt = "";
    }

    public void setPrompt(String prompt, String secondaryPrompt) {
        this.prompt = prompt;
        this.secondaryPrompt = secondaryPrompt;
    }

    private void repl(CommandLineArgs cli) throws Exception {
        this.setPrompt(this.config.getPrompt(), this.ansiTerminal ? this.config.getSecondaryPrompt() : "");
        Thread mainThread = Thread.currentThread();
        TerminalBuilder builder = TerminalBuilder.builder().streams(System.in, System.out).system(true).dumb(!this.ansiTerminal).jna(false);
        Terminal terminal = OSUtils.IS_WINDOWS ? builder.jansi(this.ansiTerminal).build() : builder.encoding("UTF-8").build();
        terminal.handle(Terminal.Signal.INT, signal -> mainThread.interrupt());
        PrintStream out = this.createPrintStream("stdout", terminal);
        PrintStream err = this.createPrintStream("stderr", terminal);
        BufferedReader in = this.createBufferedReader("stdin", terminal);
        TerminalPrinter printer = new TerminalPrinter(this.config, terminal, this.ansiTerminal, false);
        VeniceInterpreter venice = new VeniceInterpreter(this.interceptor, this.loadPaths);
        Env env = this.loadEnv(venice, cli, out, err, in);
        if (cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended")) {
            this.handleSetupCommand(venice, env, REPL.SetupMode.Extended, printer);
            return;
        }
        if (cli.switchPresent("-setup")) {
            this.handleSetupCommand(venice, env, REPL.SetupMode.Minimal, printer);
            return;
        }
        if (!this.runApp(venice, env, printer)) {
            return;
        }
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Venice").terminal(terminal).history(history).variable("secondary-prompt-pattern", this.secondaryPrompt).build();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        while (true) {
            resultHistory.mergeToEnv(env);
            try {
                Thread.interrupted();
                String line = reader.readLine(this.prompt, null, (MaskingCallback)null, null);
                if (line == null) continue;
                this.cmdHandler.accept(line);
                continue;
            }
            catch (UserInterruptException ex) {
                Thread.interrupted();
                printer.println("interrupt", " ! interrupted ! ");
                Thread.sleep(1000L);
            }
            catch (EofException | EndOfFileException ex) {
            }
            catch (Exception ex) {
                printer.printex("error", ex);
                continue;
            }
            break;
        }
    }

    private Env loadEnv(VeniceInterpreter venice, CommandLineArgs cli, PrintStream out, PrintStream err, BufferedReader in) {
        return venice.createEnv(this.macroexpand, this.ansiTerminal, new VncKeyword("repl")).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false)).setGlobal(new Var(new VncSymbol("*REPL*"), new VncJavaObject(this), false)).setStdoutPrintStream(out).setStderrPrintStream(err).setStdinReader(in);
    }

    private PrintStream createPrintStream(String context, Terminal terminal) {
        return new ReplPrintStream(terminal, this.ansiTerminal ? this.config.getColor(context) : null);
    }

    private BufferedReader createBufferedReader(String context, Terminal terminal) {
        return new BufferedReader(terminal.reader());
    }

    private void handleSetupCommand(VeniceInterpreter venice, Env env, REPL.SetupMode mode, TerminalPrinter printer) {
        try {
            String script = mode == REPL.SetupMode.Minimal ? "(do                             \n  (load-module :repl-setup)     \n  (repl-setup/setup :minimal))  \n" : "(do                             \n  (load-module :repl-setup)     \n  (repl-setup/setup :extended)) \n";
            venice.RE(script, "user", env);
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            printer.println("error", "REPL setup failed!");
        }
    }

    private String getTerminalInfo() {
        if (this.ansiTerminal) {
            if (this.config.getColorMode() == ReplConfig.ColorMode.None) {
                return "Using ansi terminal (colors turned off, turn on with option '-colors')";
            }
            return "Using ansi terminal (colors turned on)";
        }
        return "Using dumb terminal (colors turned off)";
    }

    private boolean runApp(VeniceInterpreter venice, Env env, TerminalPrinter printer) {
        try {
            if (this.app != null) {
                printer.println("stdout", "loading file \"" + this.app.getPath() + "\"");
                venice.RE("(load-file \"" + this.app.getPath() + "\")", "user", env);
            }
            return true;
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            printer.println("error", "Stopped REPL");
            return false;
        }
    }

    private boolean isSetupMode(CommandLineArgs cli) {
        return cli.switchPresent("-setup") || cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended");
    }
}

