/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.repl.ReplCompleter;
import com.github.jlangch.venice.impl.repl.ReplConfig;
import com.github.jlangch.venice.impl.repl.ReplHighlighter;
import com.github.jlangch.venice.impl.repl.ReplParser;
import com.github.jlangch.venice.impl.repl.ReplPrintStream;
import com.github.jlangch.venice.impl.repl.ReplResultHistory;
import com.github.jlangch.venice.impl.repl.TerminalPrinter;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.Licenses;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.RejectAllInterceptor;
import com.github.jlangch.venice.javainterop.SandboxInterceptor;
import com.github.jlangch.venice.javainterop.SandboxRules;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.repackage.org.jline.reader.EndOfFileException;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.LineReaderBuilder;
import org.repackage.org.jline.reader.MaskingCallback;
import org.repackage.org.jline.reader.UserInterruptException;
import org.repackage.org.jline.reader.impl.history.DefaultHistory;
import org.repackage.org.jline.terminal.Size;
import org.repackage.org.jline.terminal.Terminal;
import org.repackage.org.jline.terminal.TerminalBuilder;
import org.repackage.org.jline.utils.InfoCmp;
import org.repackage.org.jline.utils.OSUtils;

public class REPL {
    private static final String HELP = "Venice REPL: V" + Venice.getVersion() + "\n\nCommands: \n  !reload      reload Venice environment\n  !?, !help    help\n  !info        show REPL setup context data\n  !config      show a sample REPL config\n  !highlight   turn highlighting dynamically on or off\n                 !highlight {on/off}\n  !lic         prints the licenses for 3rd party\n               libs included with Venice\n  !macroexpand enable macro expansion while loading\n               files and modules. \n               This can speed-up script execution by\n               a factor 3 or 5 and even more with\n               complex code!\n  !env         print env symbols:\n                 !env print {symbol-name}\n                 !env global\n                 !env global io/*\n                 !env global *file*\n  !sandbox     sandbox\n                 !sandbox status\n                 !sandbox config\n                 !sandbox accept-all\n                 !sandbox reject-all\n                 !sandbox customized\n                 !sandbox add-rule rule\n  !java-ex     print Java exception\n  !exit        quit the REPL\n\nHistory: \n  A history of the last three result values is kept by\n  the REPL, accessible through the symbols `*1`, `*2`, `*3`,\n  and `**`. E.g. (printl *1)\n\nShortcuts:\n  ctrl-A   move the cursor to the start\n  ctrl-C   stop the running command, cancel a multi-line\n           edit, or break out of the REPL\n  ctrl-E   move the cursor to the end\n  ctrl-K   remove the text after the cursor and store it\n           in a cut-buffer\n  ctrl-L   clear the screen\n  ctrl-Y   yank the text from the cut-buffer\n  ctrl-_   undo\n";
    private static final String HELP_ENV = "Please choose from:\n   !env print {symbol-name}\n   !env global\n   !env global io/*\n   !env global *file*\n";
    private static final String HELP_SANDBOX = "Please choose from:\n   !sandbox status\n   !sandbox config\n   !sandbox accept-all\n   !sandbox reject-all\n   !sandbox customized\n   !sandbox add-rule class:java.lang.Math:*\n   !sandbox add-rule system.property:os.name\n   !sandbox add-rule blacklist:venice:func:io/exists-dir?\n   !sandbox add-rule blacklist:venice:func:*io*\n   !sandbox add-rule venice:module:shell\n";
    private static final String DELIM = StringUtil.repeat('-', 80);
    private final List<String> loadPaths;
    private ReplConfig config;
    private IInterceptor interceptor;
    private VeniceInterpreter venice;
    private TerminalPrinter printer;
    private ReplHighlighter highlighter;
    private boolean macroexpand = false;
    private boolean ansiTerminal = false;
    private boolean highlight = true;

    public REPL(IInterceptor interceptor, List<String> loadPaths) {
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
    }

    public void run(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        try {
            this.config = ReplConfig.load(cli);
            boolean setupMode = this.isSetupMode(cli);
            Level jlineLogLevel = this.config.getJLineLogLevel();
            if (jlineLogLevel != null) {
                Logger.getLogger("org.repackage.org.jline").setLevel(jlineLogLevel);
            }
            String jansiVersion = this.config.getJansiVersion();
            boolean dumbTerminal = OSUtils.IS_WINDOWS && jansiVersion == null || cli.switchPresent("-dumb") || this.config.isJLineDumbTerminal();
            boolean bl = this.ansiTerminal = !dumbTerminal;
            if (OSUtils.IS_WINDOWS) {
                if (jansiVersion != null) {
                    System.out.println("Using Jansi V" + jansiVersion);
                } else if (!setupMode) {
                    System.out.print("--------------------------------------------------------------------\nThe Venice REPL requires the jansi library on Windows.              \nPlease download the jar artifact 'org.fusesource.jansi:jansi:1.18'  \nfrom a Maven repo and put it on the classpath.                      \n--------------------------------------------------------------------\n\n");
                }
            }
            System.out.println("Loading configuration from " + this.config.getConfigSource());
            System.out.println(this.getTerminalInfo());
            System.out.println("Venice REPL: V" + Venice.getVersion() + (setupMode ? " (setup mode)" : ""));
            if (!setupMode) {
                System.out.println("Type '!' for help.");
            }
            this.repl(cli);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void repl(CommandLineArgs cli) throws Exception {
        String prompt = this.config.getPrompt();
        String secondaryPrompt = this.ansiTerminal ? this.config.getSecondaryPrompt() : "";
        String resultPrefix = this.config.getResultPrefix();
        Thread mainThread = Thread.currentThread();
        TerminalBuilder builder = TerminalBuilder.builder().streams(System.in, System.out).system(true).dumb(!this.ansiTerminal).jna(false);
        if (OSUtils.IS_WINDOWS) {
            builder.jansi(this.ansiTerminal);
        } else if (this.isRunningOnLinuxGitPod()) {
            builder.encoding("UTF-8");
            builder.type("xterm-256color");
        } else {
            builder.encoding("UTF-8");
        }
        Terminal terminal = builder.build();
        terminal.handle(Terminal.Signal.INT, signal -> mainThread.interrupt());
        PrintStream out = this.createPrintStream("stdout", terminal);
        PrintStream err = this.createPrintStream("stderr", terminal);
        BufferedReader in = this.createBufferedReader("stdin", terminal);
        this.printer = new TerminalPrinter(this.config, terminal, this.ansiTerminal, false);
        this.venice = new VeniceInterpreter(this.interceptor, this.loadPaths);
        this.highlighter = this.config.isSyntaxHighlighting() ? new ReplHighlighter(this.config) : null;
        Env env = this.loadEnv(cli, out, err, in);
        env.setGlobal(new Var(new VncSymbol("*repl-color-theme*"), new VncKeyword(this.config.getColorMode().name().toLowerCase()), false));
        ReplParser parser = new ReplParser(this.venice);
        ReplCompleter completer = new ReplCompleter(this.venice, env, this.loadPaths);
        DefaultHistory history = new DefaultHistory();
        LineReader reader = LineReaderBuilder.builder().appName("Venice").terminal(terminal).history(history).completer(completer).highlighter(this.highlighter).parser(parser).variable("secondary-prompt-pattern", secondaryPrompt).variable("indentation", 2).variable("list-max", 100).build();
        ReplResultHistory resultHistory = new ReplResultHistory(3);
        if (cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended")) {
            this.handleSetupCommand(this.venice, env, SetupMode.Extended, this.printer);
            return;
        }
        if (cli.switchPresent("-setup")) {
            this.handleSetupCommand(this.venice, env, SetupMode.Minimal, this.printer);
            return;
        }
        if (!this.runLoadFile(this.config.getLoadFile(), env, resultPrefix)) {
            return;
        }
        this.highlight = this.highlighter != null;
        while (true) {
            String line;
            resultHistory.mergeToEnv(env);
            try {
                Thread.interrupted();
                line = reader.readLine(prompt, null, (MaskingCallback)null, null);
                if (line == null) continue;
                if (line.startsWith("!")) {
                    String cmd = StringUtil.trimToEmpty(line.substring(1));
                    if (cmd.equals("reload")) {
                        env = this.loadEnv(cli, out, err, in);
                        this.printer.println("system", "reloaded");
                        continue;
                    }
                    if (cmd.equals("exit")) {
                        this.printer.println("interrupt", " good bye ");
                        Thread.sleep(1000L);
                        break;
                    }
                    this.handleCommand(cmd, env, terminal);
                    continue;
                }
            }
            catch (ContinueException ex) {
                continue;
            }
            catch (UserInterruptException ex) {
                Thread.interrupted();
                if (parser.isEOF()) {
                    this.printer.println("interrupt", " cancel ");
                    parser.reset();
                    continue;
                }
                this.printer.println("interrupt", " ! interrupted ! ");
                Thread.sleep(1000L);
                break;
            }
            catch (EofException | EndOfFileException ex) {
                break;
            }
            catch (ParseError ex) {
                history.add(reader.getBuffer().toString());
                this.printer.printex("error", ex);
                continue;
            }
            catch (Exception ex) {
                this.printer.printex("error", ex);
                continue;
            }
            VncVal result = this.runCodeFragment(line, env);
            if (result == null) continue;
            this.printer.println("result", resultPrefix + this.venice.PRINT(result));
            resultHistory.add(result);
        }
    }

    private VncVal runCodeFragment(String snippet, Env env) {
        try {
            ThreadLocalMap.clearCallStack();
            return this.venice.RE(snippet, "user", env, this.macroexpand);
        }
        catch (ContinueException ex) {
            return null;
        }
        catch (Exception ex) {
            this.printer.printex("error", ex);
            return null;
        }
        catch (Throwable ex) {
            this.printer.printex("error", ex);
            return null;
        }
    }

    private void handleCommand(String cmd, Env env, Terminal terminal) {
        if (cmd.equals("macroexpand") || cmd.equals("me")) {
            this.macroexpand = true;
            this.setMacroexpandOnLoad(env, true);
            this.printer.println("system", "macroexpansion enabled");
        } else if (cmd.isEmpty() || cmd.equals("?") || cmd.equals("help")) {
            this.printer.println("stdout", HELP);
        } else if (cmd.equals("config")) {
            this.handleConfigCommand();
        } else if (cmd.equals("setup")) {
            this.handleSetupCommand(this.venice, env, SetupMode.Minimal, this.printer);
        } else if (cmd.equals("setup-ext")) {
            this.handleSetupCommand(this.venice, env, SetupMode.Extended, this.printer);
        } else if (cmd.equals("classpath")) {
            this.handleReplClasspathCommand();
        } else if (cmd.equals("launcher")) {
            this.handleLauncherCommand();
        } else if (cmd.equals("env")) {
            this.handleEnvCommand(new String[0], env);
        } else if (cmd.startsWith("env ")) {
            String[] params = StringUtil.trimToEmpty(cmd.substring(3)).split(" +");
            this.handleEnvCommand(params, env);
        } else if (cmd.startsWith("java-ex")) {
            this.printer.setPrintJavaEx(true);
            this.printer.println("stdout", "Printing Java exceptions");
        } else if (cmd.equals("sandbox")) {
            this.handleSandboxCommand(new String[0], terminal, env);
        } else if (cmd.startsWith("sandbox ")) {
            String[] params = StringUtil.trimToEmpty(cmd.substring(7)).split(" +");
            this.handleSandboxCommand(params, terminal, env);
        } else if (cmd.equals("lic")) {
            Licenses.lics().entrySet().forEach(e -> {
                this.printer.println("stdout", "");
                this.printer.println("stdout", DELIM);
                this.printer.println("stdout", (String)e.getKey() + " License");
                this.printer.println("stdout", DELIM);
                this.printer.println("stdout", (String)e.getValue());
            });
        } else if (cmd.equals("colors")) {
            this.printer.println("default", "default");
            this.printer.println("result", "result");
            this.printer.println("stdout", "stdout");
            this.printer.println("stderr", "stderr");
            this.printer.println("error", "error");
            this.printer.println("system", "system");
            this.printer.println("interrupt", "interrupt");
        } else if (cmd.equals("info")) {
            Integer maxColors = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
            Size size = terminal.getSize();
            this.printer.println("stdout", "Terminal Name:   " + terminal.getName());
            this.printer.println("stdout", "Terminal Type:   " + terminal.getType());
            this.printer.println("stdout", "Terminal Size:   " + size.getRows() + "x" + size.getColumns());
            this.printer.println("stdout", "Terminal Colors: " + maxColors);
            this.printer.println("stdout", "Terminal Class:  " + terminal.getClass().getSimpleName());
            this.printer.println("stdout", "");
            this.printer.println("stdout", "Color Mode:      " + this.config.getColorMode().toString().toLowerCase());
            this.printer.println("stdout", "Highlighting:    " + this.config.isSyntaxHighlighting());
            this.printer.println("stdout", "");
            this.printer.println("stdout", "Env TERM:        " + System.getenv("TERM"));
            this.printer.println("stdout", "Env GITPOD:      " + this.isRunningOnLinuxGitPod());
            this.printer.println("stdout", "");
            this.printer.println("stdout", "OS Arch:         " + System.getProperty("os.arch"));
            this.printer.println("stdout", "OS Name:         " + System.getProperty("os.name"));
            this.printer.println("stdout", "OS Version:      " + System.getProperty("os.version"));
            this.printer.println("stdout", "");
            this.printer.println("stdout", "Java Version:    " + System.getProperty("java.version"));
            this.printer.println("stdout", "Java Vendor:     " + System.getProperty("java.vendor"));
            this.printer.println("stdout", "Java VM Version: " + System.getProperty("java.vm.version"));
            this.printer.println("stdout", "Java VM Name:    " + System.getProperty("java.vm.name"));
            this.printer.println("stdout", "Java VM Vendor:  " + System.getProperty("java.vm.vendor"));
        } else if (cmd.startsWith("highlight")) {
            if (cmd.equals("highlight")) {
                this.printer.println("stdout", "Highlighting: " + (this.highlight ? "on" : "off"));
            } else {
                String param = StringUtil.trimToEmpty(cmd.substring("highlight".length()));
                if ("on".equals(param)) {
                    this.highlight = true;
                    if (this.highlighter != null) {
                        this.highlighter.enable(true);
                    }
                } else if ("off".equals(param)) {
                    this.highlight = false;
                    if (this.highlighter != null) {
                        this.highlighter.enable(false);
                    }
                } else {
                    this.printer.println("error", "Invalid parameter. Use !highlight {on|off}.");
                }
            }
        } else {
            this.printer.println("error", "invalid command");
        }
    }

    private void handleConfigCommand() {
        this.printer.println("stdout", "Sample REPL configuration. Save it as 'repl.json'");
        this.printer.println("stdout", "in the REPL's working directory:");
        this.printer.println();
        this.printer.println("stdout", ReplConfig.getDefaultClasspathConfig());
    }

    private void handleSetupCommand(VeniceInterpreter venice, Env env, SetupMode setupMode, TerminalPrinter printer) {
        try {
            ReplConfig.ColorMode colorMode = this.config.isColorModeLight() && OSUtils.IS_WINDOWS ? ReplConfig.ColorMode.Dark : this.config.getColorMode();
            String sSetupMode = ":" + setupMode.name().toLowerCase();
            String sColorMode = ":" + colorMode.name().toLowerCase();
            String script = String.format("(do                                     \n  (load-module :repl-setup)             \n  (repl-setup/setup :setup-mode %s      \n                    :color-mode %s      \n                    :ansi-terminal %s))   ", sSetupMode, sColorMode, this.ansiTerminal ? "true" : "false");
            venice.RE(script, "user", env);
        }
        catch (Exception ex) {
            printer.printex("error", ex);
            printer.println("error", "REPL setup failed!");
        }
    }

    private void handleLauncherCommand() {
        String name = ReplConfig.getLauncherScriptName();
        this.printer.println("stdout", "Sample REPL launcher script. Save it as '" + name + "'");
        this.printer.println("stdout", "in the REPL's working directory:");
        this.printer.println();
        this.printer.println("stdout", ReplConfig.getDefaultClasspathLauncherScript());
    }

    private void handleEnvCommand(String[] params, Env env) {
        if (params.length == 0) {
            this.printer.println("stdout", HELP_ENV);
            return;
        }
        if (params[0].equals("print")) {
            if (params.length == 2) {
                VncVal val = env.get(new VncSymbol(params[1]));
                this.printer.println("stdout", this.venice.PRINT(val));
                return;
            }
        } else if (params[0].equals("global")) {
            if (params.length == 1) {
                this.printer.println("stdout", this.envGlobalsToString(env));
                return;
            }
            if (params.length == 2) {
                String filter = StringUtil.trimToNull(params[1]);
                filter = filter == null ? null : filter.replaceAll("[*]", ".*");
                this.printer.println("stdout", this.envGlobalsToString(env, filter));
                return;
            }
        }
        this.printer.println("error", "invalid env command");
    }

    private void handleSandboxCommand(String[] params, Terminal terminal, Env env) {
        if (params.length == 0) {
            terminal.writer().println(HELP_SANDBOX);
            return;
        }
        String interceptorName = this.interceptor.getClass().getSimpleName();
        if (params.length == 1) {
            if (params[0].equals("status")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "No sandbox active (" + interceptorName + ")");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "Sandbox active (" + interceptorName + "). Rejects all Java calls and default blacklisted Venice functions");
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "Customized sandbox active (" + interceptorName + ")");
                    return;
                }
                this.printer.println("stdout", "Sandbox: " + interceptorName);
                return;
            }
            if (params[0].equals("accept-all")) {
                this.activate(new AcceptAllInterceptor());
                return;
            }
            if (params[0].equals("reject-all")) {
                this.activate(new RejectAllInterceptor());
                return;
            }
            if (params[0].equals("customized")) {
                this.activate(new SandboxInterceptor(new SandboxRules()));
                return;
            }
            if (params[0].equals("config")) {
                if (this.interceptor instanceof AcceptAllInterceptor) {
                    this.printer.println("stdout", "[accept-all] NO sandbox active");
                    this.printer.println("stdout", "All Java calls accepted, no Venice calls rejected");
                    return;
                }
                if (this.interceptor instanceof RejectAllInterceptor) {
                    this.printer.println("stdout", "[reject-all] SAFE restricted sandbox");
                    this.printer.println("stdout", "Java calls:\n   All rejected!");
                    this.printer.println("stdout", "Whitelisted Venice modules:\n" + ((RejectAllInterceptor)this.interceptor).getWhitelistedVeniceModules().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    this.printer.println("stdout", "Blacklisted Venice functions:\n" + ((RejectAllInterceptor)this.interceptor).getBlacklistedVeniceFunctions().stream().map(s -> "   " + s).collect(Collectors.joining("\n")));
                    return;
                }
                if (this.interceptor instanceof SandboxInterceptor) {
                    this.printer.println("stdout", "[customized] Customized sandbox");
                    this.printer.println("stdout", "Sandbox rules:\n" + ((SandboxInterceptor)this.interceptor).getRules().toString());
                    return;
                }
                this.printer.println("stdout", "[" + interceptorName + "]");
                this.printer.println("stdout", "no info");
                return;
            }
        } else if (params.length == 2 && params[0].equals("add-rule")) {
            String rule = params[1];
            if (!(this.interceptor instanceof SandboxInterceptor)) {
                this.printer.println("system", "rules can only be added to a customized sandbox");
                return;
            }
            SandboxRules rules = ((SandboxInterceptor)this.interceptor).getRules();
            if (rule.startsWith("class:")) {
                rules.withClasses(rule);
            } else if (rule.startsWith("system.property:")) {
                rules.withSystemProperties(rule);
            } else if (rule.startsWith("system.env:")) {
                rules.withSystemEnvs(rule);
            } else if (rule.startsWith("venice:module:")) {
                rules.withVeniceModules(rule);
            } else if (rule.startsWith("blacklist:venice:func:")) {
                rules.rejectVeniceFunctions(rule);
            } else {
                terminal.writer().println(HELP_SANDBOX);
                return;
            }
            this.activate(new SandboxInterceptor(rules));
            return;
        }
        this.printer.println("error", "invalid sandbox command: " + Arrays.asList(params));
    }

    private Env loadEnv(CommandLineArgs cli, PrintStream out, PrintStream err, BufferedReader in) {
        return this.venice.createEnv(this.macroexpand, this.ansiTerminal, new VncKeyword("repl")).setGlobal(new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false)).setStdoutPrintStream(out).setStderrPrintStream(err).setStdinReader(in);
    }

    private void setMacroexpandOnLoad(Env env, boolean macroexpandOnLoad) {
        env.setGlobal(new Var(new VncSymbol("*macroexpand-on-load*"), VncBoolean.of(macroexpandOnLoad), true));
    }

    private void activate(IInterceptor interceptor) {
        this.interceptor = interceptor;
        this.venice = new VeniceInterpreter(interceptor, this.loadPaths);
        JavaInterop.register(interceptor);
    }

    private String envGlobalsToString(Env env) {
        return this.formatGlobalVars(env.getAllGlobalSymbols(), null);
    }

    private String envGlobalsToString(Env env, String regexFilter) {
        return this.formatGlobalVars(env.getAllGlobalSymbols(), regexFilter);
    }

    private String formatGlobalVars(Map<VncSymbol, Var> vars, String regexFilter) {
        return vars.values().stream().sorted((a, b) -> a.getName().getName().compareTo(b.getName().getName())).filter(v -> regexFilter == null ? true : v.getName().getName().matches(regexFilter)).map(v -> String.format("%s (:%s)", v.getName().getName(), this.formatGlobalVarType((Var)v).getValue())).collect(Collectors.joining("\n"));
    }

    public VncKeyword formatGlobalVarType(Var var_) {
        VncVal val = var_.getVal();
        if (Types.isVncJavaObject(val)) {
            VncJavaObject vJava = (VncJavaObject)val;
            if (vJava.getDelegateFormalType() != null) {
                return new VncKeyword(vJava.getDelegateFormalType().getName());
            }
            return new VncKeyword(vJava.getDelegate().getClass().getName());
        }
        return Types.getType(val);
    }

    private PrintStream createPrintStream(String context, Terminal terminal) {
        return new ReplPrintStream(terminal, this.ansiTerminal ? this.config.getColor(context) : null);
    }

    private BufferedReader createBufferedReader(String context, Terminal terminal) {
        return new BufferedReader(terminal.reader());
    }

    private boolean runLoadFile(String loadFile, Env env, String resultPrefix) {
        try {
            if (loadFile != null) {
                this.printer.println("stdout", "loading file \"" + loadFile + "\"");
                VncVal result = this.venice.RE("(load-file \"" + loadFile + "\")", "user", env);
                this.printer.println("stdout", resultPrefix + this.venice.PRINT(result));
            }
            return true;
        }
        catch (Exception ex) {
            this.printer.printex("error", ex);
            this.printer.println("error", "Stopped REPL");
            return false;
        }
    }

    private String getTerminalInfo() {
        if (this.ansiTerminal) {
            switch (this.config.getColorMode()) {
                case Light: {
                    return "Using Ansi terminal (light color mode turned on)";
                }
                case Dark: {
                    return "Using Ansi terminal (dark color mode turned on)";
                }
            }
            return "Using Ansi terminal (colors turned off, turn on with option '-colors')";
        }
        return "Using dumb terminal (colors turned off)";
    }

    private void handleReplClasspathCommand() {
        this.printer.println("stdout", "REPL classpath:");
        for (String f : System.getProperty("java.class.path").split(File.pathSeparator)) {
            this.printer.println("stdout", "  " + f);
        }
    }

    private boolean isSetupMode(CommandLineArgs cli) {
        return cli.switchPresent("-setup") || cli.switchPresent("-setup-ext") || cli.switchPresent("-setup-extended");
    }

    private boolean isRunningOnLinuxGitPod() {
        return "Linux".equals(System.getProperty("os.name")) && System.getenv("GITPOD_REPO_ROOT") != null;
    }

    public static enum SetupMode {
        Minimal,
        Extended;

    }
}

