/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.repackage.io.vavr.collection.HashSet;

public class VncHashSet
extends VncSet {
    public static final VncKeyword TYPE = new VncKeyword(":core/hash-set");
    private static final long serialVersionUID = -1848883965231344442L;
    private final HashSet<VncVal> value;

    public VncHashSet() {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, (VncVal)null);
    }

    public VncHashSet(VncVal meta) {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, meta);
    }

    public VncHashSet(org.repackage.io.vavr.collection.Set<VncVal> val) {
        this(val, null);
    }

    public VncHashSet(org.repackage.io.vavr.collection.Set<VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? HashSet.empty() : (val instanceof HashSet ? (HashSet<Object>)val : HashSet.ofAll(val));
    }

    public static VncHashSet ofAll(Collection<? extends VncVal> val) {
        return new VncHashSet(HashSet.ofAll(val));
    }

    public static VncHashSet ofAll(VncSequence val) {
        return new VncHashSet(HashSet.ofAll(val.getList()));
    }

    public static VncHashSet of(VncVal ... mvs) {
        return new VncHashSet(HashSet.of(mvs));
    }

    @Override
    public VncHashSet emptyWithMeta() {
        return new VncHashSet(this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncHashSet(HashSet.ofAll(replaceVals), this.getMeta());
    }

    @Override
    public VncHashSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncHashSet(HashSet.ofAll(replaceVals), meta);
    }

    @Override
    public VncHashSet withMeta(VncVal meta) {
        return new VncHashSet(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSet.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSet.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public VncHashSet add(VncVal val) {
        return new VncHashSet(this.value.add((Object)val), this.getMeta());
    }

    @Override
    public VncHashSet addAll(VncSet val) {
        return new VncHashSet(this.value.addAll(val.getSet()), this.getMeta());
    }

    @Override
    public VncHashSet addAll(VncSequence val) {
        return new VncHashSet(this.value.addAll(val.getList()), this.getMeta());
    }

    @Override
    public VncHashSet remove(VncVal val) {
        return new VncHashSet(this.value.remove((Object)val), this.getMeta());
    }

    @Override
    public VncHashSet removeAll(VncSet val) {
        return new VncHashSet(this.value.removeAll(val.getSet()), this.getMeta());
    }

    @Override
    public VncHashSet removeAll(VncSequence val) {
        return new VncHashSet(this.value.removeAll(val.getList()), this.getMeta());
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public Set<VncVal> getSet() {
        return Collections.unmodifiableSet(this.value.toJavaSet());
    }

    @Override
    public List<VncVal> getList() {
        return Collections.unmodifiableList(this.value.toJavaList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getList(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.HASHSET;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncHashSet(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncHashSet)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncHashSet other = (VncHashSet)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getList(), " ", print_readably) + "}";
    }
}

