/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.crypt;

import com.github.jlangch.venice.impl.util.crypt.CipherSuite;
import com.github.jlangch.venice.impl.util.crypt.EncryptionException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherSuiteFactory {
    private static final byte[] SALT = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private static final int ITERATIONS = 19;

    public static CipherSuite create(String algorithm, String passphrase, boolean urlSafe) {
        try {
            if ("DES".equalsIgnoreCase(algorithm)) {
                return CipherSuiteFactory.createCipherSuite(passphrase, "PBEWithMD5AndDES", "{DES}", urlSafe);
            }
            if ("PBEWithMD5AndDES".equalsIgnoreCase(algorithm)) {
                return CipherSuiteFactory.createCipherSuite(passphrase, "PBEWithMD5AndDES", "{DES}", urlSafe);
            }
            if ("3DES".equalsIgnoreCase(algorithm)) {
                return CipherSuiteFactory.createCipherSuite(passphrase, "PBEWithMD5AndTripleDES", "{3DES}", urlSafe);
            }
            if ("PBEWithMD5AndTripleDES".equalsIgnoreCase(algorithm)) {
                return CipherSuiteFactory.createCipherSuite(passphrase, "PBEWithMD5AndTripleDES", "{3DES}", urlSafe);
            }
            if ("AES256".equalsIgnoreCase(algorithm)) {
                return CipherSuiteFactory.createCipherSuite_AES256(passphrase, "AES256", "{AES256}", urlSafe);
            }
            throw new EncryptionException("Invalid cipher algorithm name '" + algorithm + "'");
        }
        catch (Exception ex) {
            throw new EncryptionException("Failed to create cipher suite.", ex);
        }
    }

    private static CipherSuite createCipherSuite(String passphrase, String algorithm, String prefix, boolean urlSafe) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(passphrase.toCharArray(), SALT, 19);
        SecretKey key = SecretKeyFactory.getInstance(algorithm).generateSecret(keySpec);
        Cipher cipherEncrypt = Cipher.getInstance(key.getAlgorithm());
        Cipher cipherDecrypt = Cipher.getInstance(key.getAlgorithm());
        PBEParameterSpec paramSpec = new PBEParameterSpec(SALT, 19);
        cipherEncrypt.init(1, (Key)key, paramSpec);
        cipherDecrypt.init(2, (Key)key, paramSpec);
        return new CipherSuite(cipherEncrypt, cipherDecrypt, prefix, urlSafe);
    }

    private static CipherSuite createCipherSuite_AES256(String passphrase, String algorithm, String prefix, boolean urlSafe) throws GeneralSecurityException {
        byte[] iv = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), SALT, 65536, 256);
        SecretKey tmp = factory.generateSecret(spec);
        SecretKeySpec secretKey = new SecretKeySpec(tmp.getEncoded(), "AES");
        Cipher cipherEncrypt = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        Cipher cipherDecrypt = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipherEncrypt.init(1, (Key)secretKey, ivspec);
        cipherDecrypt.init(2, (Key)secretKey, ivspec);
        return new CipherSuite(cipherEncrypt, cipherDecrypt, prefix, urlSafe);
    }
}

