/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.reflect;

import com.github.jlangch.venice.JavaMethodInvocationException;
import com.github.jlangch.venice.impl.util.Tuple2;
import com.github.jlangch.venice.impl.util.Tuple4;
import com.github.jlangch.venice.impl.util.reflect.ArgTypeMatcher;
import com.github.jlangch.venice.impl.util.reflect.Boxing;
import com.github.jlangch.venice.impl.util.reflect.MethodHandleUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import com.github.jlangch.venice.impl.util.reflect.ReturnValue;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionAccessor {
    private static final Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<String>> getterPropertiesCache = new ConcurrentHashMap();
    private static final Map<Class<?>, List<String>> setterPropertiesCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Method> getterMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, Method> setterMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, Integer>, List<Constructor<?>>> constructorCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, MethodHandle> staticFieldCache = new ConcurrentHashMap();
    private static final Map<Tuple2<Class<?>, String>, MethodHandle> instanceFieldCache = new ConcurrentHashMap();
    private static final Map<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> staticMethodCache = new ConcurrentHashMap();
    private static final Map<Tuple4<Class<?>, String, Integer, Boolean>, List<Method>> instanceMethodCache = new ConcurrentHashMap();

    public static void clearCache() {
        classCache.clear();
        getterMethodCache.clear();
        setterMethodCache.clear();
        constructorCache.clear();
        staticFieldCache.clear();
        instanceFieldCache.clear();
        instanceMethodCache.clear();
        staticMethodCache.clear();
    }

    public static Class<?> classForName(String className) {
        try {
            return ReflectionAccessor.memoizedClassForName(className);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get class '%s'", className), ex);
        }
    }

    public static boolean classExists(String className) {
        try {
            return ReflectionAccessor.memoizedClassForName(className) != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ReturnValue invokeConstructor(Class<?> clazz, Object[] args) {
        try {
            Class<?>[] params;
            List<Constructor<?>> ctors = ReflectionAccessor.memoizedPublicConstructors(clazz, args.length);
            if (ctors.isEmpty()) {
                throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingConstructorErrMsg(clazz, args));
            }
            if (ctors.size() == 1) {
                Constructor<?> ctor = ctors.get(0);
                Object[] boxedArgs = Boxing.boxArgs(ctor.getParameterTypes(), args);
                return new ReturnValue(ctor.newInstance(boxedArgs));
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, true, ctor.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return new ReturnValue(ctor.newInstance(boxedArgs));
            }
            for (Constructor<?> ctor : ctors) {
                params = ctor.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, false, ctor.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return new ReturnValue(ctor.newInstance(boxedArgs));
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingConstructorErrMsg(clazz, args));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException("Failed to invoke constructor " + clazz.getName() + "(" + ReflectionAccessor.formatArgTypes(args) + ")", ex);
        }
    }

    public static ReturnValue invokeInstanceMethod(Object target, String methodName, Object[] args) {
        return ReflectionAccessor.invokeInstanceMethod(target, null, methodName, args);
    }

    public static ReturnValue invokeInstanceMethod(Object target, Class<?> targetFormalType, String methodName, Object[] args) {
        try {
            Class<?> clazz = targetFormalType == null ? target.getClass() : targetFormalType;
            List<Method> methods = ReflectionAccessor.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor.invokeMatchingMethod(methodName, methods, targetFormalType, target, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (targetFormalType == null) {
                throw new JavaMethodInvocationException(String.format("Failed to invoke instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
            }
            throw new JavaMethodInvocationException(String.format("Failed to invoke instance method '%s' on target '%s' with formal type '%s'", methodName, target == null ? "<null>" : target.getClass().getName(), targetFormalType.getName()), ex);
        }
    }

    public static ReturnValue invokeStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        if (methodName.equals("new")) {
            return ReflectionAccessor.invokeConstructor(clazz, args);
        }
        try {
            List<Method> methods = ReflectionAccessor.memoizedStaticMethod(clazz, methodName, args.length, true);
            return ReflectionAccessor.invokeMatchingMethod(methodName, methods, null, null, args);
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to invoke static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static ReturnValue getStaticField(Class<?> clazz, String fieldName) {
        try {
            MethodHandle mh = ReflectionAccessor.memoizedStaticFieldGet(clazz, fieldName);
            if (mh != null) {
                return new ReturnValue(mh.invoke());
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get static field '%s' on class '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static ReturnValue getInstanceField(Object target, Class<?> targetFormalType, String fieldName) {
        try {
            Class<?> clazz = targetFormalType == null ? target.getClass() : targetFormalType;
            MethodHandle mh = ReflectionAccessor.memoizedInstanceField(clazz, fieldName);
            if (mh != null) {
                return new ReturnValue(mh.invoke(target));
            }
            throw new JavaMethodInvocationException(ReflectionAccessor.noMatchingFieldErrMsg(fieldName, clazz.getName()));
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new JavaMethodInvocationException(String.format("Failed to get instance field '%s' on target '%s'", fieldName, target.getClass().getName()), ex);
        }
    }

    public static List<String> getBeanGetterProperties(Object target) {
        return ReflectionAccessor.memoizedBeanGetterProperties(target.getClass());
    }

    public static List<String> getBeanSetterProperties(Object target) {
        return ReflectionAccessor.memoizedBeanSetterProperties(target.getClass());
    }

    public static ReturnValue getBeanProperty(Object target, String propertyName) {
        Method method = ReflectionAccessor.memoizedBeanGetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean get property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            return new ReturnValue(method.invoke(target, new Object[0]));
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(ReflectionAccessor.failedToGetBeanPropertyErrMsg(target, propertyName), ex);
        }
    }

    public static void setBeanProperty(Object target, String propertyName, Object value) {
        Method method = ReflectionAccessor.memoizedBeanSetterMethod(target.getClass(), propertyName);
        if (method == null) {
            throw new JavaMethodInvocationException(String.format("No bean set property '%s' on target '%s'", propertyName, target.getClass().getName()));
        }
        try {
            Class<?> type = method.getParameterTypes()[0];
            method.invoke(target, Boxing.boxArg(type, value));
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(ReflectionAccessor.failedToSetBeanPropertyErrMsg(target, propertyName), ex);
        }
    }

    public static boolean isStaticMethod(Class<?> clazz, String methodName, Object[] args) {
        try {
            List<Method> methods = ReflectionAccessor.memoizedStaticMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed check for available static method '%s' on class '%s'", methodName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceMethod(Object target, String methodName, Object[] args) {
        try {
            Class<?> clazz = target.getClass();
            List<Method> methods = ReflectionAccessor.memoizedInstanceMethod(clazz, methodName, args.length, true);
            return !methods.isEmpty();
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance method '%s' on target '%s'", methodName, target == null ? "<null>" : target.getClass().getName()), ex);
        }
    }

    public static boolean isStaticField(Class<?> clazz, String fieldName) {
        try {
            return ReflectionAccessor.memoizedStaticFieldGet(clazz, fieldName) != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available static field '%s' on target '%s'", fieldName, clazz.getName()), ex);
        }
    }

    public static boolean isInstanceField(Object target, String fieldName) {
        Class<?> clazz = target.getClass();
        try {
            return ReflectionAccessor.memoizedInstanceField(clazz, fieldName) != null;
        }
        catch (JavaMethodInvocationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(String.format("Failed to check for available instance field '%s' on target '%s'", fieldName, clazz.getName()), ex);
        }
    }

    private static ReturnValue invokeMatchingMethod(String methodName, List<Method> methods, Class<?> targetFormalType, Object target, Object[] args) {
        if (methods.size() == 1) {
            Method m = methods.get(0);
            Object[] boxedArgs = Boxing.boxArgs(m.getParameterTypes(), args);
            return ReflectionAccessor.invoke(m, target, boxedArgs);
        }
        if (methods.size() > 1) {
            Class<?>[] params;
            for (Method m : methods) {
                params = m.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, true, m.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return ReflectionAccessor.invoke(m, target, boxedArgs);
            }
            for (Method m : methods) {
                params = m.getParameterTypes();
                if (!ArgTypeMatcher.isCongruent(params, args, false, m.isVarArgs())) continue;
                Object[] boxedArgs = Boxing.boxArgs(params, args);
                return ReflectionAccessor.invoke(m, target, boxedArgs);
            }
        }
        String errMsg = String.format("No matching public method found: %s(%s) for target '%s'%s", methodName, ReflectionAccessor.formatArgTypes(args), target == null ? "<null>" : target.getClass().getName(), targetFormalType == null ? "" : String.format(" as formal type '%s'", targetFormalType.getName()));
        throw new JavaMethodInvocationException(errMsg);
    }

    private static ReturnValue invoke(Method method, Object target, Object[] args) {
        try {
            if (method.getDeclaringClass().getName().equals("java.util.stream.ReferencePipeline")) {
                return new ReturnValue(ReflectionAccessor.invokeStreamMethod(method.getName(), target, args), method.getReturnType());
            }
            return new ReturnValue(method.invoke(target, args), method.getReturnType());
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JavaMethodInvocationException(target == null ? String.format("Failed to invoke static method %s(%s) on class %s", method.getName(), ReflectionAccessor.formatMethodArgTypes(method.getParameterTypes()), method.getDeclaringClass().getName()) : String.format("Failed to invoke instance method %s(%s) on target %s", method.getName(), ReflectionAccessor.formatMethodArgTypes(method.getParameterTypes()), target.getClass().getName()), ex);
        }
    }

    private static Object invokeStreamMethod(String methodName, Object target, Object[] args) {
        Stream stream = (Stream)target;
        switch (methodName) {
            case "allMatch": {
                return stream.allMatch((Predicate)args[0]);
            }
            case "anyMatch": {
                return stream.anyMatch((Predicate)args[0]);
            }
            case "collect": {
                switch (args.length) {
                    case 1: {
                        return stream.collect((Collector)args[0]);
                    }
                    case 3: {
                        return stream.collect((Supplier)args[0], (BiConsumer)args[1], (BiConsumer)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'collect' with " + args.length + " parameters");
            }
            case "distinct": {
                return stream.distinct();
            }
            case "filter": {
                return stream.filter((Predicate)args[0]);
            }
            case "findAny": {
                return stream.findAny();
            }
            case "findFirst": {
                return stream.findFirst();
            }
            case "limit": {
                return stream.limit((Long)args[0]);
            }
            case "map": {
                return stream.map((Function)args[0]);
            }
            case "mapToDouble": {
                return stream.mapToDouble((ToDoubleFunction)args[0]);
            }
            case "mapToInt": {
                return stream.mapToInt((ToIntFunction)args[0]);
            }
            case "mapToLong": {
                return stream.mapToLong((ToLongFunction)args[0]);
            }
            case "max": {
                return stream.max((Comparator)args[0]);
            }
            case "min": {
                return stream.min((Comparator)args[0]);
            }
            case "noneMatch": {
                return stream.noneMatch((Predicate)args[0]);
            }
            case "reduce": {
                switch (args.length) {
                    case 1: {
                        return stream.reduce((BinaryOperator)args[0]);
                    }
                    case 2: {
                        return stream.reduce(args[0], (BinaryOperator)args[1]);
                    }
                    case 3: {
                        return stream.reduce(args[0], (BiFunction)args[1], (BinaryOperator)args[2]);
                    }
                }
                throw new JavaMethodInvocationException("Unsupported stream method 'reduce' with " + args.length + " parameters");
            }
            case "sorted": {
                return args.length == 0 ? stream.sorted() : stream.sorted((Comparator)args[0]);
            }
            case "skip": {
                return stream.skip((Long)args[0]);
            }
        }
        throw new JavaMethodInvocationException("Unsupported stream method '" + methodName + "'");
    }

    private static String noMatchingFieldErrMsg(String fieldName, Object target) {
        return String.format("No matching public field found: '%s' for target '%s'", fieldName, target == null ? "<null>" : target.getClass().getName());
    }

    private static String noMatchingConstructorErrMsg(Class<?> clazz, Object[] args) {
        return "No matching public constructor found: " + clazz.getName() + "(" + ReflectionAccessor.formatArgTypes(args) + ")";
    }

    private static String failedToGetBeanPropertyErrMsg(Object target, String propertyName) {
        return String.format("Failed to get bean property '%s' on target '%s'", propertyName, target.getClass().getName());
    }

    private static String failedToSetBeanPropertyErrMsg(Object target, String propertyName) {
        return String.format("Failed to set bean property '%s' on target '%s'", propertyName, target.getClass().getName());
    }

    private static Class<?> memoizedClassForName(String className) {
        return classCache.computeIfAbsent(className, k -> ReflectionUtil.classForName(k));
    }

    private static List<String> memoizedBeanGetterProperties(Class<?> clazz) {
        return getterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanGetterProperties(k));
    }

    private static List<String> memoizedBeanSetterProperties(Class<?> clazz) {
        return setterPropertiesCache.computeIfAbsent(clazz, k -> ReflectionUtil.getBeanSetterProperties(k));
    }

    private static Method memoizedBeanGetterMethod(Class<?> clazz, String propertyName) {
        return getterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanGetterMethod((Class)k._1, (String)k._2));
    }

    private static Method memoizedBeanSetterMethod(Class<?> clazz, String propertyName) {
        return setterMethodCache.computeIfAbsent(new Tuple2(clazz, propertyName), k -> ReflectionUtil.getBeanSetterMethod((Class)k._1, (String)k._2));
    }

    private static List<Constructor<?>> memoizedPublicConstructors(Class<?> clazz, int args) {
        return constructorCache.computeIfAbsent(new Tuple2(clazz, args), k -> ReflectionUtil.getPublicConstructors((Class)k._1, (Integer)k._2));
    }

    private static MethodHandle memoizedStaticFieldGet(Class<?> clazz, String fieldName) {
        return staticFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> MethodHandleUtil.staticField_get((Class)k._1, (String)k._2));
    }

    private static MethodHandle memoizedInstanceField(Class<?> clazz, String fieldName) {
        return instanceFieldCache.computeIfAbsent(new Tuple2(clazz, fieldName), k -> MethodHandleUtil.instanceField_get((Class)k._1, (String)k._2));
    }

    private static List<Method> memoizedStaticMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return staticMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicStaticMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4));
    }

    private static List<Method> memoizedInstanceMethod(Class<?> clazz, String methodName, Integer arity, boolean includeInheritedClasses) {
        return instanceMethodCache.computeIfAbsent(new Tuple4(clazz, methodName, arity, includeInheritedClasses), k -> ReflectionUtil.getAllPublicInstanceMethods((Class)k._1, (String)k._2, (Integer)k._3, (Boolean)k._4));
    }

    private static String formatArgTypes(Object[] args) {
        return Arrays.stream(args).map(o -> o == null ? "null" : o.getClass().getName()).collect(Collectors.joining(", "));
    }

    private static String formatMethodArgTypes(Class<?>[] args) {
        return Arrays.stream(args).map(o -> o.getName()).collect(Collectors.joining(", "));
    }
}

