/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.VeniceClasspath;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.pdf.PdfRenderer;
import java.nio.ByteBuffer;
import java.util.Map;

public class CheatsheetRenderer {
    public static String renderXHTML(Map<String, Object> data) {
        try {
            String template = CheatsheetRenderer.loadCheatSheetTemplate();
            String script = "(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ";
            return (String)new Venice().eval("(do                                           \n   (load-module :kira)                        \n   (kira/eval template [\"${\" \"}$\"] data))   ", Parameters.of("template", template, "data", data));
        }
        catch (VncException ex) {
            throw new RuntimeException("Failed to render cheatsheet XHTML. \nVenice Callstack: \n" + ex.getCallStackAsString("   "), ex);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to render cheatsheet XHTML", ex);
        }
    }

    public static ByteBuffer renderPDF(String xhtml) {
        return PdfRenderer.render(xhtml, "classpath:/com/github/jlangch/venice/fonts/");
    }

    private static String loadCheatSheetTemplate() {
        return new ClassPathResource(VeniceClasspath.getVeniceBasePath() + "docgen/cheatsheet2.html").getResourceAsString("UTF-8");
    }
}

