/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

import com.github.jlangch.venice.impl.docgen.ExampleOutput;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;

public class DocItem {
    private final String name;
    private final String altName;
    private final String id;
    private final List<String> signatures;
    private final String description;
    private final List<ExampleOutput> examples;

    public DocItem(String name, List<String> signatures, String description, List<ExampleOutput> examples, String id) {
        this.name = name;
        this.altName = this.convertSlash(this.convertDash(name));
        this.signatures = signatures;
        this.description = description;
        this.examples = examples;
        this.id = id;
    }

    public DocItem(String name, String id) {
        this(name, null, null, null, id);
    }

    public String getName() {
        return this.name;
    }

    public String getAltName() {
        return this.altName;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExamples() {
        return this.renderExamples();
    }

    public String renderExamples() {
        return StringUtil.trimToNull(this.examples.stream().map(o -> o.render()).collect(Collectors.joining("\n\n")));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DocItem other = (DocItem)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private String convertSlash(String s) {
        return s;
    }

    private String convertDash(String s) {
        return s.replace('-', '\u2212');
    }
}

