/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VncMutableList
extends VncSequence {
    public static final VncKeyword TYPE = new VncKeyword(":core/mutable-list");
    private static final long serialVersionUID = -1848883965231344442L;
    private final CopyOnWriteArrayList<VncVal> value;

    public VncMutableList() {
        this((Collection<? extends VncVal>)null, (VncVal)null);
    }

    public VncMutableList(VncVal meta) {
        this((Collection<? extends VncVal>)null, meta);
    }

    public VncMutableList(Collection<? extends VncVal> vals) {
        this(vals, null);
    }

    public VncMutableList(Collection<? extends VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? new CopyOnWriteArrayList() : (vals instanceof CopyOnWriteArrayList ? (CopyOnWriteArrayList<Object>)vals : new CopyOnWriteArrayList<VncVal>(vals));
    }

    public static VncMutableList of(VncVal ... mvs) {
        return new VncMutableList(Arrays.asList(mvs), (VncVal)Constants.Nil);
    }

    @Override
    public VncMutableList emptyWithMeta() {
        return new VncMutableList(this.getMeta());
    }

    @Override
    public VncMutableList withVariadicValues(VncVal ... replaceVals) {
        return VncMutableList.of(replaceVals).withMeta(this.getMeta());
    }

    @Override
    public VncMutableList withValues(List<? extends VncVal> replaceVals) {
        return new VncMutableList(replaceVals, this.getMeta());
    }

    @Override
    public VncMutableList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return new VncMutableList(replaceVals, meta);
    }

    @Override
    public VncMutableList withMeta(VncVal meta) {
        return new VncMutableList(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSequence.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSequence.TYPE, VncVal.TYPE);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super E v) -> action.accept((VncVal)v));
    }

    @Override
    public VncList filter(Predicate<? super VncVal> predicate) {
        return new VncList(this.value.stream().filter(predicate).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncList map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncList(this.value.stream().map(mapper).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public List<VncVal> getList() {
        return this.value;
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a mutable list of size %d. %s", idx, this.size(), this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.value.get(0))));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.get(0);
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : this.value.get(this.value.size() - 1);
    }

    @Override
    public VncMutableList rest() {
        return this.value.size() <= 1 ? new VncMutableList(this.getMeta()) : this.slice(1);
    }

    @Override
    public VncMutableList butlast() {
        return this.value.size() <= 1 ? new VncMutableList(this.getMeta()) : this.slice(0, this.value.size() - 1);
    }

    @Override
    public VncMutableList drop(int n) {
        return this.slice(n);
    }

    @Override
    public VncMutableList dropWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean drop = predicate.test(VncList.of(this.value.get(i)));
            if (drop) continue;
            return this.slice(i);
        }
        return new VncMutableList(this.getMeta());
    }

    @Override
    public VncMutableList take(int n) {
        return this.slice(0, n);
    }

    @Override
    public VncMutableList takeWhile(Predicate<? super VncVal> predicate) {
        for (int i = 0; i < this.value.size(); ++i) {
            boolean take = predicate.test(VncList.of(this.value.get(i)));
            if (take) continue;
            return this.slice(0, i);
        }
        return this;
    }

    @Override
    public VncMutableList slice(int start, int end) {
        if (start >= this.value.size()) {
            return new VncMutableList(this.getMeta());
        }
        return new VncMutableList(this.value.subList(start, Math.min(end, this.value.size())), this.getMeta());
    }

    @Override
    public VncMutableList slice(int start) {
        return this.slice(start, this.value.size());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value, this.getMeta());
    }

    @Override
    public VncMutableList addAtStart(VncVal val) {
        this.value.add(0, val);
        return this;
    }

    @Override
    public VncMutableList addAllAtStart(VncSequence list) {
        this.value.addAll(0, list.getList());
        return this;
    }

    @Override
    public VncMutableList addAtEnd(VncVal val) {
        this.value.add(val);
        return this;
    }

    @Override
    public VncMutableList addAllAtEnd(VncSequence list) {
        this.value.addAll(list.getList());
        return this;
    }

    @Override
    public VncMutableList setAt(int idx, VncVal val) {
        this.value.set(idx, val);
        return this;
    }

    @Override
    public VncMutableList removeAt(int idx) {
        this.value.remove(idx);
        return this;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MUTABLELIST;
    }

    @Override
    public boolean isVncList() {
        return true;
    }

    @Override
    public Object convertToJavaObject() {
        return this.getList().stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncList(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncMutableList)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncMutableList)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncMutableList other = (VncMutableList)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "(" + Printer.join(this.value, " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.value, " ", print_readably) + ")";
    }
}

