/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.repackage.io.vavr.collection.TreeSet;

public class VncSortedSet
extends VncSet {
    public static final VncKeyword TYPE = new VncKeyword(":core/sorted-set");
    private static final long serialVersionUID = -1848883965231344442L;
    private final TreeSet<VncVal> value;

    public VncSortedSet() {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, (VncVal)null);
    }

    public VncSortedSet(VncVal meta) {
        this((org.repackage.io.vavr.collection.Set<VncVal>)null, meta);
    }

    public VncSortedSet(org.repackage.io.vavr.collection.Set<VncVal> val) {
        this(val, null);
    }

    public VncSortedSet(org.repackage.io.vavr.collection.Set<VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? TreeSet.empty() : (val instanceof TreeSet ? (TreeSet<Object>)val : TreeSet.ofAll(val));
    }

    public static VncSortedSet ofAll(Collection<? extends VncVal> val) {
        return new VncSortedSet(TreeSet.ofAll(val));
    }

    public static VncSortedSet ofAll(VncSequence val) {
        return new VncSortedSet(TreeSet.ofAll(val.getList()));
    }

    public static VncSortedSet of(VncVal ... mvs) {
        return new VncSortedSet(TreeSet.of(mvs));
    }

    @Override
    public VncSortedSet emptyWithMeta() {
        return new VncSortedSet(this.getMeta());
    }

    @Override
    public VncSortedSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncSortedSet(TreeSet.ofAll(replaceVals), this.getMeta());
    }

    @Override
    public VncSortedSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncSortedSet(TreeSet.ofAll(replaceVals), meta);
    }

    @Override
    public VncSortedSet withMeta(VncVal meta) {
        return new VncSortedSet(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSet.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSet.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public VncSortedSet add(VncVal val) {
        return new VncSortedSet(this.value.add((Object)val), this.getMeta());
    }

    @Override
    public VncSortedSet addAll(VncSet val) {
        return new VncSortedSet(this.value.addAll(val.getSet()), this.getMeta());
    }

    @Override
    public VncSortedSet addAll(VncSequence val) {
        return new VncSortedSet(this.value.addAll(val.getList()), this.getMeta());
    }

    @Override
    public VncSortedSet remove(VncVal val) {
        return new VncSortedSet(this.value.remove((Object)val), this.getMeta());
    }

    @Override
    public VncSortedSet removeAll(VncSet val) {
        return new VncSortedSet(this.value.removeAll(val.getSet()), this.getMeta());
    }

    @Override
    public VncSortedSet removeAll(VncSequence val) {
        return new VncSortedSet(this.value.removeAll(val.getList()), this.getMeta());
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public Set<VncVal> getSet() {
        return Collections.unmodifiableSet(this.value.toJavaSet());
    }

    @Override
    public List<VncVal> getList() {
        return Collections.unmodifiableList(this.value.toJavaList());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.getList(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.getList(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SORTEDSET;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSortedSet(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncSortedSet)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSortedSet other = (VncSortedSet)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.getList(), " ", print_readably) + "}";
    }
}

