/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <U> List<U> toList(U object) {
        ArrayList<U> list = new ArrayList<U>();
        if (object != null) {
            list.add(object);
        }
        return list;
    }

    public static <U> List<U> toUnmodifiableList(U object) {
        return Collections.unmodifiableList(CollectionUtil.toList(object));
    }

    @SafeVarargs
    public static <U> List<U> toList(U ... objects) {
        return objects == null ? new ArrayList() : Arrays.asList(objects);
    }

    public static <U> ArrayList<U> toList(Enumeration<U> enumeration) {
        ArrayList<U> list = new ArrayList<U>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    @SafeVarargs
    public static <U> List<U> toUnmodifiableList(U ... objects) {
        return Collections.unmodifiableList(CollectionUtil.toList(objects));
    }

    public static <U> Set<U> toSet(U object) {
        HashSet<U> set = new HashSet<U>();
        if (object != null) {
            set.add(object);
        }
        return set;
    }

    public static <U> Set<U> toUnmodifiableSet(U object) {
        return Collections.unmodifiableSet(CollectionUtil.toSet(object));
    }

    @SafeVarargs
    public static <U> Set<U> toSet(U ... objects) {
        HashSet<U> set = new HashSet<U>();
        if (objects != null) {
            for (U obj : objects) {
                set.add(obj);
            }
        }
        return set;
    }

    @SafeVarargs
    public static <U> Set<U> toUnmodifiableSet(U ... objects) {
        return Collections.unmodifiableSet(CollectionUtil.toSet(objects));
    }
}

