/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.io;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.util.io.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoadPaths
implements ILoadPaths {
    private final List<File> paths = new ArrayList<File>();
    private final boolean unlimitedAccess;

    private LoadPaths(List<File> paths, boolean unlimitedAccess) {
        if (paths != null) {
            this.paths.addAll(paths);
        }
        this.unlimitedAccess = unlimitedAccess;
    }

    public static LoadPaths of(List<File> paths, boolean unlimitedAccess) {
        if (paths == null || paths.isEmpty()) {
            return new LoadPaths(null, unlimitedAccess);
        }
        ArrayList<File> savePaths = new ArrayList<File>();
        for (File p : paths) {
            if (p == null || !p.isFile() && !p.isDirectory()) continue;
            savePaths.add(LoadPaths.canonical(p.getAbsoluteFile()));
        }
        return new LoadPaths(savePaths, unlimitedAccess);
    }

    @Override
    public String loadVeniceFile(File file) {
        if (file == null) {
            return null;
        }
        String path = file.getPath();
        String vncFile = path.endsWith(".venice") ? path : path + ".venice";
        ByteBuffer data = this.load(new File(vncFile));
        return data == null ? null : new String(data.array(), this.getCharset("UTF-8"));
    }

    @Override
    public ByteBuffer loadBinaryResource(File file) {
        return this.load(file);
    }

    @Override
    public String loadTextResource(File file, String encoding) {
        ByteBuffer data = this.load(file);
        return data == null ? null : new String(data.array(), this.getCharset(encoding));
    }

    @Override
    public List<File> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    @Override
    public boolean isUnlimitedAccess() {
        return this.unlimitedAccess;
    }

    private ByteBuffer load(File file) {
        ByteBuffer dataFromLoadPath = this.paths.stream().map(p -> this.loadFromLoadPath((File)p, file)).filter(d -> d != null).findFirst().orElse(null);
        if (dataFromLoadPath != null) {
            return dataFromLoadPath;
        }
        if (this.unlimitedAccess && file.isFile()) {
            return this.loadFile(file);
        }
        return null;
    }

    private ByteBuffer loadFromLoadPath(File loadPath, File file) {
        if (loadPath.getName().endsWith(".zip")) {
            return this.loadFileFromZip(loadPath, file);
        }
        if (loadPath.isDirectory()) {
            return this.loadFileFromDir(loadPath, file);
        }
        if (loadPath.isFile()) {
            File f = LoadPaths.canonical(file);
            if (loadPath.equals(f)) {
                try {
                    return ByteBuffer.wrap(Files.readAllBytes(f.toPath()));
                }
                catch (IOException ex) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    private ByteBuffer loadFileFromZip(File zip, File file) {
        if (zip.exists()) {
            try {
                return ZipFileSystemUtil.loadBinaryFileFromZip(zip, file).getValue();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    private ByteBuffer loadFileFromDir(File loadPath, File file) {
        try {
            if (file.isAbsolute()) {
                return this.isFileWithinDirectory(loadPath, file) ? this.loadFile(file) : null;
            }
            File f = new File(loadPath, file.getPath());
            return f.isFile() ? this.loadFile(new File(loadPath, file.getPath())) : null;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load file '%s'", file.getPath()), ex);
        }
    }

    private static File canonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new VncException(String.format("The file '%s' can not be converted to a canonical path!", file.getPath()), ex);
        }
    }

    private ByteBuffer loadFile(File file) {
        try {
            return ByteBuffer.wrap(Files.readAllBytes(file.toPath()));
        }
        catch (IOException ex) {
            return null;
        }
    }

    private boolean isFileWithinDirectory(File dir, File file) throws IOException {
        File fl;
        File dir_ = dir.getAbsoluteFile();
        return dir_.isDirectory() && (fl = new File(dir_, file.getPath())).isFile() && fl.getCanonicalPath().startsWith(dir_.getCanonicalPath());
    }

    private Charset getCharset(String encoding) {
        return encoding == null || encoding.isEmpty() ? Charset.defaultCharset() : Charset.forName(encoding);
    }
}

