/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.CustomWrappableTypes;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.ReadEvalFunction;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.ReservedSymbols;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.specialforms.CatchBlock;
import com.github.jlangch.venice.impl.specialforms.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.DocForm;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private final IInterceptor interceptor;
    private final boolean checkSandbox;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private final CustomWrappableTypes wrappableTypes = new CustomWrappableTypes();
    private final AtomicBoolean sealedSystemNS = new AtomicBoolean(false);
    private final AtomicLong macroExpandAllCountEffective = new AtomicLong(0L);
    private final AtomicLong macroExpandAllCount = new AtomicLong(0L);
    private final AtomicLong macroExpandCount = new AtomicLong(0L);
    private volatile boolean macroexpand = false;

    public VeniceInterpreter(IInterceptor interceptor) {
        if (interceptor == null) {
            throw new SecurityException("VeniceInterpreter can not run without an interceptor");
        }
        this.interceptor = interceptor;
        this.meterRegistry = this.interceptor.getMeterRegistry();
        this.checkSandbox = !(interceptor instanceof AcceptAllInterceptor);
    }

    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    public void setMacroexpandOnLoad(boolean macroexpandOnLoad, Env env) {
        env.setMacroexpandOnLoad(VncBoolean.of(macroexpandOnLoad));
        this.macroexpand = macroexpandOnLoad;
    }

    public boolean isMacroexpandOnLoad() {
        return this.macroexpand;
    }

    public VncVal READ(String script, String filename) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = Reader.read_str(script, filename);
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
            return val;
        }
        return Reader.read_str(script, filename);
    }

    public VncVal EVAL(VncVal ast, Env env) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = this.evaluate(ast, env);
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
            return val;
        }
        return this.evaluate(ast, env);
    }

    public VncVal MACROEXPAND(VncVal ast, Env env) {
        return this.macroexpand_all(ast, env);
    }

    public VncVal RE(String script, String name, Env env) {
        VncVal ast = this.READ(script, name);
        if (this.macroexpand) {
            ast = this.MACROEXPAND(ast, env);
        }
        return this.EVAL(ast, env);
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    public Env createEnv(List<String> preloadedExtensionModules, boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = new VncMutableSet(ModuleLoader.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        }
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString(Version.VERSION), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode.mode, false));
        env.setGlobal(new Var(new VncSymbol("*loaded-modules*"), loadedModules, true));
        env.setGlobal(new Var(new VncSymbol("*loaded-files*"), new VncMutableSet(), true));
        this.initNS();
        this.setMacroexpandOnLoad(macroexpandOnLoad, env);
        this.loadModule("core", env, loadedModules);
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadedExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(ModuleLoader.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        long nanos = System.nanoTime();
        this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
        }
        loadedModules.add(new VncKeyword(module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private VncVal evaluate(VncVal ast_, Env env_) {
        if (!(ast_ instanceof VncList)) {
            return this.evaluate_values(ast_, env_);
        }
        recursionPoint = null;
        orig_ast = ast_;
        env = env_;
        block277: while (true) {
            if (!(orig_ast instanceof VncList)) {
                return this.evaluate_values(orig_ast, env);
            }
            expanded = this.macroexpand(orig_ast, env, null);
            if (!(expanded instanceof VncList)) {
                return this.evaluate_values(expanded, env);
            }
            ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            var10_10 = a0sym = a0 instanceof VncSymbol != false ? ((VncSymbol)a0).getName() : "__<*fn*>__";
            var11_11 = -1;
            switch (var10_10.hashCode()) {
                case 3211: {
                    if (!var10_10.equals("do")) break;
                    var11_11 = 0;
                    break;
                }
                case 99333: {
                    if (!var10_10.equals("def")) break;
                    var11_11 = 1;
                    break;
                }
                case 1545213958: {
                    if (!var10_10.equals("defonce")) break;
                    var11_11 = 2;
                    break;
                }
                case 1590555255: {
                    if (!var10_10.equals("def-dynamic")) break;
                    var11_11 = 3;
                    break;
                }
                case 654758631: {
                    if (!var10_10.equals("defmacro")) break;
                    var11_11 = 4;
                    break;
                }
                case 1545373887: {
                    if (!var10_10.equals("deftype")) break;
                    var11_11 = 5;
                    break;
                }
                case 661950304: {
                    if (!var10_10.equals("deftype?")) break;
                    var11_11 = 6;
                    break;
                }
                case 479068581: {
                    if (!var10_10.equals("deftype-of")) break;
                    var11_11 = 7;
                    break;
                }
                case 479068593: {
                    if (!var10_10.equals("deftype-or")) break;
                    var11_11 = 8;
                    break;
                }
                case 1484: {
                    if (!var10_10.equals(".:")) break;
                    var11_11 = 9;
                    break;
                }
                case 3526655: {
                    if (!var10_10.equals("set!")) break;
                    var11_11 = 10;
                    break;
                }
                case 655363156: {
                    if (!var10_10.equals("defmulti")) break;
                    var11_11 = 11;
                    break;
                }
                case -1173127898: {
                    if (!var10_10.equals("defmethod")) break;
                    var11_11 = 12;
                    break;
                }
                case 3525: {
                    if (!var10_10.equals("ns")) break;
                    var11_11 = 13;
                    break;
                }
                case 1951546764: {
                    if (!var10_10.equals("ns-remove")) break;
                    var11_11 = 14;
                    break;
                }
                case -1180934629: {
                    if (!var10_10.equals("ns-unmap")) break;
                    var11_11 = 15;
                    break;
                }
                case 1252218203: {
                    if (!var10_10.equals("namespace")) break;
                    var11_11 = 16;
                    break;
                }
                case -1184795739: {
                    if (!var10_10.equals("import")) break;
                    var11_11 = 17;
                    break;
                }
                case 1926037870: {
                    if (!var10_10.equals("imports")) break;
                    var11_11 = 18;
                    break;
                }
                case 1097368044: {
                    if (!var10_10.equals("resolve")) break;
                    var11_11 = 19;
                    break;
                }
                case 235003824: {
                    if (!var10_10.equals("var-get")) break;
                    var11_11 = 20;
                    break;
                }
                case 1957454356: {
                    if (!var10_10.equals("inspect")) break;
                    var11_11 = 21;
                    break;
                }
                case 820867430: {
                    if (!var10_10.equals("macroexpand")) break;
                    var11_11 = 22;
                    break;
                }
                case 846111568: {
                    if (!var10_10.equals("*macroexpand-all")) break;
                    var11_11 = 23;
                    break;
                }
                case -544537419: {
                    if (!var10_10.equals("macroexpand-info")) break;
                    var11_11 = 24;
                    break;
                }
                case 107953788: {
                    if (!var10_10.equals("quote")) break;
                    var11_11 = 25;
                    break;
                }
                case 1896636553: {
                    if (!var10_10.equals("quasiquote")) break;
                    var11_11 = 26;
                    break;
                }
                case 99640: {
                    if (!var10_10.equals("doc")) break;
                    var11_11 = 27;
                    break;
                }
                case 1227433863: {
                    if (!var10_10.equals("modules")) break;
                    var11_11 = 28;
                    break;
                }
                case 3125404: {
                    if (!var10_10.equals("eval")) break;
                    var11_11 = 29;
                    break;
                }
                case 107035: {
                    if (!var10_10.equals("let")) break;
                    var11_11 = 30;
                    break;
                }
                case -108220795: {
                    if (!var10_10.equals("binding")) break;
                    var11_11 = 31;
                    break;
                }
                case -1383205247: {
                    if (!var10_10.equals("bound?")) break;
                    var11_11 = 32;
                    break;
                }
                case -173865320: {
                    if (!var10_10.equals("global-vars-count")) break;
                    var11_11 = 33;
                    break;
                }
                case 3327652: {
                    if (!var10_10.equals("loop")) break;
                    var11_11 = 34;
                    break;
                }
                case 108389165: {
                    if (!var10_10.equals("recur")) break;
                    var11_11 = 35;
                    break;
                }
                case 115131: {
                    if (!var10_10.equals("try")) break;
                    var11_11 = 36;
                    break;
                }
                case 1908075928: {
                    if (!var10_10.equals("try-with")) break;
                    var11_11 = 37;
                    break;
                }
                case 95772192: {
                    if (!var10_10.equals("dorun")) break;
                    var11_11 = 38;
                    break;
                }
                case 1827513477: {
                    if (!var10_10.equals("dobench")) break;
                    var11_11 = 39;
                    break;
                }
                case 3357: {
                    if (!var10_10.equals("if")) break;
                    var11_11 = 40;
                    break;
                }
                case 3272: {
                    if (!var10_10.equals("fn")) break;
                    var11_11 = 41;
                    break;
                }
                case 3449689: {
                    if (!var10_10.equals("prof")) break;
                    var11_11 = 42;
                    break;
                }
                case 338706135: {
                    if (!var10_10.equals("locking")) break;
                    var11_11 = 43;
                }
            }
            switch (var11_11) {
                case 0: {
                    expressions = ast.rest();
                    this.evaluate_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 1: {
                    name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "def");
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobal(new Var((VncSymbol)name, res, true));
                    return name;
                }
                case 2: {
                    name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "defonce");
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobal(new Var((VncSymbol)name, res, false));
                    return name;
                }
                case 3: {
                    name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "def-dynamic");
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobalDynamic((VncSymbol)name, res);
                    return name;
                }
                case 4: {
                    cs = new WithCallStack(new CallFrame("defmacro", ast));
                    val = null;
                    try {
                        res = this.defmacro_(ast, env);
                        return res;
                    }
                    catch (Throwable res) {
                        val = res;
                        throw res;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var15_59) {
                                    val.addSuppressed(var15_59);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 5: {
                    cs = new WithCallStack(new CallFrame("deftype", ast));
                    val = null;
                    try {
                        type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
                        fields = Coerce.toVncVector(ast.third());
                        validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
                        var17_92 /* !! */  = DefTypeForm.defineCustomType(type, fields, (VncFunction)validationFn, (ReadEvalFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;, RE(java.lang.String java.lang.String com.github.jlangch.venice.impl.env.Env ), (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;)((VeniceInterpreter)this), env);
                        return var17_92 /* !! */ ;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var18_96) {
                                    val.addSuppressed(var18_96);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 6: {
                    cs = new WithCallStack(new CallFrame("deftype?", ast));
                    val = null;
                    try {
                        type = this.evaluate(ast.second(), env);
                        fields = VncBoolean.of(DefTypeForm.isCustomType(type, env));
                        return fields;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable validationFn) {
                                    val.addSuppressed(validationFn);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 7: {
                    cs = new WithCallStack(new CallFrame("deftype-of", ast));
                    val = null;
                    try {
                        type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
                        baseType = Coerce.toVncKeyword(this.evaluate(ast.third(), env));
                        validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
                        var17_92 /* !! */  = DefTypeForm.defineCustomWrapperType(type, baseType, (VncFunction)validationFn, (ReadEvalFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;, RE(java.lang.String java.lang.String com.github.jlangch.venice.impl.env.Env ), (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;)((VeniceInterpreter)this), env, this.wrappableTypes);
                        return var17_92 /* !! */ ;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var18_97) {
                                    val.addSuppressed(var18_97);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 8: {
                    cs = new WithCallStack(new CallFrame("deftype-or", ast));
                    val = null;
                    try {
                        type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
                        choiceVals = ast.slice(2);
                        validationFn = DefTypeForm.defineCustomChoiceType(type, choiceVals, (ReadEvalFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;, RE(java.lang.String java.lang.String com.github.jlangch.venice.impl.env.Env ), (Ljava/lang/String;Ljava/lang/String;Lcom/github/jlangch/venice/impl/env/Env;)Lcom/github/jlangch/venice/impl/types/VncVal;)((VeniceInterpreter)this), env);
                        return validationFn;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var17_94) {
                                    val.addSuppressed(var17_94);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 9: {
                    args = new ArrayList<VncVal>();
                    iter = ast.rest().iterator();
                    while (iter.hasNext()) {
                        v = iter.next();
                        args.add(this.evaluate(v, env));
                    }
                    return DefTypeForm.createType(args, env);
                }
                case 10: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    globVar = env.getGlobalVarOrNull((VncSymbol)name);
                    if (globVar != null) {
                        expr = ast.third();
                        val = this.evaluate(expr, env).withMeta(name.getMeta());
                        if (globVar instanceof DynamicVar) {
                            env.popGlobalDynamic(globVar.getName());
                            env.pushGlobalDynamic(globVar.getName(), val);
                        } else {
                            env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable()));
                        }
                        return val;
                    }
                    cs = new WithCallStack(new CallFrame("set!", name));
                    val = null;
                    try {
                        try {
                            throw new VncException(String.format("The global var or thread-local '%s' does not exist!", new Object[]{name.getName()}));
                        }
                        catch (Throwable validationFn) {
                            val = validationFn;
                            throw validationFn;
                        }
                    }
                    catch (Throwable var27_114) {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var28_115) {
                                    val.addSuppressed(var28_115);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var27_114;
                    }
                }
                case 11: {
                    name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "defmulti");
                    dispatchFn /* !! */  = Types.isVncKeyword(ast.third()) != false ? (VncKeyword)ast.third() : (Types.isVncSymbol(ast.third()) != false ? Coerce.toVncFunction(env.get((VncSymbol)ast.third())) : this.fn_(Coerce.toVncList(ast.third()), env));
                    multiFn = new VncMultiFunction(name.getName(), dispatchFn /* !! */ ).withMeta(name.getMeta());
                    env.setGlobal(new Var((VncSymbol)name, multiFn, true));
                    return multiFn;
                }
                case 12: {
                    multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(ast.second()));
                    multiFnVal = env.getGlobalOrNull(multiFnName);
                    if (multiFnVal == null) {
                        cs = new WithCallStack(new CallFrame("defmethod", ast));
                        val = null;
                        try {
                            try {
                                throw new VncException(String.format("No multifunction '%s' defined for the method definition", new Object[]{multiFnName.getName()}));
                            }
                            catch (Throwable validationFn) {
                                val = validationFn;
                                throw validationFn;
                            }
                        }
                        catch (Throwable var29_116) {
                            if (cs != null) {
                                if (val != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var30_117) {
                                        val.addSuppressed(var30_117);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var29_116;
                        }
                    }
                    multiFn = Coerce.toVncMultiFunction(multiFnVal);
                    dispatchVal = ast.third();
                    params = Coerce.toVncVector(ast.fourth());
                    if (params.size() != multiFn.getParams().size()) {
                        cs = new WithCallStack(new CallFrame("defmethod", ast));
                        var18_95 = null;
                        try {
                            try {
                                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", new Object[]{multiFnName.getName(), multiFn.getParams().size()}));
                            }
                            catch (Throwable var19_102) {
                                var18_95 = var19_102;
                                throw var19_102;
                            }
                        }
                        catch (Throwable var31_118) {
                            if (cs != null) {
                                if (var18_95 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var32_119) {
                                        var18_95.addSuppressed(var32_119);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var31_118;
                        }
                    }
                    preConditions = this.getFnPreconditions(ast.nth(4), env);
                    body = ast.slice(preConditions == null ? 4 : 5);
                    fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, false, env);
                    return multiFn.addFn(dispatchVal, fn.withMeta(ast.getMeta()));
                }
                case 13: {
                    name = ast.second();
                    v0 = ns = Types.isVncSymbol(name) != false ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(new VncVal[]{this.evaluate(name, env)}));
                    if (ns.hasNamespace()) {
                        cs = new WithCallStack(new CallFrame("ns", ast));
                        dispatchVal = null;
                        try {
                            try {
                                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", new Object[]{ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()}));
                            }
                            catch (Throwable params) {
                                dispatchVal = params;
                                throw params;
                            }
                        }
                        catch (Throwable var33_120) {
                            if (cs != null) {
                                if (dispatchVal != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var34_121) {
                                        dispatchVal.addSuppressed(var34_121);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var33_120;
                        }
                    }
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        cs = new WithCallStack(new CallFrame("ns", ast));
                        dispatchVal = null;
                        try {
                            try {
                                throw new VncException("Namespace '" + ns.getName() + "' cannot be reopened!");
                            }
                            catch (Throwable params) {
                                dispatchVal = params;
                                throw params;
                            }
                        }
                        catch (Throwable var35_122) {
                            if (cs != null) {
                                if (dispatchVal != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var36_123) {
                                        dispatchVal.addSuppressed(var36_123);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var35_122;
                        }
                    }
                    Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns));
                    return ns;
                }
                case 14: {
                    ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        cs = new WithCallStack(new CallFrame("ns-remove", ast));
                        cs = null;
                        try {
                            try {
                                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
                            }
                            catch (Throwable dispatchVal) {
                                cs = dispatchVal;
                                throw dispatchVal;
                            }
                        }
                        catch (Throwable var37_124) {
                            if (cs != null) {
                                if (cs != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var38_125) {
                                        cs.addSuppressed(var38_125);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var37_124;
                        }
                    }
                    env.removeGlobalSymbolsByNS((VncSymbol)ns);
                    this.nsRegistry.remove((VncSymbol)ns);
                    return Constants.Nil;
                }
                case 15: {
                    ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        cs = new WithCallStack(new CallFrame("ns-unmap", ast));
                        cs = null;
                        try {
                            try {
                                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
                            }
                            catch (Throwable dispatchVal) {
                                cs = dispatchVal;
                                throw dispatchVal;
                            }
                        }
                        catch (Throwable var39_126) {
                            if (cs != null) {
                                if (cs != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var40_127) {
                                        cs.addSuppressed(var40_127);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var39_126;
                        }
                    }
                    sym = Coerce.toVncSymbol(ast.third()).withNamespace((VncSymbol)ns);
                    env.removeGlobalSymbol(sym);
                    return Constants.Nil;
                }
                case 16: {
                    val = this.evaluate(ast.second(), env);
                    if (val instanceof INamespaceAware) {
                        return new VncString(((INamespaceAware)val).getNamespace());
                    }
                    cs = new WithCallStack(new CallFrame("namespace", ast));
                    cs = null;
                    try {
                        try {
                            throw new VncException(String.format("The type '%s' does not support namespaces!", new Object[]{Types.getType(val)}));
                        }
                        catch (Throwable dispatchVal) {
                            cs = dispatchVal;
                            throw dispatchVal;
                        }
                    }
                    catch (Throwable var41_128) {
                        if (cs != null) {
                            if (cs != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var42_129) {
                                    cs.addSuppressed(var42_129);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var41_128;
                    }
                }
                case 17: {
                    cs = new WithCallStack(new CallFrame("import", ast));
                    cs = null;
                    try {
                        ast.rest().forEach((Consumer<VncVal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$evaluate$1(com.github.jlangch.venice.impl.types.VncVal ), (Lcom/github/jlangch/venice/impl/types/VncVal;)V)());
                        cs = Constants.Nil;
                        return cs;
                    }
                    catch (Throwable cs) {
                        cs = cs;
                        throw cs;
                    }
                    finally {
                        if (cs != null) {
                            if (cs != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    cs.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 18: {
                    if (ast.size() == 1) {
                        return Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                    }
                    ns = Coerce.toVncSymbol(ast.second());
                    namespace = this.nsRegistry.get((VncSymbol)ns);
                    if (namespace != null) {
                        return namespace.getJavaImportsAsVncList();
                    }
                    cs = new WithCallStack(new CallFrame("imports", ast));
                    dispatchVal = null;
                    try {
                        try {
                            throw new VncException(String.format("The namespace '%s' does not exist", new Object[]{ns.toString()}));
                        }
                        catch (Throwable params) {
                            dispatchVal = params;
                            throw params;
                        }
                    }
                    catch (Throwable var45_132) {
                        if (cs != null) {
                            if (dispatchVal != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var46_133) {
                                    dispatchVal.addSuppressed(var46_133);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var45_132;
                    }
                }
                case 19: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case 20: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case 21: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return Inspector.inspect(env.get(sym));
                }
                case 22: {
                    cs = new WithCallStack(new CallFrame("macroexpand", ast));
                    namespace = null;
                    try {
                        cs = this.macroexpand(this.evaluate(ast.second(), env), env, null);
                        return cs;
                    }
                    catch (Throwable cs) {
                        namespace = cs;
                        throw cs;
                    }
                    finally {
                        if (cs != null) {
                            if (namespace != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    namespace.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 23: {
                    cs = new WithCallStack(new CallFrame("*macroexpand-all", ast));
                    namespace = null;
                    try {
                        cs = this.macroexpand_all(this.evaluate(ast.second(), env), env);
                        return cs;
                    }
                    catch (Throwable cs) {
                        namespace = cs;
                        throw cs;
                    }
                    finally {
                        if (cs != null) {
                            if (namespace != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    namespace.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 24: {
                    return VncHashMap.of(new VncVal[]{new VncKeyword("macroexpand-count"), new VncLong(this.macroExpandCount.get()), new VncKeyword("macroexpand-all-count"), new VncLong(this.macroExpandAllCount.get()), new VncKeyword("macroexpand-all-count-effective"), new VncLong(this.macroExpandAllCountEffective.get())});
                }
                case 25: {
                    return ast.second();
                }
                case 26: {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    break;
                }
                case 27: {
                    cs = new WithCallStack(new CallFrame("doc", ast));
                    namespace = null;
                    doc = DocForm.doc(ast.second(), env);
                    orig_ast = VncList.of(new VncVal[]{new VncSymbol("println"), doc});
                    if (cs == null) continue block277;
                    if (namespace == null) ** GOTO lbl665
                    try {
                        cs.close();
                    }
                    catch (Throwable doc) {
                        namespace.addSuppressed(doc);
                    }
                    continue block277;
lbl665:
                    // 1 sources

                    cs.close();
                    break;
                    catch (Throwable doc) {
                        try {
                            namespace = doc;
                            throw doc;
                        }
                        catch (Throwable var51_138) {
                            if (cs != null) {
                                if (namespace != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var52_139) {
                                        namespace.addSuppressed(var52_139);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var51_138;
                        }
                    }
                }
                case 28: {
                    cs = new WithCallStack(new CallFrame("modules", ast));
                    namespace = null;
                    try {
                        doc = VncList.ofList(ModuleLoader.VALID_MODULES.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$evaluate$2(java.lang.String ), (Ljava/lang/String;)Z)()).sorted().map((Function<String, VncKeyword>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$evaluate$3(java.lang.String ), (Ljava/lang/String;)Lcom/github/jlangch/venice/impl/types/VncKeyword;)()).collect(Collectors.toList()));
                        return doc;
                    }
                    catch (Throwable doc) {
                        namespace = doc;
                        throw doc;
                    }
                    finally {
                        if (cs != null) {
                            if (namespace != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    namespace.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 29: {
                    ns = Namespaces.getCurrentNamespace();
                    try {
                        namespace = this.evaluate(Coerce.toVncSequence(this.evaluate_values(ast.rest(), env)).last(), env);
                        return namespace;
                    }
                    finally {
                        Namespaces.setCurrentNamespace((Namespace)ns);
                    }
                }
                case 30: {
                    env = new Env(env);
                    bindings = Coerce.toVncVector(ast.second());
                    expressions = ast.slice(2);
                    for (i = 0; i < bindings.size(); i += 2) {
                        sym = bindings.nth(i);
                        val = this.evaluate(bindings.nth(i + 1), env);
                        env.addLocalVars(Destructuring.destructure(sym, val));
                    }
                    if (expressions.isEmpty()) {
                        orig_ast = Constants.Nil;
                        break;
                    }
                    this.evaluate_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 31: {
                    return this.binding_(ast, new Env(env));
                }
                case 32: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return VncBoolean.of(env.isBound(sym));
                }
                case 33: {
                    return new VncLong(env.globalsCount());
                }
                case 34: {
                    recursionPoint = null;
                    env = new Env(env);
                    bindings = Coerce.toVncVector(ast.second());
                    expressions = ast.slice(2);
                    bindingNames = new ArrayList<VncSymbol>(bindings.size() / 2);
                    for (i = 0; i < bindings.size(); i += 2) {
                        sym = Coerce.toVncSymbol(bindings.nth(i));
                        val = this.evaluate(bindings.nth(i + 1), env);
                        env.setLocal(new Var(sym, val));
                        bindingNames.add(sym);
                    }
                    recursionPoint = new RecursionPoint(bindingNames, (VncList)expressions, env);
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                        break;
                    }
                    this.evaluate_values(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 35: {
                    if (recursionPoint == null) {
                        cs = new WithCallStack(new CallFrame("recur", ast));
                        expressions = null;
                        try {
                            try {
                                throw new VncException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable var56_143) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var57_144) {
                                        expressions.addSuppressed(var57_144);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var56_143;
                        }
                    }
                    recur_env = recursionPoint.getLoopEnv();
                    switch (ast.size()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), this.evaluate(ast.second(), env)));
                            break;
                        }
                        case 3: {
                            v1 = this.evaluate(ast.second(), env);
                            v2 = this.evaluate(ast.third(), env);
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1));
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2));
                            break;
                        }
                        case 4: {
                            v1_ = this.evaluate(ast.second(), env);
                            v2_ = this.evaluate(ast.third(), env);
                            v3_ = this.evaluate(ast.fourth(), env);
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1_));
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2_));
                            recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(2), v3_));
                            break;
                        }
                        default: {
                            values = ast.rest();
                            newValues = new VncVal[values.size()];
                            for (kk = 0; kk < values.size(); ++kk) {
                                newValues[kk++] = this.evaluate(values.nth(kk), env);
                            }
                            for (ii = 0; ii < recursionPoint.getLoopBindingNamesCount(); ++ii) {
                                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(ii), newValues[ii]));
                            }
                        }
                    }
                    expressions = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    if (expressions.size() > 1) {
                        this.evaluate_values(expressions.butlast(), env);
                    }
                    orig_ast = expressions.last();
                    break;
                }
                case 36: {
                    cs = new WithCallStack(new CallFrame("try", ast));
                    expressions = null;
                    try {
                        v2 = this.try_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable v1_) {
                                    expressions.addSuppressed(v1_);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 37: {
                    cs = new WithCallStack(new CallFrame("try-with", ast));
                    expressions = null;
                    try {
                        v2 = this.try_with_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable v1_) {
                                    expressions.addSuppressed(v1_);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 38: {
                    return this.dorun_(ast, env);
                }
                case 39: {
                    return this.dobench_(ast, env);
                }
                case 40: {
                    cond = this.evaluate(ast.second(), env);
                    if (VncBoolean.isFalse(cond) || cond == Constants.Nil) {
                        orig_ast = ast.fourth();
                        break;
                    }
                    orig_ast = ast.third();
                    break;
                }
                case 41: {
                    return this.fn_(ast, env);
                }
                case 42: {
                    return this.prof_(ast, env);
                }
                case 43: {
                    return this.locking_(ast, env);
                }
                default: {
                    el = (VncList)this.evaluate_values(ast, env);
                    elFirst = el.first();
                    elArgs = el.rest();
                    if (elFirst instanceof VncFunction) {
                        fn = (VncFunction)elFirst;
                        fnName = fn.getQualifiedName();
                        v1 = nanos = this.meterRegistry.enabled != false ? System.nanoTime() : 0L;
                        if (this.checkSandbox) {
                            this.interceptor.validateVeniceFunction(fnName);
                            this.interceptor.validateMaxExecutionTime();
                        }
                        this.checkInterrupted(fnName);
                        callStack = ThreadLocalMap.getCallStack();
                        try {
                            callStack.push(new CallFrame(fn.getQualifiedName(), a0.getMeta()));
                            var21_107 = fn.apply(elArgs);
                            return var21_107;
                        }
                        finally {
                            callStack.pop();
                            this.checkInterrupted(fnName);
                            if (this.checkSandbox) {
                                this.interceptor.validateMaxExecutionTime();
                            }
                            if (this.meterRegistry.enabled) {
                                elapsed = System.nanoTime() - nanos;
                                this.meterRegistry.record(fn.getQualifiedName(), elapsed);
                            }
                        }
                    }
                    if (elFirst instanceof IVncFunction) {
                        return ((IVncFunction)elFirst).apply(elArgs);
                    }
                    cs = new WithCallStack(new CallFrame(a0sym, ast));
                    var17_92 /* !! */  = null;
                    try {
                        try {
                            throw new VncException(String.format("Expected a function or keyword/set/map/vector as s-expression  symbol value but got a value of type '%s'!", new Object[]{Types.getType(elFirst)}));
                        }
                        catch (Throwable var18_99) {
                            var17_92 /* !! */  = var18_99;
                            throw var18_99;
                        }
                    }
                    catch (Throwable var65_151) {
                        if (cs != null) {
                            if (var17_92 /* !! */  != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var66_152) {
                                    var17_92 /* !! */ .addSuppressed(var66_152);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var65_151;
                    }
                }
            }
        }
    }

    private VncVal evaluate_values(VncVal ast, Env env) {
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncSequence) {
            VncSequence seq = (VncSequence)ast;
            switch (seq.size()) {
                case 0: {
                    return seq;
                }
                case 1: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env));
                }
                case 2: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
                }
                case 3: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env));
                }
                case 4: {
                    return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env), this.evaluate(seq.fourth(), env));
                }
            }
            ArrayList<VncVal> vals = new ArrayList<VncVal>(seq.size());
            for (int ii = 0; ii < seq.size(); ++ii) {
                vals.add(this.evaluate(seq.nth(ii), env));
            }
            return seq.withValues(vals);
        }
        if (ast instanceof VncMap) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>(map.size());
            for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
            }
            return map.withValues(vals);
        }
        if (ast instanceof VncSet) {
            VncSet set = (VncSet)ast;
            ArrayList<VncVal> vals = new ArrayList<VncVal>(set.size());
            for (VncVal v : set.getList()) {
                vals.add(this.evaluate(v, env));
            }
            return set.withValues(vals);
        }
        return ast;
    }

    private VncVal macroexpand(VncVal ast, Env env, AtomicInteger expandedMacrosCounter) {
        VncVal fn;
        VncVal a0;
        long nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
        VncVal ast_ = ast;
        int expandedMacros = 0;
        while (ast_ instanceof VncList && (a0 = ((VncList)ast_).first()) instanceof VncSymbol && (fn = env.getGlobalOrNull((VncSymbol)a0)) != null && fn instanceof VncFunction && ((VncFunction)fn).isMacro()) {
            VncFunction macro = (VncFunction)fn;
            VncList macroArgs = ((VncList)ast_).rest();
            if (this.checkSandbox) {
                this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            }
            ++expandedMacros;
            if (this.meterRegistry.enabled) {
                long nanosRun = System.nanoTime();
                ast_ = macro.apply(macroArgs);
                this.meterRegistry.record(macro.getQualifiedName() + "[m]", System.nanoTime() - nanosRun);
                continue;
            }
            ast_ = macro.apply(macroArgs);
        }
        if (expandedMacros > 0) {
            this.macroExpandCount.addAndGet(expandedMacros);
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
            }
        }
        if (expandedMacrosCounter != null) {
            expandedMacrosCounter.addAndGet(expandedMacros);
        }
        return ast_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal macroexpand_all(VncVal form, final Env env) {
        final AtomicInteger expandedMacroCounter = new AtomicInteger(0);
        VncFunction handler = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-handler")){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                VncList list;
                VncVal first;
                VncVal form = args.first();
                if (Types.isVncList(form) && Types.isVncSymbol(first = (list = (VncList)form).first())) {
                    VncVal second = list.second();
                    if (list.size() == 2 && "ns".equals(((VncSymbol)first).getName()) && second instanceof VncSymbol) {
                        Namespaces.setCurrentNamespace(VeniceInterpreter.this.nsRegistry.computeIfAbsent((VncSymbol)second));
                    } else {
                        return VeniceInterpreter.this.macroexpand(list, env, expandedMacroCounter);
                    }
                }
                return form;
            }
        };
        final VncFunction walk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-walk")){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                VncFunction inner = (VncFunction)args.first();
                VncVal form = args.second();
                if (Types.isVncList(form)) {
                    return TransducerFunctions.map.applyOf(inner, form);
                }
                if (Types.isVncMapEntry(form)) {
                    return CoreFunctions.new_map_entry.applyOf(inner.applyOf(((VncMapEntry)form).getKey()), inner.applyOf(((VncMapEntry)form).getValue()));
                }
                if (Types.isVncCollection(form)) {
                    return CoreFunctions.into.applyOf(CoreFunctions.empty.applyOf(form), TransducerFunctions.map.applyOf(inner, form));
                }
                return form;
            }
        };
        VncFunction prewalk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-prewalk")){
            private static final long serialVersionUID = -1L;

            @Override
            public VncVal apply(VncList args) {
                VncFunction f = (VncFunction)args.first();
                VncVal form = args.second();
                return walk.applyOf(CoreFunctions.partial.applyOf(this, f), f.applyOf(form));
            }
        };
        Namespace original_ns = Namespaces.getCurrentNamespace();
        try {
            VncVal expanded = prewalk.applyOf(handler, form);
            int count = expandedMacroCounter.get();
            if (count == 0) {
                this.macroExpandAllCount.incrementAndGet();
            } else {
                this.macroExpandAllCount.incrementAndGet();
                this.macroExpandAllCountEffective.incrementAndGet();
            }
            VncVal vncVal = expanded;
            return vncVal;
        }
        finally {
            Namespaces.setCurrentNamespace(original_ns);
        }
    }

    private static boolean isNonEmptySequence(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        if (VeniceInterpreter.isNonEmptySequence(ast)) {
            VncVal a00;
            VncVal a0 = Coerce.toVncSequence(ast).first();
            if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
                return ((VncSequence)ast).second();
            }
            if (VeniceInterpreter.isNonEmptySequence(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
                return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
            }
            return VncList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("quote"), ast);
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        VncSymbol macroName;
        VncVal meta;
        int argPos = 1;
        if (MetaUtil.isPrivate(meta = (macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.nth(argPos++), env))).getMeta())) {
            throw new VncException(String.format("The macro '%s' must not be defined as private! Venice does not support private macros.", macroName.getName()));
        }
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String name = macroName.getName();
        String ns = macroName.getNamespace();
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            VncList body = ast.slice(++argPos);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, body, null, true, env);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, true, env));
        });
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns, true).withMeta(meta);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(new CallFrame("dorun", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dorun requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        long count = Coerce.toVncLong(ast.second()).getValue();
        if (count <= 0L) {
            return Constants.Nil;
        }
        VncVal expr = ast.third();
        try {
            VncVal first = this.evaluate(expr, env);
            int ii = 1;
            while ((long)ii < count) {
                VncVal result = this.evaluate(expr, env);
                this.checkInterrupted("dorun");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncVal vncVal = first;
            return vncVal;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(new CallFrame("dobench", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dobench requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        try {
            long count = Coerce.toVncLong(ast.second()).getValue();
            VncVal expr = ast.third();
            ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
            int ii = 0;
            while ((long)ii < count) {
                long start = System.nanoTime();
                VncVal result = this.evaluate(expr, env);
                long end = System.nanoTime();
                elapsed.add(new VncLong(end - start));
                this.checkInterrupted("dobench");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncList vncList = VncList.ofList(elapsed);
            return vncList;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(VncList ast, Env env) {
        VncVal mutex;
        if (ast.size() < 3) {
            WithCallStack cs = new WithCallStack(new CallFrame("locking", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("locking requires a lockee and one or more expressions to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        VncVal vncVal = mutex = this.evaluate(ast.second(), env);
        synchronized (vncVal) {
            return this.evaluateBody(ast.slice(2), env);
        }
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSymbol name;
        int argPos;
        if (Types.isVncSymbol(ast.second())) {
            argPos = 2;
            name = (VncSymbol)ast.second();
        } else {
            argPos = 1;
            name = new VncSymbol(VncFunction.createAnonymousFuncName());
        }
        VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
        ReservedSymbols.validateNotReservedSymbol(fnName);
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        if (Types.isVncVector(paramsOrSig)) {
            VncVector preCon;
            VncVector params = (VncVector)paramsOrSig;
            if ((preCon = this.getFnPreconditions(ast.nth(++argPos), env)) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(fnName.getName(), params, body, preCon, false, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preCon = this.getFnPreconditions(sig.nth(pos), env);
            if (preCon != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(fnName.getName(), params, body, preCon, false, env));
        });
        return new VncMultiArityFunction(fnName.getName(), fns, false);
    }

    private VncVal prof_(VncList ast, Env env) {
        if (Types.isVncKeyword(ast.second())) {
            VncKeyword cmd = (VncKeyword)ast.second();
            switch (cmd.getValue()) {
                case "on": 
                case "enable": {
                    this.meterRegistry.enable();
                    return new VncKeyword("on");
                }
                case "off": 
                case "disable": {
                    this.meterRegistry.disable();
                    return new VncKeyword("off");
                }
                case "status": {
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear": {
                    this.meterRegistry.reset();
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear-all-but": {
                    this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "data": {
                    return this.meterRegistry.getVncTimerData();
                }
                case "data-formatted": {
                    VncVal opt1 = ast.third();
                    VncVal opt2 = ast.fourth();
                    String title = "Metrics";
                    if (Types.isVncString(opt1) && !Types.isVncKeyword(opt1)) {
                        title = ((VncString)opt1).getValue();
                    }
                    if (Types.isVncString(opt2) && !Types.isVncKeyword(opt2)) {
                        title = ((VncString)opt2).getValue();
                    }
                    boolean anonFn = false;
                    if (Types.isVncKeyword(opt1)) {
                        boolean bl = anonFn = anonFn || ((VncKeyword)opt1).hasValue("anon-fn");
                    }
                    if (Types.isVncKeyword(opt2)) {
                        anonFn = anonFn || ((VncKeyword)opt2).hasValue("anon-fn");
                    }
                    return new VncString(this.meterRegistry.getTimerDataFormatted(title, anonFn));
                }
            }
        }
        WithCallStack cs = new WithCallStack(new CallFrame("prof", ast));
        Object object = null;
        try {
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (cs != null) {
                if (object != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            vars.addAll(Destructuring.destructure(sym, val));
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            this.evaluate_values(expressions.butlast(), env);
            VncVal vncVal = this.evaluate(expressions.last(), env);
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.evaluateBody(this.getTryBody(ast), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
            if (catchBlock == null) {
                throw th;
            }
            env.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(th)));
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), env);
            return vncVal;
        }
        finally {
            VncList finallyBlock = this.findFirstFinallyBlock(ast);
            if (finallyBlock != null) {
                this.evaluate_values(finallyBlock.rest(), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block21: {
            VncSequence bindings = Coerce.toVncSequence(ast.second());
            ArrayList<Var> boundResources = new ArrayList<Var>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    WithCallStack cs = new WithCallStack(new CallFrame("try-with", ast));
                    Throwable throwable = null;
                    try {
                        try {
                            throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (cs != null) {
                            if (throwable != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                Var binding = new Var((VncSymbol)sym, val);
                env.setLocal(binding);
                boundResources.add(binding);
            }
            result = Constants.Nil;
            try {
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block21;
                    this.evaluate_values(finallyBlock.rest(), env);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block22: {
                        try {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(th)));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env);
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock == null) break block22;
                            this.evaluate_values(finallyBlock.rest(), env);
                        }
                        catch (Throwable throwable) {
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock != null) {
                                this.evaluate_values(finallyBlock.rest(), env);
                            }
                            throw throwable;
                        }
                    }
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        VncVal resource = b.getVal();
                        if (Types.isVncJavaObject(resource)) {
                            Object r = ((VncJavaObject)resource).getDelegate();
                            if (r instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)r).close();
                                }
                                catch (Exception ex) {
                                    WithCallStack cs = new WithCallStack(new CallFrame("try-with", ast));
                                    Throwable throwable = null;
                                    try {
                                        try {
                                            throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (cs != null) {
                                            if (throwable != null) {
                                                try {
                                                    cs.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable.addSuppressed(throwable4);
                                                }
                                            } else {
                                                cs.close();
                                            }
                                        }
                                        throw throwable3;
                                    }
                                }
                            }
                            if (r instanceof Closeable) {
                                try {
                                    ((Closeable)r).close();
                                }
                                catch (Exception ex) {
                                    WithCallStack cs = new WithCallStack(new CallFrame("try-with", ast));
                                    Throwable throwable = null;
                                    try {
                                        try {
                                            throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                                        }
                                        catch (Throwable throwable5) {
                                            throwable = throwable5;
                                            throw throwable5;
                                        }
                                    }
                                    catch (Throwable throwable6) {
                                        if (cs != null) {
                                            if (throwable != null) {
                                                try {
                                                    cs.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable.addSuppressed(throwable7);
                                                }
                                            } else {
                                                cs.close();
                                            }
                                        }
                                        throw throwable6;
                                    }
                                }
                            }
                        }
                    });
                    return vncVal;
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.getVal();
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                WithCallStack cs = new WithCallStack(new CallFrame("try-with", ast));
                                Throwable throwable = null;
                                try {
                                    try {
                                        throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = throwable2;
                                        throw throwable2;
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (cs != null) {
                                        if (throwable != null) {
                                            try {
                                                cs.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable.addSuppressed(throwable4);
                                            }
                                        } else {
                                            cs.close();
                                        }
                                    }
                                    throw throwable3;
                                }
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                WithCallStack cs = new WithCallStack(new CallFrame("try-with", ast));
                                Throwable throwable = null;
                                try {
                                    try {
                                        throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                                    }
                                    catch (Throwable throwable5) {
                                        throwable = throwable5;
                                        throw throwable5;
                                    }
                                }
                                catch (Throwable throwable6) {
                                    if (cs != null) {
                                        if (throwable != null) {
                                            try {
                                                cs.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            cs.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iter = ast.rest().iterator();
        while (!(!iter.hasNext() || Types.isVncList(e = iter.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return VncList.ofList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        Iterator<VncVal> iter = blocks.iterator();
        while (iter.hasNext()) {
            VncList block;
            VncVal first;
            VncVal b = iter.next();
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        Iterator<VncVal> iter = blocks.iterator();
        while (iter.hasNext()) {
            VncList block;
            VncVal first;
            VncVal b = iter.next();
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, boolean macro, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        final boolean switchToFunctionNamespaceAtRuntime = !macro && !name.equals("macroexpand-all");
        final boolean plainSymbolParams = Destructuring.isFnParamsWithoutDestructuring(params);
        final boolean hasPreConditions = preConditions != null && !preConditions.isEmpty();
        return new VncFunction(name, params, macro){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(env);
                if (plainSymbolParams) {
                    for (int ii = 0; ii < params.size(); ++ii) {
                        localEnv.setLocal(new Var((VncSymbol)params.nth(ii), args.nthOrDefault(ii, Constants.Nil)));
                    }
                } else {
                    localEnv.addLocalVars(Destructuring.destructure(params, args));
                }
                if (switchToFunctionNamespaceAtRuntime) {
                    ThreadLocalMap threadLocalMap = ThreadLocalMap.get();
                    Namespace curr_ns = threadLocalMap.getCurrentNS();
                    try {
                        threadLocalMap.setCurrentNS(ns);
                        if (hasPreConditions) {
                            VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                        }
                        VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv);
                        return vncVal;
                    }
                    finally {
                        threadLocalMap.setCurrentNS(curr_ns);
                    }
                }
                if (hasPreConditions) {
                    VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                }
                return VeniceInterpreter.this.evaluateBody(body, localEnv);
            }

            @Override
            public VncVal getBody() {
                return body;
            }
        };
    }

    private VncVector getFnPreconditions(VncVal prePostConditions, Env env) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? VncBoolean.isTrue(((VncSequence)result).first()) : VncBoolean.isTrue(result);
    }

    private void validateFnPreconditions(String fnName, VncVector preConditions, Env env) {
        if (preConditions != null && !preConditions.isEmpty()) {
            Env local = new Env(env);
            Iterator<VncVal> iter = preConditions.iterator();
            while (iter.hasNext()) {
                VncVal v = iter.next();
                if (this.isFnConditionTrue(this.evaluate(v, local))) continue;
                WithCallStack cs = new WithCallStack(new CallFrame(fnName, v));
                Throwable throwable = null;
                try {
                    try {
                        throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncList.of(v))).getValue()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private VncVal evaluateBody(VncList body, Env env) {
        if (body.isEmpty()) {
            return Constants.Nil;
        }
        if (body.size() == 1) {
            return this.evaluate(body.first(), env);
        }
        if (body.size() == 2) {
            this.evaluate(body.first(), env);
            return this.evaluate(body.second(), env);
        }
        this.evaluate_values(body.butlast(), env);
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String fnName) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while processing function " + fnName);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (sym.hasNamespace()) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), sym.getNamespace()));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        VncVal newMeta = MetaUtil.setNamespace(sym.getMeta(), ns.getName());
        return Namespaces.isCoreNS(ns) ? new VncSymbol(sym.getName(), newMeta) : new VncSymbol(ns.getName(), sym.getName(), newMeta);
    }

    private VncSymbol validateSymbolWithCurrNS(VncSymbol sym, String specialFormName) {
        String ns;
        if (sym != null && (ns = sym.getNamespace()) != null && !ns.equals(Namespaces.getCurrentNS().getName())) {
            WithCallStack cs = new WithCallStack(new CallFrame(specialFormName, sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Special form '%s': Invalid use of namespace. The symbol '%s' can only be defined for the current namespace '%s'.", specialFormName, sym.getSimpleName(), Namespaces.getCurrentNS().toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return sym;
    }

    private static /* synthetic */ VncKeyword lambda$evaluate$3(String s) {
        return new VncKeyword(s);
    }

    private static /* synthetic */ boolean lambda$evaluate$2(String s) {
        return !s.equals("core");
    }

    private static /* synthetic */ void lambda$evaluate$1(VncVal i) {
        Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue());
    }
}

