/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

public class ExampleOutput {
    private final long idx;
    private final String name;
    private final String example;
    private final String result;
    private final String stdout;
    private final String stderr;
    private final RuntimeException ex;

    public ExampleOutput(long idx, String name, String example) {
        this.idx = idx;
        this.name = name;
        this.example = example;
        this.stdout = null;
        this.stderr = null;
        this.result = null;
        this.ex = null;
    }

    public ExampleOutput(long idx, String name, String example, String stdout, String stderr, String result) {
        this.idx = idx;
        this.name = name;
        this.example = example;
        this.stdout = stdout;
        this.stderr = stderr;
        this.result = result;
        this.ex = null;
    }

    public ExampleOutput(long idx, String name, String example, String stdout, String stderr, RuntimeException ex) {
        this.idx = idx;
        this.name = name;
        this.example = example;
        this.stdout = stdout;
        this.stderr = stderr;
        this.result = null;
        this.ex = ex;
    }

    public long getIdx() {
        return this.idx;
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    public String getResult() {
        return this.result;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public RuntimeException getEx() {
        return this.ex;
    }

    public String getExString() {
        return this.ex != null ? String.format("%s: %s", this.ex.getClass().getSimpleName(), this.ex.getMessage()) : null;
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.example).append("\n");
        if (this.stdout != null && !this.stdout.isEmpty()) {
            sb.append(this.stdout);
            if (!this.stdout.endsWith("\n")) {
                sb.append("\n");
            }
        }
        if (this.stderr != null && !this.stderr.isEmpty()) {
            sb.append(this.stderr);
            if (!this.stderr.endsWith("\n")) {
                sb.append("\n");
            }
        }
        if (this.result != null) {
            sb.append("=> ").append(this.result);
        }
        if (this.ex != null) {
            sb.append("=> ").append(this.getExString());
        }
        return sb.toString();
    }

    public boolean isFirst() {
        return this.idx == 0L;
    }
}

