/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.env;

import com.github.jlangch.venice.impl.types.VncSymbol;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ReservedSymbols {
    private static final Set<String> sepcial_forms = new HashSet<String>(Arrays.asList("def", "defonce", "def-dynamic", "defmacro", "doc", "ns", "eval", "let", "binding", "loop", "recur", "quote", "quasiquote", "macroexpand", "try", "try-with", "import", "imports", "do", "dorun", "dobench", "if", "fn", "resolve", "set!", "prof", "var-get", "defmulti", "defmethod", "deftype", "defprotocol", "defrecord"));
    private static final Set<String> reserved = ReservedSymbols.merge(sepcial_forms, Arrays.asList(".", "proxify", "*in*", "*out*", "*err*", "*version*", "*newline*", "*ns*", "*loaded-modules*", "*loaded-files*", "*load-path*", "*run-mode*", "*macroexpand-on-load*", "*ansi-term*", "*app-name*", "*app-archive*", "*ARGV*", "*REPL*"));

    public static boolean isReserved(VncSymbol symbol) {
        return symbol != null && reserved.contains(symbol.getName());
    }

    public static boolean isSpecialForm(VncSymbol symbol) {
        return symbol != null && sepcial_forms.contains(symbol.getName());
    }

    public static boolean isSpecialForm(String name) {
        return name != null && sepcial_forms.contains(name);
    }

    public static void validateNotReservedSymbol(VncSymbol symbol) {
        if (symbol != null && ReservedSymbols.isReserved(symbol)) {
            throw new SecurityException(String.format("Reserved symbol '%s'. Redefinition is not allowed.", symbol.getName()));
        }
    }

    private static <T> HashSet<T> merge(Set<T> s1, Collection<T> s2) {
        HashSet<T> s = new HashSet<T>(s1);
        s.addAll(s2);
        return s;
    }
}

