/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.repl.FilePathCompleter;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.util.List;
import org.repackage.org.jline.reader.Candidate;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.reader.LineReader;
import org.repackage.org.jline.reader.ParsedLine;

public class ReplCompleter
implements Completer {
    private final VeniceInterpreter venice;
    private final Env env;
    private final FilePathCompleter filePathCompleter;

    public ReplCompleter(VeniceInterpreter venice, Env env, List<File> loadPaths) {
        this.venice = venice;
        this.env = env;
        this.filePathCompleter = new FilePathCompleter(loadPaths);
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        if (line.line().contains("(load-file ")) {
            candidates.addAll(this.filePathCompleter.getCandidates(line));
        } else if (line.line().endsWith("(load-module ")) {
            this.venice.getAvailableModules().forEach(m -> candidates.add(new Candidate(":" + m)));
        } else if (line.line().startsWith("(doc ")) {
            String namePrefix = StringUtil.trimToNull(line.line().substring(5));
            this.env.getAllGlobalFunctionSymbols().stream().map(s -> s.getName()).filter(s -> namePrefix == null ? true : s.startsWith(namePrefix)).forEach(s -> candidates.add(new Candidate((String)s)));
        } else if (line.word().startsWith("(")) {
            String sym = StringUtil.trimToNull(line.word().substring(1));
            this.env.getAllGlobalFunctionSymbols().stream().map(s -> s.getName()).filter(s -> sym == null || sym.isEmpty() || s.startsWith(sym)).sorted().forEach(s -> candidates.add(new Candidate("(" + s, (String)s, null, null, null, null, true)));
        }
    }
}

