/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.List;

public class VncSymbol
extends VncVal
implements INamespaceAware {
    public static final VncKeyword TYPE = new VncKeyword(":core/symbol");
    private static final long serialVersionUID = -1848883965231344442L;
    private final String qualifiedName;
    private final String simpleName;
    private final String namespace;
    private final int hash;

    public VncSymbol(String v) {
        this(v, (VncVal)Constants.Nil);
    }

    public VncSymbol(String v, VncVal meta) {
        super(meta);
        int pos = v.indexOf("/");
        this.namespace = pos <= 0 ? null : v.substring(0, pos);
        this.simpleName = pos < 0 ? v : v.substring(pos + 1);
        this.qualifiedName = v;
        this.hash = v.hashCode();
    }

    public VncSymbol(String ns, String name, VncVal meta) {
        super(meta);
        boolean emptyNS = ns == null || ns.isEmpty();
        this.namespace = emptyNS ? null : ns;
        this.simpleName = name;
        this.qualifiedName = emptyNS ? this.simpleName : ns + "/" + this.simpleName;
        this.hash = this.qualifiedName.hashCode();
    }

    private VncSymbol(VncSymbol other, VncVal meta) {
        super(meta);
        this.namespace = other.namespace;
        this.simpleName = other.simpleName;
        this.qualifiedName = other.qualifiedName;
        this.hash = other.hash;
    }

    @Override
    public VncSymbol withMeta(VncVal meta) {
        return new VncSymbol(this, meta);
    }

    public VncSymbol withNamespace(VncSymbol namespace) {
        if (namespace.hasNamespace()) {
            throw new VncException(String.format("A namespace '%s' must not be qualified with an other namespace", namespace));
        }
        return this.withNamespace(namespace.getName());
    }

    public VncSymbol withNamespace(String namespace) {
        if (this.hasNamespace()) {
            throw new VncException(String.format("The symbol '%s' is already qualified with a namespace", this.qualifiedName));
        }
        return new VncSymbol(namespace, this.simpleName, this.getMeta());
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncVal.TYPE);
    }

    public String getName() {
        return this.qualifiedName;
    }

    public String getValue() {
        return this.qualifiedName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public static VncSymbol qualifySymbol(VncSymbol ns, VncSymbol sym) {
        if (sym.hasNamespace()) {
            throw new VncException(String.format("The symbol '%s' is already qualified with a namespace", sym.getName()));
        }
        return new VncSymbol(ns.getName() + "/" + sym.getName());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SYMBOL;
    }

    @Override
    public Object convertToJavaObject() {
        return this.qualifiedName;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSymbol(o)) {
            return this.getName().compareTo(((VncSymbol)o).getName());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.qualifiedName.equals(((VncSymbol)obj).qualifiedName);
    }

    public String toString() {
        return this.qualifiedName;
    }
}

