/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.IndexedSeq;
import org.repackage.io.vavr.collection.Seq;
import org.repackage.io.vavr.collection.Vector;

public class VncVector
extends VncSequence
implements IVncFunction {
    public static final VncKeyword TYPE = new VncKeyword(":core/vector");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Vector<VncVal> value;

    protected VncVector(VncVal meta) {
        this((Seq<VncVal>)null, meta);
    }

    protected VncVector(Collection<? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : Vector.ofAll(vals), meta);
    }

    public VncVector(Seq<VncVal> vals, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = vals == null ? Vector.empty() : (vals instanceof Vector ? (Vector<Object>)vals : Vector.ofAll(vals));
    }

    public static VncVector of(VncVal ... mvs) {
        switch (mvs.length) {
            case 0: {
                return VncTinyVector.empty();
            }
            case 1: {
                return new VncTinyVector(mvs[0], null);
            }
            case 2: {
                return new VncTinyVector(mvs[0], mvs[1], null);
            }
            case 3: {
                return new VncTinyVector(mvs[0], mvs[1], mvs[2], null);
            }
            case 4: {
                return new VncTinyVector(mvs[0], mvs[1], mvs[2], mvs[3], null);
            }
        }
        return new VncVector(Vector.of(mvs), null);
    }

    public static VncVector ofList(List<? extends VncVal> list) {
        switch (list.size()) {
            case 0: {
                return new VncTinyVector(null);
            }
            case 1: {
                return new VncTinyVector(list.get(0), null);
            }
            case 2: {
                return new VncTinyVector(list.get(0), list.get(1), null);
            }
            case 3: {
                return new VncTinyVector(list.get(0), list.get(1), list.get(2), null);
            }
            case 4: {
                return new VncTinyVector(list.get(0), list.get(1), list.get(2), list.get(3), null);
            }
        }
        return new VncVector(list, null);
    }

    public static VncVector ofList(List<? extends VncVal> list, VncVal meta) {
        switch (list.size()) {
            case 0: {
                return new VncTinyVector(meta);
            }
            case 1: {
                return new VncTinyVector(list.get(0), meta);
            }
            case 2: {
                return new VncTinyVector(list.get(0), list.get(1), meta);
            }
            case 3: {
                return new VncTinyVector(list.get(0), list.get(1), list.get(2), meta);
            }
            case 4: {
                return new VncTinyVector(list.get(0), list.get(1), list.get(2), list.get(3), meta);
            }
        }
        return new VncVector(list, meta);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("nth", args, 1);
        return this.nth(Coerce.toVncLong(args.first()).getValue().intValue());
    }

    @Override
    public VncVector emptyWithMeta() {
        return new VncTinyVector(this.getMeta());
    }

    @Override
    public VncVector withVariadicValues(VncVal ... replaceVals) {
        switch (replaceVals.length) {
            case 0: {
                return new VncTinyVector(this.getMeta());
            }
            case 1: {
                return new VncTinyVector(replaceVals[0], this.getMeta());
            }
            case 2: {
                return new VncTinyVector(replaceVals[0], replaceVals[1], this.getMeta());
            }
            case 3: {
                return new VncTinyVector(replaceVals[0], replaceVals[1], replaceVals[2], this.getMeta());
            }
            case 4: {
                return new VncTinyVector(replaceVals[0], replaceVals[1], replaceVals[2], replaceVals[3], this.getMeta());
            }
        }
        return new VncVector(Vector.of(replaceVals), this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals) {
        return new VncVector(replaceVals, this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return new VncVector(replaceVals, meta);
    }

    @Override
    public VncVector withMeta(VncVal meta) {
        return new VncVector(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSequence.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSequence.TYPE, VncVal.TYPE);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public VncVector filter(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.filter(predicate), this.getMeta());
    }

    @Override
    public VncVector map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncVector(this.value.map(mapper), this.getMeta());
    }

    @Override
    public List<VncVal> getList() {
        return this.value.asJava();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.value.size()) {
            throw new VncException(String.format("nth: index %d out of range for a vector of size %d. %s", idx, this.size(), this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.value.get(0))));
        }
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        return idx >= 0 && idx < this.value.size() ? this.value.get(idx) : defaultVal;
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : this.value.head();
    }

    @Override
    public VncVal last() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.last();
    }

    @Override
    public VncVector rest() {
        if (this.value.isEmpty()) {
            return this;
        }
        IndexedSeq rest = this.value.tail();
        return rest.size() <= 4 ? VncTinyVector.ofList(((Vector)rest).asJava(), this.getMeta()) : new VncVector(rest, this.getMeta());
    }

    @Override
    public VncVector butlast() {
        if (this.value.isEmpty()) {
            return this;
        }
        IndexedSeq butlast = this.value.dropRight(1);
        return butlast.size() < 4 ? VncTinyVector.ofList(((Vector)butlast).asJava(), this.getMeta()) : new VncVector(butlast, this.getMeta());
    }

    @Override
    public VncVector drop(int n) {
        return this.value.isEmpty() ? this : new VncVector(this.value.drop(n), this.getMeta());
    }

    @Override
    public VncVector dropWhile(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.dropWhile(predicate), this.getMeta());
    }

    @Override
    public VncVector take(int n) {
        return this.value.isEmpty() ? this : new VncVector(this.value.take(n), this.getMeta());
    }

    @Override
    public VncVector takeWhile(Predicate<? super VncVal> predicate) {
        return new VncVector(this.value.takeWhile(predicate), this.getMeta());
    }

    @Override
    public VncVector slice(int start, int end) {
        return new VncVector(this.value.subSequence(start, Math.min(end, this.value.size())), this.getMeta());
    }

    @Override
    public VncVector slice(int start) {
        return new VncVector(this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return this;
    }

    @Override
    public VncVector addAtStart(VncVal val) {
        return new VncVector(this.value.prepend((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtStart(VncSequence list) {
        return new VncVector(this.value.prependAll(list.getList()), this.getMeta());
    }

    @Override
    public VncVector addAtEnd(VncVal val) {
        return new VncVector(this.value.append((Object)val), this.getMeta());
    }

    @Override
    public VncVector addAllAtEnd(VncSequence list) {
        return new VncVector(this.value.appendAll(list.getList()), this.getMeta());
    }

    @Override
    public VncVector setAt(int idx, VncVal val) {
        return new VncVector(this.value.update(idx, (Object)val), this.getMeta());
    }

    @Override
    public VncVector removeAt(int idx) {
        return new VncVector(this.value.removeAt(idx), this.getMeta());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.VECTOR;
    }

    @Override
    public Object convertToJavaObject() {
        return this.getList().stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncVector)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncVector other = (VncVector)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return "[" + Printer.join(this.value.toJavaList(), " ", true) + "]";
    }

    @Override
    public String toString(boolean print_readably) {
        return "[" + Printer.join(this.value.toJavaList(), " ", print_readably) + "]";
    }

    public static VncVector empty() {
        return VncTinyVector.EMPTY;
    }
}

