/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.util.StackFrame;

public class CallFrame {
    private final String fnName;
    private final VncVal meta;

    public CallFrame(String fnName, VncVal meta) {
        this.fnName = fnName;
        this.meta = meta;
    }

    public String getFnName() {
        return this.fnName;
    }

    public String getFile() {
        VncVal vFile = this.getMetaVal(MetaUtil.FILE);
        String file = vFile == Constants.Nil ? null : Coerce.toVncString(vFile).getValue();
        return file == null || file.isEmpty() ? "unknown" : file;
    }

    public int getLine() {
        VncVal vLine = this.getMetaVal(MetaUtil.LINE);
        return vLine == Constants.Nil ? -1 : Coerce.toVncLong(vLine).getValue().intValue();
    }

    public int getCol() {
        VncVal vCol = this.getMetaVal(MetaUtil.COLUMN);
        return vCol == Constants.Nil ? -1 : Coerce.toVncLong(vCol).getValue().intValue();
    }

    public StackFrame toStackFrame() {
        return new StackFrame(this.getFnName(), this.getFile(), this.getLine(), this.getCol());
    }

    public String toString() {
        return this.fnName == null ? String.format("%s: line %d, col %d", this.getFile(), this.getLine(), this.getCol()) : String.format("%s (%s: line %d, col %d)", this.fnName, this.getFile(), this.getLine(), this.getCol());
    }

    private VncVal getMetaVal(VncString key) {
        return this.meta instanceof VncHashMap ? ((VncHashMap)this.meta).get(key) : Constants.Nil;
    }
}

