/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.util.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MeterRegistry
implements Serializable {
    private static final long serialVersionUID = 5426843508785133806L;
    private final Map<String, Timer> data = new ConcurrentHashMap<String, Timer>();
    public volatile boolean enabled;

    public MeterRegistry(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void reset() {
        this.data.clear();
    }

    public void resetAllBut(VncSequence records) {
        Map keep = records.getList().stream().map(r -> this.data.get(Coerce.toVncString(r).getValue())).filter(t -> t != null).collect(Collectors.toMap(Timer::getName, Function.identity()));
        this.data.clear();
        this.data.putAll(keep);
    }

    public void record(String name, long elapsedTime) {
        if (elapsedTime > 0L) {
            this.data.compute(name, (k, v) -> v == null ? new Timer(name, elapsedTime) : v.add(elapsedTime));
        }
    }

    public Collection<Timer> getTimerData() {
        return this.data.values();
    }

    public VncList getVncTimerData() {
        return VncList.ofList(this.getTimerData().stream().map(t -> this.convertToVncMap((Timer)t)).collect(Collectors.toList()));
    }

    public String getTimerDataFormatted(String title, boolean withAnonymousFunctions) {
        Collection data = withAnonymousFunctions ? this.getTimerData() : (Collection)this.getTimerData().stream().filter(t -> !t.name.contains("anonymous-")).collect(Collectors.toList());
        int maxNameLen = data.stream().mapToInt(v -> v.name.length()).max().orElse(10);
        int maxCount = data.stream().mapToInt(v -> v.count).max().orElse(10);
        int maxCountLen = Integer.valueOf(maxCount).toString().length();
        List lines = data.stream().sorted((u, v) -> Long.valueOf(v.elapsedNanos).compareTo(u.elapsedNanos)).map(v -> this.format((Timer)v, maxNameLen, maxCountLen)).collect(Collectors.toList());
        if (lines.isEmpty()) {
            lines.add("no meter data!");
        }
        if (!StringUtil.isBlank(title)) {
            int maxLineLen = Math.max(title.length(), lines.stream().mapToInt(l -> l.length()).max().orElse(0));
            String delim = String.join((CharSequence)"", Collections.nCopies(maxLineLen, "-"));
            lines.add(0, delim.toString());
            lines.add(0, title);
            lines.add(0, delim.toString());
            lines.add(delim.toString());
        }
        return String.join((CharSequence)"\n", lines);
    }

    private String format(Timer t, int maxNameLen, int maxCountLen) {
        return String.format("%-" + maxNameLen + "s  [%" + maxCountLen + "d]: %11s %11s", t.name, t.count, Timer.formatNanos(t.elapsedNanos), t.count == 1 ? "" : Timer.formatNanos(t.elapsedNanos / (long)t.count));
    }

    private VncMap convertToVncMap(Timer timer) {
        return VncHashMap.of(new VncKeyword("name"), new VncString(timer.name), new VncKeyword("count"), new VncLong(timer.count), new VncKeyword("nanos"), new VncLong(timer.elapsedNanos));
    }
}

