/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MimeTypes {
    public static final String APPLICATION_PDF = "application/pdf";
    public static final String APPLICATION_XML = "application/xml";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_XLS = "application/vnd.ms-msexcel";
    public static final String APPLICATION_DOC = "application/msword";
    public static final String APPLICATION_PPT = "application/vnd.ms-powerpoint";
    public static final String APPLICATION_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String APPLICATION_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String APPLICATION_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final String APPLICATION_TTF = "application/x-font-ttf";
    public static final String APPLICATION_BINARY = "application/octet-stream";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_CSV = "text/csv";
    public static final String TEXT_CSS = "text/css";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_URL = "text/url";
    public static final String TEXT_GROOVY = "text/groovy";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_SVG_XML = "image/svg+xml";
    public static final String EMAIL = "message/rfc822";
    private static final Map<String, List<String>> mimeTypeFileExtMap = new HashMap<String, List<String>>();

    private MimeTypes() {
    }

    public static List<String> getFileExtension(String mimeType) {
        List<String> list = mimeTypeFileExtMap.get(mimeType);
        return list == null ? new ArrayList<String>() : new ArrayList<String>(list);
    }

    public static String getMimeTypeFromFileExtension(String fileExtension) {
        String ext = StringUtil.trimToEmpty(fileExtension);
        return mimeTypeFileExtMap.entrySet().stream().filter(e -> ((List)e.getValue()).contains(ext)).map(e -> (String)e.getKey()).findFirst().orElse(null);
    }

    public static String getMimeTypeFromFileName(String fileName) {
        return MimeTypes.getMimeTypeFromFileExtension(MimeTypes.getFileExt(fileName));
    }

    public static String getMimeTypeFromFile(File file) {
        return MimeTypes.getMimeTypeFromFileName(file.getName());
    }

    public static Set<String> getAvailableMimeTypes() {
        return new HashSet<String>(mimeTypeFileExtMap.keySet());
    }

    private static String getFileExt(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("A fileName must not be null");
        }
        int pos = fileName.lastIndexOf(46);
        return pos < 0 ? null : fileName.substring(pos + 1);
    }

    static {
        mimeTypeFileExtMap.put(APPLICATION_PDF, Arrays.asList("pdf"));
        mimeTypeFileExtMap.put(APPLICATION_XML, Arrays.asList("xml"));
        mimeTypeFileExtMap.put(APPLICATION_ZIP, Arrays.asList("zip"));
        mimeTypeFileExtMap.put(APPLICATION_TTF, Arrays.asList("ttf"));
        mimeTypeFileExtMap.put(APPLICATION_BINARY, Arrays.asList("exe"));
        mimeTypeFileExtMap.put(TEXT_HTML, Arrays.asList("html", "htm"));
        mimeTypeFileExtMap.put(TEXT_XML, Arrays.asList("xml"));
        mimeTypeFileExtMap.put(TEXT_CSV, Arrays.asList("csv"));
        mimeTypeFileExtMap.put(TEXT_CSS, Arrays.asList("css"));
        mimeTypeFileExtMap.put(TEXT_PLAIN, Arrays.asList("txt"));
        mimeTypeFileExtMap.put(TEXT_URL, Arrays.asList("url"));
        mimeTypeFileExtMap.put(TEXT_GROOVY, Arrays.asList("groovy"));
        mimeTypeFileExtMap.put(IMAGE_JPEG, Arrays.asList("jpg"));
        mimeTypeFileExtMap.put(IMAGE_PNG, Arrays.asList("png"));
        mimeTypeFileExtMap.put(IMAGE_GIF, Arrays.asList("gif"));
        mimeTypeFileExtMap.put(IMAGE_SVG_XML, Arrays.asList("svg"));
        mimeTypeFileExtMap.put(EMAIL, Arrays.asList("eml"));
        mimeTypeFileExtMap.put(APPLICATION_XLS, Arrays.asList("xls"));
        mimeTypeFileExtMap.put(APPLICATION_XLSX, Arrays.asList("xlsx"));
        mimeTypeFileExtMap.put(APPLICATION_DOC, Arrays.asList("doc"));
        mimeTypeFileExtMap.put(APPLICATION_DOCX, Arrays.asList("docx"));
        mimeTypeFileExtMap.put(APPLICATION_PPT, Arrays.asList("ppt"));
        mimeTypeFileExtMap.put(APPLICATION_PPTX, Arrays.asList("pptx"));
    }
}

