/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.crypt;

import com.github.jlangch.venice.impl.util.crypt.HashException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

public class SHA1_Hash {
    public static byte[] hash(String text, String salt) {
        if (text == null) {
            throw new IllegalArgumentException("A text must not be null");
        }
        try {
            return SHA1_Hash.hash(text.getBytes("UTF-8"), salt);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] hash(byte[] buffer, String salt) {
        if (buffer == null) {
            throw new IllegalArgumentException("A buffer must not be null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.reset();
            if (salt != null) {
                md.update(salt.getBytes("UTF-8"));
            }
            md.update(buffer);
            return md.digest();
        }
        catch (Exception ex) {
            throw new HashException("Failed to compute SHA-1 hash.", ex);
        }
    }
}

