/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.NotInTailPositionException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Modules;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.env.DynamicVar;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.ReservedSymbols;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.functions.TransducerFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.reader.Reader;
import com.github.jlangch.venice.impl.specialforms.CatchBlock;
import com.github.jlangch.venice.impl.specialforms.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.DocForm;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.custom.CustomWrappableTypes;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private final IInterceptor interceptor;
    private final boolean checkSandbox;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private final CustomWrappableTypes wrappableTypes = new CustomWrappableTypes();
    private final AtomicBoolean sealedSystemNS = new AtomicBoolean(false);
    private final AtomicLong macroExpandAllCountEffective = new AtomicLong(0L);
    private final AtomicLong macroExpandAllCount = new AtomicLong(0L);
    private final AtomicLong macroExpandCount = new AtomicLong(0L);
    private volatile boolean macroexpand = false;

    public VeniceInterpreter(IInterceptor interceptor) {
        if (interceptor == null) {
            throw new SecurityException("VeniceInterpreter can not run without an interceptor");
        }
        this.interceptor = interceptor;
        this.meterRegistry = this.interceptor.getMeterRegistry();
        this.checkSandbox = !(interceptor instanceof AcceptAllInterceptor);
    }

    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    public void setMacroexpandOnLoad(boolean macroexpandOnLoad, Env env) {
        env.setMacroexpandOnLoad(VncBoolean.of(macroexpandOnLoad));
        this.macroexpand = macroexpandOnLoad;
    }

    public boolean isMacroexpandOnLoad() {
        return this.macroexpand;
    }

    public VncVal READ(String script, String filename) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = Reader.read_str(script, filename);
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
            return val;
        }
        return Reader.read_str(script, filename);
    }

    public VncVal EVAL(VncVal ast, Env env) {
        if (this.meterRegistry.enabled) {
            long nanos = System.nanoTime();
            VncVal val = this.evaluate(ast, env);
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
            return val;
        }
        return this.evaluate(ast, env);
    }

    public VncVal MACROEXPAND(VncVal ast, Env env) {
        return this.macroexpand_all(new CallFrame("macroexpand-all", ast.getMeta()), ast, env);
    }

    public VncVal RE(String script, String name, Env env) {
        VncVal ast = this.READ(script, name);
        if (this.macroexpand) {
            ast = this.MACROEXPAND(ast, env);
        }
        return this.EVAL(ast, env);
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    public Env createEnv(List<String> preloadedExtensionModules, boolean macroexpandOnLoad, boolean ansiTerminal, RunMode runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = new VncMutableSet(Modules.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        }
        env.setGlobal(new Var(new VncSymbol("*version*"), new VncString(Version.VERSION), false));
        env.setGlobal(new Var(new VncSymbol("*newline*"), new VncString(System.lineSeparator()), false));
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(new VncSymbol("*run-mode*"), runMode == null ? Constants.Nil : runMode.mode, false));
        env.setGlobal(new Var(new VncSymbol("*loaded-modules*"), loadedModules, true));
        env.setGlobal(new Var(new VncSymbol("*loaded-files*"), new VncMutableSet(), true));
        this.initNS();
        this.setMacroexpandOnLoad(macroexpandOnLoad, env);
        this.loadModule("core", env, loadedModules);
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadedExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(Modules.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        long nanos = System.nanoTime();
        this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
        }
        loadedModules.add(new VncKeyword(module));
    }

    private VncVal evaluate(VncVal ast_, Env env_) {
        return this.evaluate(ast_, env_, false);
    }

    private VncVal evaluateInTailPosition(VncVal ast_, Env env_) {
        return this.evaluate(ast_, env_, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal evaluate(VncVal ast_, Env env_, boolean inTailPosition) {
        if (!(ast_ instanceof VncList)) {
            return this.evaluate_values(ast_, env_);
        }
        RecursionPoint recursionPoint = null;
        boolean tailPosition = inTailPosition;
        VncVal orig_ast = ast_;
        Env env = env_;
        while (orig_ast instanceof VncList) {
            String a0sym;
            VncVal expanded = this.macroexpand(orig_ast, env, null);
            if (!(expanded instanceof VncList)) {
                return this.evaluate_values(expanded, env);
            }
            VncList ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            VncVal a0 = ast.first();
            switch (a0sym = a0 instanceof VncSymbol ? ((VncSymbol)a0).getName() : "__<*fn*>__") {
                case "do": {
                    VncList expressions2 = ast.rest();
                    this.evaluate_values(expressions2.butlast(), env);
                    orig_ast = expressions2.last();
                    tailPosition = true;
                    break;
                }
                case "if": {
                    VncVal cond = this.evaluate(ast.second(), env);
                    orig_ast = VncBoolean.isFalse(cond) || cond == Constants.Nil ? ast.fourth() : ast.third();
                    tailPosition = true;
                    break;
                }
                case "let": {
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    Serializable expressions = ast.slice(2);
                    for (int i = 0; i < bindings.size(); i += 2) {
                        VncVal sym = bindings.nth(i);
                        VncVal val = this.evaluate(bindings.nth(i + 1), env);
                        env.addLocalVars(Destructuring.destructure(sym, val));
                    }
                    this.evaluate_values(((VncList)expressions).butlast(), env);
                    orig_ast = ((VncList)expressions).last();
                    tailPosition = true;
                    break;
                }
                case "loop": {
                    recursionPoint = null;
                    env = new Env(env);
                    VncVector bindings = Coerce.toVncVector(ast.second());
                    Serializable expressions = ast.slice(2);
                    ArrayList<VncSymbol> bindingNames = new ArrayList<VncSymbol>(bindings.size() / 2);
                    for (int i = 0; i < bindings.size(); i += 2) {
                        VncSymbol sym = Coerce.toVncSymbol(bindings.nth(i));
                        VncVal val = this.evaluate(bindings.nth(i + 1), env);
                        env.setLocal(new Var(sym, val));
                        bindingNames.add(sym);
                    }
                    recursionPoint = new RecursionPoint(bindingNames, (VncList)expressions, env);
                    if (((VncList)expressions).size() == 1) {
                        orig_ast = ((VncList)expressions).first();
                        break;
                    }
                    this.evaluate_values(((VncList)expressions).butlast(), env);
                    orig_ast = ((VncList)expressions).last();
                    tailPosition = true;
                    break;
                }
                case "recur": {
                    Serializable expressions;
                    if (recursionPoint == null) {
                        WithCallStack cs = new WithCallStack(new CallFrame("recur", a0.getMeta()));
                        expressions = null;
                        try {
                            try {
                                throw new NotInTailPositionException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable throwable) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        ((Throwable)expressions).addSuppressed(throwable2);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw throwable;
                        }
                    }
                    env = this.buildRecursionEnv(ast, env, recursionPoint);
                    VncList expressions2 = recursionPoint.getLoopExpressions();
                    if (expressions2.size() > 1) {
                        this.evaluate_values(expressions2.butlast(), env);
                    }
                    orig_ast = expressions2.last();
                    tailPosition = true;
                    break;
                }
                case "quasiquote": {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    break;
                }
                case "quote": {
                    return ast.second();
                }
                case "fn": {
                    return this.fn_(ast, env);
                }
                case "eval": {
                    return this.eval_(new CallFrame("eval", a0.getMeta()), ast, env);
                }
                case "def": {
                    return this.def_(new CallFrame("def", a0.getMeta()), ast, env);
                }
                case "defonce": {
                    return this.defonce_(new CallFrame("defonce", a0.getMeta()), ast, env);
                }
                case "def-dynamic": {
                    return this.def_dynamic_(new CallFrame("def-dynamic", a0.getMeta()), ast, env);
                }
                case "defmacro": {
                    return this.defmacro_(new CallFrame("defmacro", a0.getMeta()), ast, env);
                }
                case "deftype": {
                    return this.deftype_(new CallFrame("deftype", a0.getMeta()), ast, env);
                }
                case "deftype?": {
                    return this.deftypeQ_(new CallFrame("deftype?", a0.getMeta()), ast, env);
                }
                case "deftype-of": {
                    return this.deftype_of_(new CallFrame("deftype-of", a0.getMeta()), ast, env);
                }
                case "deftype-or": {
                    return this.deftype_or_(new CallFrame("deftype-or", a0.getMeta()), ast, env);
                }
                case ".:": {
                    return this.deftype_create_(new CallFrame(".:", a0.getMeta()), ast, env);
                }
                case "defmulti": {
                    return this.defmulti_(new CallFrame("defmulti", a0.getMeta()), ast, env);
                }
                case "defmethod": {
                    return this.defmethod_(new CallFrame("defmethod", a0.getMeta()), ast, env);
                }
                case "ns": {
                    return this.ns_(new CallFrame("ns", a0.getMeta()), ast, env);
                }
                case "ns-remove": {
                    return this.ns_remove_(new CallFrame("ns-remove", a0.getMeta()), ast, env);
                }
                case "ns-unmap": {
                    return this.ns_unmap_(new CallFrame("ns-unmap", a0.getMeta()), ast, env);
                }
                case "ns-list": {
                    return this.ns_list_(new CallFrame("ns-list", a0.getMeta()), ast, env);
                }
                case "import": {
                    return this.import_(new CallFrame("import", a0.getMeta()), ast, env);
                }
                case "imports": {
                    return this.imports_(new CallFrame("imports", a0.getMeta()), ast, env);
                }
                case "namespace": {
                    return this.namespace_(new CallFrame("namespace", a0.getMeta()), ast, env);
                }
                case "resolve": {
                    return this.resolve_(new CallFrame("resolve", a0.getMeta()), ast, env);
                }
                case "var-get": {
                    return this.var_get_(new CallFrame("var-get", a0.getMeta()), ast, env);
                }
                case "var-ns": {
                    return this.var_ns_(new CallFrame("var-ns", a0.getMeta()), ast, env);
                }
                case "var-name": {
                    return this.var_name_(new CallFrame("var-name", a0.getMeta()), ast, env);
                }
                case "var-local?": {
                    return this.var_localQ_(new CallFrame("var-local?", a0.getMeta()), ast, env);
                }
                case "var-thread-local?": {
                    return this.var_thread_localQ_(new CallFrame("var-thread-local?", a0.getMeta()), ast, env);
                }
                case "var-global?": {
                    return this.var_globalQ_(new CallFrame("var-global?", a0.getMeta()), ast, env);
                }
                case "set!": {
                    return this.setBANG_(new CallFrame("set!", a0.getMeta()), ast, env);
                }
                case "inspect": {
                    return this.inspect_(new CallFrame("inspect", a0.getMeta()), ast, env);
                }
                case "macroexpand": {
                    return this.macroexpand(new CallFrame("macroexpand", a0.getMeta()), this.evaluate(ast.second(), env), env, null);
                }
                case "macroexpand-all*": {
                    return this.macroexpand_all(new CallFrame("macroexpand-all*", a0.getMeta()), this.evaluate(ast.second(), env), env);
                }
                case "macroexpand-info": {
                    return this.macroexpand_info_(new CallFrame("macroexpand-info", a0.getMeta()), ast, env);
                }
                case "doc": {
                    return this.doc_(new CallFrame("doc", a0.getMeta()), ast, env);
                }
                case "print-highlight": {
                    return this.print_highlight_(new CallFrame("print-highlight", a0.getMeta()), ast, env);
                }
                case "modules": {
                    return this.modules_(new CallFrame("modules", a0.getMeta()), ast, env);
                }
                case "binding": {
                    return this.binding_(ast, new Env(env));
                }
                case "bound?": {
                    return VncBoolean.of(env.isBound(Coerce.toVncSymbol(this.evaluate(ast.second(), env))));
                }
                case "global-vars-count": {
                    return new VncLong(env.globalsCount());
                }
                case "try": {
                    return this.try_(new CallFrame("try", a0.getMeta()), ast, new Env(env));
                }
                case "try-with": {
                    return this.try_with_(new CallFrame("try-with", a0.getMeta()), ast, new Env(env));
                }
                case "locking": {
                    return this.locking_(new CallFrame("locking", a0.getMeta()), ast, env);
                }
                case "dorun": {
                    this.specialFormCallValidation("dorun");
                    return this.dorun_(new CallFrame("dorun", a0.getMeta()), ast, env);
                }
                case "dobench": {
                    this.specialFormCallValidation("dobench");
                    return this.dobench_(new CallFrame("dobench", a0.getMeta()), ast, env);
                }
                case "prof": {
                    this.specialFormCallValidation("prof");
                    return this.prof_(new CallFrame("prof", a0.getMeta()), ast, env);
                }
                case "tail-pos": {
                    return this.tail_pos_check(tailPosition, new CallFrame("tail-pos", a0.getMeta()), ast, env);
                }
                default: {
                    VncVal elFirst = this.evaluate(ast.first(), env);
                    VncList fnArgs = (VncList)this.evaluate_sequence_values(ast.rest(), env);
                    if (elFirst instanceof VncFunction) {
                        long nanos;
                        VncFunction fn = (VncFunction)elFirst;
                        String fnName = fn.getQualifiedName();
                        long l = nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
                        if (this.checkSandbox) {
                            this.interceptor.validateVeniceFunction(fnName);
                            this.interceptor.validateMaxExecutionTime();
                        }
                        this.checkInterrupted(fnName);
                        CallStack callStack = ThreadLocalMap.getCallStack();
                        if (VeniceInterpreter.supportsAutoTCO() && tailPosition && !fn.isNative() && !callStack.isEmpty() && fnName.equals(callStack.peek().getFnName())) {
                            VncFunction f = fn.getFunctionForArgs(fnArgs);
                            env.addLocalVars(Destructuring.destructure(f.getParams(), fnArgs));
                            VncList body = (VncList)f.getBody();
                            this.evaluate_values(body.butlast(), env);
                            orig_ast = body.last();
                            break;
                        }
                        try {
                            callStack.push(new CallFrame(fn.getQualifiedName(), a0.getMeta()));
                            VncVal vncVal = fn.apply(fnArgs);
                            return vncVal;
                        }
                        finally {
                            callStack.pop();
                            this.checkInterrupted(fnName);
                            if (this.checkSandbox) {
                                this.interceptor.validateMaxExecutionTime();
                            }
                            if (this.meterRegistry.enabled) {
                                long elapsed = System.nanoTime() - nanos;
                                if (fn instanceof VncMultiArityFunction) {
                                    VncFunction f = fn.getFunctionForArgs(fnArgs);
                                    this.meterRegistry.record(fn.getQualifiedName() + "[" + f.getParams().size() + "]", elapsed);
                                } else {
                                    this.meterRegistry.record(fn.getQualifiedName(), elapsed);
                                }
                            }
                        }
                    }
                    if (elFirst instanceof IVncFunction) {
                        return ((IVncFunction)((Object)elFirst)).apply(fnArgs);
                    }
                    WithCallStack cs = new WithCallStack(new CallFrame(a0sym, a0.getMeta()));
                    Throwable throwable = null;
                    try {
                        try {
                            throw new VncException(String.format("Expected a function or keyword/set/map/vector as s-expression symbol value but got a value of type '%s'!", Types.getType(elFirst)));
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (cs != null) {
                            if (throwable != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable4;
                    }
                }
            }
        }
        return this.evaluate_values(orig_ast, env);
    }

    private VncVal evaluate_values(VncVal ast, Env env) {
        if (ast == Constants.Nil) {
            return Constants.Nil;
        }
        if (ast instanceof VncSymbol) {
            return env.get((VncSymbol)ast);
        }
        if (ast instanceof VncSequence) {
            return this.evaluate_sequence_values((VncSequence)ast, env);
        }
        if (ast instanceof VncMap) {
            VncMap map = (VncMap)ast;
            HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>(map.size());
            for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
            }
            return map.withValues(vals);
        }
        if (ast instanceof VncSet) {
            VncSet set = (VncSet)ast;
            ArrayList<VncVal> vals = new ArrayList<VncVal>(set.size());
            for (VncVal v : set.getList()) {
                vals.add(this.evaluate(v, env));
            }
            return set.withValues(vals);
        }
        return ast;
    }

    private VncSequence evaluate_sequence_values(VncSequence seq, Env env) {
        switch (seq.size()) {
            case 0: {
                return seq;
            }
            case 1: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env));
            }
            case 2: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
            }
            case 3: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env));
            }
            case 4: {
                return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env), this.evaluate(seq.fourth(), env));
            }
        }
        ArrayList<VncVal> vals = new ArrayList<VncVal>(seq.size());
        for (int ii = 0; ii < seq.size(); ++ii) {
            vals.add(this.evaluate(seq.nth(ii), env));
        }
        return seq.withValues(vals);
    }

    private VncVal macroexpand(VncVal ast, Env env, AtomicInteger expandedMacrosCounter) {
        VncVal fn;
        VncVal a0;
        long nanos = this.meterRegistry.enabled ? System.nanoTime() : 0L;
        VncVal ast_ = ast;
        int expandedMacros = 0;
        while (ast_ instanceof VncList && (a0 = ((VncList)ast_).first()) instanceof VncSymbol && (fn = env.getGlobalOrNull((VncSymbol)a0)) != null && fn instanceof VncFunction && ((VncFunction)fn).isMacro()) {
            VncFunction macro = (VncFunction)fn;
            VncList macroArgs = ((VncList)ast_).rest();
            if (this.checkSandbox) {
                this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            }
            ++expandedMacros;
            if (this.meterRegistry.enabled) {
                long nanosRun = System.nanoTime();
                ast_ = macro.apply(macroArgs);
                this.meterRegistry.record(macro.getQualifiedName() + "[m]", System.nanoTime() - nanosRun);
                continue;
            }
            ast_ = macro.apply(macroArgs);
        }
        if (expandedMacros > 0) {
            this.macroExpandCount.addAndGet(expandedMacros);
            if (this.meterRegistry.enabled) {
                this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
            }
        }
        if (expandedMacrosCounter != null) {
            expandedMacrosCounter.addAndGet(expandedMacros);
        }
        return ast_;
    }

    private VncVal macroexpand(CallFrame callframe, VncVal ast, Env env, AtomicInteger expandedMacrosCounter) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal = this.macroexpand(ast, env, expandedMacrosCounter);
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal macroexpand_all(CallFrame callframe, VncVal form, final Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            final AtomicInteger expandedMacroCounter = new AtomicInteger(0);
            VncFunction handler = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-handler")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncList list;
                    VncVal first;
                    VncVal form = args.first();
                    if (Types.isVncList(form) && Types.isVncSymbol(first = (list = (VncList)form).first())) {
                        VncVal second = list.second();
                        if (list.size() == 2 && "ns".equals(((VncSymbol)first).getName()) && second instanceof VncSymbol) {
                            Namespaces.setCurrentNamespace(VeniceInterpreter.this.nsRegistry.computeIfAbsent((VncSymbol)second));
                        } else {
                            return VeniceInterpreter.this.macroexpand(list, env, expandedMacroCounter);
                        }
                    }
                    return form;
                }
            };
            final VncFunction walk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-walk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction inner = (VncFunction)args.first();
                    VncVal form = args.second();
                    if (Types.isVncList(form)) {
                        return TransducerFunctions.map.applyOf(inner, form);
                    }
                    if (Types.isVncMapEntry(form)) {
                        return CoreFunctions.new_map_entry.applyOf(inner.applyOf(((VncMapEntry)form).getKey()), inner.applyOf(((VncMapEntry)form).getValue()));
                    }
                    if (Types.isVncCollection(form)) {
                        return CoreFunctions.into.applyOf(CoreFunctions.empty.applyOf(form), TransducerFunctions.map.applyOf(inner, form));
                    }
                    return form;
                }
            };
            VncFunction prewalk = new VncFunction(VncFunction.createAnonymousFuncName("macroexpand-all-prewalk")){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    VncFunction f = (VncFunction)args.first();
                    VncVal form = args.second();
                    return walk.applyOf(CoreFunctions.partial.applyOf(this, f), f.applyOf(form));
                }
            };
            Namespace original_ns = Namespaces.getCurrentNamespace();
            try {
                VncVal expanded = prewalk.applyOf(handler, form);
                int count = expandedMacroCounter.get();
                if (count == 0) {
                    this.macroExpandAllCount.incrementAndGet();
                } else {
                    this.macroExpandAllCount.incrementAndGet();
                    this.macroExpandAllCountEffective.incrementAndGet();
                }
                vncVal = expanded;
            }
            catch (Throwable throwable2) {
                try {
                    Namespaces.setCurrentNamespace(original_ns);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            Namespaces.setCurrentNamespace(original_ns);
            return vncVal;
        }
    }

    private static boolean isNonEmptySequence(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        if (VeniceInterpreter.isNonEmptySequence(ast)) {
            VncVal a00;
            VncVal a0 = Coerce.toVncSequence(ast).first();
            if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
                return ((VncSequence)ast).second();
            }
            if (VeniceInterpreter.isNonEmptySequence(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
                return VncList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
            }
            return VncList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncList.of(new VncSymbol("quote"), ast);
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        VncSymbol macroName;
        VncVal meta;
        int argPos = 1;
        if (MetaUtil.isPrivate(meta = (macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.nth(argPos++), env))).getMeta())) {
            throw new VncException(String.format("The macro '%s' must not be defined as private! Venice does not support private macros.", macroName.getName()));
        }
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String name = macroName.getName();
        String ns = macroName.getNamespace();
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            VncList body = ast.slice(++argPos);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, body, null, true, env);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, true, env));
        });
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns, true).withMeta(meta);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    private VncVal def_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("def", ast.rest(), 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "def");
            VncVal val = ast.third();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, true));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal defonce_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("defonce", ast.rest(), 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "defonce");
            VncVal val = ast.third();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobal(new Var(name, res, false));
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal def_dynamic_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("def-dynamic", ast.rest(), 1, 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "def-dynamic");
            VncVal val = ast.third();
            VncVal res = this.evaluate(val, env).withMeta(name.getMeta());
            env.setGlobalDynamic(name, res);
            VncSymbol vncSymbol = name;
            return vncSymbol;
        }
    }

    private VncVal defmacro_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertMinArity("defmacro", ast.rest(), 2);
            VncFunction vncFunction = this.defmacro_(ast, env);
            return vncFunction;
        }
    }

    private VncVal deftype_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("deftype", ast.rest(), 2, 3);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
            VncVector fields = Coerce.toVncVector(ast.third());
            VncFunction validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
            VncVal vncVal = DefTypeForm.defineCustomType(type, fields, validationFn, this::RE, env);
            return vncVal;
        }
    }

    private VncVal deftypeQ_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("deftype?", ast.rest(), 1);
            VncVal type = this.evaluate(ast.second(), env);
            VncBoolean vncBoolean = VncBoolean.of(DefTypeForm.isCustomType(type, env));
            return vncBoolean;
        }
    }

    private VncVal deftype_of_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertMinArity("deftype-of", ast.rest(), 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
            VncKeyword baseType = Coerce.toVncKeyword(this.evaluate(ast.third(), env));
            VncFunction validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
            VncVal vncVal = DefTypeForm.defineCustomWrapperType(type, baseType, validationFn, this::RE, env, this.wrappableTypes);
            return vncVal;
        }
    }

    private VncVal deftype_or_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertMinArity("deftype-or", ast.rest(), 2);
            VncKeyword type = Coerce.toVncKeyword(this.evaluate(ast.second(), env));
            VncList choiceVals = ast.slice(2);
            VncVal vncVal = DefTypeForm.defineCustomChoiceType(type, choiceVals, this::RE, env);
            return vncVal;
        }
    }

    private VncVal deftype_create_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertMinArity(".:", ast.rest(), 1);
            ArrayList<VncVal> args = new ArrayList<VncVal>();
            Iterator<VncVal> iter = ast.rest().iterator();
            while (iter.hasNext()) {
                VncVal v = iter.next();
                args.add(this.evaluate(v, env));
            }
            VncVal vncVal = DefTypeForm.createType(args, env);
            return vncVal;
        }
    }

    private VncVal defmulti_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.assertArity("defmulti", ast.rest(), 2);
            VncSymbol name = this.validateSymbolWithCurrNS(this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env)), "defmulti");
            VncVal dispatchFn = Types.isVncKeyword(ast.third()) ? (VncKeyword)ast.third() : (Types.isVncSymbol(ast.third()) ? Coerce.toVncFunction(env.get((VncSymbol)ast.third())) : this.fn_(Coerce.toVncList(ast.third()), env));
            VncMultiFunction multiFn = new VncMultiFunction(name.getName(), (IVncFunction)((Object)dispatchFn)).withMeta(name.getMeta());
            env.setGlobal(new Var(name, multiFn, true));
            VncMultiFunction vncMultiFunction = multiFn;
            return vncMultiFunction;
        }
    }

    private VncVal defmethod_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(ast.second()));
            VncVal multiFnVal = env.getGlobalOrNull(multiFnName);
            if (multiFnVal == null) {
                throw new VncException(String.format("No multifunction '%s' defined for the method definition", multiFnName.getName()));
            }
            VncMultiFunction multiFn = Coerce.toVncMultiFunction(multiFnVal);
            VncVal dispatchVal = ast.third();
            VncVector params = Coerce.toVncVector(ast.fourth());
            if (params.size() != multiFn.getParams().size()) {
                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", multiFnName.getName(), multiFn.getParams().size()));
            }
            VncVector preConditions = this.getFnPreconditions(ast.nth(4), env);
            VncList body = ast.slice(preConditions == null ? 4 : 5);
            VncFunction fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, false, env);
            VncMultiFunction vncMultiFunction = multiFn.addFn(dispatchVal, fn.withMeta(ast.getMeta()));
            return vncMultiFunction;
        }
    }

    private VncVal ns_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncSymbol ns;
            this.specialFormCallValidation("ns");
            VncVal name = ast.second();
            VncSymbol vncSymbol = ns = Types.isVncSymbol(name) ? (VncSymbol)name : (VncSymbol)CoreFunctions.symbol.apply(VncList.of(this.evaluate(name, env)));
            if (ns.hasNamespace()) {
                throw new VncException(String.format("A namespace '%s' must not have itself a namespace! However you can use '%s'.", ns.getQualifiedName(), ns.getNamespace() + "." + ns.getSimpleName()));
            }
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be reopened!");
            }
            Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(ns));
            VncSymbol vncSymbol2 = ns;
            return vncSymbol2;
        }
    }

    private VncVal ns_remove_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-remove");
            VncSymbol ns = Namespaces.lookupNS(ast.second(), env);
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
            }
            env.removeGlobalSymbolsByNS(ns);
            this.nsRegistry.remove(ns);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal ns_unmap_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-unmap");
            VncSymbol ns = Namespaces.lookupNS(ast.second(), env);
            if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
            }
            VncSymbol sym = Coerce.toVncSymbol(ast.third()).withNamespace(ns);
            env.removeGlobalSymbol(sym);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal ns_list_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            this.specialFormCallValidation("ns-list");
            VncSymbol ns = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
            String nsName = ns.getName();
            VncList vncList = VncList.ofList(env.getAllGlobalSymbols().keySet().stream().map(s -> {
                String n = env.getNamespace((VncSymbol)s);
                return new VncSymbol(n, s.getSimpleName(), Constants.Nil);
            }).filter(s -> nsName.equals(s.getNamespace())).sorted().collect(Collectors.toList()));
            return vncList;
        }
    }

    private VncVal import_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            ast.rest().forEach(i -> Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue()));
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal imports_(CallFrame callframe, VncList ast, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            if (ast.size() == 1) {
                VncList vncList = Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                return vncList;
            }
            VncSymbol ns = Coerce.toVncSymbol(ast.second());
            Namespace namespace = this.nsRegistry.get(ns);
            if (namespace != null) {
                VncList vncList = namespace.getJavaImportsAsVncList();
                return vncList;
            }
            try {
                throw new VncException(String.format("The namespace '%s' does not exist", ns.toString()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private VncVal namespace_(CallFrame callframe, VncList ast, Env env) {
        VncVal val = this.evaluate(ast.second(), env);
        if (val instanceof INamespaceAware) {
            return new VncString(((INamespaceAware)((Object)val)).getNamespace());
        }
        WithCallStack cs = new WithCallStack(callframe);
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("The type '%s' does not support namespaces!", Types.getType(val)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    private VncVal resolve_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("resolve");
        return env.getOrNil(Coerce.toVncSymbol(this.evaluate(ast.second(), env)));
    }

    private VncVal var_get_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("var-get");
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return env.getOrNil(sym);
    }

    private VncVal var_ns_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("var-ns");
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        String ns = env.getNamespace(sym);
        return ns == null ? Constants.Nil : new VncString(ns);
    }

    private VncVal var_name_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("var-name");
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return new VncString(sym.getName());
    }

    private VncVal var_localQ_(CallFrame callframe, VncList ast, Env env) {
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return VncBoolean.of(env.isLocal(sym));
    }

    private VncVal var_thread_localQ_(CallFrame callframe, VncList ast, Env env) {
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return VncBoolean.of(env.isThreadLocal(sym));
    }

    private VncVal var_globalQ_(CallFrame callframe, VncList ast, Env env) {
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return VncBoolean.of(env.isGlobal(sym));
    }

    private VncVal setBANG_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("set!");
        VncSymbol sym = Types.isVncSymbol(ast.second()) ? (VncSymbol)ast.second() : Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        Var globVar = env.getGlobalVarOrNull(sym);
        if (globVar != null) {
            VncVal expr = ast.third();
            VncVal val = this.evaluate(expr, env);
            if (globVar instanceof DynamicVar) {
                env.popGlobalDynamic(globVar.getName());
                env.pushGlobalDynamic(globVar.getName(), val);
            } else {
                env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable()));
            }
            return val;
        }
        WithCallStack cs = new WithCallStack(callframe);
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("The global or thread-local var '%s' does not exist!", sym.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    private VncVal inspect_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("inspect");
        VncSymbol sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
        return Inspector.inspect(env.get(sym));
    }

    private VncVal macroexpand_info_(CallFrame callframe, VncList ast, Env env) {
        return VncHashMap.of(new VncKeyword("macroexpand-count"), new VncLong(this.macroExpandCount.get()), new VncKeyword("macroexpand-all-count"), new VncLong(this.macroExpandAllCount.get()), new VncKeyword("macroexpand-all-count-effective"), new VncLong(this.macroExpandAllCountEffective.get()));
    }

    private VncVal doc_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncString doc = DocForm.doc(ast.second(), env);
            this.evaluate(VncList.of(new VncSymbol("println"), doc), env);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal print_highlight_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncString form = DocForm.highlight(Coerce.toVncString(ast.second()), env);
            this.evaluate(VncList.of(new VncSymbol("println"), form), env);
            VncConstant vncConstant = Constants.Nil;
            return vncConstant;
        }
    }

    private VncVal modules_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList = VncList.ofList(Modules.VALID_MODULES.stream().filter(s -> !s.equals("core")).sorted().map(s -> new VncKeyword((String)s)).collect(Collectors.toList()));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal eval_(CallFrame callframe, VncList ast, Env env) {
        this.specialFormCallValidation("eval");
        Namespace ns = Namespaces.getCurrentNamespace();
        try {
            VncVal vncVal = this.evaluate(Coerce.toVncSequence(this.evaluate_values(ast.rest(), env)).last(), env);
            return vncVal;
        }
        finally {
            Namespaces.setCurrentNamespace(ns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(CallFrame callframe, VncList ast, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal vncVal;
            if (ast.size() != 3) {
                throw new VncException("dorun requires two arguments a count and an expression to run");
            }
            long count = Coerce.toVncLong(ast.second()).getValue();
            if (count <= 0L) {
                VncConstant vncConstant = Constants.Nil;
                return vncConstant;
            }
            VncVal expr = ast.third();
            try {
                VncVal first = this.evaluate(expr, env);
                int ii = 1;
                while ((long)ii < count) {
                    VncVal result = this.evaluate(expr, env);
                    this.checkInterrupted("dorun");
                    ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                    ++ii;
                }
                vncVal = first;
            }
            catch (Throwable throwable2) {
                try {
                    ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
            return vncVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(CallFrame callframe, VncList ast, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncList vncList;
            if (ast.size() != 3) {
                throw new VncException("dobench requires two arguments a count and an expression to run");
            }
            try {
                long count = Coerce.toVncLong(ast.second()).getValue();
                VncVal expr = ast.third();
                ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
                int ii = 0;
                while ((long)ii < count) {
                    long start = System.nanoTime();
                    VncVal result = this.evaluate(expr, env);
                    long end = System.nanoTime();
                    elapsed.add(new VncLong(end - start));
                    this.checkInterrupted("dobench");
                    ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                    ++ii;
                }
                vncList = VncList.ofList(elapsed);
            }
            catch (Throwable throwable2) {
                try {
                    ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
            return vncList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(CallFrame callframe, VncList ast, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal mutex;
            if (ast.size() < 3) {
                throw new VncException("locking requires a lockee and one or more expressions to run");
            }
            VncVal vncVal = mutex = this.evaluate(ast.second(), env);
            synchronized (vncVal) {
                try {
                    VncVal vncVal2 = this.evaluateBody(ast.slice(2), env, true);
                    return vncVal2;
                }
                catch (Throwable throwable2) {
                    try {
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
            }
        }
    }

    private VncVal tail_pos_check(boolean inTailPosition, CallFrame callframe, VncList ast, Env env) {
        if (!inTailPosition) {
            VncString name = Coerce.toVncString(ast.nthOrDefault(1, VncString.empty()));
            WithCallStack cs = new WithCallStack(callframe);
            Throwable throwable = null;
            try {
                try {
                    throw new NotInTailPositionException(name.isEmpty() ? "Not in tail position" : String.format("Not '%s' in tail position", name.getValue()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return Constants.Nil;
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSymbol name;
        int argPos;
        if (Types.isVncSymbol(ast.second())) {
            argPos = 2;
            name = (VncSymbol)ast.second();
        } else {
            argPos = 1;
            name = new VncSymbol(VncFunction.createAnonymousFuncName());
        }
        VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
        ReservedSymbols.validateNotReservedSymbol(fnName);
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        if (Types.isVncVector(paramsOrSig)) {
            VncVector preCon;
            VncVector params = (VncVector)paramsOrSig;
            if ((preCon = this.getFnPreconditions(ast.nthOrDefault(++argPos, null), env)) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(fnName.getName(), params, body, preCon, false, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preCon = this.getFnPreconditions(sig.nth(pos), env);
            if (preCon != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(fnName.getName(), params, body, preCon, false, env));
        });
        return new VncMultiArityFunction(fnName.getName(), fns, false);
    }

    private VncVal prof_(CallFrame callframe, VncList ast, Env env) {
        Throwable throwable = null;
        try (WithCallStack cs = new WithCallStack(callframe);){
            if (Types.isVncKeyword(ast.second())) {
                VncKeyword cmd = (VncKeyword)ast.second();
                switch (cmd.getValue()) {
                    case "on": 
                    case "enable": {
                        this.meterRegistry.enable();
                        VncKeyword vncKeyword = new VncKeyword("on");
                        return vncKeyword;
                    }
                    case "off": 
                    case "disable": {
                        this.meterRegistry.disable();
                        VncKeyword vncKeyword = new VncKeyword("off");
                        return vncKeyword;
                    }
                    case "status": {
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear": {
                        this.meterRegistry.reset();
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "clear-all-but": {
                        this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                        VncKeyword vncKeyword = new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                        return vncKeyword;
                    }
                    case "data": {
                        VncList vncList = this.meterRegistry.getVncTimerData();
                        return vncList;
                    }
                    case "data-formatted": {
                        VncVal opt1 = ast.third();
                        VncVal opt2 = ast.fourth();
                        String title = "Metrics";
                        if (Types.isVncString(opt1) && !Types.isVncKeyword(opt1)) {
                            title = ((VncString)opt1).getValue();
                        }
                        if (Types.isVncString(opt2) && !Types.isVncKeyword(opt2)) {
                            title = ((VncString)opt2).getValue();
                        }
                        boolean anonFn = false;
                        if (Types.isVncKeyword(opt1)) {
                            boolean bl = anonFn = anonFn || ((VncKeyword)opt1).hasValue("anon-fn");
                        }
                        if (Types.isVncKeyword(opt2)) {
                            anonFn = anonFn || ((VncKeyword)opt2).hasValue("anon-fn");
                        }
                        VncString vncString = new VncString(this.meterRegistry.getTimerDataFormatted(title, anonFn));
                        return vncString;
                    }
                }
            }
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            vars.addAll(Destructuring.destructure(sym, val));
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            this.evaluate_values(expressions.butlast(), env);
            VncVal vncVal = this.evaluate(expressions.last(), env);
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private VncVal try_(CallFrame callframe, VncList ast, Env env) {
        try (WithCallStack cs = new WithCallStack(callframe);){
            VncVal result;
            block22: {
                result = Constants.Nil;
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env, true);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block22;
                    this.evaluateBody(finallyBlock, env, false);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block23: {
                        block24: {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(new Var(catchBlock.getExSym(), new VncJavaObject(th)));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env, false);
                            if (cs == null) break block23;
                            if (var5_5 == null) break block24;
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                            break block23;
                        }
                        cs.close();
                    }
                    return vncVal;
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        VncList finallyBlock = this.findFirstFinallyBlock(ast);
                        if (finallyBlock != null) {
                            this.evaluateBody(finallyBlock, env, false);
                        }
                    }
                }
            }
            VncVal vncVal = result;
            return vncVal;
        }
    }

    /*
     * Exception decompiling
     */
    private VncVal try_with_(CallFrame callframe, VncList ast, Env env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iter = ast.rest().iterator();
        while (!(!iter.hasNext() || Types.isVncList(e = iter.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return VncList.ofList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        Iterator<VncVal> iter = blocks.iterator();
        while (iter.hasNext()) {
            VncList block;
            VncVal first;
            VncVal b = iter.next();
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        Iterator<VncVal> iter = blocks.iterator();
        while (iter.hasNext()) {
            VncList block;
            VncVal first;
            VncVal b = iter.next();
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block.rest();
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, boolean macro, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        final boolean switchToFunctionNamespaceAtRuntime = !macro && !name.equals("macroexpand-all");
        final boolean plainSymbolParams = Destructuring.isFnParamsWithoutDestructuring(params);
        final boolean hasPreConditions = preConditions != null && !preConditions.isEmpty();
        return new VncFunction(name, params, macro){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                if (this.hasVariadicArgs()) {
                    if (args.size() < this.getFixedArgsCount()) {
                        WithCallStack cs = new WithCallStack(new CallFrame(name, params.getMeta()));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new ArityException(String.format("Wrong number of args (%d) passed to the variadic function %s that requires at least %d args (%s).", args.size(), this.getQualifiedName(), this.getFixedArgsCount(), this.getParams().toString(true)));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (cs != null) {
                                if (throwable != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                } else if (args.size() != this.getFixedArgsCount()) {
                    WithCallStack cs = new WithCallStack(new CallFrame(name, params.getMeta()));
                    Throwable throwable = null;
                    try {
                        try {
                            throw new ArityException(args.size(), this.getFixedArgsCount(), this.getQualifiedName());
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (cs != null) {
                            if (throwable != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw throwable6;
                    }
                }
                Env localEnv = new Env(env);
                this.addFnArgsToEnv(args, localEnv);
                if (switchToFunctionNamespaceAtRuntime) {
                    ThreadLocalMap threadLocalMap = ThreadLocalMap.get();
                    Namespace curr_ns = threadLocalMap.getCurrentNS();
                    try {
                        threadLocalMap.setCurrentNS(ns);
                        if (hasPreConditions) {
                            this.validateFnPreconditions(localEnv);
                        }
                        VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv, true);
                        return vncVal;
                    }
                    finally {
                        threadLocalMap.setCurrentNS(curr_ns);
                    }
                }
                if (hasPreConditions) {
                    this.validateFnPreconditions(localEnv);
                }
                return VeniceInterpreter.this.evaluateBody(body, localEnv, false);
            }

            @Override
            public boolean isNative() {
                return false;
            }

            @Override
            public VncVal getBody() {
                return body;
            }

            private void addFnArgsToEnv(VncList args, Env env2) {
                if (plainSymbolParams) {
                    for (int ii = 0; ii < params.size(); ++ii) {
                        env2.setLocal(new Var((VncSymbol)params.nth(ii), args.nthOrDefault(ii, Constants.Nil)));
                    }
                } else {
                    env2.addLocalVars(Destructuring.destructure(params, args));
                }
            }

            private void validateFnPreconditions(Env env2) {
                if (preConditions != null && !preConditions.isEmpty()) {
                    Env local = new Env(env2);
                    Iterator<VncVal> iter = preConditions.iterator();
                    while (iter.hasNext()) {
                        VncVal v = iter.next();
                        if (VeniceInterpreter.this.isFnConditionTrue(VeniceInterpreter.this.evaluate(v, local))) continue;
                        WithCallStack cs = new WithCallStack(new CallFrame(name, v.getMeta()));
                        Throwable throwable = null;
                        try {
                            try {
                                throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncList.of(v))).getValue()));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (cs != null) {
                                if (throwable != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                }
            }
        };
    }

    private Env buildRecursionEnv(VncList ast, Env env, RecursionPoint recursionPoint) {
        Env recur_env = recursionPoint.getLoopEnv();
        switch (ast.size()) {
            case 1: {
                break;
            }
            case 2: {
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), this.evaluate(ast.second(), env)));
                break;
            }
            case 3: {
                VncVal v1 = this.evaluate(ast.second(), env);
                VncVal v2 = this.evaluate(ast.third(), env);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2));
                break;
            }
            case 4: {
                VncVal v1_ = this.evaluate(ast.second(), env);
                VncVal v2_ = this.evaluate(ast.third(), env);
                VncVal v3_ = this.evaluate(ast.fourth(), env);
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(0), v1_));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(1), v2_));
                recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(2), v3_));
                break;
            }
            default: {
                VncList values = ast.rest();
                VncVal[] newValues = new VncVal[values.size()];
                for (int kk = 0; kk < values.size(); ++kk) {
                    newValues[kk++] = this.evaluate(values.nth(kk), env);
                }
                for (int ii = 0; ii < recursionPoint.getLoopBindingNamesCount(); ++ii) {
                    recur_env.setLocal(new Var(recursionPoint.getLoopBindingName(ii), newValues[ii]));
                }
            }
        }
        return recur_env;
    }

    private VncVector getFnPreconditions(VncVal prePostConditions, Env env) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? VncBoolean.isTrue(((VncSequence)result).first()) : VncBoolean.isTrue(result);
    }

    private VncVal evaluateBody(VncList body, Env env, boolean withTailPosition) {
        this.evaluate_values(body.butlast(), env);
        if (withTailPosition) {
            return this.evaluateInTailPosition(body.last(), env);
        }
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String fnName) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while processing function " + fnName);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (sym.hasNamespace()) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), sym.getNamespace()));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        VncVal newMeta = MetaUtil.setNamespace(sym.getMeta(), ns.getName());
        return Namespaces.isCoreNS(ns) ? new VncSymbol(sym.getName(), newMeta) : new VncSymbol(ns.getName(), sym.getName(), newMeta);
    }

    private VncSymbol validateSymbolWithCurrNS(VncSymbol sym, String specialFormName) {
        String ns;
        if (sym != null && (ns = sym.getNamespace()) != null && !ns.equals(Namespaces.getCurrentNS().getName())) {
            WithCallStack cs = new WithCallStack(new CallFrame(specialFormName, sym.getMeta()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("Special form '%s': Invalid use of namespace. The symbol '%s' can only be defined for the current namespace '%s'.", specialFormName, sym.getSimpleName(), Namespaces.getCurrentNS().toString()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return sym;
    }

    private void assertArity(String name, VncList args, int ... expectedArities) {
        int arity = args.size();
        for (int ii = 0; ii < expectedArities.length; ++ii) {
            if (expectedArities[ii] != arity) continue;
            return;
        }
        throw new ArityException(arity, name);
    }

    private void assertMinArity(String name, VncList args, int minArity) {
        int arity = args.size();
        if (arity < minArity) {
            throw new ArityException(arity, name);
        }
    }

    private void specialFormCallValidation(String name) {
        JavaInterop.getInterceptor().validateVeniceFunction(name);
    }

    public static boolean supportsAutoTCO() {
        return true;
    }

    private static /* synthetic */ void lambda$try_with_$10(Var b) {
        VncVal resource = b.getVal();
        if (Types.isVncJavaObject(resource)) {
            Object r = ((VncJavaObject)resource).getDelegate();
            if (r instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)r).close();
                }
                catch (Exception ex) {
                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                }
            }
            if (r instanceof Closeable) {
                try {
                    ((Closeable)r).close();
                }
                catch (Exception ex) {
                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.getName()));
                }
            }
        }
    }
}

