/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.cidr.CIDR;
import com.github.jlangch.venice.impl.util.cidr.collect.CidrTrie;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Map;

public class CidrFunctions {
    public static VncFunction parse = new VncFunction("cidr/parse", (VncVal)VncFunction.meta().arglists("(cidr/parse cidr)").doc("Parses CIDR IP blocks to an IP address range. Supports both IPv4 and IPv6.").examples("(cidr/parse \"222.192.0.0/11\")", "(cidr/parse \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347/64\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal cidr = args.first();
            if (Types.isVncJavaObject(cidr, CIDR.class)) {
                return cidr;
            }
            return new VncJavaObject(CIDR.parse(Coerce.toVncString(cidr).getValue()));
        }
    };
    public static VncFunction in_range_Q = new VncFunction("cidr/in-range?", (VncVal)VncFunction.meta().arglists("(cidr/in-range? ip cidr)").doc("Returns true if the ip adress is within the ip range of the cidr else false. ip may be a string or a :java.net.InetAddress, cidr may be a string or a CIDR Java object obtained from 'cidr/parse'.").examples("(cidr/in-range? \"222.220.0.0\" \"222.220.0.0/11\")", "(cidr/in-range? (cidr/inet-addr \"222.220.0.0\") \"222.220.0.0/11\")", "(cidr/in-range? \"222.220.0.0\" (cidr/parse \"222.220.0.0/11\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 2);
            VncVal ip = args.first();
            VncVal cidr_ = args.second();
            if (Types.isVncString(ip)) {
                if (Types.isVncString(cidr_)) {
                    CIDR cidr = CIDR.parse(((VncString)cidr_).getValue());
                    return VncBoolean.of(cidr.isInRange(((VncString)ip).getValue()));
                }
                if (Types.isVncJavaObject(cidr_, CIDR.class)) {
                    CIDR cidr = (CIDR)((VncJavaObject)cidr_).getDelegate();
                    return VncBoolean.of(cidr.isInRange(((VncString)ip).getValue()));
                }
                throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(cidr_)));
            }
            if (Types.isVncJavaObject(ip, InetAddress.class)) {
                if (Types.isVncString(cidr_)) {
                    InetAddress inet = (InetAddress)((VncJavaObject)ip).getDelegate();
                    CIDR cidr = CIDR.parse(((VncString)cidr_).getValue());
                    return VncBoolean.of(cidr.isInRange(inet));
                }
                if (Types.isVncJavaObject(cidr_, CIDR.class)) {
                    InetAddress inet = (InetAddress)((VncJavaObject)ip).getDelegate();
                    CIDR cidr = (CIDR)((VncJavaObject)cidr_).getDelegate();
                    return VncBoolean.of(cidr.isInRange(inet));
                }
                throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(cidr_)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(ip)));
        }
    };
    public static VncFunction start_inet_addr = new VncFunction("cidr/start-inet-addr", (VncVal)VncFunction.meta().arglists("(cidr/start-inet-addr cidr)").doc("Returns the start inet address of a CIDR IP block.").examples("(cidr/start-inet-addr \"222.192.0.0/11\")", "(cidr/start-inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347/64\")", "(cidr/start-inet-addr (cidr/parse \"222.192.0.0/11\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal arg = args.first();
            if (Types.isVncJavaObject(arg, CIDR.class)) {
                CIDR cidr = (CIDR)((VncJavaObject)arg).getDelegate();
                return new VncJavaObject(cidr.getLowInetAddress());
            }
            if (Types.isVncString(arg)) {
                CIDR cidr = CIDR.parse(((VncString)arg).getValue());
                return new VncJavaObject(cidr.getLowInetAddress());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/start-inet-addr'", Types.getType(arg)));
        }
    };
    public static VncFunction end_inet_addr = new VncFunction("cidr/end-inet-addr", (VncVal)VncFunction.meta().arglists("(cidr/end-inet-addr cidr)").doc("Returns the end inet address of a CIDR IP block.").examples("(cidr/end-inet-addr \"222.192.0.0/11\")", "(cidr/end-inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347/64\")", "(cidr/end-inet-addr (cidr/parse \"222.192.0.0/11\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal arg = args.first();
            if (Types.isVncJavaObject(arg, CIDR.class)) {
                CIDR cidr = (CIDR)((VncJavaObject)arg).getDelegate();
                return new VncJavaObject(cidr.getHighInetAddress());
            }
            if (Types.isVncString(arg)) {
                CIDR cidr = CIDR.parse(((VncString)arg).getValue());
                return new VncJavaObject(cidr.getHighInetAddress());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/end-inet-addr'", Types.getType(arg)));
        }
    };
    public static VncFunction trie = new VncFunction("cidr/trie", (VncVal)VncFunction.meta().arglists("(cidr/trie)").doc("Create a new mutable concurrent CIDR trie.").examples("(do                                                \n  (let [trie (cidr/trie)]                          \n    (cidr/insert trie                              \n                 (cidr/parse \"192.16.10.0/24\")   \n                 \"Germany\")                      \n    (cidr/lookup trie \"192.16.10.15\")))            ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 0);
            return new VncJavaObject(new CidrTrie());
        }
    };
    public static VncFunction size = new VncFunction("cidr/size", (VncVal)VncFunction.meta().arglists("(cidr/size trie)").doc("Returns the size of the trie.").examples("(do                                                \n  (let [trie (cidr/trie)]                          \n    (cidr/insert trie                              \n                 (cidr/parse \"192.16.10.0/24\")   \n                 \"Germany\")                      \n    (cidr/size trie)))                               ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            CidrTrie trie = Coerce.toVncJavaObject(args.first(), CidrTrie.class);
            return new VncLong(trie.size());
        }
    };
    public static VncFunction insert = new VncFunction("cidr/insert", (VncVal)VncFunction.meta().arglists("(cidr/insert trie cidr value)").doc("Insert a new CIDR / value relation into trie. Works with IPv4 and IPv6. Please keep IPv4 and IPv6 CIDRs in different tries.").examples("(do                                                \n  (let [trie (cidr/trie)]                          \n    (cidr/insert trie                              \n                 (cidr/parse \"192.16.10.0/24\")   \n                 \"Germany\")                      \n    (cidr/lookup trie \"192.16.10.15\")))            ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 3);
            CidrTrie trie = Coerce.toVncJavaObject(args.first(), CidrTrie.class);
            CIDR cidr = Coerce.toVncJavaObject(args.second(), CIDR.class);
            trie.insert(cidr, args.third());
            return Constants.Nil;
        }
    };
    public static VncFunction lookup = new VncFunction("cidr/lookup", (VncVal)VncFunction.meta().arglists("(cidr/lookup trie ip)").doc("Lookup the associated value of a CIDR in the trie. A cidr \"192.16.10.0/24\" or an inet address \"192.16.10.15\" can be passed as ip.").examples("(do                                                \n  (let [trie (cidr/trie)]                          \n    (cidr/insert trie                              \n                 (cidr/parse \"192.16.10.0/24\")   \n                 \"Germany\")                      \n    (cidr/lookup trie \"192.16.10.15\")))            ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 2);
            CidrTrie trie = Coerce.toVncJavaObject(args.first(), CidrTrie.class);
            if (Types.isVncString(args.second())) {
                String ip = ((VncString)args.second()).getValue();
                VncVal val = (VncVal)trie.getValue(ip);
                return val == null ? Constants.Nil : val;
            }
            if (Types.isVncJavaObject(args.second())) {
                CIDR cidr = Coerce.toVncJavaObject(args.second(), CIDR.class);
                VncVal val = (VncVal)trie.getValue(cidr);
                return val == null ? Constants.Nil : val;
            }
            throw new VncException(String.format("Invalid second argument type %s while calling function 'cidr/lookup'", Types.getType(args.second())));
        }
    };
    public static VncFunction lookup_mixed = new VncFunction("cidr/lookup-mixed", (VncVal)VncFunction.meta().arglists("(cidr/lookup-mixed trie-ip4 trie-ip6 ip)").doc("Lookup the associated value of a CIDR in the IPv4 or IPv6 trie. A cidr \"192.16.10.0/24\" or an inet address \"192.16.10.15\" (IPv4 or IPv6) can be passed as ip. The ip will then be routed to the corresponding IPv4 or IPv6 trie.").examples("(do                                               \n  (let [trie-ip4 (cidr/trie)                      \n        trie-ip6 (cidr/trie)]                     \n    (cidr/insert trie-ip4                         \n                 (cidr/parse \"192.16.10.0/24\")  \n                 \"Germany\")                     \n    (cidr/lookup-mixed trie-ip4                   \n                       trie-ip6                   \n                       \"192.16.10.15\")))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 3);
            if (Types.isVncString(args.third())) {
                String ip = ((VncString)args.third()).getValue();
                CidrTrie trie = Coerce.toVncJavaObject(ip.contains(".") ? args.first() : args.second(), CidrTrie.class);
                VncVal val = (VncVal)trie.getValue(ip);
                return val == null ? Constants.Nil : val;
            }
            if (Types.isVncJavaObject(args.third())) {
                CIDR cidr = Coerce.toVncJavaObject(args.third(), CIDR.class);
                CidrTrie trie = Coerce.toVncJavaObject(cidr.isIP4() ? args.first() : args.second(), CidrTrie.class);
                VncVal val = (VncVal)trie.getValue(cidr);
                return val == null ? Constants.Nil : val;
            }
            throw new VncException(String.format("Invalid second argument type %s while calling function 'cidr/lookup-mixed'", Types.getType(args.third())));
        }
    };
    public static VncFunction lookup_reverse = new VncFunction("cidr/lookup-reverse", (VncVal)VncFunction.meta().arglists("(cidr/lookup-reverse trie ip)").doc("Reverse lookup a CIDR in the trie given an IP address").examples("(do                                                \n  (let [trie (cidr/trie)]                          \n    (cidr/insert trie                              \n                 (cidr/parse \"192.16.10.0/24\")   \n                 \"Germany\")                      \n    (cidr/lookup-reverse trie \"192.16.10.15\")))    ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 2);
            CidrTrie trie = Coerce.toVncJavaObject(args.first(), CidrTrie.class);
            if (Types.isVncString(args.second())) {
                String ip = ((VncString)args.second()).getValue();
                CIDR cidr = trie.getCIDR(ip);
                return cidr == null ? Constants.Nil : new VncJavaObject(cidr);
            }
            throw new VncException(String.format("Invalid second argument type %s while calling function 'cidr/lookup-reverse'", Types.getType(args.second())));
        }
    };
    public static VncFunction ip4_Q = new VncFunction("cidr/ip4?", (VncVal)VncFunction.meta().arglists("(cidr/ip4? addr)").doc("Returns true if addr is an IPv4 address.").examples("(cidr/ip4? \"222.192.0.0\")", "(cidr/ip4? (cidr/inet-addr \"222.192.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                return VncBoolean.of(((VncString)addr).getValue().contains("."));
            }
            if (Types.isVncJavaObject(addr)) {
                Object inet = ((VncJavaObject)addr).getDelegate();
                return VncBoolean.of(inet instanceof Inet4Address);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction ip6_Q = new VncFunction("cidr/ip6?", (VncVal)VncFunction.meta().arglists("(cidr/ip6? addr)").doc("Returns true if addr is an IPv6 address.").examples("(cidr/ip6? \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")", "(cidr/ip6? (cidr/inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal addr = args.first();
            if (Types.isVncString(addr)) {
                return VncBoolean.of(((VncString)addr).getValue().contains(":"));
            }
            if (Types.isVncJavaObject(addr)) {
                Object inet = ((VncJavaObject)addr).getDelegate();
                return VncBoolean.of(inet instanceof Inet6Address);
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction inet_addr = new VncFunction("cidr/inet-addr", (VncVal)VncFunction.meta().arglists("(cidr/inet-addr addr)").doc("Converts a stringified IPv4 or IPv6 to a Java InetAddress.").examples("(cidr/inet-addr \"222.192.0.0\")", "(cidr/inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            String ip = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncJavaObject(InetAddress.getByName(ip));
            }
            catch (Exception ex) {
                throw new VncException("Not an IP address: '" + ip + "'");
            }
        }
    };
    public static VncFunction inet_addr_to_bytes = new VncFunction("cidr/inet-addr-to-bytes", (VncVal)VncFunction.meta().arglists("(cidr/inet-addr-to-bytes addr)").doc("Converts a stringified IPv4/IPv6 address or a Java InetAddress to an InetAddress byte vector.").examples("(cidr/inet-addr-to-bytes \"222.192.12.0\")", "(cidr/inet-addr-to-bytes \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")", "(cidr/inet-addr-to-bytes (cidr/inet-addr \"222.192.0.0\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncVal ip = args.first();
            if (Types.isVncString(ip)) {
                String ip_ = ((VncString)ip).getValue();
                try {
                    byte[] bytes = InetAddress.getByName(ip_).getAddress();
                    VncVal[] ints = new VncInteger[bytes.length];
                    for (int ii = 0; ii < bytes.length; ++ii) {
                        ints[ii] = new VncInteger(Byte.toUnsignedInt(bytes[ii]));
                    }
                    return VncVector.of(ints);
                }
                catch (Exception ex) {
                    throw new VncException("Not an IP address: '" + ip_ + "'");
                }
            }
            if (Types.isVncJavaObject(ip, InetAddress.class)) {
                InetAddress ip_ = (InetAddress)((VncJavaObject)ip).getDelegate();
                byte[] bytes = ip_.getAddress();
                VncVal[] ints = new VncInteger[bytes.length];
                for (int ii = 0; ii < bytes.length; ++ii) {
                    ints[ii] = new VncInteger(Byte.toUnsignedInt(bytes[ii]));
                }
                return VncVector.of(ints);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(ip)));
        }
    };
    public static VncFunction inet_addr_from_bytes = new VncFunction("cidr/inet-addr-from-bytes", (VncVal)VncFunction.meta().arglists("(cidr/inet-addr-bytes addr)").doc("Converts a IPv4 or IPv6 byte address (a vector of unsigned integers) to a Java InetAddress.").examples("(cidr/inet-addr-from-bytes [222I 192I 12I 0I])", "(cidr/inet-addr-from-bytes [32I 1I 13I 184I 133I 163I 8I 211I 19I 25I 138I 46I 3I 112I 115I 71I])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            VncList ints = Coerce.toVncList(args.first());
            try {
                byte[] addr = new byte[ints.size()];
                for (int ii = 0; ii < ints.size(); ++ii) {
                    addr[ii] = Coerce.toVncInteger(ints.nth(ii)).getValue().byteValue();
                }
                return new VncJavaObject(InetAddress.getByAddress(addr));
            }
            catch (Exception ex) {
                throw new VncException("Not an IP address: '" + args.first() + "'");
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(parse).add(in_range_Q).add(inet_addr).add(ip4_Q).add(ip6_Q).add(inet_addr_to_bytes).add(inet_addr_from_bytes).add(trie).add(size).add(insert).add(lookup).add(lookup_mixed).add(lookup_reverse).add(start_inet_addr).add(end_inet_addr).toMap();
}

