/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.concurrent.ManagedScheduledThreadPoolExecutor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class ScheduleFunctions {
    public static VncFunction schedule_delay = new VncFunction("schedule-delay", (VncVal)VncFunction.meta().arglists("(schedule-delay fn delay time-unit)").doc("Creates and executes a one-shot action that becomes enabled after the given delay. \nReturns a future. (deref f), (future? f), (future-cancel f), and (future-done? f) will work on the returned future. \nTime unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-delay (fn[] (println \"test\")) 1 :seconds)", "(deref (schedule-delay (fn [] 100) 2 :seconds))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 3);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncKeyword unit = Coerce.toVncKeyword(args.third());
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Callable<VncVal> taskWrapper = () -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    VncVal vncVal = fn.applyOf(new VncVal[0]);
                    return vncVal;
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            ScheduledFuture<VncVal> future = mngdExecutor.getExecutor().schedule(taskWrapper, (long)delay.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static VncFunction schedule_at_fixed_rate = new VncFunction("schedule-at-fixed-rate", (VncVal)VncFunction.meta().arglists("(schedule-at-fixed-rate fn initial-delay period time-unit)").doc("Creates and executes a periodic action that becomes enabled first after the given initial delay, and subsequently with the given period. \nReturns a future. (future? f), (future-cancel f), and (future-done? f) will work on the returned future. \nTime unit is one of :milliseconds, :seconds, :minutes, :hours, or :days. ").examples("(schedule-at-fixed-rate #(println \"test\") 1 2 :seconds)", "(let [s (schedule-at-fixed-rate #(println \"test\") 1 2 :seconds)] \n   (sleep 16 :seconds) \n   (future-cancel s))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 4);
            this.sandboxFunctionCallValidation();
            VncFunction fn = Coerce.toVncFunction(args.first());
            VncLong delay = Coerce.toVncLong(args.second());
            VncLong period = Coerce.toVncLong(args.third());
            VncKeyword unit = Coerce.toVncKeyword(args.nth(3));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Runnable taskWrapper = () -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    fn.applyOf(new VncVal[0]);
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            ScheduledFuture<?> future = mngdExecutor.getExecutor().scheduleAtFixedRate(taskWrapper, delay.getValue(), period.getValue(), ScheduleFunctions.toTimeUnit(unit));
            return new VncJavaObject(future);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(schedule_delay).add(schedule_at_fixed_rate).toMap();
    private static ManagedScheduledThreadPoolExecutor mngdExecutor = new ManagedScheduledThreadPoolExecutor("venice-scheduler-pool", 4);

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid scheduler time-unit " + unit.getValue());
    }

    public static void shutdown() {
        mngdExecutor.shutdown();
    }
}

