/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.javainterop.ClassVersionChecker;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncTunnelAsJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.StreamUtil;
import com.github.jlangch.venice.impl.util.reflect.ReflectionUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaInteropFunctions {
    private static Set<String> skippedFn = new HashSet<String>(Arrays.asList("clone", "equals", "hashCode", "notify", "notifyAll", "getClass", "toString", "wait"));
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(new JavaFn()).add(new ProxifyFn()).add(new CastFn()).add(new FormalTypeFn()).add(new SupersFn()).add(new BasesFn()).add(new DescribeJavaClassFn()).add(new JavaExistsClassQFn()).add(new JavaObjQFn()).add(new JavaEnumToListFn()).add(new JavaIterToListFn()).add(new JavaObjWrapFn()).add(new JavaObjUnwrapFn()).add(new JavaExStacktraceFn()).add(new JavaClassFn()).add(new JavaClassOfFn()).add(new JavaClassNameFn()).add(new JavaClassVersionFn()).add(new JavaClassLoaderFn()).add(new JavaClassLoaderOfFn()).add(new JavaUnwrapOptionalFn()).toMap();

    private static VncHashMap mapField(Field f) {
        return new VncHashMap().assoc(new VncKeyword(":name"), new VncKeyword(f.getName())).assoc(new VncKeyword(":type"), new VncKeyword(f.getType().getName())).assoc(new VncKeyword(":static"), VncBoolean.of(ReflectionUtil.isStatic(f)));
    }

    private static VncHashMap mapMethod(Method m) {
        Parameter[] params = m.getParameters();
        Type[] types = m.getGenericParameterTypes();
        Type ret = m.getGenericReturnType();
        return new VncHashMap().assoc(new VncKeyword(":name"), new VncKeyword(m.getName())).assoc(new VncKeyword(":params"), JavaInteropFunctions.mapParams(params, types)).assoc(new VncKeyword(":return"), new VncKeyword(ret.getTypeName())).assoc(new VncKeyword(":static"), VncBoolean.of(ReflectionUtil.isStatic(m)));
    }

    private static VncHashMap mapConstructor(Constructor<?> c) {
        Parameter[] params = c.getParameters();
        Type[] types = c.getGenericParameterTypes();
        return new VncHashMap().assoc(new VncKeyword(":default"), VncBoolean.of(params.length == 0)).assoc(new VncKeyword(":params"), JavaInteropFunctions.mapParams(params, types));
    }

    private static VncHashMap mapParams(Parameter[] params, Type[] types) {
        VncHashMap map = new VncHashMap();
        for (int ii = 0; ii < params.length; ++ii) {
            map = map.assoc(new VncKeyword(params[ii].getName()), new VncKeyword(types[ii].getTypeName()));
        }
        return map;
    }

    private static VncHashMap mapBeanGetter(Method m) {
        String name = ReflectionUtil.getBeanPropertyName(m);
        Type type = m.getGenericReturnType();
        return new VncHashMap().assoc(new VncKeyword(":property"), new VncKeyword(name)).assoc(new VncKeyword(":type"), new VncKeyword(type.getTypeName())).assoc(new VncKeyword(":getter"), VncBoolean.True);
    }

    private static VncHashMap mapBeanSetter(Method m) {
        String name = ReflectionUtil.getBeanPropertyName(m);
        Type type = m.getGenericParameterTypes()[0];
        return new VncHashMap().assoc(new VncKeyword(":property"), new VncKeyword(name)).assoc(new VncKeyword(":type"), new VncKeyword(type.getTypeName())).assoc(new VncKeyword(":setter"), VncBoolean.True);
    }

    public static class JavaUnwrapOptionalFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaUnwrapOptionalFn() {
            super("java-unwrap-optional", (VncVal)VncFunction.meta().arglists("(java-unwrap-optional val)").doc("Unwraps a Java :java.util.Optional to its contained value or nil").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Optional.class)) {
                Optional optional = (Optional)((VncJavaObject)args.first()).getDelegate();
                return optional.isPresent() ? new VncJavaObject(optional.get()) : Constants.Nil;
            }
            throw new VncException(String.format("Function 'java-unwrap-optional' does not allow %s as parameter", Types.getType(args.first())));
        }
    }

    public static class JavaObjUnwrapFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjUnwrapFn() {
            super("java-unwrap", (VncVal)VncFunction.meta().arglists("(java-unwrap val)").doc("Unwraps a venice value").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? ((VncTunnelAsJavaObject)arg).getDelegate() : arg;
        }
    }

    public static class JavaObjWrapFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjWrapFn() {
            super("java-wrap", (VncVal)VncFunction.meta().arglists("(java-wrap val)").doc("Wraps a venice value").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            VncVal arg = args.first();
            return arg instanceof VncTunnelAsJavaObject ? arg : new VncTunnelAsJavaObject(arg);
        }
    }

    public static class JavaIterToListFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaIterToListFn() {
            super("java-iterator-to-list", (VncVal)VncFunction.meta().arglists("(java-iterator-to-list e)").doc("Converts a Java iterator to a list").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Iterator.class)) {
                Iterator i = (Iterator)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(i).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return VncList.ofList(list);
            }
            throw new VncException(String.format("Function 'java-iterator-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    }

    public static class JavaEnumToListFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaEnumToListFn() {
            super("java-enumeration-to-list", (VncVal)VncFunction.meta().arglists("(java-enumeration-to-list e)").doc("Converts a Java enumeration to a list").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Enumeration.class)) {
                Enumeration e = (Enumeration)Coerce.toVncJavaObject(args.first()).getDelegate();
                List list = StreamUtil.stream(e).map(v -> JavaInteropUtil.convertToVncVal(v)).collect(Collectors.toList());
                return VncList.ofList(list);
            }
            throw new VncException(String.format("Function 'java-enumeration-to-list' does not allow %s as parameter", Types.getType(args.first())));
        }
    }

    public static class JavaObjQFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaObjQFn() {
            super("java-obj?", (VncVal)VncFunction.meta().arglists("(java-obj? obj)").doc("Returns true if obj is a Java object").examples("(java-obj? (. :java.math.BigInteger :new \"0\"))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            return VncBoolean.of(Types.isVncJavaObject(args.first()));
        }
    }

    public static class DescribeJavaClassFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public DescribeJavaClassFn() {
            super("describe-class", (VncVal)VncFunction.meta().arglists("(describe-class class)").doc("Describes a Java class.").examples("(describe :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            VncHashMap map = new VncHashMap();
            map = map.assoc(new VncKeyword("constructors"), VncList.ofList(ReflectionUtil.getPublicConstructors(clazz).stream().map(c -> JavaInteropFunctions.mapConstructor(c)).collect(Collectors.toList())));
            map = map.assoc(new VncKeyword("methods"), VncList.empty().addAllAtEnd(VncList.ofList(ReflectionUtil.getAllPublicInstanceMethods(clazz, true).stream().filter(m -> !skippedFn.contains(m.getName())).map(m -> JavaInteropFunctions.mapMethod(m)).collect(Collectors.toList()))).addAllAtEnd(VncList.ofList(ReflectionUtil.getAllPublicStaticMethods(clazz, true).stream().filter(m -> !skippedFn.contains(m.getName())).map(m -> JavaInteropFunctions.mapMethod(m)).collect(Collectors.toList()))));
            map = map.assoc(new VncKeyword("fields"), VncList.empty().addAllAtEnd(VncList.ofList(ReflectionUtil.getPublicInstanceFields(clazz).stream().map(m -> JavaInteropFunctions.mapField(m)).collect(Collectors.toList()))).addAllAtEnd(VncList.ofList(ReflectionUtil.getPublicStaticFields(clazz).stream().map(m -> JavaInteropFunctions.mapField(m)).collect(Collectors.toList()))));
            map = map.assoc(new VncKeyword("bean"), VncList.empty().addAllAtEnd(VncList.ofList(ReflectionUtil.getBeanGetterMethods(clazz).stream().map(m -> JavaInteropFunctions.mapBeanGetter(m)).collect(Collectors.toList()))).addAllAtEnd(VncList.ofList(ReflectionUtil.getBeanSetterMethods(clazz).stream().map(m -> JavaInteropFunctions.mapBeanSetter(m)).collect(Collectors.toList()))));
            return map;
        }
    }

    public static class BasesFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public BasesFn() {
            super("bases", (VncVal)VncFunction.meta().arglists("(bases class)").doc("Returns the immediate superclass and interfaces of class, if any.").examples("(bases :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            ArrayList classes = new ArrayList();
            Class<?> superclass = ReflectionUtil.getSuperclass(clazz);
            if (superclass != null) {
                classes.add(superclass);
            }
            classes.addAll(ReflectionUtil.getAllDirectInterfaces(clazz));
            return VncList.ofList(JavaInteropUtil.toVncKeywords(ReflectionUtil.distinct(classes)));
        }
    }

    public static class SupersFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public SupersFn() {
            super("supers", (VncVal)VncFunction.meta().arglists("(supers class)").doc("Returns the immediate and indirect superclasses and interfaces of class, if any.").examples("(supers :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            ArrayList classes = new ArrayList();
            List<Class<?>> superclasses = ReflectionUtil.getAllSuperclasses(clazz);
            List<Class<?>> interfaces = ReflectionUtil.getAllInterfaces(superclasses);
            classes.addAll(superclasses);
            classes.addAll(interfaces);
            return VncList.ofList(JavaInteropUtil.toVncKeywords(ReflectionUtil.distinct(classes)));
        }
    }

    public static class JavaExistsClassQFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaExistsClassQFn() {
            super("exists-class?", (VncVal)VncFunction.meta().arglists("(exists-class? name)").doc("Returns true the Java class for the given name exists otherwise returns false.").examples("(exists-class? :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            try {
                JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
                return VncBoolean.True;
            }
            catch (Exception ex) {
                return VncBoolean.False;
            }
        }
    }

    public static class JavaExStacktraceFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaExStacktraceFn() {
            super("stacktrace", (VncVal)VncFunction.meta().arglists("(stacktrace ex)").doc("Returns the stacktrace of a java exception").examples("(println (stacktrace (. :VncException :new (str \"test\"))))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first())) {
                VncJavaObject obj = (VncJavaObject)args.first();
                if (obj.getDelegate() instanceof Exception) {
                    Exception ex = (Exception)obj.getDelegate();
                    StringWriter wr = new StringWriter();
                    ex.printStackTrace(new PrintWriter(wr));
                    return new VncString(wr.getBuffer().toString());
                }
                throw new VncException(String.format("Function 'stacktrace' accepts only Java objects holding objects of type :java.lang.Exception type. Got a %s.", new VncKeyword(obj.getDelegate().getClass().getName())));
            }
            throw new VncException(String.format("Function 'stacktrace' requires a Java exception object. Got a %s.", Types.getType(args.second())));
        }
    }

    public static class JavaClassLoaderOfFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassLoaderOfFn() {
            super("classloader-of", (VncVal)VncFunction.meta().arglists("(classloader-of x)").doc("Returns the classloader of a value or a Java class. \n\nNote: \nSome Java VM implementations may use 'null' to represent \nthe  bootstrap class loader. This method will return 'nil' \nin such implementations if this class was loaded by the \nbootstrap class loader.").examples("(classloader-of (class :java.awt.Point))", "(classloader-of (. :java.awt.Point :new 10 10))", "(classloader-of (class-of \"abcdef\"))", "(classloader-of \"abcdef\")").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Class.class)) {
                Object obj = ((VncJavaObject)args.first()).getDelegate();
                ClassLoader cl = ((Class)obj).getClassLoader();
                return cl == null ? Constants.Nil : new VncJavaObject(cl);
            }
            if (Types.isVncJavaObject(args.first())) {
                Object obj = ((VncJavaObject)args.first()).getDelegate();
                ClassLoader cl = obj.getClass().getClassLoader();
                return cl == null ? Constants.Nil : new VncJavaObject(cl);
            }
            ClassLoader cl = args.first().getClass().getClassLoader();
            return cl == null ? Constants.Nil : new VncJavaObject(cl);
        }
    }

    public static class JavaClassLoaderFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassLoaderFn() {
            super("classloader", (VncVal)VncFunction.meta().arglists("(classloader)", "(classloader type)").doc("Returns the classloader.").examples(";; Returns the current classloader\n(classloader)", ";; Returns the system classloader\n(classloader :system)", ";; Returns the classloader which loaded the Venice classes\n(classloader :application)", ";; Returns the thread-context classloader\n(classloader :thread-context)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 0, 1);
            this.sandboxFunctionCallValidation();
            if (args.size() == 0) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return new VncJavaObject(cl != null ? cl.getClass() : VeniceInterpreter.class.getClassLoader());
            }
            if (Types.isVncKeyword(args.first())) {
                VncKeyword type = (VncKeyword)args.first();
                if ("system".equals(type.getValue())) {
                    return new VncJavaObject(ClassLoader.getSystemClassLoader());
                }
                if ("application".equals(type.getValue())) {
                    return new VncJavaObject(VeniceInterpreter.class.getClassLoader());
                }
                if ("thread-context".equals(type.getValue())) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return cl == null ? Constants.Nil : new VncJavaObject(cl);
                }
            }
            throw new VncException("Function 'classloader' unknown argument");
        }
    }

    public static class JavaClassVersionFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassVersionFn() {
            super("class-version", (VncVal)VncFunction.meta().arglists("(class-version class)").doc("Returns the major version of a Java class.\n\nJava major versions:\n  - Java 8 uses major version 52\n  - Java 9 uses major version 53\n  - Java 10 uses major version 54\n  - Java 11 uses major version 55\n  - Java 12 uses major version 56\n  - Java 13 uses major version 57\n  - Java 14 uses major version 58\n  - Java 15 uses major version 59").examples("(class-version :com.github.jlangch.venice.Venice)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            VncKeyword cl = Coerce.toVncKeyword(args.first());
            String name = cl.getValue().replace(".", "/") + ".class";
            return new VncLong(ClassVersionChecker.getClassResourceMajorVersion(name));
        }
    }

    public static class JavaClassNameFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassNameFn() {
            super("class-name", (VncVal)VncFunction.meta().arglists("(class-name class)").doc("Returns the Java class name of a class.").examples("(class-name (class :java.util.ArrayList))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first(), Class.class)) {
                Class clazz = (Class)((VncJavaObject)args.first()).getDelegate();
                return new VncString(clazz.getName());
            }
            throw new VncException(String.format("Function 'class-name' requires a Java class as argument", Types.getType(args.first())));
        }
    }

    public static class JavaClassOfFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassOfFn() {
            super("class-of", (VncVal)VncFunction.meta().arglists("(class-of x)").doc("Returns the Java class of a value.").examples("(class-of 100)", "(class-of (. :java.awt.Point :new 10 10))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            if (Types.isVncJavaObject(args.first())) {
                Object obj = ((VncJavaObject)args.first()).getDelegate();
                return new VncJavaObject(obj.getClass());
            }
            return new VncJavaObject(args.first().getClass());
        }
    }

    public static class JavaClassFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaClassFn() {
            super("class", (VncVal)VncFunction.meta().arglists("(class name)").doc("Returns the Java class for the given name. Throws an exception if the class is not found.").examples("(class :java.util.ArrayList)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports()));
        }
    }

    public static class FormalTypeFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public FormalTypeFn() {
            super("formal-type", (VncVal)VncFunction.meta().arglists("(formal-type object)").doc("Returns the formal type of a Java object").examples("(do \n   (import :java.awt.image.BufferedImage) \n   (import :java.awt.Graphics) \n\n   ;; cast the graphics context to 'java.awt.Graphics' instead of the \n   ;; implicit cast to 'java.awt.Graphics2D' as Venice is doing \n   (let [img (. :BufferedImage :new 40 40 1) \n         gd (cast :Graphics (. img :createGraphics))] \n     (formal-type gd)))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 1);
            if (Types.isVncJavaObject(args.first())) {
                VncJavaObject obj = (VncJavaObject)args.first();
                return new VncKeyword(obj.getDelegateFormalType() == null ? obj.getDelegate().getClass().getName() : obj.getDelegateFormalType().getName());
            }
            throw new VncException(String.format("Function 'formal-type' is not supported on non Java object (%s)", Types.getType(args.first())));
        }
    }

    public static class CastFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public CastFn() {
            super("cast", (VncVal)VncFunction.meta().arglists("(cast class object)").doc("Casts a Java object").examples("(do \n   (import :java.awt.image.BufferedImage) \n   (import :java.awt.Graphics) \n\n   ;; cast the graphics context to 'java.awt.Graphics' instead of the \n   ;; implicit cast to 'java.awt.Graphics2D' as Venice is doing \n   (let [img (. :BufferedImage :new 40 40 1) \n         gd (cast :Graphics (. img :createGraphics))] \n     (. gd :fillOval 10 20 5 5)\n     img))").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 2);
            if (args.second() == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncJavaObject(args.second())) {
                Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
                return ((VncJavaObject)args.second()).castTo(clazz);
            }
            throw new VncException(String.format("Function 'cast' does not allow casting a non Java object (%s)", Types.getType(args.second())));
        }
    }

    public static class ProxifyFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public ProxifyFn() {
            super("proxify", (VncVal)VncFunction.meta().arglists("(proxify classname method-map)").doc("Proxifies a Java interface to be passed as a Callback object to Java functions. The interface's methods are implemented by Venice functions. \nThe dynamic invocation handler takes care that the methods are called in the context of Venice sandbox even if the Java method that invokes the callback methods is running in another thread.").examples("(do \n   (import :java.io.File :java.io.FilenameFilter) \n\n   (def file-filter \n      (fn [dir name] (str/ends-with? name \".xxx\"))) \n\n   (let [dir (io/tmp-dir )] \n      ;; create a dynamic proxy for the interface FilenameFilter\n      ;; and implement its function 'accept' by 'file-filter'\n      (. dir :list (proxify :FilenameFilter {:accept file-filter}))) \n)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertArity(args, 2);
            this.sandboxFunctionCallValidation();
            Class<?> clazz = JavaInteropUtil.toClass(args.first(), Namespaces.getCurrentNamespace().getJavaImports());
            return new VncJavaObject(DynamicInvocationHandler.proxify(new CallFrame("proxify(:" + clazz.getName() + ")", args.getMeta()), clazz, Coerce.toVncMap(args.second())));
        }
    }

    public static class JavaFn
    extends AbstractJavaFn {
        private static final long serialVersionUID = -1848883965231344442L;

        public JavaFn() {
            super(".", (VncVal)VncFunction.meta().arglists("(. classname :new args)", "(. classname method-name args)", "(. classname field-name)", "(. classname :class)", "(. object method-name args)", "(. object field-name)", "(. object :class)").doc("Java interop. Calls a constructor or an class/object method or accesses a class/instance field. The function is sandboxed.").examples(";; invoke constructor \n(. :java.lang.Long :new 10)", ";; invoke static method \n(. :java.time.ZonedDateTime :now)", ";; invoke static method \n(. :java.lang.Math :min 10 20)", ";; access static field \n(. :java.lang.Math :PI)", ";; invoke method \n(. (. :java.lang.Long :new 10) :toString)", ";; get class name \n(. :java.lang.Math :class)", ";; get class name \n(. (. :java.io.File :new \"/temp\") :class)").build());
        }

        @Override
        public VncVal apply(VncList args) {
            this.assertMinArity(args, 2);
            this.sandboxFunctionCallValidation();
            return JavaInteropUtil.applyJavaAccess(args, Namespaces.getCurrentNamespace().getJavaImports());
        }
    }

    private static abstract class AbstractJavaFn
    extends VncFunction {
        private static final long serialVersionUID = -1848883965231344442L;

        public AbstractJavaFn(String name, VncVal meta) {
            super(name, meta);
        }

        @Override
        public boolean isRedefinable() {
            return false;
        }
    }
}

