/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.ContinueException;
import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.reader.AnonymousFnArgs;
import com.github.jlangch.venice.impl.reader.AtomType;
import com.github.jlangch.venice.impl.reader.AutoGenSym;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.reader.Tokenizer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBigInteger;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Reader {
    private final String filename;
    private final String form;
    private final List<Token> tokens;
    private int position;
    private final AnonymousFnArgs anonymousFnArgs = new AnonymousFnArgs();
    private final AutoGenSym autoGenSym = new AutoGenSym();

    private Reader(String filename, String form, List<Token> formTokens) {
        this.filename = filename;
        this.form = form;
        this.tokens = formTokens;
        this.position = 0;
    }

    public static VncVal read_str(String str, String filename) {
        return Reader.read_form(Reader.reader(str, filename));
    }

    private static Reader reader(String str, String filename) {
        return new Reader(filename, str, Reader.tokenize(str, filename));
    }

    public String unprocessedRest() {
        return this.lastReadPos() < 0 ? this.form : this.form.substring(this.lastReadPos());
    }

    public int lastReadPos() {
        return this.position == 0 ? -1 : this.tokens.get(this.position - 1).getFileEndPos();
    }

    public String toString() {
        return this.tokens.stream().map(t -> String.format("%-8s %s", String.format("%d,%d:", t.getLine(), t.getColumn()), t.getToken())).collect(Collectors.joining("\n"));
    }

    private Token peek() {
        return this.position >= this.tokens.size() ? null : this.tokens.get(this.position);
    }

    private Token next() {
        if (this.position >= this.tokens.size()) {
            throw new ContinueException();
        }
        return this.tokens.get(this.position++);
    }

    public static List<Token> tokenize(String str, String filename) {
        return Reader.tokenize(str, filename, true, true);
    }

    public static List<Token> tokenize(String str, String filename, boolean errorOnUnbalancedStringQuotes, boolean errorOnIncompleteEscapeChars) {
        return Tokenizer.tokenize(str, filename, true, errorOnUnbalancedStringQuotes, errorOnIncompleteEscapeChars);
    }

    private static VncVal read_atom(Reader rdr) {
        Token token = rdr.next();
        String sToken = token.getToken();
        switch (Reader.getAtomType(token)) {
            case NIL: {
                return Constants.Nil;
            }
            case TRUE: {
                return VncBoolean.True;
            }
            case FALSE: {
                return VncBoolean.False;
            }
            case INTEGER: {
                boolean hex = Reader.isHexNumberLiteral(sToken);
                return new VncInteger(hex ? Integer.parseInt(sToken.substring(2, sToken.length() - 1), 16) : Integer.parseInt(Reader.butlast(sToken).replaceAll("_", "")), MetaUtil.toMeta(token));
            }
            case LONG: {
                boolean hex = Reader.isHexNumberLiteral(sToken);
                return new VncLong(hex ? Long.parseLong(sToken.substring(2), 16) : Long.parseLong(sToken.replaceAll("_", "")), MetaUtil.toMeta(token));
            }
            case DOUBLE: {
                return new VncDouble(Double.parseDouble(sToken.replaceAll("_", "")), MetaUtil.toMeta(token));
            }
            case DECIMAL: {
                return new VncBigDecimal(new BigDecimal(Reader.butlast(sToken).replaceAll("_", "")), MetaUtil.toMeta(token));
            }
            case BIGINT: {
                boolean hex = Reader.isHexNumberLiteral(sToken);
                return new VncBigInteger(hex ? new BigInteger(Reader.butlast(sToken.substring(2)).replaceAll("_", ""), 16) : new BigInteger(Reader.butlast(sToken).replaceAll("_", "")), MetaUtil.toMeta(token));
            }
            case STRING: {
                String s = Reader.unescapeAndDecodeUnicode(StringUtil.removeEnd(sToken.substring(1), "\""));
                return Reader.interpolate(s, rdr.filename, token.getLine(), token.getColumn()).withMeta(MetaUtil.toMeta(token));
            }
            case STRING_BLOCK: {
                String s = Reader.unescapeAndDecodeUnicode(StringUtil.stripIndentIfFirstLineEmpty(StringUtil.removeEnd(sToken.substring(3), "\"\"\"")));
                return Reader.interpolate(s, rdr.filename, token.getLine(), token.getColumn()).withMeta(MetaUtil.toMeta(token));
            }
            case KEYWORD: {
                return new VncKeyword(sToken, MetaUtil.toMeta(token));
            }
            case SYMBOL: {
                VncSymbol sym = new VncSymbol(sToken);
                if (rdr.autoGenSym.isWithinSyntaxQuote() && rdr.autoGenSym.isAutoGenSymbol(sym)) {
                    return rdr.autoGenSym.lookup(sym);
                }
                rdr.anonymousFnArgs.addSymbol(sym);
                return sym.withMeta(MetaUtil.toMeta(token));
            }
        }
        throw new ParseError(Reader.formatParseError(token, "Unrecognized token '%s'", token.getToken()));
    }

    private static VncSequence read_list(Reader rdr, VncSequence lst, char start, char end) {
        Token token;
        Token lstToken = rdr.next();
        if (lstToken.charAt(0) != start) {
            throw new ParseError(Reader.formatParseError(lstToken, "Expected '%c'", Character.valueOf(start)));
        }
        ArrayList<VncVal> items = new ArrayList<VncVal>();
        while ((token = rdr.peek()) != null && token.charAt(0) != end) {
            items.add(Reader.read_form(rdr));
        }
        if (token == null) {
            throw new EofException(Reader.formatParseError(token, "Expected '%c', got EOF", Character.valueOf(end)));
        }
        rdr.next();
        return lst.withValues(items, MetaUtil.toMeta(lstToken));
    }

    private static VncHashMap read_hash_map(Reader rdr) {
        Token refToken = rdr.peek();
        VncSequence lst = Reader.read_list(rdr, VncList.empty(), '{', '}');
        return VncHashMap.ofAll(lst).withMeta(MetaUtil.toMeta(refToken));
    }

    private static VncVal read_form(Reader rdr) {
        Token token = rdr.peek();
        if (token == null) {
            throw new ContinueException();
        }
        switch (token.charAt(0)) {
            case '\'': {
                rdr.next();
                return VncList.of(new VncSymbol("quote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '`': {
                rdr.next();
                try {
                    rdr.autoGenSym.enterSyntaxQuote();
                    VncList vncList = VncList.of(new VncSymbol("quasiquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
                    return vncList;
                }
                finally {
                    rdr.autoGenSym.leaveSyntaxQuote();
                }
            }
            case '~': {
                if (token.equals("~")) {
                    rdr.next();
                    return VncList.of(new VncSymbol("unquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
                }
                rdr.next();
                return VncList.of(new VncSymbol("splice-unquote"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '^': {
                rdr.next();
                Token metaToken = rdr.peek();
                VncVal meta = Reader.read_form(rdr);
                if (Types.isVncKeyword(meta)) {
                    meta = VncHashMap.of(meta, VncBoolean.True);
                }
                if (Types.isVncMap(meta)) {
                    Token symToken = rdr.peek();
                    return Reader.read_form(rdr).withMeta(MetaUtil.mergeMeta(meta, MetaUtil.toMeta(symToken)));
                }
                throw new ParseError(Reader.formatParseError(metaToken, "Invalid meta data type %s", Types.getType(meta)));
            }
            case '@': {
                rdr.next();
                return VncList.of(new VncSymbol("deref"), Reader.read_form(rdr)).withMeta(MetaUtil.toMeta(token));
            }
            case '#': {
                rdr.next();
                Token t = rdr.peek();
                if (t.charAt(0) == '{') {
                    return VncHashSet.ofAll(Reader.read_list(rdr, VncList.empty(), '{', '}'));
                }
                if (t.charAt(0) == '(') {
                    VncVal meta = MetaUtil.toMeta(t);
                    if (rdr.anonymousFnArgs.isCapturing()) {
                        throw new ParseError(Reader.formatParseError(t, " #() forms cannot be nested", new Object[0]));
                    }
                    rdr.anonymousFnArgs.startCapture();
                    VncSequence body = Reader.read_list(rdr, VncList.empty(), '(', ')').withMeta(meta);
                    VncVector argsDef = rdr.anonymousFnArgs.buildArgDef().withMeta(meta);
                    VncList s_expr = VncList.of(new VncSymbol("fn", meta), argsDef, body);
                    rdr.anonymousFnArgs.stopCapture();
                    return s_expr;
                }
                throw new ParseError(Reader.formatParseError(t, "Expected '#{' or '#('", new Object[0]));
            }
            case '(': {
                return Reader.read_list(rdr, VncList.empty(), '(', ')');
            }
            case ')': {
                rdr.next();
                throw new ParseError(Reader.formatParseError(token, "Unexpected ')'", new Object[0]));
            }
            case '[': {
                return Reader.read_list(rdr, VncVector.empty(), '[', ']');
            }
            case ']': {
                rdr.next();
                throw new ParseError(Reader.formatParseError(token, "Unexpected ']'", new Object[0]));
            }
            case '{': {
                return Reader.read_hash_map(rdr);
            }
            case '}': {
                rdr.next();
                throw new ParseError(Reader.formatParseError(token, "Unexpected '}'", new Object[0]));
            }
        }
        return Reader.read_atom(rdr);
    }

    public static AtomType getAtomType(Token token) {
        switch (token.getType()) {
            case STRING: {
                return AtomType.STRING;
            }
            case STRING_BLOCK: {
                return AtomType.STRING_BLOCK;
            }
            case ANY: {
                char second;
                String sToken = token.getToken();
                char first = sToken.charAt(0);
                char c = second = sToken.length() > 1 ? (char)sToken.charAt(1) : (char)' ';
                if (first == ':') {
                    return AtomType.KEYWORD;
                }
                if (first == '0' && (second == 'x' || second == 'X')) {
                    return Reader.classifyNumericToken(sToken);
                }
                if (Character.isDigit(first) || first == '-' && Character.isDigit(second)) {
                    return Reader.classifyNumericToken(sToken);
                }
                switch (sToken) {
                    case "nil": {
                        return AtomType.NIL;
                    }
                    case "true": {
                        return AtomType.TRUE;
                    }
                    case "false": {
                        return AtomType.FALSE;
                    }
                }
                return AtomType.SYMBOL;
            }
        }
        return AtomType.UNKNOWN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VncVal interpolate(String s, String filename, int line, int column) {
        int pos = Reader.getFirstInterpolationFormStartPos(s);
        if (pos < 0) {
            return new VncString(s);
        }
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        list.add(CoreFunctions.str);
        String str = s;
        while (true) {
            String tail;
            String rest;
            if (pos > 0) {
                list.add(new VncString(str.substring(0, pos)));
            }
            if ((rest = str.substring(pos)).startsWith("~(")) {
                String s_ = rest.substring(1);
                Reader rdr = new Reader(filename, s_, Reader.tokenize(s_, filename, false, false));
                list.add(Reader.read_list(rdr, VncList.empty(), '(', ')'));
                tail = rdr.unprocessedRest().substring(1);
            } else {
                if (!rest.startsWith("~{")) throw new ParseError(Reader.formatParseError(filename, line, column, "Interpolation error. Expected \"~(\" or \"~{\"", new Object[0]));
                int endPos = rest.indexOf(125);
                if (endPos <= 2) throw new ParseError(Reader.formatParseError(filename, line, column, "Invalid value interpolation expression\"~{..}\" ", new Object[0]));
                String expr = rest.substring(2, endPos);
                Reader rdr = Reader.reader(expr, filename);
                list.add(Reader.read_form(rdr));
                tail = rest.substring(endPos + 1);
            }
            pos = Reader.getFirstInterpolationFormStartPos(tail);
            if (pos < 0) {
                if (tail.isEmpty()) return VncList.ofList(list);
                list.add(new VncString(tail));
                return VncList.ofList(list);
            }
            str = tail;
        }
    }

    private static int getFirstInterpolationFormStartPos(String s) {
        int p1 = s.indexOf("~{");
        int p2 = s.indexOf("~(");
        return p1 < 0 || p2 < 0 ? Math.max(p1, p2) : Math.min(p1, p2);
    }

    private static String unescapeAndDecodeUnicode(String s) {
        return Reader.unescape(StringUtil.decodeUnicode(s));
    }

    private static String unescape(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = text.toCharArray();
        int len = chars.length;
        int ii = 0;
        block10: while (ii < len) {
            char c;
            if ((c = chars[ii++]) == '\\' && ii < len) {
                switch (chars[ii++]) {
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                    case '\r': {
                        if (ii < len && chars[ii] == '\n') {
                            ++ii;
                            continue block10;
                        }
                        sb.append("\\\r");
                        continue block10;
                    }
                    case '\n': {
                        continue block10;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String formatParseError(Token token, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(token);
    }

    private static String formatParseError(String filename, int line, int column, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(filename, line, column);
    }

    private static boolean isHexNumberLiteral(String s) {
        return s.startsWith("0x") || s.startsWith("0X");
    }

    private static String butlast(String s) {
        return s.substring(0, s.length() - 1);
    }

    private static AtomType classifyNumericToken(String sToken) {
        char lastCh = sToken.charAt(sToken.length() - 1);
        if (lastCh == 'I') {
            return AtomType.INTEGER;
        }
        if (lastCh == 'M') {
            return AtomType.DECIMAL;
        }
        if (lastCh == 'N') {
            return AtomType.BIGINT;
        }
        return sToken.indexOf(46) > 0 ? AtomType.DOUBLE : AtomType.LONG;
    }
}

