/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class VncBigInteger
extends VncNumber {
    public static final VncKeyword TYPE = new VncKeyword(":core/bigint");
    private static final long serialVersionUID = -1848883965231344442L;
    private final BigInteger value;

    public VncBigInteger(BigInteger v) {
        this(v, null, Constants.Nil);
    }

    public VncBigInteger(double v) {
        this(BigInteger.valueOf((long)v), null, Constants.Nil);
    }

    public VncBigInteger(long v) {
        this(BigInteger.valueOf(v), null, Constants.Nil);
    }

    public VncBigInteger(BigInteger v, VncVal meta) {
        this(v, null, meta);
    }

    public VncBigInteger(BigInteger v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    @Override
    public VncBigInteger withMeta(VncVal meta) {
        return new VncBigInteger(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncBigInteger wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncBigInteger(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncBigInteger negate() {
        return new VncBigInteger(this.value.negate());
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BIGDECIMAL;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBigInteger(o)) {
            return this.value.compareTo(((VncBigInteger)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToBigint((VncBigDecimal)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(Numeric.intToBigint((VncInteger)o).getValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToBigint((VncDouble)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(Numeric.longToBigint((VncLong)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncBigInteger)obj).value);
    }

    public String toString() {
        return this.value.toString() + "N";
    }
}

