/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.env.Var;
import com.github.jlangch.venice.impl.functions.JsonFunctions;
import com.github.jlangch.venice.impl.functions.SystemFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.repl.CustomREPL;
import com.github.jlangch.venice.impl.repl.REPL;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.util.CommandLineArgs;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.impl.util.io.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import com.github.jlangch.venice.javainterop.ILoadPaths;
import com.github.jlangch.venice.javainterop.LoadPathsFactory;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class Launcher {
    public static void main(String[] args) {
        CommandLineArgs cli = new CommandLineArgs(args);
        ILoadPaths loadPaths = LoadPathsFactory.parseDelimitedLoadPath(cli.switchValue("-loadpath"), true);
        boolean macroexpand = cli.switchPresent("-macroexpand");
        try {
            if (cli.switchPresent("-help")) {
                Launcher.printHelp();
            } else if (cli.switchPresent("-file")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-file"));
                String script = new String(FileUtil.load(new File(file)));
                System.out.println(Launcher.runScript(cli, macroexpand, interceptor, script, new File(file).getName()));
            } else if (cli.switchPresent("-cp-file")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                String file = Launcher.suffixWithVeniceFileExt(cli.switchValue("-cp-file"));
                String script = new ClassPathResource(file).getResourceAsString();
                System.out.println(Launcher.runScript(cli, macroexpand, interceptor, script, new File(file).getName()));
            } else if (cli.switchPresent("-script")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                String script = cli.switchValue("-script");
                System.out.println(Launcher.runScript(cli, macroexpand, interceptor, script, "script"));
            } else if (cli.switchPresent("-app")) {
                File appFile = new File(Launcher.suffixWithZipFileExt(cli.switchValue("-app")));
                List<File> mergedLoadPaths = Arrays.asList(appFile.getAbsoluteFile());
                mergedLoadPaths.addAll(loadPaths.getPaths());
                ILoadPaths appLoadPaths = LoadPathsFactory.of(mergedLoadPaths, loadPaths.isUnlimitedAccess());
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(appLoadPaths);
                JavaInterop.register(interceptor);
                VncMap manifest = Launcher.getManifest(appFile);
                String appName = Coerce.toVncString(manifest.get(new VncString("app-name"))).getValue();
                String mainFile = Coerce.toVncString(manifest.get(new VncString("main-file"))).getValue();
                System.out.println(String.format("Launching Venice application '%s' ...", appName));
                String appBootstrap = String.format("(do (load-file \"%s\") nil)", Launcher.stripVeniceFileExt(mainFile));
                Launcher.runApp(cli, macroexpand, interceptor, appBootstrap, appName, appFile);
            } else if (cli.switchPresent("-app-repl")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                String file = cli.switchValue("-app-repl");
                new CustomREPL(interceptor, new File(file)).run(args);
            } else if (cli.switchPresent("-repl")) {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                new REPL(interceptor).run(args);
            } else {
                AcceptAllInterceptor interceptor = new AcceptAllInterceptor(loadPaths);
                JavaInterop.register(interceptor);
                new REPL(interceptor).run(args);
            }
            System.exit(SystemFunctions.SYSTEM_EXIT_CODE.get());
        }
        catch (VncException ex) {
            ex.printVeniceStackTrace();
            System.exit(99);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(99);
        }
    }

    private static void printHelp() {
        System.out.println("The Launcher runs Venice scripts or apps and starts the REPL. \n\nThe launcher is configured as the Venice JAR's main-class. \n\nRunning scripts: \n    java -jar venice-1.9.5.jar -script \"(+ 1 1)\" \n\nRunning a REPL:  \n    java \\ \n       -server \\ \n       -Xmx6G \\ \n       -XX:-OmitStackTraceInFastThrow \\ \n       -cp \"libs/*\" \\ \n       com.github.jlangch.venice.Launcher \\ \n       -repl \\ \n       -colors \n\n\nLauncher command line options: \n  -loadpath path    defines a load path \n                    E.g.: -loadpath \"/users/foo/scripts;/users/foo/res\" \n\n  -macroexpand      turns up-front macro expansion on, resulting in a \n                    much better performance \n\n  -file script      loads the script to run from a file \n                    E.g.:  -file ./test.venice \n\n  -cp-file res      loads the script to run from the classpath \n                    E.g.:  -cp-file com/github/jlangch/venice/test.venice \n\n  -script script    run a script \n                    E.g.:  -script \"(+ 1 10)\" \n\n  -app app          run a Venice app  \n                    E.g.:  -app test-app.zip \n\n  -repl             start a REPL \n\n  -help             prints a help \n\nNote: \n  The options '-file', '-cp-file', '-script', '-app', and '-repl' exclude \n  each other \n");
    }

    private static String runApp(CommandLineArgs cli, boolean macroexpand, IInterceptor interceptor, String script, String name, File appArchive) {
        VeniceInterpreter venice = new VeniceInterpreter(interceptor);
        Env env = Launcher.createEnv(venice, macroexpand, RunMode.APP, Arrays.asList(Launcher.convertCliArgsToVar(cli), Launcher.convertAppNameToVar(name), Launcher.convertAppArchiveToVar(appArchive)));
        return venice.PRINT(venice.RE(script, name, env));
    }

    private static String runScript(CommandLineArgs cli, boolean macroexpand, IInterceptor interceptor, String script, String name) {
        VeniceInterpreter venice = new VeniceInterpreter(interceptor);
        Env env = Launcher.createEnv(venice, macroexpand, RunMode.SCRIPT, Arrays.asList(Launcher.convertCliArgsToVar(cli)));
        return venice.PRINT(venice.RE(script, name, env));
    }

    private static Env createEnv(VeniceInterpreter venice, boolean macroexpand, RunMode runMode, List<Var> vars) {
        return venice.createEnv(macroexpand, false, runMode).addGlobalVars(vars).setStdoutPrintStream(new PrintStream(System.out, true)).setStderrPrintStream(new PrintStream(System.err, true)).setStdinReader(new InputStreamReader(System.in));
    }

    private static Var convertAppNameToVar(String appName) {
        return new Var(new VncSymbol("*app-name*"), new VncString(appName), false);
    }

    private static Var convertAppArchiveToVar(File appArchive) {
        return new Var(new VncSymbol("*app-archive*"), new VncJavaObject(appArchive), false);
    }

    private static Var convertCliArgsToVar(CommandLineArgs cli) {
        return new Var(new VncSymbol("*ARGV*"), cli.argsAsList(), false);
    }

    private static String stripVeniceFileExt(String s) {
        return StringUtil.removeEnd(s, ".venice");
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s == null ? null : (s.endsWith(".venice") ? s : s + ".venice");
    }

    private static String suffixWithZipFileExt(String s) {
        return s == null ? null : (s.endsWith(".zip") ? s : s + ".zip");
    }

    private static VncMap getManifest(File app) {
        if (app.exists()) {
            try {
                VncString manifest = ZipFileSystemUtil.loadTextFileFromZip(app, new File("MANIFEST.MF"), "utf-8");
                return Coerce.toVncMap(JsonFunctions.read_str.apply(VncList.of(manifest)));
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to load manifest from Venice application archive '%s'.", app.getPath()));
            }
        }
        throw new VncException(String.format("The Venice application archive '%s' does not exist", app.getPath()));
    }
}

