/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.HashMap;

public class MetaUtil {
    public static final VncKeyword ARGLIST = new VncKeyword(":arglists");
    public static final VncKeyword DOC = new VncKeyword(":doc");
    public static final VncKeyword EXAMPLES = new VncKeyword(":examples");
    public static final VncKeyword SEE_ALSO = new VncKeyword(":see-also");
    public static final VncKeyword FUNCTION_REFS = new VncKeyword(":function-refs");
    public static final VncKeyword FILE = new VncKeyword(":file");
    public static final VncKeyword LINE = new VncKeyword(":line");
    public static final VncKeyword COLUMN = new VncKeyword(":column");
    public static final VncKeyword MACRO = new VncKeyword(":macro");
    public static final VncKeyword NS = new VncKeyword(":ns");
    public static final VncKeyword PRIVATE = new VncKeyword(":private");

    public static VncVal addDefMeta(VncVal val, VncMap meta) {
        VncVal valMeta = val.getMeta();
        if (valMeta == Constants.Nil) {
            valMeta = meta;
        } else if (Types.isVncMap(valMeta)) {
            valMeta = ((VncMap)valMeta).assoc(meta.toVncList());
        }
        return val.withMeta(valMeta);
    }

    public static VncVal toMeta(Token token) {
        return VncHashMap.of(FILE, new VncString(token.getFile()), LINE, new VncLong(token.getLine()), COLUMN, new VncLong(token.getColumn()));
    }

    public static VncVal addMetaVal(VncVal meta, VncVal ... mvs) {
        if (meta == Constants.Nil) {
            return VncHashMap.of(mvs);
        }
        if (Types.isVncMap(meta)) {
            return ((VncMap)meta).assoc(mvs);
        }
        return meta;
    }

    public static VncVal mergeMeta(VncVal meta1, VncVal meta2) {
        if (meta1 == Constants.Nil) {
            return meta2;
        }
        if (meta2 == Constants.Nil) {
            return meta1;
        }
        if (Types.isVncMap(meta1) && Types.isVncMap(meta2)) {
            HashMap<VncVal, VncVal> m = new HashMap<VncVal, VncVal>(((VncMap)meta1).getJavaMap());
            m.putAll(((VncMap)meta2).getJavaMap());
            return new VncHashMap(m);
        }
        throw new VncException(String.format("Failed to merge meta data on incompatible old (%s) and new (%s) meta data types", Types.getType(meta1), Types.getType(meta2)));
    }

    public static boolean isPrivate(VncVal meta) {
        if (meta == Constants.Nil) {
            return false;
        }
        if (meta instanceof VncHashMap) {
            return VncBoolean.isTrue(((VncHashMap)meta).get(PRIVATE));
        }
        return false;
    }

    public static String getNamespace(VncVal meta) {
        if (meta == Constants.Nil) {
            return null;
        }
        if (meta instanceof VncHashMap) {
            VncVal ns = ((VncHashMap)meta).get(NS);
            return ns == Constants.Nil ? null : ((VncString)ns).getValue();
        }
        return null;
    }

    public static VncVal setNamespace(VncVal meta, String ns) {
        return MetaUtil.addMetaVal(meta, NS, new VncString(ns));
    }
}

