/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

import com.github.jlangch.venice.Parameters;
import com.github.jlangch.venice.Venice;
import com.github.jlangch.venice.impl.RunMode;
import com.github.jlangch.venice.impl.VeniceInterpreter;
import com.github.jlangch.venice.impl.docgen.CheatsheetRenderer;
import com.github.jlangch.venice.impl.docgen.CodeSnippetReader;
import com.github.jlangch.venice.impl.docgen.CrossRef;
import com.github.jlangch.venice.impl.docgen.DocColorTheme;
import com.github.jlangch.venice.impl.docgen.DocHighlighter;
import com.github.jlangch.venice.impl.docgen.DocItem;
import com.github.jlangch.venice.impl.docgen.DocSection;
import com.github.jlangch.venice.impl.docgen.ExampleOutput;
import com.github.jlangch.venice.impl.env.Env;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.util.CapturingPrintStream;
import com.lowagie.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DocGenerator {
    private static final List<ExampleOutput> EMPTY_EXAMPLES = Collections.unmodifiableList(new ArrayList());
    private final Map<String, String> idMap = new HashMap<String, String>();
    private final AtomicLong gen = new AtomicLong(1000L);
    private final List<String> preloadedModules = new ArrayList<String>();
    private final Map<String, DocItem> docItems = new HashMap<String, DocItem>();
    private final Env env;
    private final boolean runExamples;
    private final DocHighlighter codeHighlighter;

    public DocGenerator(boolean runExamples) {
        this.runExamples = runExamples;
        this.preloadedModules.addAll(Arrays.asList("app", "xml", "crypt", "gradle", "trace", "ansi", "maven", "kira"));
        this.env = new VeniceInterpreter(new AcceptAllInterceptor()).createEnv(this.preloadedModules, false, false, RunMode.DOCGEN).setStdoutPrintStream(null).setStderrPrintStream(null);
        this.codeHighlighter = new DocHighlighter(DocColorTheme.getLightTheme());
    }

    public static void main(String[] args) {
        String version = args.length > 0 ? args[0] : "0.0.0";
        new DocGenerator(true).run(version);
    }

    public static List<DocSection> docInfo() {
        return new DocGenerator(false).buildDocInfo();
    }

    private List<DocSection> buildDocInfo() {
        ArrayList<DocSection> sections = new ArrayList<DocSection>();
        sections.addAll(this.getLeftSections());
        sections.addAll(this.getRightSections());
        return sections;
    }

    private void run(String version) {
        try {
            System.out.println("Creating cheatsheet V" + version);
            List<DocSection> left = this.getLeftSections();
            List<DocSection> right = this.getRightSections();
            this.validateUniqueSectionsId(left, right);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("meta-author", "Venice");
            data.put("version", version);
            data.put("sections", this.concat(left, right));
            data.put("left", left);
            data.put("right", right);
            data.put("details", this.getDocItems(this.concat(left, right)));
            data.put("snippets", new CodeSnippetReader().readSnippets());
            data.put("pdfmode", false);
            String html = CheatsheetRenderer.renderXHTML(data);
            this.save(new File(this.getUserDir(), "cheatsheet.html"), html);
            data.put("pdfmode", true);
            String xhtml = CheatsheetRenderer.renderXHTML(data);
            ByteBuffer pdf = CheatsheetRenderer.renderPDF(xhtml);
            byte[] pdfArr = pdf.array();
            this.save(new File(this.getUserDir(), "cheatsheet.pdf"), pdfArr);
            PdfReader reader = new PdfReader(pdf.array());
            int pages = reader.getNumberOfPages();
            reader.close();
            System.out.println(String.format("Generated Cheat Sheet at: %s. XHTML: %dKB, PDF: %dKB / %d pages", this.getUserDir(), xhtml.length() / 1024, pdfArr.length / 1024, pages));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private List<DocSection> getLeftSections() {
        return Arrays.asList(this.getPrimitivesSection(), this.getByteBufSection(), this.getRegexSection(), this.getTransducersSection(), this.getFunctionsSection(), this.getMacrosSection(), this.getSpecialFormsSection(), this.getTypesSection(), this.getNamespaceSection(), this.getAppSection(), this.getJavaInteropSection(), this.getModulesSection());
    }

    private List<DocSection> getRightSections() {
        return Arrays.asList(this.getCollectionsSection(), this.getLazySequencesSection(), this.getArraysSection(), this.getConcurrencySection(), this.getSystemSection(), this.getTimeSection(), this.getIOSection(), this.getMiscellaneousSection());
    }

    private List<DocItem> getDocItems(List<DocSection> sections) {
        return sections.stream().map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getSections()).flatMap(Collection::stream).map(s -> s.getItems()).flatMap(Collection::stream).filter(i -> !StringUtil.isBlank(i.getName())).distinct().sorted(Comparator.comparing(DocItem::getName)).collect(Collectors.toList());
    }

    private DocSection getPrimitivesSection() {
        DocSection section = new DocSection("Primitives", "primitives");
        DocSection lit = new DocSection("Literals", "primitives.literals");
        section.addSection(lit);
        lit.addLiteralIem("Nil", "nil");
        lit.addLiteralIem("Boolean", "true, false");
        lit.addLiteralIem("Integer", "150I, 1_000_000I, 0x1FFI");
        lit.addLiteralIem("Long", "1500, 1_000_000, 0x00A055FF");
        lit.addLiteralIem("Double", "3.569, 2.0E+10");
        lit.addLiteralIem("BigDecimal", "6.897M, 2.345E+10M");
        lit.addLiteralIem("BigInteger", "1000N, 1_000_000N");
        lit.addLiteralIem("String", "\"abcd\", \"ab\\\"cd\", \"PI: \\u03C0\"");
        lit.addLiteralIem("", "\"\"\"{ \"age\": 42 }\"\"\"");
        DocSection numbers = new DocSection("Numbers", "primitives.numbers");
        section.addSection(numbers);
        DocSection arithmetic = new DocSection("Arithmetic", this.id());
        numbers.addSection(arithmetic);
        arithmetic.addItem(this.getDocItem("+"));
        arithmetic.addItem(this.getDocItem("-"));
        arithmetic.addItem(this.getDocItem("*"));
        arithmetic.addItem(this.getDocItem("/"));
        arithmetic.addItem(this.getDocItem("mod"));
        arithmetic.addItem(this.getDocItem("inc"));
        arithmetic.addItem(this.getDocItem("dec"));
        arithmetic.addItem(this.getDocItem("min"));
        arithmetic.addItem(this.getDocItem("max"));
        arithmetic.addItem(this.getDocItem("abs"));
        arithmetic.addItem(this.getDocItem("sgn"));
        arithmetic.addItem(this.getDocItem("negate"));
        arithmetic.addItem(this.getDocItem("floor"));
        arithmetic.addItem(this.getDocItem("ceil"));
        arithmetic.addItem(this.getDocItem("sqrt"));
        arithmetic.addItem(this.getDocItem("square"));
        arithmetic.addItem(this.getDocItem("pow"));
        arithmetic.addItem(this.getDocItem("log"));
        arithmetic.addItem(this.getDocItem("log10"));
        DocSection convert = new DocSection("Convert", this.id());
        numbers.addSection(convert);
        convert.addItem(this.getDocItem("int"));
        convert.addItem(this.getDocItem("long"));
        convert.addItem(this.getDocItem("double"));
        convert.addItem(this.getDocItem("decimal"));
        convert.addItem(this.getDocItem("bigint"));
        DocSection compare = new DocSection("Compare", this.id());
        numbers.addSection(compare);
        compare.addItem(this.getDocItem("=="));
        compare.addItem(this.getDocItem("="));
        compare.addItem(this.getDocItem("<"));
        compare.addItem(this.getDocItem(">"));
        compare.addItem(this.getDocItem("<="));
        compare.addItem(this.getDocItem(">="));
        compare.addItem(this.getDocItem("compare"));
        DocSection test = new DocSection("Test", this.id());
        numbers.addSection(test);
        test.addItem(this.getDocItem("zero?"));
        test.addItem(this.getDocItem("pos?"));
        test.addItem(this.getDocItem("neg?"));
        test.addItem(this.getDocItem("even?"));
        test.addItem(this.getDocItem("odd?"));
        test.addItem(this.getDocItem("number?"));
        test.addItem(this.getDocItem("int?"));
        test.addItem(this.getDocItem("long?"));
        test.addItem(this.getDocItem("double?"));
        test.addItem(this.getDocItem("decimal?"));
        DocSection random = new DocSection("Random", this.id());
        numbers.addSection(random);
        random.addItem(this.getDocItem("rand-long"));
        random.addItem(this.getDocItem("rand-double"));
        random.addItem(this.getDocItem("rand-gaussian"));
        DocSection trigonometry = new DocSection("Trigonometry", this.id());
        numbers.addSection(trigonometry);
        trigonometry.addItem(this.getDocItem("to-radians"));
        trigonometry.addItem(this.getDocItem("to-degrees"));
        trigonometry.addItem(this.getDocItem("sin"));
        trigonometry.addItem(this.getDocItem("cos"));
        trigonometry.addItem(this.getDocItem("tan"));
        DocSection statistics = new DocSection("Statistics", this.id());
        numbers.addSection(statistics);
        statistics.addItem(this.getDocItem("mean"));
        statistics.addItem(this.getDocItem("median"));
        statistics.addItem(this.getDocItem("quartiles"));
        statistics.addItem(this.getDocItem("quantile"));
        statistics.addItem(this.getDocItem("standard-deviation"));
        DocSection bigdecimal = new DocSection("BigDecimal", this.id());
        numbers.addSection(bigdecimal);
        bigdecimal.addItem(this.getDocItem("dec/add"));
        bigdecimal.addItem(this.getDocItem("dec/sub"));
        bigdecimal.addItem(this.getDocItem("dec/mul"));
        bigdecimal.addItem(this.getDocItem("dec/div"));
        bigdecimal.addItem(this.getDocItem("dec/scale"));
        DocSection strings = new DocSection("Strings", "primitives.strings");
        section.addSection(strings);
        DocSection create = new DocSection("Create", this.id());
        strings.addSection(create);
        create.addItem(this.getDocItem("str"));
        create.addItem(this.getDocItem("str/format"));
        create.addItem(this.getDocItem("str/quote"));
        create.addItem(this.getDocItem("str/double-quote"));
        create.addItem(this.getDocItem("str/double-unquote"));
        DocSection use = new DocSection("Use", this.id());
        strings.addSection(use);
        use.addItem(this.getDocItem("count"));
        use.addItem(this.getDocItem("compare"));
        use.addItem(this.getDocItem("empty-to-nil"));
        use.addItem(this.getDocItem("first"));
        use.addItem(this.getDocItem("last"));
        use.addItem(this.getDocItem("nth"));
        use.addItem(this.getDocItem("nfirst"));
        use.addItem(this.getDocItem("nlast"));
        use.addItem(this.getDocItem("seq"));
        use.addItem(this.getDocItem("rest"));
        use.addItem(this.getDocItem("butlast"));
        use.addItem(this.getDocItem("reverse"));
        use.addItem(this.getDocItem("shuffle"));
        use.addItem(this.getDocItem("str/index-of"));
        use.addItem(this.getDocItem("str/last-index-of"));
        use.addItem(this.getDocItem("str/subs"));
        use.addItem(this.getDocItem("str/rest"));
        use.addItem(this.getDocItem("str/butlast"));
        use.addItem(this.getDocItem("str/chars"));
        use.addItem(this.getDocItem("str/pos"));
        use.addItem(this.getDocItem("str/repeat"));
        use.addItem(this.getDocItem("str/reverse"));
        use.addItem(this.getDocItem("str/truncate"));
        use.addItem(this.getDocItem("str/expand"));
        use.addItem(this.getDocItem("str/lorem-ipsum"));
        DocSection split = new DocSection("Split/Join", this.id());
        strings.addSection(split);
        split.addItem(this.getDocItem("str/split"));
        split.addItem(this.getDocItem("str/split-lines"));
        split.addItem(this.getDocItem("str/join"));
        DocSection replace = new DocSection("Replace", this.id());
        strings.addSection(replace);
        replace.addItem(this.getDocItem("str/replace-first"));
        replace.addItem(this.getDocItem("str/replace-last"));
        replace.addItem(this.getDocItem("str/replace-all"));
        DocSection strip = new DocSection("Strip", this.id());
        strings.addSection(strip);
        strip.addItem(this.getDocItem("str/strip-start"));
        strip.addItem(this.getDocItem("str/strip-end"));
        strip.addItem(this.getDocItem("str/strip-indent"));
        strip.addItem(this.getDocItem("str/strip-margin"));
        DocSection conv = new DocSection("Conversion", this.id());
        strings.addSection(conv);
        conv.addItem(this.getDocItem("str/lower-case"));
        conv.addItem(this.getDocItem("str/upper-case"));
        conv.addItem(this.getDocItem("str/cr-lf", false));
        DocSection regex = new DocSection("Regex", this.id());
        strings.addSection(regex);
        regex.addItem(this.getDocItem("match?"));
        regex.addItem(this.getDocItem("not-match?"));
        DocSection trim = new DocSection("Trim", this.id());
        strings.addSection(trim);
        trim.addItem(this.getDocItem("str/trim"));
        trim.addItem(this.getDocItem("str/trim-to-nil"));
        DocSection hex = new DocSection("Hex", this.id());
        strings.addSection(hex);
        hex.addItem(this.getDocItem("str/hex-to-bytebuf"));
        hex.addItem(this.getDocItem("str/bytebuf-to-hex"));
        hex.addItem(this.getDocItem("str/format-bytebuf"));
        DocSection encode = new DocSection("Encode/Decode", this.id());
        strings.addSection(encode);
        encode.addItem(this.getDocItem("str/encode-base64"));
        encode.addItem(this.getDocItem("str/decode-base64"));
        encode.addItem(this.getDocItem("str/encode-url"));
        encode.addItem(this.getDocItem("str/decode-url"));
        encode.addItem(this.getDocItem("str/escape-html"));
        encode.addItem(this.getDocItem("str/escape-xml"));
        DocSection validation = new DocSection("Validation", this.id());
        strings.addSection(validation);
        validation.addItem(this.getDocItem("str/valid-email-addr?"));
        DocSection str_test = new DocSection("Test", this.id());
        strings.addSection(str_test);
        str_test.addItem(this.getDocItem("string?"));
        str_test.addItem(this.getDocItem("empty?"));
        str_test.addItem(this.getDocItem("not-empty?"));
        str_test.addItem(this.getDocItem("str/blank?"));
        str_test.addItem(this.getDocItem("str/starts-with?"));
        str_test.addItem(this.getDocItem("str/ends-with?"));
        str_test.addItem(this.getDocItem("str/contains?"));
        str_test.addItem(this.getDocItem("str/equals-ignore-case?"));
        str_test.addItem(this.getDocItem("str/quoted?"));
        str_test.addItem(this.getDocItem("str/double-quoted?"));
        DocSection str_test_char = new DocSection("Test char", this.id());
        strings.addSection(str_test_char);
        str_test_char.addItem(this.getDocItem("str/char?"));
        str_test_char.addItem(this.getDocItem("str/digit?"));
        str_test_char.addItem(this.getDocItem("str/letter?"));
        str_test_char.addItem(this.getDocItem("str/whitespace?"));
        str_test_char.addItem(this.getDocItem("str/linefeed?"));
        str_test_char.addItem(this.getDocItem("str/lower-case?"));
        str_test_char.addItem(this.getDocItem("str/upper-case?"));
        DocSection chars = new DocSection("Chars", "primitives.chars");
        section.addSection(chars);
        DocSection charuse = new DocSection("Use", this.id());
        chars.addSection(charuse);
        charuse.addItem(this.getDocItem("char"));
        charuse.addItem(this.getDocItem("char?"));
        DocSection other = new DocSection("Other", "primitives.other");
        section.addSection(other);
        DocSection nil = new DocSection("Nil", this.id());
        other.addSection(nil);
        nil.addItem(this.getDocItem("nil?"));
        nil.addItem(this.getDocItem("some?"));
        DocSection keywords = new DocSection("Keywords", this.id());
        other.addSection(keywords);
        keywords.addItem(new DocItem(":a :blue", null));
        keywords.addItem(this.getDocItem("keyword?"));
        keywords.addItem(this.getDocItem("keyword"));
        DocSection symbols = new DocSection("Symbols", this.id());
        other.addSection(symbols);
        symbols.addItem(new DocItem("'a 'blue", null));
        symbols.addItem(this.getDocItem("symbol?"));
        symbols.addItem(this.getDocItem("symbol"));
        DocSection just = new DocSection("Just", this.id());
        other.addSection(just);
        just.addItem(this.getDocItem("just"));
        just.addItem(this.getDocItem("just?"));
        DocSection boolean_ = new DocSection("Boolean", this.id());
        other.addSection(boolean_);
        boolean_.addItem(this.getDocItem("boolean"));
        boolean_.addItem(this.getDocItem("not"));
        boolean_.addItem(this.getDocItem("boolean?"));
        boolean_.addItem(this.getDocItem("true?"));
        boolean_.addItem(this.getDocItem("false?"));
        return section;
    }

    private DocSection getCollectionsSection() {
        DocSection section = new DocSection("Collections", "collections");
        DocSection collections = new DocSection("Collections", this.id());
        section.addSection(collections);
        DocSection generic = new DocSection("Generic", "collections.generic");
        collections.addSection(generic);
        generic.addItem(this.getDocItem("count"));
        generic.addItem(this.getDocItem("compare"));
        generic.addItem(this.getDocItem("empty-to-nil"));
        generic.addItem(this.getDocItem("empty"));
        generic.addItem(this.getDocItem("into"));
        generic.addItem(this.getDocItem("cons"));
        generic.addItem(this.getDocItem("conj"));
        generic.addItem(this.getDocItem("remove"));
        generic.addItem(this.getDocItem("repeat"));
        generic.addItem(this.getDocItem("repeatedly"));
        generic.addItem(this.getDocItem("cycle"));
        generic.addItem(this.getDocItem("replace"));
        generic.addItem(this.getDocItem("range"));
        generic.addItem(this.getDocItem("group-by"));
        generic.addItem(this.getDocItem("frequencies"));
        generic.addItem(this.getDocItem("get-in"));
        generic.addItem(this.getDocItem("seq"));
        generic.addItem(this.getDocItem("reverse"));
        generic.addItem(this.getDocItem("shuffle"));
        DocSection coll_test = new DocSection("Tests", "collections.tests");
        collections.addSection(coll_test);
        coll_test.addItem(this.getDocItem("empty?"));
        coll_test.addItem(this.getDocItem("not-empty?"));
        coll_test.addItem(this.getDocItem("coll?"));
        coll_test.addItem(this.getDocItem("list?"));
        coll_test.addItem(this.getDocItem("vector?"));
        coll_test.addItem(this.getDocItem("set?"));
        coll_test.addItem(this.getDocItem("sorted-set?"));
        coll_test.addItem(this.getDocItem("mutable-set?"));
        coll_test.addItem(this.getDocItem("map?"));
        coll_test.addItem(this.getDocItem("sequential?"));
        coll_test.addItem(this.getDocItem("hash-map?"));
        coll_test.addItem(this.getDocItem("ordered-map?"));
        coll_test.addItem(this.getDocItem("sorted-map?"));
        coll_test.addItem(this.getDocItem("mutable-map?"));
        coll_test.addItem(this.getDocItem("bytebuf?"));
        DocSection coll_process = new DocSection("Process", "collections.process");
        collections.addSection(coll_process);
        coll_process.addItem(this.getDocItem("map"));
        coll_process.addItem(this.getDocItem("map-indexed"));
        coll_process.addItem(this.getDocItem("filter"));
        coll_process.addItem(this.getDocItem("reduce"));
        coll_process.addItem(this.getDocItem("keep"));
        coll_process.addItem(this.getDocItem("docoll"));
        DocSection lists = new DocSection("Lists", "collections.lists");
        section.addSection(lists);
        DocSection list_create = new DocSection("Create", this.id());
        lists.addSection(list_create);
        list_create.addItem(this.getDocItem("()"));
        list_create.addItem(this.getDocItem("list"));
        list_create.addItem(this.getDocItem("list*"));
        list_create.addItem(this.getDocItem("mutable-list"));
        DocSection list_access = new DocSection("Access", this.id());
        lists.addSection(list_access);
        list_access.addItem(this.getDocItem("first"));
        list_access.addItem(this.getDocItem("second"));
        list_access.addItem(this.getDocItem("third"));
        list_access.addItem(this.getDocItem("fourth"));
        list_access.addItem(this.getDocItem("nth"));
        list_access.addItem(this.getDocItem("last"));
        list_access.addItem(this.getDocItem("peek"));
        list_access.addItem(this.getDocItem("rest"));
        list_access.addItem(this.getDocItem("butlast"));
        list_access.addItem(this.getDocItem("nfirst"));
        list_access.addItem(this.getDocItem("nlast"));
        list_access.addItem(this.getDocItem("some"));
        DocSection list_modify = new DocSection("Modify", this.id());
        lists.addSection(list_modify);
        list_modify.addItem(this.getDocItem("cons"));
        list_modify.addItem(this.getDocItem("conj"));
        list_modify.addItem(this.getDocItem("rest"));
        list_modify.addItem(this.getDocItem("pop"));
        list_modify.addItem(this.getDocItem("into"));
        list_modify.addItem(this.getDocItem("concat"));
        list_modify.addItem(this.getDocItem("distinct"));
        list_modify.addItem(this.getDocItem("dedupe"));
        list_modify.addItem(this.getDocItem("partition"));
        list_modify.addItem(this.getDocItem("partition-by"));
        list_modify.addItem(this.getDocItem("interpose"));
        list_modify.addItem(this.getDocItem("interleave"));
        list_modify.addItem(this.getDocItem("mapcat"));
        list_modify.addItem(this.getDocItem("flatten"));
        list_modify.addItem(this.getDocItem("sort"));
        list_modify.addItem(this.getDocItem("sort-by"));
        list_modify.addItem(this.getDocItem("take"));
        list_modify.addItem(this.getDocItem("take-while"));
        list_modify.addItem(this.getDocItem("drop"));
        list_modify.addItem(this.getDocItem("drop-while"));
        list_modify.addItem(this.getDocItem("split-at"));
        list_modify.addItem(this.getDocItem("split-with"));
        DocSection list_test = new DocSection("Test", this.id());
        lists.addSection(list_test);
        list_test.addItem(this.getDocItem("list?"));
        list_test.addItem(this.getDocItem("mutable-list?"));
        list_test.addItem(this.getDocItem("every?"));
        list_test.addItem(this.getDocItem("not-every?"));
        list_test.addItem(this.getDocItem("any?"));
        list_test.addItem(this.getDocItem("not-any?"));
        DocSection vectors = new DocSection("Vectors", "collections.vectors");
        section.addSection(vectors);
        DocSection vec_create = new DocSection("Create", this.id());
        vectors.addSection(vec_create);
        vec_create.addItem(this.getDocItem("[]"));
        vec_create.addItem(this.getDocItem("vector"));
        vec_create.addItem(this.getDocItem("mapv"));
        DocSection vec_access = new DocSection("Access", this.id());
        vectors.addSection(vec_access);
        vec_access.addItem(this.getDocItem("first"));
        vec_access.addItem(this.getDocItem("second"));
        vec_access.addItem(this.getDocItem("third"));
        vec_access.addItem(this.getDocItem("nth"));
        vec_access.addItem(this.getDocItem("last"));
        vec_access.addItem(this.getDocItem("peek"));
        vec_access.addItem(this.getDocItem("butlast"));
        vec_access.addItem(this.getDocItem("rest"));
        vec_access.addItem(this.getDocItem("nfirst"));
        vec_access.addItem(this.getDocItem("nlast"));
        vec_access.addItem(this.getDocItem("subvec"));
        vec_access.addItem(this.getDocItem("some"));
        DocSection vec_modify = new DocSection("Modify", this.id());
        vectors.addSection(vec_modify);
        vec_modify.addItem(this.getDocItem("cons"));
        vec_modify.addItem(this.getDocItem("conj"));
        vec_modify.addItem(this.getDocItem("rest"));
        vec_modify.addItem(this.getDocItem("pop"));
        vec_modify.addItem(this.getDocItem("into"));
        vec_modify.addItem(this.getDocItem("concat"));
        vec_modify.addItem(this.getDocItem("distinct"));
        vec_modify.addItem(this.getDocItem("dedupe"));
        vec_modify.addItem(this.getDocItem("partition"));
        vec_modify.addItem(this.getDocItem("partition-by"));
        vec_modify.addItem(this.getDocItem("interpose"));
        vec_modify.addItem(this.getDocItem("interleave"));
        vec_modify.addItem(this.getDocItem("mapcat"));
        vec_modify.addItem(this.getDocItem("flatten"));
        vec_modify.addItem(this.getDocItem("sort"));
        vec_modify.addItem(this.getDocItem("sort-by"));
        vec_modify.addItem(this.getDocItem("take"));
        vec_modify.addItem(this.getDocItem("take-while"));
        vec_modify.addItem(this.getDocItem("drop"));
        vec_modify.addItem(this.getDocItem("drop-while"));
        vec_modify.addItem(this.getDocItem("update"));
        vec_modify.addItem(this.getDocItem("update!"));
        vec_modify.addItem(this.getDocItem("split-with"));
        DocSection vec_nested = new DocSection("Nested", this.id());
        vectors.addSection(vec_nested);
        vec_nested.addItem(this.getDocItem("get-in"));
        vec_nested.addItem(this.getDocItem("assoc-in"));
        vec_nested.addItem(this.getDocItem("update-in"));
        vec_nested.addItem(this.getDocItem("dissoc-in"));
        DocSection vec_test = new DocSection("Test", this.id());
        vectors.addSection(vec_test);
        vec_test.addItem(this.getDocItem("vector?"));
        vec_test.addItem(this.getDocItem("contains?"));
        vec_test.addItem(this.getDocItem("not-contains?"));
        vec_test.addItem(this.getDocItem("every?"));
        vec_test.addItem(this.getDocItem("not-every?"));
        vec_test.addItem(this.getDocItem("any?"));
        vec_test.addItem(this.getDocItem("not-any?"));
        DocSection sets = new DocSection("Sets", "collections.sets");
        section.addSection(sets);
        DocSection set_create = new DocSection("Create", this.id());
        sets.addSection(set_create);
        set_create.addItem(this.getDocItem("#{}"));
        set_create.addItem(this.getDocItem("set"));
        set_create.addItem(this.getDocItem("sorted-set"));
        set_create.addItem(this.getDocItem("mutable-set"));
        DocSection set_modify = new DocSection("Modify", this.id());
        sets.addSection(set_modify);
        set_modify.addItem(this.getDocItem("cons"));
        set_modify.addItem(this.getDocItem("cons!"));
        set_modify.addItem(this.getDocItem("conj"));
        set_modify.addItem(this.getDocItem("conj!"));
        set_modify.addItem(this.getDocItem("disj"));
        set_modify.addItem(this.getDocItem("difference"));
        set_modify.addItem(this.getDocItem("union"));
        set_modify.addItem(this.getDocItem("intersection"));
        DocSection set_test = new DocSection("Test", this.id());
        sets.addSection(set_test);
        set_test.addItem(this.getDocItem("set?"));
        set_test.addItem(this.getDocItem("sorted-set?"));
        set_test.addItem(this.getDocItem("mutable-set?"));
        set_test.addItem(this.getDocItem("contains?"));
        set_test.addItem(this.getDocItem("not-contains?"));
        set_test.addItem(this.getDocItem("every?"));
        set_test.addItem(this.getDocItem("not-every?"));
        set_test.addItem(this.getDocItem("any?"));
        set_test.addItem(this.getDocItem("not-any?"));
        DocSection maps = new DocSection("Maps", "collections.maps");
        section.addSection(maps);
        DocSection maps_create = new DocSection("Create", this.id());
        maps.addSection(maps_create);
        maps_create.addItem(this.getDocItem("{}"));
        maps_create.addItem(this.getDocItem("hash-map"));
        maps_create.addItem(this.getDocItem("ordered-map"));
        maps_create.addItem(this.getDocItem("sorted-map"));
        maps_create.addItem(this.getDocItem("mutable-map"));
        maps_create.addItem(this.getDocItem("zipmap"));
        DocSection map_access = new DocSection("Access", this.id());
        maps.addSection(map_access);
        map_access.addItem(this.getDocItem("find"));
        map_access.addItem(this.getDocItem("get"));
        map_access.addItem(this.getDocItem("keys"));
        map_access.addItem(this.getDocItem("vals"));
        map_access.addItem(this.getDocItem("key"));
        map_access.addItem(this.getDocItem("val"));
        map_access.addItem(this.getDocItem("entries"));
        DocSection map_modify = new DocSection("Modify", this.id());
        maps.addSection(map_modify);
        map_modify.addItem(this.getDocItem("cons"));
        map_modify.addItem(this.getDocItem("conj"));
        map_modify.addItem(this.getDocItem("assoc"));
        map_modify.addItem(this.getDocItem("assoc!"));
        map_modify.addItem(this.getDocItem("update"));
        map_modify.addItem(this.getDocItem("update!"));
        map_modify.addItem(this.getDocItem("dissoc"));
        map_modify.addItem(this.getDocItem("dissoc!"));
        map_modify.addItem(this.getDocItem("into"));
        map_modify.addItem(this.getDocItem("concat"));
        map_modify.addItem(this.getDocItem("flatten"));
        map_modify.addItem(this.getDocItem("filter-k"));
        map_modify.addItem(this.getDocItem("filter-kv"));
        map_modify.addItem(this.getDocItem("reduce-kv"));
        map_modify.addItem(this.getDocItem("merge"));
        map_modify.addItem(this.getDocItem("merge-with"));
        map_modify.addItem(this.getDocItem("map-invert"));
        map_modify.addItem(this.getDocItem("map-keys"));
        map_modify.addItem(this.getDocItem("map-vals"));
        DocSection map_nested = new DocSection("Nested", this.id());
        maps.addSection(map_nested);
        map_nested.addItem(this.getDocItem("get-in"));
        map_nested.addItem(this.getDocItem("assoc-in"));
        map_nested.addItem(this.getDocItem("update-in"));
        map_nested.addItem(this.getDocItem("dissoc-in"));
        DocSection map_test = new DocSection("Test", this.id());
        maps.addSection(map_test);
        map_test.addItem(this.getDocItem("map?"));
        map_test.addItem(this.getDocItem("sequential?"));
        map_test.addItem(this.getDocItem("hash-map?"));
        map_test.addItem(this.getDocItem("ordered-map?"));
        map_test.addItem(this.getDocItem("sorted-map?"));
        map_test.addItem(this.getDocItem("mutable-map?"));
        map_test.addItem(this.getDocItem("map-entry?"));
        map_test.addItem(this.getDocItem("contains?"));
        map_test.addItem(this.getDocItem("not-contains?"));
        DocSection stacks = new DocSection("Stack", "collections.stack");
        section.addSection(stacks);
        DocSection stacks_create = new DocSection("Create", this.id());
        stacks.addSection(stacks_create);
        stacks_create.addItem(this.getDocItem("stack"));
        DocSection stacks_access = new DocSection("Access", this.id());
        stacks.addSection(stacks_access);
        stacks_access.addItem(this.getDocItem("peek"));
        stacks_access.addItem(this.getDocItem("pop!"));
        stacks_access.addItem(this.getDocItem("push!"));
        stacks_access.addItem(this.getDocItem("count"));
        DocSection stacks_test = new DocSection("Test", this.id());
        stacks.addSection(stacks_test);
        stacks_test.addItem(this.getDocItem("empty?"));
        stacks_test.addItem(this.getDocItem("stack?"));
        DocSection queues = new DocSection("Queue", "collections.queue");
        section.addSection(queues);
        DocSection queues_create = new DocSection("Create", this.id());
        queues.addSection(queues_create);
        queues_create.addItem(this.getDocItem("queue"));
        DocSection queues_access = new DocSection("Access", this.id());
        queues.addSection(queues_access);
        queues_access.addItem(this.getDocItem("peek"));
        queues_access.addItem(this.getDocItem("poll!"));
        queues_access.addItem(this.getDocItem("offer!"));
        queues_access.addItem(this.getDocItem("count"));
        DocSection queues_test = new DocSection("Test", this.id());
        queues.addSection(queues_test);
        queues_test.addItem(this.getDocItem("empty?"));
        queues_test.addItem(this.getDocItem("queue?"));
        return section;
    }

    private DocSection getLazySequencesSection() {
        DocSection section = new DocSection("Lazy Sequences", "lazyseq");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", this.id());
        all.addSection(create);
        create.addItem(this.getDocItem("lazy-seq"));
        DocSection realize = new DocSection("Realize", this.id());
        all.addSection(realize);
        realize.addItem(this.getDocItem("doall"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("lazy-seq?"));
        return section;
    }

    private DocSection getArraysSection() {
        DocSection section = new DocSection("Arrays", "arrays");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", this.id());
        all.addSection(create);
        create.addItem(this.getDocItem("make-array"));
        create.addItem(this.getDocItem("object-array"));
        create.addItem(this.getDocItem("string-array"));
        create.addItem(this.getDocItem("int-array"));
        create.addItem(this.getDocItem("long-array"));
        create.addItem(this.getDocItem("float-array"));
        create.addItem(this.getDocItem("double-array"));
        DocSection use = new DocSection("Use", this.id());
        all.addSection(use);
        use.addItem(this.getDocItem("aget"));
        use.addItem(this.getDocItem("aset"));
        use.addItem(this.getDocItem("alength"));
        use.addItem(this.getDocItem("asub"));
        use.addItem(this.getDocItem("acopy"));
        use.addItem(this.getDocItem("amap"));
        return section;
    }

    private DocSection getRegexSection() {
        DocSection section = new DocSection("Regex", "regex");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection general = new DocSection("General", this.id());
        all.addSection(general);
        general.addItem(this.getDocItem("regex/pattern"));
        general.addItem(this.getDocItem("regex/matcher"));
        general.addItem(this.getDocItem("regex/find"));
        general.addItem(this.getDocItem("regex/find-all"));
        general.addItem(this.getDocItem("regex/find-group"));
        general.addItem(this.getDocItem("regex/find-all-groups"));
        general.addItem(this.getDocItem("regex/reset"));
        general.addItem(this.getDocItem("regex/find?"));
        general.addItem(this.getDocItem("regex/matches"));
        general.addItem(this.getDocItem("regex/matches?"));
        general.addItem(this.getDocItem("regex/group"));
        general.addItem(this.getDocItem("regex/groupcount"));
        return section;
    }

    private DocSection getFunctionsSection() {
        DocSection section = new DocSection("Functions", "functions");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", this.id());
        all.addSection(create);
        create.addItem(this.getDocItem("fn"));
        create.addItem(this.getDocItem("defn"));
        create.addItem(this.getDocItem("defn-"));
        create.addItem(this.getDocItem("identity"));
        create.addItem(this.getDocItem("comp"));
        create.addItem(this.getDocItem("partial"));
        create.addItem(this.getDocItem("memoize"));
        create.addItem(this.getDocItem("juxt"));
        create.addItem(this.getDocItem("fnil"));
        create.addItem(this.getDocItem("trampoline"));
        create.addItem(this.getDocItem("complement"));
        create.addItem(this.getDocItem("constantly"));
        create.addItem(this.getDocItem("every-pred"));
        create.addItem(this.getDocItem("any-pred"));
        DocSection call = new DocSection("Call", this.id());
        all.addSection(call);
        call.addItem(this.getDocItem("apply"));
        call.addItem(this.getDocItem("->"));
        call.addItem(this.getDocItem("->>"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("fn?"));
        DocSection ex = new DocSection("Exception", this.id());
        all.addSection(ex);
        ex.addItem(this.getDocItem("throw"));
        DocSection misc = new DocSection("Misc", this.id());
        all.addSection(misc);
        misc.addItem(this.getDocItem("nil?"));
        misc.addItem(this.getDocItem("some?"));
        misc.addItem(this.getDocItem("eval"));
        misc.addItem(this.getDocItem("name"));
        misc.addItem(this.getDocItem("callstack"));
        misc.addItem(this.getDocItem("coalesce"));
        misc.addItem(this.getDocItem("load-resource"));
        DocSection env = new DocSection("Environment", this.id());
        all.addSection(env);
        env.addItem(this.getDocItem("set!"));
        env.addItem(this.getDocItem("resolve"));
        env.addItem(this.getDocItem("bound?"));
        env.addItem(this.getDocItem("var-get"));
        env.addItem(this.getDocItem("var-name"));
        env.addItem(this.getDocItem("var-ns"));
        env.addItem(this.getDocItem("var-thread-local?"));
        env.addItem(this.getDocItem("var-local?"));
        env.addItem(this.getDocItem("var-global?"));
        env.addItem(this.getDocItem("name"));
        env.addItem(this.getDocItem("namespace"));
        DocSection walk = new DocSection("Tree Walker", this.id());
        all.addSection(walk);
        walk.addItem(this.getDocItem("prewalk"));
        walk.addItem(this.getDocItem("postwalk"));
        DocSection meta = new DocSection("Meta", this.id());
        all.addSection(meta);
        meta.addItem(this.getDocItem("meta"));
        meta.addItem(this.getDocItem("with-meta"));
        meta.addItem(this.getDocItem("vary-meta"));
        DocSection doc = new DocSection("Documentation", this.id());
        all.addSection(doc);
        doc.addItem(this.getDocItem("doc", false));
        doc.addItem(this.getDocItem("modules"));
        DocSection syntax = new DocSection("Syntax", this.id());
        all.addSection(syntax);
        syntax.addItem(this.getDocItem("highlight"));
        return section;
    }

    private DocSection getSystemSection() {
        DocSection section = new DocSection("System", "system");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection venice = new DocSection("Venice", this.id());
        all.addSection(venice);
        venice.addItem(this.getDocItem("version"));
        venice.addItem(this.getDocItem("sandboxed?"));
        venice.addItem(this.getDocItem("sandbox-type"));
        DocSection system = new DocSection("System", this.id());
        all.addSection(system);
        system.addItem(this.getDocItem("system-prop"));
        system.addItem(this.getDocItem("system-env"));
        system.addItem(this.getDocItem("system-exit-code"));
        system.addItem(this.getDocItem("charset-default-encoding"));
        DocSection java = new DocSection("Java", this.id());
        all.addSection(java);
        java.addItem(this.getDocItem("java-version"));
        java.addItem(this.getDocItem("java-version-info"));
        java.addItem(this.getDocItem("java-major-version"));
        DocSection os = new DocSection("OS", this.id());
        all.addSection(os);
        os.addItem(this.getDocItem("os-type"));
        os.addItem(this.getDocItem("os-type?"));
        os.addItem(this.getDocItem("os-arch"));
        os.addItem(this.getDocItem("os-name"));
        os.addItem(this.getDocItem("os-version"));
        DocSection time = new DocSection("Time", this.id());
        all.addSection(time);
        time.addItem(this.getDocItem("current-time-millis"));
        time.addItem(this.getDocItem("nano-time"));
        time.addItem(this.getDocItem("format-nano-time"));
        time.addItem(this.getDocItem("format-micro-time"));
        time.addItem(this.getDocItem("format-milli-time"));
        DocSection util = new DocSection("Other", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("uuid"));
        util.addItem(this.getDocItem("sleep"));
        util.addItem(this.getDocItem("host-name"));
        util.addItem(this.getDocItem("host-address"));
        util.addItem(this.getDocItem("gc"));
        util.addItem(this.getDocItem("cpus"));
        util.addItem(this.getDocItem("pid"));
        util.addItem(this.getDocItem("shutdown-hook"));
        util.addItem(this.getDocItem("total-memory"));
        util.addItem(this.getDocItem("used-memory"));
        DocSection shell = new DocSection("Shell", this.id());
        all.addSection(shell);
        shell.addItem(this.getDocItem("sh", false));
        shell.addItem(this.getDocItem("with-sh-dir", false));
        shell.addItem(this.getDocItem("with-sh-env", false));
        shell.addItem(this.getDocItem("with-sh-throw", false));
        return section;
    }

    private DocSection getMacrosSection() {
        DocSection section = new DocSection("Macros", "macros");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection create = new DocSection("Create", this.id());
        all.addSection(create);
        create.addItem(this.getDocItem("defn"));
        create.addItem(this.getDocItem("defn-"));
        create.addItem(this.getDocItem("defmacro"));
        create.addItem(this.getDocItem("macroexpand"));
        create.addItem(this.getDocItem("macroexpand-all"));
        DocSection quote = new DocSection("Quoting", this.id());
        all.addSection(quote);
        quote.addItem(this.getDocItem("quote"));
        quote.addItem(this.getDocItem("quasiquote"));
        DocSection branch = new DocSection("Branch", this.id());
        all.addSection(branch);
        branch.addItem(this.getDocItem("and"));
        branch.addItem(this.getDocItem("or"));
        branch.addItem(this.getDocItem("when"));
        branch.addItem(this.getDocItem("when-not"));
        branch.addItem(this.getDocItem("if-not"));
        branch.addItem(this.getDocItem("if-let"));
        branch.addItem(this.getDocItem("when-let"));
        DocSection loop = new DocSection("Loop", this.id());
        all.addSection(loop);
        loop.addItem(this.getDocItem("while"));
        loop.addItem(this.getDocItem("dotimes"));
        loop.addItem(this.getDocItem("list-comp"));
        loop.addItem(this.getDocItem("doseq"));
        DocSection call = new DocSection("Call", this.id());
        all.addSection(call);
        call.addItem(this.getDocItem("doto"));
        call.addItem(this.getDocItem("->"));
        call.addItem(this.getDocItem("->>"));
        call.addItem(this.getDocItem("-<>"));
        call.addItem(this.getDocItem("as->"));
        call.addItem(this.getDocItem("cond->"));
        call.addItem(this.getDocItem("cond->>"));
        call.addItem(this.getDocItem("some->"));
        call.addItem(this.getDocItem("some->>"));
        DocSection loading = new DocSection("Loading", this.id());
        all.addSection(loading);
        loading.addItem(this.getDocItem("load-module"));
        loading.addItem(this.getDocItem("load-file", false));
        loading.addItem(this.getDocItem("load-classpath-file"));
        loading.addItem(this.getDocItem("load-string"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("macro?"));
        test.addItem(this.getDocItem("cond"));
        test.addItem(this.getDocItem("condp"));
        test.addItem(this.getDocItem("case"));
        DocSection assert_ = new DocSection("Assert", this.id());
        all.addSection(assert_);
        assert_.addItem(this.getDocItem("assert", true, true));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("comment"));
        util.addItem(this.getDocItem("gensym"));
        util.addItem(this.getDocItem("time"));
        util.addItem(this.getDocItem("with-out-str"));
        util.addItem(this.getDocItem("with-err-str"));
        DocSection profil = new DocSection("Profiling", this.id());
        all.addSection(profil);
        profil.addItem(this.getDocItem("time"));
        profil.addItem(this.getDocItem("perf", false));
        return section;
    }

    private DocSection getTypesSection() {
        DocSection section = new DocSection("Types", "types");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("type"));
        test.addItem(this.getDocItem("supertype"));
        test.addItem(this.getDocItem("instance?"));
        test.addItem(this.getDocItem("deftype?"));
        DocSection define = new DocSection("Define", this.id());
        all.addSection(define);
        define.addItem(this.getDocItem("deftype"));
        define.addItem(this.getDocItem("deftype-of"));
        define.addItem(this.getDocItem("deftype-or"));
        DocSection create = new DocSection("Create", this.id());
        all.addSection(create);
        create.addItem(this.getDocItem(".:"));
        return section;
    }

    private DocSection getTransducersSection() {
        DocSection section = new DocSection("Transducers", "transducers");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection run = new DocSection("Use", this.id());
        all.addSection(run);
        run.addItem(this.getDocItem("transduce"));
        DocSection func = new DocSection("Functions", this.id());
        all.addSection(func);
        func.addItem(this.getDocItem("map"));
        func.addItem(this.getDocItem("map-indexed"));
        func.addItem(this.getDocItem("filter"));
        func.addItem(this.getDocItem("drop"));
        func.addItem(this.getDocItem("drop-while"));
        func.addItem(this.getDocItem("take"));
        func.addItem(this.getDocItem("take-while"));
        func.addItem(this.getDocItem("keep"));
        func.addItem(this.getDocItem("remove"));
        func.addItem(this.getDocItem("dedupe"));
        func.addItem(this.getDocItem("distinct"));
        func.addItem(this.getDocItem("sorted"));
        func.addItem(this.getDocItem("reverse"));
        func.addItem(this.getDocItem("flatten"));
        func.addItem(this.getDocItem("halt-when"));
        DocSection red = new DocSection("Reductions", this.id());
        all.addSection(red);
        red.addItem(this.getDocItem("rf-first"));
        red.addItem(this.getDocItem("rf-last"));
        red.addItem(this.getDocItem("rf-every?"));
        red.addItem(this.getDocItem("rf-any?"));
        DocSection early = new DocSection("Early", this.id());
        all.addSection(early);
        early.addItem(this.getDocItem("reduced"));
        early.addItem(this.getDocItem("reduced?"));
        early.addItem(this.getDocItem("deref"));
        early.addItem(this.getDocItem("deref?"));
        return section;
    }

    private DocSection getConcurrencySection() {
        DocSection section = new DocSection("Concurrency", "concurrency");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection atoms = new DocSection("Atoms", "concurrency.atoms");
        all.addSection(atoms);
        atoms.addItem(this.getDocItem("atom"));
        atoms.addItem(this.getDocItem("atom?"));
        atoms.addItem(this.getDocItem("deref"));
        atoms.addItem(this.getDocItem("deref?"));
        atoms.addItem(this.getDocItem("reset!"));
        atoms.addItem(this.getDocItem("swap!"));
        atoms.addItem(this.getDocItem("compare-and-set!"));
        atoms.addItem(this.getDocItem("add-watch"));
        atoms.addItem(this.getDocItem("remove-watch"));
        DocSection futures = new DocSection("Futures", "concurrency.futures");
        all.addSection(futures);
        futures.addItem(this.getDocItem("future"));
        futures.addItem(this.getDocItem("future?"));
        futures.addItem(this.getDocItem("future-done?"));
        futures.addItem(this.getDocItem("future-cancel"));
        futures.addItem(this.getDocItem("future-cancelled?"));
        futures.addItem(this.getDocItem("futures-fork"));
        futures.addItem(this.getDocItem("futures-wait"));
        futures.addItem(this.getDocItem("deref"));
        futures.addItem(this.getDocItem("deref?"));
        futures.addItem(this.getDocItem("realized?"));
        DocSection promises = new DocSection("Promises", "concurrency.promises");
        all.addSection(promises);
        promises.addItem(this.getDocItem("promise"));
        promises.addItem(this.getDocItem("promise?"));
        promises.addItem(this.getDocItem("deliver"));
        promises.addItem(this.getDocItem("realized?"));
        DocSection delay = new DocSection("Delay", "concurrency.delay");
        all.addSection(delay);
        delay.addItem(this.getDocItem("delay"));
        delay.addItem(this.getDocItem("delay?"));
        delay.addItem(this.getDocItem("deref"));
        delay.addItem(this.getDocItem("deref?"));
        delay.addItem(this.getDocItem("force"));
        delay.addItem(this.getDocItem("realized?"));
        DocSection agents = new DocSection("Agents", "concurrency.agents");
        all.addSection(agents);
        agents.addItem(this.getDocItem("agent"));
        agents.addItem(this.getDocItem("send"));
        agents.addItem(this.getDocItem("send-off"));
        agents.addItem(this.getDocItem("restart-agent"));
        agents.addItem(this.getDocItem("set-error-handler!"));
        agents.addItem(this.getDocItem("agent-error"));
        agents.addItem(this.getDocItem("await"));
        agents.addItem(this.getDocItem("await-for"));
        agents.addItem(this.getDocItem("shutdown-agents", false));
        agents.addItem(this.getDocItem("shutdown-agents?", false));
        agents.addItem(this.getDocItem("await-termination-agents", false));
        agents.addItem(this.getDocItem("await-termination-agents?", false));
        DocSection sched = new DocSection("Scheduler", "concurrency.scheduler");
        all.addSection(sched);
        sched.addItem(this.getDocItem("schedule-delay", false));
        sched.addItem(this.getDocItem("schedule-at-fixed-rate", false));
        DocSection locking = new DocSection("Locking", "concurrency.locking");
        all.addSection(locking);
        locking.addItem(this.getDocItem("locking"));
        DocSection volatiles = new DocSection("Volatiles", "concurrency.volatiles");
        all.addSection(volatiles);
        volatiles.addItem(this.getDocItem("volatile"));
        volatiles.addItem(this.getDocItem("volatile?"));
        volatiles.addItem(this.getDocItem("deref"));
        volatiles.addItem(this.getDocItem("deref?"));
        volatiles.addItem(this.getDocItem("reset!"));
        volatiles.addItem(this.getDocItem("swap!"));
        DocSection thlocal = new DocSection("ThreadLocal", "concurrency.threadlocal");
        all.addSection(thlocal);
        thlocal.addItem(this.getDocItem("thread-local"));
        thlocal.addItem(this.getDocItem("thread-local?"));
        thlocal.addItem(this.getDocItem("thread-local-clear"));
        thlocal.addItem(this.getDocItem("assoc"));
        thlocal.addItem(this.getDocItem("dissoc"));
        thlocal.addItem(this.getDocItem("get"));
        DocSection threads = new DocSection("Threads", "concurrency.threads");
        all.addSection(threads);
        threads.addItem(this.getDocItem("thread-id"));
        threads.addItem(this.getDocItem("thread-name"));
        threads.addItem(this.getDocItem("thread-interrupted?"));
        threads.addItem(this.getDocItem("thread-interrupted"));
        return section;
    }

    private DocSection getIOSection() {
        DocSection section = new DocSection("IO", "io");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection to = new DocSection("to", "io.to");
        all.addSection(to);
        to.addItem(this.getDocItem("print"));
        to.addItem(this.getDocItem("println"));
        to.addItem(this.getDocItem("printf"));
        to.addItem(this.getDocItem("flush"));
        to.addItem(this.getDocItem("newline"));
        DocSection to_str = new DocSection("to-str", "io.tostr");
        all.addSection(to_str);
        to_str.addItem(this.getDocItem("pr-str"));
        to_str.addItem(this.getDocItem("with-out-str"));
        DocSection from = new DocSection("from", "io.from");
        all.addSection(from);
        from.addItem(this.getDocItem("read-line"));
        from.addItem(this.getDocItem("read-string"));
        DocSection file = new DocSection("file", "io.file");
        all.addSection(file);
        file.addItem(this.getDocItem("io/file"));
        file.addItem(this.getDocItem("io/file-parent"));
        file.addItem(this.getDocItem("io/file-name"));
        file.addItem(this.getDocItem("io/file-path"));
        file.addItem(this.getDocItem("io/file-absolute-path"));
        file.addItem(this.getDocItem("io/file-canonical-path"));
        file.addItem(this.getDocItem("io/file-ext?"));
        file.addItem(this.getDocItem("io/file-size"));
        DocSection file_dir = new DocSection("file dir", "io.filedir");
        all.addSection(file_dir);
        file_dir.addItem(this.getDocItem("io/mkdir"));
        file_dir.addItem(this.getDocItem("io/mkdirs"));
        DocSection file_io = new DocSection("file i/o", "io.fileio");
        all.addSection(file_io);
        file_io.addItem(this.getDocItem("io/slurp"));
        file_io.addItem(this.getDocItem("io/slurp-lines"));
        file_io.addItem(this.getDocItem("io/spit"));
        file_io.addItem(this.getDocItem("io/copy-file"));
        file_io.addItem(this.getDocItem("io/move-file"));
        file_io.addItem(this.getDocItem("io/delete-file"));
        file_io.addItem(this.getDocItem("io/delete-file-on-exit"));
        file_io.addItem(this.getDocItem("io/delete-file-tree"));
        DocSection file_list = new DocSection("file list", "io.filelist");
        all.addSection(file_list);
        file_list.addItem(this.getDocItem("io/list-files"));
        file_list.addItem(this.getDocItem("io/list-files-glob"));
        file_list.addItem(this.getDocItem("io/list-file-tree"));
        DocSection file_test = new DocSection("file test", "io.filetest");
        all.addSection(file_test);
        file_test.addItem(this.getDocItem("io/file?"));
        file_test.addItem(this.getDocItem("io/exists-file?"));
        file_test.addItem(this.getDocItem("io/exists-dir?"));
        file_test.addItem(this.getDocItem("io/file-can-read?", false));
        file_test.addItem(this.getDocItem("io/file-can-write?", false));
        file_test.addItem(this.getDocItem("io/file-can-execute?", false));
        file_test.addItem(this.getDocItem("io/file-hidden?", false));
        DocSection file_watch = new DocSection("file watch", "io.filewatch");
        all.addSection(file_watch);
        file_watch.addItem(this.getDocItem("io/await-for", false));
        file_watch.addItem(this.getDocItem("io/watch-dir", false));
        file_watch.addItem(this.getDocItem("io/close-watcher", false));
        DocSection file_other = new DocSection("file other", "io.fileother");
        all.addSection(file_other);
        file_other.addItem(this.getDocItem("io/temp-file"));
        file_other.addItem(this.getDocItem("io/tmp-dir"));
        file_other.addItem(this.getDocItem("io/user-dir"));
        file_other.addItem(this.getDocItem("io/user-home-dir"));
        DocSection classpath = new DocSection("classpath", "io.classpath");
        all.addSection(classpath);
        classpath.addItem(this.getDocItem("io/load-classpath-resource", false));
        classpath.addItem(this.getDocItem("io/classpath-resource?", false));
        DocSection stream = new DocSection("stream", "io.stream");
        all.addSection(stream);
        stream.addItem(this.getDocItem("io/copy-stream"));
        stream.addItem(this.getDocItem("io/slurp-stream"));
        stream.addItem(this.getDocItem("io/spit-stream"));
        stream.addItem(this.getDocItem("io/uri-stream", false));
        stream.addItem(this.getDocItem("io/wrap-os-with-buffered-writer"));
        stream.addItem(this.getDocItem("io/wrap-os-with-print-writer"));
        stream.addItem(this.getDocItem("io/wrap-is-with-buffered-reader"));
        DocSection rd_wr = new DocSection("reader/writer", "io.readerwriter");
        all.addSection(rd_wr);
        rd_wr.addItem(this.getDocItem("io/buffered-reader"));
        rd_wr.addItem(this.getDocItem("io/buffered-writer"));
        DocSection http = new DocSection("http", "io.http");
        all.addSection(http);
        http.addItem(this.getDocItem("io/download", false));
        http.addItem(this.getDocItem("io/internet-avail?", false));
        DocSection zip = new DocSection("zip", "io.zip");
        all.addSection(zip);
        zip.addItem(this.getDocItem("io/zip", false));
        zip.addItem(this.getDocItem("io/zip-file", false));
        zip.addItem(this.getDocItem("io/zip-list", false));
        zip.addItem(this.getDocItem("io/zip-list-entry-names", false));
        zip.addItem(this.getDocItem("io/zip-append", false));
        zip.addItem(this.getDocItem("io/zip-remove", false));
        zip.addItem(this.getDocItem("io/zip?"));
        zip.addItem(this.getDocItem("io/unzip"));
        zip.addItem(this.getDocItem("io/unzip-first"));
        zip.addItem(this.getDocItem("io/unzip-nth"));
        zip.addItem(this.getDocItem("io/unzip-all"));
        zip.addItem(this.getDocItem("io/unzip-to-dir", false));
        DocSection gzip = new DocSection("gzip", "io.gzip");
        all.addSection(gzip);
        gzip.addItem(this.getDocItem("io/gzip", false));
        gzip.addItem(this.getDocItem("io/gzip-to-stream"));
        gzip.addItem(this.getDocItem("io/gzip?"));
        gzip.addItem(this.getDocItem("io/ungzip"));
        gzip.addItem(this.getDocItem("io/ungzip-to-stream"));
        DocSection other = new DocSection("other", "io.other");
        all.addSection(other);
        other.addItem(this.getDocItem("with-out-str"));
        other.addItem(this.getDocItem("io/mime-type"));
        other.addItem(this.getDocItem("io/default-charset"));
        return section;
    }

    private DocSection getAppSection() {
        DocSection section = new DocSection("Application", "application");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection mgmt = new DocSection("Management", this.id());
        all.addSection(mgmt);
        mgmt.addItem(this.getDocItem("app/build"));
        mgmt.addItem(this.getDocItem("app/manifest"));
        return section;
    }

    private DocSection getNamespaceSection() {
        DocSection section = new DocSection("Namespace", "namespace");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection open = new DocSection("Open", this.id());
        all.addSection(open);
        open.addItem(this.getDocItem("ns"));
        DocSection curr = new DocSection("Current", this.id());
        all.addSection(curr);
        curr.addItem(this.getDocItem("*ns*"));
        DocSection remove = new DocSection("Remove", this.id());
        all.addSection(remove);
        remove.addItem(this.getDocItem("ns-unmap"));
        remove.addItem(this.getDocItem("ns-remove"));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("ns-list"));
        util.addItem(this.getDocItem("namespace"));
        return section;
    }

    private DocSection getByteBufSection() {
        DocSection section = new DocSection("Byte Buffer", "bytebuf");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection bb_create = new DocSection("Create", this.id());
        all.addSection(bb_create);
        bb_create.addItem(this.getDocItem("bytebuf"));
        bb_create.addItem(this.getDocItem("bytebuf-allocate"));
        bb_create.addItem(this.getDocItem("bytebuf-from-string"));
        DocSection bb_test = new DocSection("Test", this.id());
        all.addSection(bb_test);
        bb_test.addItem(this.getDocItem("empty?"));
        bb_test.addItem(this.getDocItem("not-empty?"));
        bb_test.addItem(this.getDocItem("bytebuf?"));
        DocSection bb_use = new DocSection("Use", this.id());
        all.addSection(bb_use);
        bb_use.addItem(this.getDocItem("count"));
        bb_use.addItem(this.getDocItem("bytebuf-capacity"));
        bb_use.addItem(this.getDocItem("bytebuf-limit"));
        bb_use.addItem(this.getDocItem("bytebuf-to-string"));
        bb_use.addItem(this.getDocItem("bytebuf-to-list"));
        bb_use.addItem(this.getDocItem("bytebuf-sub"));
        bb_use.addItem(this.getDocItem("bytebuf-pos"));
        bb_use.addItem(this.getDocItem("bytebuf-pos!"));
        DocSection bb_read = new DocSection("Read", this.id());
        all.addSection(bb_read);
        bb_read.addItem(this.getDocItem("bytebuf-get-byte"));
        bb_read.addItem(this.getDocItem("bytebuf-get-int"));
        bb_read.addItem(this.getDocItem("bytebuf-get-long"));
        bb_read.addItem(this.getDocItem("bytebuf-get-float"));
        bb_read.addItem(this.getDocItem("bytebuf-get-double"));
        DocSection bb_write = new DocSection("Write", this.id());
        all.addSection(bb_write);
        bb_write.addItem(this.getDocItem("bytebuf-put-byte!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-int!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-long!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-float!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-double!"));
        bb_write.addItem(this.getDocItem("bytebuf-put-buf!"));
        DocSection encode = new DocSection("Base64", this.id());
        all.addSection(encode);
        encode.addItem(this.getDocItem("str/encode-base64"));
        encode.addItem(this.getDocItem("str/decode-base64"));
        DocSection hex = new DocSection("Hex", this.id());
        all.addSection(hex);
        hex.addItem(this.getDocItem("str/hex-to-bytebuf"));
        hex.addItem(this.getDocItem("str/bytebuf-to-hex"));
        hex.addItem(this.getDocItem("str/format-bytebuf"));
        return section;
    }

    private DocSection getTimeSection() {
        DocSection section = new DocSection("Time", "time");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection date = new DocSection("Date", this.id());
        all.addSection(date);
        date.addItem(this.getDocItem("time/date"));
        date.addItem(this.getDocItem("time/date?"));
        DocSection local_date = new DocSection("Local Date", this.id());
        all.addSection(local_date);
        local_date.addItem(this.getDocItem("time/local-date"));
        local_date.addItem(this.getDocItem("time/local-date?"));
        local_date.addItem(this.getDocItem("time/local-date-parse"));
        DocSection local_date_time = new DocSection("Local Date Time", this.id());
        all.addSection(local_date_time);
        local_date_time.addItem(this.getDocItem("time/local-date-time"));
        local_date_time.addItem(this.getDocItem("time/local-date-time?"));
        local_date_time.addItem(this.getDocItem("time/local-date-time-parse"));
        DocSection zoned_date_time = new DocSection("Zoned Date Time", this.id());
        all.addSection(zoned_date_time);
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time"));
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time?"));
        zoned_date_time.addItem(this.getDocItem("time/zoned-date-time-parse"));
        DocSection fields = new DocSection("Fields", this.id());
        all.addSection(fields);
        fields.addItem(this.getDocItem("time/year"));
        fields.addItem(this.getDocItem("time/month"));
        fields.addItem(this.getDocItem("time/day-of-week"));
        fields.addItem(this.getDocItem("time/day-of-month"));
        fields.addItem(this.getDocItem("time/day-of-year"));
        fields.addItem(this.getDocItem("time/hour"));
        fields.addItem(this.getDocItem("time/minute"));
        fields.addItem(this.getDocItem("time/second"));
        DocSection etc = new DocSection("Fields etc", this.id());
        all.addSection(etc);
        etc.addItem(this.getDocItem("time/length-of-year"));
        etc.addItem(this.getDocItem("time/length-of-month"));
        etc.addItem(this.getDocItem("time/first-day-of-month"));
        etc.addItem(this.getDocItem("time/last-day-of-month"));
        DocSection zone = new DocSection("Zone", this.id());
        all.addSection(zone);
        zone.addItem(this.getDocItem("time/zone"));
        zone.addItem(this.getDocItem("time/zone-offset"));
        DocSection format = new DocSection("Format", this.id());
        all.addSection(format);
        format.addItem(this.getDocItem("time/formatter"));
        format.addItem(this.getDocItem("time/format"));
        DocSection compare = new DocSection("Test", this.id());
        all.addSection(compare);
        compare.addItem(this.getDocItem("time/after?"));
        compare.addItem(this.getDocItem("time/not-after?"));
        compare.addItem(this.getDocItem("time/before?"));
        compare.addItem(this.getDocItem("time/not-before?"));
        compare.addItem(this.getDocItem("time/within?"));
        compare.addItem(this.getDocItem("time/leap-year?"));
        DocSection misc = new DocSection("Miscellaneous", this.id());
        all.addSection(misc);
        misc.addItem(this.getDocItem("time/with-time"));
        misc.addItem(this.getDocItem("time/plus"));
        misc.addItem(this.getDocItem("time/minus"));
        misc.addItem(this.getDocItem("time/period"));
        misc.addItem(this.getDocItem("time/earliest"));
        misc.addItem(this.getDocItem("time/latest"));
        DocSection util = new DocSection("Util", this.id());
        all.addSection(util);
        util.addItem(this.getDocItem("time/zone-ids"));
        util.addItem(this.getDocItem("time/to-millis"));
        return section;
    }

    private DocSection getSpecialFormsSection() {
        DocSection section = new DocSection("Special Forms", "specialforms");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection generic = new DocSection("Forms", this.id());
        all.addSection(generic);
        generic.addItem(this.getDocItem("def"));
        generic.addItem(this.getDocItem("defonce"));
        generic.addItem(this.getDocItem("def-dynamic"));
        generic.addItem(this.getDocItem("defmulti"));
        generic.addItem(this.getDocItem("defmethod"));
        generic.addItem(this.getDocItem("if"));
        generic.addItem(this.getDocItem("do"));
        generic.addItem(this.getDocItem("let"));
        generic.addItem(this.getDocItem("binding"));
        generic.addItem(this.getDocItem("fn"));
        generic.addItem(this.getDocItem("set!"));
        DocSection recur = new DocSection("Recursion", this.id());
        all.addSection(recur);
        recur.addItem(this.getDocItem("loop"));
        recur.addItem(this.getDocItem("recur"));
        recur.addItem(this.getDocItem("tail-pos", true, true));
        DocSection ex = new DocSection("Exception", this.id());
        all.addSection(ex);
        ex.addItem(this.getDocItem("throw", true, true));
        ex.addItem(this.getDocItem("try", true, true));
        ex.addItem(this.getDocItem("try-with", true, true));
        DocSection profiling = new DocSection("Profiling", this.id());
        all.addSection(profiling);
        profiling.addItem(this.getDocItem("dobench"));
        profiling.addItem(this.getDocItem("dorun"));
        profiling.addItem(this.getDocItem("prof"));
        return section;
    }

    private DocSection getJavaInteropSection() {
        DocSection section = new DocSection("Java Interoperability", "javainterop");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection java = new DocSection("Java", this.id());
        all.addSection(java);
        java.addItem(this.getDocItem("."));
        java.addItem(this.getDocItem("import"));
        java.addItem(this.getDocItem("java-iterator-to-list"));
        java.addItem(this.getDocItem("java-enumeration-to-list"));
        java.addItem(this.getDocItem("java-unwrap-optional"));
        java.addItem(this.getDocItem("cast"));
        java.addItem(this.getDocItem("class"));
        DocSection proxy = new DocSection("Proxify", this.id());
        all.addSection(proxy);
        proxy.addItem(this.getDocItem("proxify"));
        proxy.addItem(this.getDocItem("as-runnable"));
        proxy.addItem(this.getDocItem("as-callable"));
        proxy.addItem(this.getDocItem("as-predicate"));
        proxy.addItem(this.getDocItem("as-function"));
        proxy.addItem(this.getDocItem("as-consumer"));
        proxy.addItem(this.getDocItem("as-supplier"));
        proxy.addItem(this.getDocItem("as-bipredicate"));
        proxy.addItem(this.getDocItem("as-bifunction"));
        proxy.addItem(this.getDocItem("as-biconsumer"));
        proxy.addItem(this.getDocItem("as-binaryoperator"));
        DocSection test = new DocSection("Test", this.id());
        all.addSection(test);
        test.addItem(this.getDocItem("java-obj?"));
        test.addItem(this.getDocItem("exists-class?"));
        DocSection support = new DocSection("Support", this.id());
        all.addSection(support);
        support.addItem(this.getDocItem("imports"));
        support.addItem(this.getDocItem("supers"));
        support.addItem(this.getDocItem("bases"));
        support.addItem(this.getDocItem("formal-type"));
        support.addItem(this.getDocItem("stacktrace", false, false));
        DocSection clazz = new DocSection("Class", this.id());
        all.addSection(clazz);
        clazz.addItem(this.getDocItem("class"));
        clazz.addItem(this.getDocItem("class-of"));
        clazz.addItem(this.getDocItem("class-name"));
        clazz.addItem(this.getDocItem("class-version"));
        clazz.addItem(this.getDocItem("classloader"));
        clazz.addItem(this.getDocItem("classloader-of"));
        return section;
    }

    private DocSection getMiscellaneousSection() {
        DocSection section = new DocSection("Miscellaneous", "miscellaneous");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection json = new DocSection("JSON", "miscellaneous.json");
        all.addSection(json);
        json.addItem(this.getDocItem("json/write-str"));
        json.addItem(this.getDocItem("json/read-str"));
        json.addItem(this.getDocItem("json/spit"));
        json.addItem(this.getDocItem("json/slurp"));
        json.addItem(this.getDocItem("json/pretty-print"));
        DocSection pdf = new DocSection("PDF", "miscellaneous.pdf");
        all.addSection(pdf);
        pdf.addItem(this.getDocItem("pdf/render", false));
        pdf.addItem(this.getDocItem("pdf/text-to-pdf", false));
        pdf.addItem(this.getDocItem("pdf/available?", false));
        pdf.addItem(this.getDocItem("pdf/check-required-libs", false));
        DocSection pdf_tools = new DocSection("PDF Tools", "miscellaneous.pdftools");
        all.addSection(pdf_tools);
        pdf_tools.addItem(this.getDocItem("pdf/merge", false));
        pdf_tools.addItem(this.getDocItem("pdf/copy", false));
        pdf_tools.addItem(this.getDocItem("pdf/pages"));
        pdf_tools.addItem(this.getDocItem("pdf/watermark", false));
        DocSection csv = new DocSection("CSV", "miscellaneous.csv");
        all.addSection(csv);
        csv.addItem(this.getDocItem("csv/read"));
        csv.addItem(this.getDocItem("csv/write", false));
        csv.addItem(this.getDocItem("csv/write-str"));
        DocSection cidr = new DocSection("CIDR", "miscellaneous.cidr");
        all.addSection(cidr);
        cidr.addItem(this.getDocItem("cidr/parse"));
        cidr.addItem(this.getDocItem("cidr/in-range?"));
        cidr.addItem(this.getDocItem("cidr/start-inet-addr"));
        cidr.addItem(this.getDocItem("cidr/end-inet-addr"));
        cidr.addItem(this.getDocItem("cidr/inet-addr"));
        cidr.addItem(this.getDocItem("cidr/inet-addr-to-bytes"));
        cidr.addItem(this.getDocItem("cidr/inet-addr-from-bytes"));
        DocSection cidr_trie = new DocSection("CIDR Trie", "miscellaneous.cidrtrie");
        all.addSection(cidr_trie);
        cidr_trie.addItem(this.getDocItem("cidr/trie"));
        cidr_trie.addItem(this.getDocItem("cidr/size"));
        cidr_trie.addItem(this.getDocItem("cidr/insert"));
        cidr_trie.addItem(this.getDocItem("cidr/lookup"));
        cidr_trie.addItem(this.getDocItem("cidr/lookup-reverse"));
        DocSection other = new DocSection("Other", "miscellaneous.other");
        all.addSection(other);
        other.addItem(this.getDocItem("*version*"));
        other.addItem(this.getDocItem("*newline*"));
        other.addItem(this.getDocItem("*loaded-modules*"));
        other.addItem(this.getDocItem("*loaded-files*"));
        other.addItem(this.getDocItem("*ns*"));
        other.addItem(this.getDocItem("*run-mode*"));
        other.addItem(this.getDocItem("*ansi-term*"));
        return section;
    }

    private DocSection getModulesSection() {
        DocSection section = new DocSection("Extension Modules (selection)", "modules");
        DocSection all = new DocSection("", this.id());
        section.addSection(all);
        DocSection kira = new DocSection("Kira", "modules.kira");
        all.addSection(kira);
        kira.addItem(new DocItem("(load-module :kira)", null));
        kira.addItem(this.getDocItem("kira/eval"));
        kira.addItem(this.getDocItem("kira/fn"));
        kira.addItem(this.getDocItem("kira/escape-xml"));
        kira.addItem(this.getDocItem("kira/escape-html"));
        DocSection trace = new DocSection("Tracing", "modules.tracing");
        all.addSection(trace);
        trace.addItem(new DocItem("(load-module :trace)", null));
        trace.addItem(this.getDocItem("trace/trace"));
        trace.addItem(this.getDocItem("trace/traced?"));
        trace.addItem(this.getDocItem("trace/traceable?"));
        trace.addItem(this.getDocItem("trace/trace-var"));
        trace.addItem(this.getDocItem("trace/untrace-var"));
        DocSection xml = new DocSection("XML", "modules.xml");
        all.addSection(xml);
        xml.addItem(new DocItem("(load-module :xml)", null));
        xml.addItem(this.getDocItem("xml/parse-str"));
        xml.addItem(this.getDocItem("xml/parse"));
        xml.addItem(this.getDocItem("xml/path->"));
        xml.addItem(this.getDocItem("xml/children"));
        xml.addItem(this.getDocItem("xml/text"));
        DocSection crypt = new DocSection("Cryptography", "modules.cryptography");
        all.addSection(crypt);
        crypt.addItem(new DocItem("(load-module :crypt)", null));
        crypt.addItem(this.getDocItem("crypt/md5-hash"));
        crypt.addItem(this.getDocItem("crypt/sha1-hash"));
        crypt.addItem(this.getDocItem("crypt/sha512-hash"));
        crypt.addItem(this.getDocItem("crypt/pbkdf2-hash"));
        crypt.addItem(this.getDocItem("crypt/encrypt"));
        crypt.addItem(this.getDocItem("crypt/decrypt"));
        DocSection gradle = new DocSection("Gradle", "modules.gradle");
        all.addSection(gradle);
        gradle.addItem(new DocItem("(load-module :gradle)", null));
        gradle.addItem(this.getDocItem("gradle/with-home", false));
        gradle.addItem(this.getDocItem("gradle/version", false));
        gradle.addItem(this.getDocItem("gradle/task", false));
        DocSection maven = new DocSection("Maven", "modules.maven");
        all.addSection(maven);
        maven.addItem(new DocItem("(load-module :maven)", null));
        maven.addItem(this.getDocItem("maven/download", false));
        maven.addItem(this.getDocItem("maven/get", false));
        maven.addItem(this.getDocItem("maven/uri", false));
        return section;
    }

    private DocItem getDocItem(String name) {
        return this.getDocItem(name, true, false);
    }

    private DocItem getDocItem(String name, boolean runExamples) {
        return this.getDocItem(name, runExamples, false);
    }

    private DocItem getDocItem(String name, boolean runExamples, boolean catchEx) {
        DocItem item = this.docItems.get(name);
        if (item != null) {
            return item;
        }
        DocItem item_ = this.getDocItem_(name, runExamples, catchEx);
        if (item_ != null) {
            this.docItems.put(name, item_);
        }
        return item_;
    }

    private DocItem getDocItem_(String name, boolean runExamples, boolean catchEx) {
        VncFunction fn = this.findFunction(name);
        if (fn != null) {
            return new DocItem(name, this.toStringList(fn.getArgLists()), fn.getDoc() == Constants.Nil ? "" : ((VncString)fn.getDoc()).getValue(), this.runExamples(name, this.toStringList(fn.getExamples()), runExamples, catchEx), this.createCrossRefs(name, fn), this.id(name));
        }
        throw new RuntimeException(String.format("Unknown function %s", name));
    }

    private List<ExampleOutput> runExamples(String name, List<String> examples, boolean run, boolean catchEx) {
        if (this.runExamples) {
            Venice runner = new Venice();
            try {
                return examples.stream().filter(e -> !StringUtil.isEmpty(e)).map(e -> this.runExample(runner, name, (String)e, run, catchEx)).collect(Collectors.toList());
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(String.format("Failed to run examples for %s", name), ex);
            }
        }
        return EMPTY_EXAMPLES;
    }

    private ExampleOutput runExample(Venice runner, String name, String example, boolean run, boolean catchEx) {
        String exampleHighlighted = this.codeHighlighter.highlight(example);
        if (run) {
            CapturingPrintStream ps_out = new CapturingPrintStream();
            CapturingPrintStream ps_err = new CapturingPrintStream();
            try {
                String modules = this.preloadedModules.stream().map(m -> "  (load-module :" + m + ")").collect(Collectors.joining("\n"));
                String script = "(do \n" + modules + "\n\n  (pr-str " + example + "\n))";
                String result = (String)runner.eval("example", script, Parameters.of("*out*", ps_out, "*err*", ps_err));
                return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), result);
            }
            catch (RuntimeException ex) {
                if (catchEx) {
                    return new ExampleOutput(name, example, exampleHighlighted, ps_out.getOutput(), ps_err.getOutput(), ex);
                }
                throw ex;
            }
        }
        return new ExampleOutput(name, example, exampleHighlighted);
    }

    private VncFunction findFunction(String name) {
        VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(name));
        if (fn != null) {
            return fn;
        }
        return this.getFunction(name);
    }

    private List<CrossRef> createCrossRefs(String parentName, VncFunction fn) {
        ArrayList<CrossRef> crossRefs = new ArrayList<CrossRef>();
        VncList seeAlso = fn.getSeeAlso();
        seeAlso.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)v -> {
            String crossRefFnName = ((VncString)v).getValue();
            VncFunction crossRefFn = this.findFunction(crossRefFnName);
            if (crossRefFn != null) {
                String doc;
                String string = doc = crossRefFn.getDoc() == Constants.Nil ? null : ((VncString)crossRefFn.getDoc()).getValue();
                if (doc != null) {
                    crossRefs.add(this.createCrossRef(crossRefFnName, this.getCrossRefDescr(doc)));
                }
            } else {
                throw new RuntimeException(String.format("Missing cross reference function %s -> %s", parentName, crossRefFnName));
            }
        }));
        return crossRefs;
    }

    private String getCrossRefDescr(String descr) {
        String s;
        int posLF = descr.indexOf(10);
        String string = s = posLF == -1 ? descr.trim() : descr.substring(0, posLF).trim();
        if (s.length() > 145) {
            int spacePos = s.indexOf(32, 135);
            String string2 = s = spacePos != -1 ? s.substring(0, spacePos) : s.substring(0, 140).trim();
            if (!s.endsWith(".")) {
                s = s + " ...";
            }
        }
        return s;
    }

    private CrossRef createCrossRef(String name, String descr) {
        return new CrossRef(name, this.id(name), descr);
    }

    private List<String> toStringList(VncList list) {
        return list.stream().map(s -> ((VncString)s).getValue()).collect(Collectors.toList());
    }

    private List<DocSection> concat(List<DocSection> l1, List<DocSection> l2) {
        ArrayList<DocSection> list = new ArrayList<DocSection>();
        list.addAll(l1);
        list.addAll(l2);
        return list;
    }

    private void save(File file, String text) throws Exception {
        this.save(file, text.getBytes("UTF-8"));
    }

    private void save(File file, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data, 0, data.length);
            fos.flush();
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private VncFunction getFunction(String name) {
        VncVal val = this.env.get(new VncSymbol(name));
        return Types.isVncFunction(val) ? (VncFunction)val : null;
    }

    private String id() {
        return String.valueOf(this.gen.getAndIncrement());
    }

    private String id(String name) {
        return this.idMap.computeIfAbsent(name, n -> String.valueOf(this.gen.getAndIncrement()));
    }

    private final void validateUniqueSectionsId(List<DocSection> left, List<DocSection> right) {
        HashSet ids = new HashSet();
        left.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
        right.forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }

    private final void validateUniqueSectionId(DocSection section, Set<String> ids) {
        String id = section.getId();
        if (id != null) {
            if (ids.contains(section.getId())) {
                throw new RuntimeException(String.format("Non unique section id %s on section %s", id, section.getTitle()));
            }
            ids.add(id);
        }
        section.getSections().forEach(s -> this.validateUniqueSectionId((DocSection)s, ids));
    }
}

