/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.docgen;

import com.github.jlangch.venice.impl.docgen.DocHighlighter;
import com.github.jlangch.venice.impl.util.StringEscapeUtil;
import com.github.jlangch.venice.impl.util.StringUtil;

public class ExampleOutput {
    private final String name;
    private final String example;
    private final String exampleXmlStyled;
    private final String result;
    private final String stdout;
    private final String stderr;
    private final RuntimeException ex;

    public ExampleOutput(String name, String example, String exampleXmlStyled) {
        this(name, example, exampleXmlStyled, null, null, null, null);
    }

    public ExampleOutput(String name, String example, String exampleXmlStyled, String stdout, String stderr, String result) {
        this(name, example, exampleXmlStyled, stdout, stderr, result, null);
    }

    public ExampleOutput(String name, String example, String exampleXmlStyled, String stdout, String stderr, RuntimeException ex) {
        this(name, example, exampleXmlStyled, stdout, stderr, null, ex);
    }

    private ExampleOutput(String name, String example, String exampleXmlStyled, String stdout, String stderr, String result, RuntimeException ex) {
        this.name = name;
        this.example = StringUtil.emptyToNull(StringUtil.trimRight(example));
        this.exampleXmlStyled = exampleXmlStyled;
        this.stdout = StringUtil.emptyToNull(StringUtil.trimRight(stdout));
        this.stderr = StringUtil.emptyToNull(StringUtil.trimRight(stderr));
        this.result = StringUtil.emptyToNull(StringUtil.trimRight(result));
        this.ex = ex;
    }

    public String getName() {
        return this.name;
    }

    public String getExample() {
        return this.example;
    }

    public String getExampleXmlStyled() {
        return this.exampleXmlStyled;
    }

    public String getResult() {
        return this.result;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public RuntimeException getEx() {
        return this.ex;
    }

    public String getExString() {
        return this.ex != null ? String.format("%s: %s", this.ex.getClass().getSimpleName(), this.ex.getMessage()) : null;
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.example);
        if (this.stdout != null) {
            sb.append("\n");
            sb.append(this.stdout);
        }
        if (this.stderr != null) {
            sb.append("\n");
            sb.append(this.stderr);
        }
        if (this.result != null) {
            sb.append("\n");
            sb.append("=> ").append(this.result);
        }
        if (this.ex != null) {
            sb.append("\n");
            sb.append("=> ").append(this.getExString());
        }
        return sb.toString();
    }

    public String renderXmlStyled() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.exampleXmlStyled);
        if (this.stdout != null) {
            sb.append("\n");
            sb.append(DocHighlighter.style(this.stdout, "#808080"));
        }
        if (this.stderr != null) {
            sb.append("\n");
            sb.append(DocHighlighter.style(this.stderr, "#808080"));
        }
        if (this.result != null) {
            sb.append("\n");
            sb.append(StringEscapeUtil.escapeXml("=> "));
            sb.append(StringEscapeUtil.escapeXml(this.result));
        }
        if (this.ex != null) {
            sb.append("\n");
            sb.append(StringEscapeUtil.escapeXml("=> "));
            sb.append(DocHighlighter.style(this.getExString(), "#808080"));
        }
        return sb.toString();
    }
}

