/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.ConcurrencyFunctions;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import com.github.jlangch.venice.impl.util.MimeTypes;
import com.github.jlangch.venice.impl.util.io.ClassPathResource;
import com.github.jlangch.venice.impl.util.io.FileUtil;
import com.github.jlangch.venice.impl.util.io.IOStreamUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IOFunctions {
    public static VncFunction io_file = new VncFunction("io/file", (VncVal)VncFunction.meta().arglists("(io/file path)", "(io/file parent child)", "(io/file parent child & children)").doc("Returns a java.io.File from file path, or from a parent path and one or multiple children. The path and parent may be a file or a string (file path), child and children must be strings.").examples("(io/file \"/temp/test.txt\")", "(io/file \"/temp\" \"test.txt\")", "(io/file \"/temp\" \"test\" \"test.txt\")", "(io/file (io/file \"/temp\") \"test\" \"test.txt\")", "(io/file (. :java.io.File :new \"/temp/test.txt\"))").seeAlso("io/file-name", "io/file-parent", "io/file-path", "io/file-absolute-path", "io/file-canonical-path").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            File parent;
            ArityExceptions.assertMinArity(this, args, 1);
            if (args.size() == 1) {
                return new VncJavaObject(IOFunctions.convertToFile(args.first(), "Function 'io/file' does not allow %s as path"));
            }
            File file = parent = IOFunctions.convertToFile(args.first(), "Function 'io/file' does not allow %s as parent");
            for (VncVal child : args.rest()) {
                file = new File(file, Coerce.toVncString(child).getValue());
            }
            return new VncJavaObject(file);
        }
    };
    public static VncFunction io_file_size = new VncFunction("io/file-size", (VncVal)VncFunction.meta().arglists("(io/file-size f)").doc("Returns the size of the file f. f must be a file or a string (file path).").examples("(io/file-size \"/bin/sh\")").seeAlso("io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-size' does not allow %s as f");
            IOFunctions.validateReadableFile(f);
            return new VncLong(f.length());
        }
    };
    public static VncFunction io_file_path = new VncFunction("io/file-path", (VncVal)VncFunction.meta().arglists("(io/file-path f)").doc("Returns the path of the file f as a string. f must be a file or a string (file path).").examples("(io/file-path (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-absolute-path", "io/file-canonical-path", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-path' does not allow %s as f");
            return new VncString(f.getPath());
        }
    };
    public static VncFunction io_file_canonical_path = new VncFunction("io/file-canonical-path", (VncVal)VncFunction.meta().arglists("(io/file-canonical-path f)").doc("Returns the canonical path of the file f. f must be a file or a string (file path).").examples("(io/file-canonical-path (io/file \"/tmp/test/../x.txt\"))").seeAlso("io/file-path", "io/file-absolute-path", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            try {
                File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-canonical-path' does not allow %s as f");
                return new VncString(f.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new VncException("Failed to get canonical file path", ex);
            }
        }
    };
    public static VncFunction io_file_absolute_path = new VncFunction("io/file-absolute-path", (VncVal)VncFunction.meta().arglists("(io/file-absolute-path f)").doc("Returns the absolute path of the file f. f must be a file or a string (file path).").examples("(io/file-absolute-path (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-path", "io/file-canonical-path", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-absolute-path' does not allow %s as f");
            return new VncString(f.getAbsolutePath());
        }
    };
    public static VncFunction io_file_parent = new VncFunction("io/file-parent", (VncVal)VncFunction.meta().arglists("(io/file-parent f)").doc("Returns the parent file of the file f. f must be a file or a string (file path).").examples("(io/file-path (io/file-parent (io/file \"/tmp/test/x.txt\")))").seeAlso("io/file-name", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-parent' does not allow %s as f");
            File parent = f.getParentFile();
            return parent == null ? Constants.Nil : new VncJavaObject(parent);
        }
    };
    public static VncFunction io_file_name = new VncFunction("io/file-name", (VncVal)VncFunction.meta().arglists("(io/file-name f)").doc("Returns the name of the file f as a string. f must be a file or a string (file path).").examples("(io/file-name (io/file \"/tmp/test/x.txt\"))").seeAlso("io/file-parent", "io/file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-name' does not allow %s as f");
            return new VncString(f.getName());
        }
    };
    public static VncFunction io_file_ext_Q = new VncFunction("io/file-ext?", (VncVal)VncFunction.meta().arglists("(io/file-ext? f ext)").doc("Returns true if the file f hast the extension ext. f must be a file or a string (file path).").examples("(io/file-ext? \"/tmp/test/x.txt\" \"txt\")", "(io/file-ext? (io/file \"/tmp/test/x.txt\") \".txt\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-ext?' does not allow %s as f");
            String ext = Coerce.toVncString(args.second()).getValue();
            return VncBoolean.of(f.getName().endsWith(ext.startsWith(".") ? ext : "." + ext));
        }
    };
    public static VncFunction io_file_Q = new VncFunction("io/file?", (VncVal)VncFunction.meta().arglists("(io/file? x)").doc("Returns true if x is a java.io.File.").examples("(io/file? (io/file \"/temp/test.txt\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), File.class));
        }
    };
    public static VncFunction io_exists_file_Q = new VncFunction("io/exists-file?", (VncVal)VncFunction.meta().arglists("(io/exists-file? f)").doc("Returns true if the file f exists. f must be a file or a string (file path).").examples("(io/exists-file? \"/temp/test.txt\")").seeAlso("io/exists-dir?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/exists-file?' does not allow %s as x");
            return VncBoolean.of(f.isFile());
        }
    };
    public static VncFunction io_exists_dir_Q = new VncFunction("io/exists-dir?", (VncVal)VncFunction.meta().arglists("(io/exists-dir? f)").doc("Returns true if the file f exists and is a directory. f must be a file or a string (file path).").examples("(io/exists-dir? (io/file \"/temp\"))").seeAlso("io/exists-file?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/exists-dir?' does not allow %s as f");
            return VncBoolean.of(f.isDirectory());
        }
    };
    public static VncFunction io_file_can_read_Q = new VncFunction("io/file-can-read?", (VncVal)VncFunction.meta().arglists("(io/file-can-read? f)").doc("Returns true if the file or directory f exists and can be read. f must be a file or a string (file path).").examples("(io/file-can-read? \"/temp/test.txt\")").seeAlso("io/file-can-write?", "io/file-can-execute?", "io/file-hidden?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-read?' does not allow %s as x");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canRead());
        }
    };
    public static VncFunction io_file_can_write_Q = new VncFunction("io/file-can-write?", (VncVal)VncFunction.meta().arglists("(io/file-can-write? f)").doc("Returns true if the file or directory f exists and can be written. f must be a file or a string (file path).").examples("(io/file-can-write? \"/temp/test.txt\")").seeAlso("io/file-can-read?", "io/file-can-execute?", "io/file-hidden?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-write?' does not allow %s as x");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canWrite());
        }
    };
    public static VncFunction io_file_can_execute_Q = new VncFunction("io/file-can-execute?", (VncVal)VncFunction.meta().arglists("(io/file-can-execute? f)").doc("Returns true if the file or directory f exists and can be executed. f must be a file or a string (file path).").examples("(io/file-can-execute? \"/temp/test.txt\")").seeAlso("io/file-can-read?", "io/file-can-write?", "io/file-hidden?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-can-execute?' does not allow %s as x");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.canExecute());
        }
    };
    public static VncFunction io_file_hidden_Q = new VncFunction("io/file-hidden?", (VncVal)VncFunction.meta().arglists("(io/file-hidden? f)").doc("Returns true if the file or directory f exists and is hidden. f must be a file or a string (file path).").examples("(io/file-hidden? \"/temp/test.txt\")").seeAlso("io/file-can-read?", "io/file-can-write?", "io/file-can-execute?").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            File f = IOFunctions.convertToFile(args.first(), "Function 'io/file-hidden?' does not allow %s as x");
            return VncBoolean.of((f.isFile() || f.isDirectory()) && f.isHidden());
        }
    };
    public static VncFunction io_await_for = new VncFunction("io/await-for", (VncVal)VncFunction.meta().arglists("(io/await-for timeout time-unit file & modes)").doc("Blocks the current thread until the file has been created, deleted, or modified according to the passed modes {:created, :deleted, :modified}, or the timeout has elapsed. Returns logical false if returning due to timeout, logical true otherwise. \nSupported time units are: {:milliseconds, :seconds, :minutes, :hours, :days}").examples("(io/await-for 10 :seconds \"/tmp/data.json\" :created)").seeAlso("io/watch-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 3);
            this.sandboxFunctionCallValidation();
            long timeout = Coerce.toVncLong(args.first()).getValue();
            TimeUnit unit = IOFunctions.toTimeUnit(Coerce.toVncKeyword(args.second()));
            long timeoutMillis = unit.toMillis(Math.max(0L, timeout));
            File file = IOFunctions.convertToFile(args.third(), "Function 'io/await-for' does not allow %s as file").getAbsoluteFile();
            HashSet events = new HashSet();
            block13: for (VncVal v : args.slice(3)) {
                VncKeyword mode = Coerce.toVncKeyword(v);
                switch (mode.getSimpleName()) {
                    case "created": {
                        events.add(StandardWatchEventKinds.ENTRY_CREATE);
                        continue block13;
                    }
                    case "deleted": {
                        events.add(StandardWatchEventKinds.ENTRY_DELETE);
                        continue block13;
                    }
                    case "modified": {
                        events.add(StandardWatchEventKinds.ENTRY_MODIFY);
                        continue block13;
                    }
                }
                throw new VncException(String.format("Function 'io/await-for' invalid mode '%s'. Use one or multiple of {:created, :deleted, :modified}", mode.toString()));
            }
            if (events.isEmpty()) {
                throw new VncException("Function 'io/await-for' missing a mode. Pass one or multiple of {:created, :deleted, :modified}");
            }
            try {
                return VncBoolean.of(FileUtil.awaitFile(file.getCanonicalFile().toPath(), timeoutMillis, events));
            }
            catch (java.lang.InterruptedException ex) {
                throw new InterruptedException("Interrupted while calling function 'io/await-for'", ex);
            }
            catch (IOException ex) {
                throw new VncException(String.format("Function 'io/await-for' failed to await for file '%s'", file.getPath()), ex);
            }
        }
    };
    public static VncFunction io_watch_dir = new VncFunction("io/watch-dir", (VncVal)VncFunction.meta().arglists("(io/watch-dir dir event-fn)", "(io/watch-dir dir event-fn failure-fn)", "(io/watch-dir dir event-fn failure-fn termination-fn)").doc("Watch a directory for changes, and call the function event-fn when it does. Calls the optional failure-fn if errors occur. On closing the watcher termination-fn is called. \nevent-fn is a two argument function that receives the path and mode {:created, :deleted, :modified} of the changed file. \nfailure-fn is a two argument function that receives the watch dir and the failure exception. \ntermination-fn is a one argument function receives the watch dir.\nReturns a watcher that is activley watching a directory. The watcher is \na resource which should be closed with io/close-watcher.").examples("(do                                                           \n  (defn log [msg] (locking log (println msg)))                \n                                                              \n  (let [w (io/watch-dir \"/tmp\" #(log (str %1 \" \" %2)))]   \n    (sleep 30 :seconds)                                       \n    (io/close-watcher w)))                                      ").seeAlso("io/await-for").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2, 3, 4);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/watch-dir' does not allow %s as file").getAbsoluteFile();
            if (!dir.isDirectory()) {
                throw new VncException(String.format("Function 'io/watch-dir': dir '%s' is not a directpry", dir.toString()));
            }
            VncFunction eventFn = Coerce.toVncFunction(args.second());
            VncFunction failFn = Coerce.toVncFunctionOptional(args.third());
            VncFunction termFn = Coerce.toVncFunctionOptional(args.fourth());
            Function<WatchEvent.Kind, VncKeyword> convert = event -> {
                switch (event.name()) {
                    case "ENTRY_CREATE": {
                        return new VncKeyword("created");
                    }
                    case "ENTRY_DELETE": {
                        return new VncKeyword("deleted");
                    }
                    case "ENTRY_MODIFY": {
                        return new VncKeyword("modified");
                    }
                }
                return new VncKeyword("unknown");
            };
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Consumer<Runnable> wrapper = runnable -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    runnable.run();
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            BiConsumer<Path, WatchEvent.Kind<?>> eventListener = (path, event) -> wrapper.accept(() -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(eventFn, new VncString(path.toString()), (VncVal)convert.apply((WatchEvent.Kind)event))));
            BiConsumer<Path, Exception> errorListener = failFn == null ? null : (path, ex) -> wrapper.accept(() -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(failFn, new VncString(path.toString()), new VncJavaObject(ex))));
            Consumer<Path> terminationListener = termFn == null ? null : path -> wrapper.accept(() -> ConcurrencyFunctions.future.applyOf(CoreFunctions.partial.applyOf(termFn, new VncString(path.toString()))));
            try {
                return new VncJavaObject(FileUtil.watchDir(dir.toPath(), eventListener, errorListener, terminationListener));
            }
            catch (IOException ex2) {
                throw new VncException(String.format("Function 'io/watch-dir' failed to watch dir '%s'", dir.toString()), ex2);
            }
        }
    };
    public static VncFunction io_close_watcher = new VncFunction("io/close-watcher", (VncVal)VncFunction.meta().arglists("(io/close-watcher watcher)").doc("Closes a watcher created from 'io/watch-dir'.").seeAlso("io/watch-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            WatchService ws = Coerce.toVncJavaObject(args.first(), WatchService.class);
            try {
                ws.close();
                return Constants.Nil;
            }
            catch (IOException ex) {
                throw new VncException("Function 'io/close-watcher' failed to close watch service", ex);
            }
        }
    };
    public static VncFunction io_delete_file = new VncFunction("io/delete-file", (VncVal)VncFunction.meta().arglists("(io/delete-file f & files)").doc("Deletes one or multiple files. Silently skips delete if the file does not exist. If f is a directory the directory must be empty. f must be a file or a string (file path)").seeAlso("io/delete-file-tree", "io/delete-file-on-exit", "io/copy-file", "io/move-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)f -> {
                try {
                    File file = IOFunctions.convertToFile(f, "Function 'io/delete-file' does not allow %s as f");
                    Files.deleteIfExists(file.toPath());
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to delete file %s", f.toString()), ex);
                }
            }));
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file_tree = new VncFunction("io/delete-file-tree", (VncVal)VncFunction.meta().arglists("(io/delete-file-tree f & files)").doc("Deletes a file or a directory with all its content. Silently skips delete if the file or directory does not exist. f must be a file or a string (file path)").seeAlso("io/delete-file", "io/delete-file-on-exit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            args.forEach((Consumer<? super VncVal>)((Consumer<VncVal>)f -> {
                File file = IOFunctions.convertToFile(f, "Function 'io/delete-file-tree' does not allow %s as f");
                if (file.isDirectory()) {
                    try {
                        Files.walk(file.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (Exception ex) {
                        throw new VncException(String.format("Failed to delete dir %s", file.toString()), ex);
                    }
                } else if (file.isFile()) {
                    file.delete();
                }
            }));
            return Constants.Nil;
        }
    };
    public static VncFunction io_delete_file_on_exit = new VncFunction("io/delete-file-on-exit", (VncVal)VncFunction.meta().arglists("(io/delete-file-on-exit f)").doc("Deletes a file f on JVM exit. f must be a file or a string (file path).").seeAlso("io/delete-file", "io/delete-file-tree").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File file = IOFunctions.convertToFile(args.first(), "Function 'io/delete-file-on-exit' does not allow %s as f");
            IOFunctions.validateReadableFile(file);
            try {
                file.deleteOnExit();
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to mark file %s to be deleted on exit", file.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_list_files = new VncFunction("io/list-files", (VncVal)VncFunction.meta().arglists("(io/list-files dir)", "(io/list-files dir filter-fn)").doc("Lists files in a directory. dir must be a file or a string (file path). filter-fn is an optional filter that filters the files found. The filter gets a java.io.File as argument. Returns files as java.io.File.\n\n(io/list-files \"/tmp\") \n(io/list-files \"/tmp\" #(io/file-ext? % \".log\"))").seeAlso("io/list-file-tree", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-files' does not allow %s as dir");
            IOFunctions.validateReadableDirectory(dir);
            try {
                VncFunction filterFn = args.size() == 2 ? Coerce.toVncFunction(args.second()) : null;
                ArrayList<VncJavaObject> files = new ArrayList<VncJavaObject>();
                for (File f : dir.listFiles()) {
                    if (filterFn != null && !VncBoolean.isTrue(filterFn.apply(VncList.of(new VncJavaObject(f))))) continue;
                    files.add(new VncJavaObject(f));
                }
                return VncList.ofList(files);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_list_file_tree = new VncFunction("io/list-file-tree", (VncVal)VncFunction.meta().arglists("(io/list-file-tree dir)", "(io/list-file-tree dir filter-fn)").doc("Lists all files in a directory tree. dir must be a file or a string (file path). filter-fn is an optional filter that filters the files found. The filter gets a java.io.File as argument. Returns files as java.io.File.\n\n(io/list-file-tree \"/tmp\") \n(io/list-file-tree \"/tmp\" #(io/file-ext? % \".log\"))").seeAlso("io/list-files", "io/list-files-glob").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-file-tree' does not allow %s as dir");
            IOFunctions.validateReadableDirectory(dir);
            try {
                VncFunction filterFn = args.size() == 2 ? Coerce.toVncFunction(args.second()) : null;
                ArrayList files = new ArrayList();
                Files.walk(dir.toPath(), new FileVisitOption[0]).map(Path::toFile).forEach(f -> {
                    if (filterFn == null || VncBoolean.isTrue(filterFn.apply(VncList.of(new VncJavaObject(f))))) {
                        files.add(new VncJavaObject(f));
                    }
                });
                return VncList.ofList(files);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_list_files_glob_pattern = new VncFunction("io/list-files-glob", (VncVal)VncFunction.meta().arglists("(io/list-files-glob dir glob)").doc("Lists all files in a directory that match the glob pattern. dir must be a file or a string (file path). Returns files as java.io.File.\n\n(io/list-files-glob \".\" \"sample*.txt\".").seeAlso("io/list-files", "io/list-file-tree").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/list-files-glob' does not allow %s as dir");
            String glob = Coerce.toVncString(args.second()).getValue();
            IOFunctions.validateReadableDirectory(dir);
            try {
                ArrayList files = new ArrayList();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir.toPath(), glob);){
                    dirStream.forEach(path -> files.add(new VncJavaObject(path.toFile())));
                }
                return VncList.ofList(files);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to list files %s", dir.getPath()), ex);
            }
        }
    };
    public static VncFunction io_copy_file = new VncFunction("io/copy-file", (VncVal)VncFunction.meta().arglists("(io/copy-file source dest & options)").doc("Copies source to dest. Returns nil or throws IOException. Source must be a file or a string (file path), dest must be a file, a string (file path), or an OutputStream.\n\nOptions: \n  :replace true/false - e.g if true replace an aexistiong file, defaults to false").seeAlso("io/move-file", "io/delete-file", "io/copy-stream").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            VncHashMap options = VncHashMap.ofAll(args.rest().rest());
            VncVal replaceOpt = options.get(new VncKeyword("replace"));
            File source = IOFunctions.convertToFile(args.first(), "Function 'io/copy-file' does not allow %s as source");
            IOFunctions.validateReadableFile(source);
            VncVal destVal = args.second();
            if (Types.isVncString(destVal) || Types.isVncJavaObject(destVal, File.class)) {
                File dest = Types.isVncString(destVal) ? new File(Coerce.toVncString(destVal).getValue()) : Coerce.toVncJavaObject(destVal, File.class);
                ArrayList<StandardCopyOption> copyOptions = new ArrayList<StandardCopyOption>();
                if (VncBoolean.isTrue(replaceOpt)) {
                    copyOptions.add(StandardCopyOption.REPLACE_EXISTING);
                }
                try {
                    if (dest.isDirectory()) {
                        Files.copy(source.toPath(), dest.toPath().resolve(source.getName()), copyOptions.toArray(new CopyOption[0]));
                    }
                    Files.copy(source.toPath(), dest.toPath(), copyOptions.toArray(new CopyOption[0]));
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to %s", source.getPath(), dest.getPath()), ex);
                }
            } else if (Types.isVncJavaObject(destVal, OutputStream.class)) {
                OutputStream os = (OutputStream)((VncJavaObject)destVal).getDelegate();
                try {
                    IOStreamUtil.copyFileToOS(source, os);
                }
                catch (Exception ex) {
                    throw new VncException(String.format("Failed to copy file %s to stream", source.getPath()), ex);
                }
            } else {
                throw new VncException(String.format("Function 'io/copy-file' does not allow %s as dest", Types.getType(destVal)));
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_move_file = new VncFunction("io/move-file", (VncVal)VncFunction.meta().arglists("(io/move-file source target)").doc("Moves source to target. Returns nil or throws IOException. Source and target must be a file or a string (file path).").seeAlso("io/copy-file", "io/delete-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            File from = IOFunctions.convertToFile(args.first(), "Function 'io/move-file' does not allow %s as source");
            File to = IOFunctions.convertToFile(args.second(), "Function 'io/move-file' does not allow %s as target");
            IOFunctions.validateReadableFile(from);
            try {
                Files.move(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to move file %s to %s", from.getPath(), to.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_mkdir = new VncFunction("io/mkdir", (VncVal)VncFunction.meta().arglists("(io/mkdir dir)").doc("Creates the directory. dir must be a file or a string (file path).").seeAlso("io/mkdirs").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/mkdir' does not allow %s as dir");
            try {
                dir.mkdir();
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create dir %s", dir.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_mkdirs = new VncFunction("io/mkdirs", (VncVal)VncFunction.meta().arglists("(io/mkdirs dir)").doc("Creates the directory including any necessary but nonexistent parent directories. dir must be a file or a string (file path).").seeAlso("io/mkdir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            File dir = IOFunctions.convertToFile(args.first(), "Function 'io/mkdirs' does not allow %s as dir");
            try {
                dir.mkdirs();
            }
            catch (Exception ex) {
                throw new VncException(String.format("Failed to create dir %s", dir.getPath()), ex);
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_tmp_dir = new VncFunction("io/tmp-dir", (VncVal)VncFunction.meta().arglists("(io/tmp-dir)").doc("Returns the tmp dir as a java.io.File.").examples("(io/tmp-dir )").seeAlso("io/user-dir", "io/user-home-dir", "io/temp-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("java.io.tmpdir")));
        }
    };
    public static VncFunction io_user_dir = new VncFunction("io/user-dir", (VncVal)VncFunction.meta().arglists("(io/user-dir)").doc("Returns the user dir (current working dir) as a java.io.File.").seeAlso("io/tmp-dir", "io/user-home-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.dir")));
        }
    };
    public static VncFunction io_user_home_dir = new VncFunction("io/user-home-dir", (VncVal)VncFunction.meta().arglists("(io/user-home-dir)").doc("Returns the user's home dir as a java.io.File.").seeAlso("io/user-dir", "io/tmp-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            this.sandboxFunctionCallValidation();
            return new VncJavaObject(new File(System.getProperty("user.home")));
        }
    };
    public static VncFunction io_slurp_lines = new VncFunction("io/slurp-lines", (VncVal)VncFunction.meta().arglists("(io/slurp-lines f & options)").doc("Read all lines from f. f may be a file, a string file path, a Java InputStream, or a Java Reader. \n\nOptions: \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").seeAlso("io/slurp", "io/slurp-stream", "io/spit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                VncVal arg = args.first();
                VncHashMap options = VncHashMap.ofAll(args.rest());
                if (Types.isVncString(arg) || Types.isVncJavaObject(arg, File.class)) {
                    File file = Types.isVncString(arg) ? new File(((VncString)arg).getValue()) : (File)Coerce.toVncJavaObject(args.first()).getDelegate();
                    IOFunctions.validateReadableFile(file);
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    String encoding = IOFunctions.encoding(encVal);
                    List lines = Files.readAllLines(file.toPath(), Charset.forName(encoding)).stream().map(s -> new VncString((String)s)).collect(Collectors.toList());
                    return VncList.ofList(lines);
                }
                if (Types.isVncJavaObject(arg, InputStream.class)) {
                    InputStream is = (InputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    String encoding = IOFunctions.encoding(encVal);
                    try (BufferedReader rd = new BufferedReader(new InputStreamReader(is, encoding));){
                        VncList vncList = VncList.ofList(rd.lines().map(s -> new VncString((String)s)).collect(Collectors.toList()));
                        return vncList;
                    }
                }
                if (!Types.isVncJavaObject(arg, Reader.class)) {
                    throw new VncException(String.format("Function 'io/slurp-lines' does not allow %s as f", Types.getType(args.first())));
                }
                Reader rd = (Reader)Coerce.toVncJavaObject(args.first()).getDelegate();
                try (BufferedReader brd = new BufferedReader(rd);){
                    VncList vncList = VncList.ofList(brd.lines().map(s -> new VncString((String)s)).collect(Collectors.toList()));
                    return vncList;
                }
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_slurp = new VncFunction("io/slurp", (VncVal)VncFunction.meta().arglists("(io/slurp f & options)").doc("Reads the content of file f as text (string) or binary (bytebuf). f may be a file, a string file path, a Java InputStream, or a Java Reader. \n\nOptions: \n  :binary true/false - e.g :binary true, defaults to false \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").seeAlso("io/slurp-lines", "io/slurp-stream", "io/spit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                VncVal arg = args.first();
                VncHashMap options = VncHashMap.ofAll(args.rest());
                VncVal binary = options.get(new VncKeyword("binary"));
                if (Types.isVncString(arg) || Types.isVncJavaObject(arg, File.class)) {
                    File file = Types.isVncString(arg) ? new File(((VncString)arg).getValue()) : (File)Coerce.toVncJavaObject(args.first()).getDelegate();
                    IOFunctions.validateReadableFile(file);
                    if (VncBoolean.isTrue(binary)) {
                        byte[] data = Files.readAllBytes(file.toPath());
                        return new VncByteBuffer(ByteBuffer.wrap(data));
                    }
                    VncVal encVal = options.get(new VncKeyword("encoding"));
                    String encoding = IOFunctions.encoding(encVal);
                    byte[] data = Files.readAllBytes(file.toPath());
                    return new VncString(new String(data, encoding));
                }
                if (Types.isVncJavaObject(arg, InputStream.class)) {
                    VncVal vncVal;
                    InputStream is = (InputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                    if (!VncBoolean.isTrue(binary)) {
                        VncVal encVal = options.get(new VncKeyword("encoding"));
                        String encoding = IOFunctions.encoding(encVal);
                        return new VncString(IOStreamUtil.copyIStoString(is, encoding));
                    }
                    byte[] data = IOStreamUtil.copyIStoByteArray(is);
                    if (data == null) {
                        vncVal = Constants.Nil;
                        return vncVal;
                    }
                    vncVal = new VncByteBuffer(ByteBuffer.wrap(data));
                    return vncVal;
                }
                if (!Types.isVncJavaObject(arg, Reader.class)) {
                    throw new VncException(String.format("Function 'io/slurp' does not allow %s as f", Types.getType(args.first())));
                }
                Reader rd = (Reader)Coerce.toVncJavaObject(args.first()).getDelegate();
                try (BufferedReader brd = new BufferedReader(rd);){
                    String s = brd.lines().collect(Collectors.joining(System.lineSeparator()));
                    if (VncBoolean.isTrue(binary)) {
                        VncVal encVal = options.get(new VncKeyword("encoding"));
                        String encoding = IOFunctions.encoding(encVal);
                        VncByteBuffer vncByteBuffer = new VncByteBuffer(s.getBytes(encoding));
                        return vncByteBuffer;
                    }
                    VncString vncString = new VncString(s);
                    return vncString;
                }
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_spit = new VncFunction("io/spit", (VncVal)VncFunction.meta().arglists("(io/spit f content & options)").doc("Opens file f, writes content, and then closes f. f may be a file or a string (file path). The content may be a string or a bytebuf.\n\nOptions: \n  :append true/false - e.g :append true, defaults to false \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").seeAlso("io/spit-stream", "io/slurp", "io/slurp-lines").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            try {
                byte[] data;
                File file = IOFunctions.convertToFile(args.first(), "Function 'io/spit' does not allow %s as f");
                VncVal content = args.second();
                VncHashMap options = VncHashMap.ofAll(args.slice(2));
                VncVal append = options.get(new VncKeyword("append"));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = IOFunctions.encoding(encVal);
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getBytes();
                } else {
                    throw new VncException(String.format("Function 'io/spit' does not allow %s as content", Types.getType(content)));
                }
                ArrayList<StandardOpenOption> openOptions = new ArrayList<StandardOpenOption>();
                openOptions.add(StandardOpenOption.CREATE);
                openOptions.add(StandardOpenOption.WRITE);
                openOptions.add(VncBoolean.isTrue(append) ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
                Files.write(file.toPath(), data, openOptions.toArray(new OpenOption[0]));
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_download = new VncFunction("io/download", (VncVal)VncFunction.meta().arglists("(io/download uri & options)").doc("Downloads the content from the uri and reads it as text (string) or binary (bytebuf). \n\nOptions: \n  :binary true/false - e.g :binary true, defaults to false \n  :user-agent agent  - e.g :user-agent \"Mozilla\", defaults to nil \n  :encoding enc      - e.g :encoding :utf-8, defaults to :utf-8\n  :conn-timeout val  - e.g :conn-timeout 10000, \n                           connection timeout in milli seconds. \n                           0 is interpreted as an infinite timeout. \n  :read-timeout val  - e.g :read-timeout 10000, \n                           read timeout in milli seconds. \n                           0 is interpreted as an infinite timeout. \n  :progress-fn fn    - a progress function that takes 2 args \n                           [1] progress (0..100%) \n                           [2] status {:start :progress :end :failed}\n\nIf the server returns a 403 (access denied) sending a user-agent\nmay fool the website.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        /*
         * Exception decompiling
         */
        @Override
        public VncVal apply(VncList args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    };
    public static VncFunction io_internet_avail_Q = new VncFunction("io/internet-avail?", (VncVal)VncFunction.meta().arglists("(io/internet-avail?)", "(internet-avail? url)").doc("Checks if an internet connection is present for a given url. Defaults to URL http://www.google.com.").examples("(io/internet-avail? \"http://www.google.com\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0, 1);
            String sUrl = args.isEmpty() ? "http://www.google.com" : Coerce.toVncString(args.first()).getValue();
            try {
                URL url = new URL(sUrl);
                URLConnection connection = url.openConnection();
                connection.setConnectTimeout(3000);
                connection.connect();
                connection.getInputStream().close();
                return VncBoolean.True;
            }
            catch (Exception e) {
                return VncBoolean.False;
            }
        }
    };
    public static VncFunction io_copy_stream = new VncFunction("io/copy-stream", (VncVal)VncFunction.meta().arglists("(io/copy-file in-stream out-stream)").doc("Copies input stream to an output stream. Returns nil or throws IOException. Input and output must be a java.io.InputStream and java.io.OutputStream.").seeAlso("io/copy-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            Object is = Coerce.toVncJavaObject(args.first()).getDelegate();
            Object os = Coerce.toVncJavaObject(args.second()).getDelegate();
            if (!(is instanceof InputStream)) {
                throw new VncException(String.format("Function 'io/copy-stream' does not allow %s as in-stream", Types.getType(args.first())));
            }
            if (!(os instanceof OutputStream)) {
                throw new VncException(String.format("Function 'io/copy-stream' does not allow %s as out-stream", Types.getType(args.second())));
            }
            try {
                IOStreamUtil.copy((InputStream)is, (OutputStream)os);
            }
            catch (Exception ex) {
                throw new VncException("Failed to copy stream");
            }
            return Constants.Nil;
        }
    };
    public static VncFunction io_slurp_stream = new VncFunction("io/slurp-stream", (VncVal)VncFunction.meta().arglists("(io/slurp-stream is & options)").doc("Slurps binary or string data from a Java InputStream is. Supports the option :binary to either slurp binary or string data. For string data an optional encoding can be specified.\n\nOptions: \n  :binary true/false - e.g :binary true, defaults to false \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").examples("(do \n   (import :java.io.FileInputStream) \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/delete-file-on-exit file) \n        (io/spit file \"123456789\" :append true) \n        (try-with [is (. :FileInputStream :new file)] \n           (io/slurp-stream is :binary false))) \n)").seeAlso("io/slurp", "io/slurp-lines", "io/spit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            try {
                InputStream is = (InputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncHashMap options = VncHashMap.ofAll(args.rest());
                VncVal binary = options.get(new VncKeyword("binary"));
                if (VncBoolean.isTrue(binary)) {
                    byte[] data = IOStreamUtil.copyIStoByteArray(is);
                    return data == null ? Constants.Nil : new VncByteBuffer(ByteBuffer.wrap(data));
                }
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : Coerce.toVncString(encVal).getValue();
                return new VncString(IOStreamUtil.copyIStoString(is, encoding));
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_spit_stream = new VncFunction("io/spit-stream", (VncVal)VncFunction.meta().arglists("(io/spit-stream os content & options)").doc("Writes content (string or bytebuf) to the Java OutputStream os. If content is of type string an optional encoding (defaults to UTF-8) is supported. The stream can optionally be flushed after the operation.\n\nOptions: \n  :flush true/false - e.g :flush true, defaults to false \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").examples("(do \n   (import :java.io.FileOutputStream) \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/delete-file-on-exit file) \n        (try-with [os (. :FileOutputStream :new file)] \n           (io/spit-stream os \"123456789\" :flush true))) \n)").seeAlso("io/spit").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            try {
                byte[] data;
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncVal content = args.second();
                VncHashMap options = VncHashMap.ofAll(args.slice(2));
                VncVal encVal = options.get(new VncKeyword("encoding"));
                String encoding = encVal == Constants.Nil ? "UTF-8" : ((VncString)encVal).getValue();
                VncVal flushVal = options.get(new VncKeyword("flush"));
                boolean flush = VncBoolean.isTrue(flushVal);
                if (Types.isVncString(content)) {
                    data = ((VncString)content).getValue().getBytes(encoding);
                } else if (Types.isVncByteBuffer(content)) {
                    data = ((VncByteBuffer)content).getBytes();
                } else {
                    throw new VncException(String.format("Function 'spit-stream' does not allow %s as content", Types.getType(content)));
                }
                os.write(data);
                if (flush) {
                    os.flush();
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_uri_stream = new VncFunction("io/uri-stream", (VncVal)VncFunction.meta().arglists("(io/uri-stream uri)").doc("Returns a Java InputStream from the uri.").examples("(-> (io/uri-stream \"https://www.w3schools.com/xml/books.xml\") \n    (io/slurp-stream :binary false :encoding :utf-8))             ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String uri = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncJavaObject(new URL(uri).openStream());
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_wrap_os_with_buffered_writer = new VncFunction("io/wrap-os-with-buffered-writer", (VncVal)VncFunction.meta().arglists("(io/wrap-os-with-buffered-writer os encoding?)").doc("Wraps an OutputStream os with a BufferedWriter using an optional encoding (defaults to :utf-8).").examples("(do                                                         \n   (import :java.io.ByteArrayOutputStream)                  \n   (let [os (. :ByteArrayOutputStream :new)                 \n         wr (io/wrap-os-with-buffered-writer os :utf-8)]    \n      (. wr :write \"line 1\")                              \n      (. wr :newLine)                                       \n      (. wr :write \"line 2\")                              \n      (. wr :flush)                                         \n      (. os :toByteArray)))                                   ").seeAlso("io/wrap-os-with-print-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                String encoding = args.size() == 1 ? "UTF-8" : ((VncString)args.second()).getValue();
                return new VncJavaObject(new BufferedWriter(new OutputStreamWriter(os, encoding)));
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_wrap_os_with_print_writer = new VncFunction("io/wrap-os-with-print-writer", (VncVal)VncFunction.meta().arglists("(io/wrap-os-with-print-writer os encoding?)").doc("Wraps an OutputStream os with a PrintWriter using an optional encoding (defaults to :utf-8).").examples("(do                                                      \n   (import :java.io.ByteArrayOutputStream)               \n   (let [os (. :ByteArrayOutputStream :new)              \n         wr (io/wrap-os-with-print-writer os :utf-8)]    \n      (. wr :println \"line 1\")                         \n      (. wr :println \"line 2\")                         \n      (. wr :flush)                                      \n      (. os :toByteArray)))                                ").seeAlso("io/wrap-os-with-buffered-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            try {
                OutputStream os = (OutputStream)Coerce.toVncJavaObject(args.first()).getDelegate();
                String encoding = args.size() == 1 ? "UTF-8" : ((VncString)args.second()).getValue();
                return new VncJavaObject(new PrintWriter(new OutputStreamWriter(os, encoding)));
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_wrap_is_with_buffered_reader = new VncFunction("io/wrap-is-with-buffered-reader", (VncVal)VncFunction.meta().arglists("(io/wrap-is-with-buffered-reader is encoding?)").doc("Wraps an InputStream is with a BufferedReader using an optional encoding (defaults to :utf-8).").examples("(do                                                                          \n   (import :java.io.ByteArrayInputStream)                                    \n   (let [data (byte-array [108 105 110 101 32 49 10 108 105 110 101 32 50])  \n         is (. :ByteArrayInputStream :new data)                              \n         rd (io/wrap-is-with-buffered-reader is :utf-8)]                     \n      (println (. rd :readLine))                                             \n      (println (. rd :readLine))))                                             ").seeAlso("io/buffered-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncJavaObject(args.first()) && (delegate = ((VncJavaObject)args.first()).getDelegate()) instanceof InputStream) {
                try {
                    InputStream is = (InputStream)delegate;
                    String encoding = args.size() == 1 ? "UTF-8" : ((VncString)args.second()).getValue();
                    return new VncJavaObject(new BufferedReader(new InputStreamReader(is, encoding)));
                }
                catch (Exception ex) {
                    throw new VncException(ex.getMessage(), ex);
                }
            }
            throw new VncException(String.format("Function 'io/wrap-is-with-buffered-reader' requires an InputStream or a Reader. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_buffered_reader = new VncFunction("io/buffered-reader", (VncVal)VncFunction.meta().arglists("(io/buffered-reader is encoding?)", "(io/buffered-reader rdr)").doc("Creates a BufferedReader from an InputStream is with optional encoding (defaults to :utf-8), from a Reader or from a string.").examples("(do                                                                          \n   (import :java.io.ByteArrayInputStream)                                    \n   (let [data (byte-array [108 105 110 101 32 49 10 108 105 110 101 32 50])  \n         is (. :ByteArrayInputStream :new data)                              \n         rd (io/buffered-reader is :utf-8)]                                  \n      (println (. rd :readLine))                                             \n      (println (. rd :readLine))))                                             ", "(do                                                                          \n   (let [rd (io/buffered-reader \"1\\n2\\n3\\n4\")]                          \n      (println (. rd :readLine))                                             \n      (println (. rd :readLine))))                                             ").seeAlso("io/buffered-writer").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncString(args.first())) {
                return new VncJavaObject(new BufferedReader(new StringReader(((VncString)args.first()).getValue())));
            }
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof InputStream) {
                    try {
                        InputStream is = (InputStream)delegate;
                        String encoding = args.size() == 1 ? "UTF-8" : ((VncString)args.second()).getValue();
                        return new VncJavaObject(new BufferedReader(new InputStreamReader(is, encoding)));
                    }
                    catch (Exception ex) {
                        throw new VncException(ex.getMessage(), ex);
                    }
                }
                if (delegate instanceof BufferedReader) {
                    return args.first();
                }
                if (delegate instanceof Reader) {
                    return new VncJavaObject(new BufferedReader((Reader)delegate));
                }
            }
            throw new VncException(String.format("Function 'io/buffered-reader' requires an InputStream, a Reader, or a string. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_buffered_writer = new VncFunction("io/buffered-writer", (VncVal)VncFunction.meta().arglists("(io/buffered-writer os encoding?)", "(io/buffered-writer wr)").doc("Creates a BufferedWriter from an OutputStream os with optional encoding (defaults to :utf-8) or from a Writer.").examples(new String[0]).seeAlso("io/buffered-reader").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1, 2);
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof OutputStream) {
                    try {
                        OutputStream os = (OutputStream)delegate;
                        String encoding = args.size() == 1 ? "UTF-8" : ((VncString)args.second()).getValue();
                        return new VncJavaObject(new BufferedWriter(new OutputStreamWriter(os, encoding)));
                    }
                    catch (Exception ex) {
                        throw new VncException(ex.getMessage(), ex);
                    }
                }
                if (delegate instanceof BufferedWriter) {
                    return args.first();
                }
                if (delegate instanceof Writer) {
                    return new VncJavaObject(new BufferedWriter((Writer)delegate));
                }
            }
            throw new VncException(String.format("Function 'io/buffered-writer' requires an OutputStream or a Writer. %s as is not allowed!", Types.getType(args.first())));
        }
    };
    public static VncFunction io_mime_type = new VncFunction("io/mime-type", (VncVal)VncFunction.meta().arglists("(io/mime-type file)").doc("Returns the mime-type for the file if available else nil.").examples("(io/mime-type \"document.pdf\")", "(io/mime-type (io/file \"document.pdf\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertMinArity(this, args, 1);
            VncVal file = args.first();
            if (Types.isVncString(file)) {
                return new VncString(MimeTypes.getMimeTypeFromFileName(((VncString)file).getValue()));
            }
            if (Types.isVncJavaObject(file, File.class)) {
                return new VncString(MimeTypes.getMimeTypeFromFile((File)Coerce.toVncJavaObject(file).getDelegate()));
            }
            throw new VncException(String.format("Function 'io/mime-type' does not allow %s as fs", Types.getType(file)));
        }
    };
    public static VncFunction io_temp_file = new VncFunction("io/temp-file", (VncVal)VncFunction.meta().arglists("(io/temp-file prefix suffix)").doc("Creates an empty temp file with prefix and suffix.").examples("(do \n   (let [file (io/temp-file \"test-\", \".txt\")] \n        (io/spit file \"123456789\" :append true) \n        (io/slurp file :binary false :remove true)) \n)").seeAlso("io/temp-dir").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 2);
            this.sandboxFunctionCallValidation();
            String prefix = Coerce.toVncString(args.first()).getValue();
            String suffix = Coerce.toVncString(args.second()).getValue();
            try {
                return new VncString(Files.createTempFile(prefix, suffix, new FileAttribute[0]).normalize().toString());
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_temp_dir = new VncFunction("io/temp-dir", (VncVal)VncFunction.meta().arglists("(io/temp-dir prefix)").doc("Creates a temp directory with prefix.").examples("(io/temp-dir \"test-\")").seeAlso("io/tmp-dir", "io/temp-file").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 1);
            this.sandboxFunctionCallValidation();
            String prefix = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncString(Files.createTempDirectory(prefix, new FileAttribute[0]).normalize().toString());
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_load_classpath_resource = new VncFunction("io/load-classpath-resource", (VncVal)VncFunction.meta().arglists("(io/load-classpath-resource name)").doc("Loads a classpath resource. Returns a bytebuf").examples("(io/load-classpath-resource \"org/foo/images/foo.png\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                ArityExceptions.assertArity(this, args, 1);
                this.sandboxFunctionCallValidation();
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String res = ((VncString)args.first()).getValue();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncKeyword(name)) {
                    String res = ((VncKeyword)args.first()).getValue();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                if (Types.isVncSymbol(name)) {
                    String res = ((VncSymbol)args.first()).getName();
                    byte[] data = JavaInterop.getInterceptor().onLoadClassPathResource(res);
                    return data == null ? Constants.Nil : new VncByteBuffer(data);
                }
                return Constants.Nil;
            }
            catch (SecurityException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException(ex.getMessage(), ex);
            }
        }
    };
    public static VncFunction io_classpath_resource_Q = new VncFunction("io/classpath-resource?", (VncVal)VncFunction.meta().arglists("(io/classpath-resource? name)").doc("Returns true if the classpath resource exists otherwise false.").examples("(io/classpath-resource? \"org/foo/images/foo.png\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            try {
                ArityExceptions.assertArity(this, args, 1);
                VncVal name = args.first();
                if (Types.isVncString(name)) {
                    String path = ((VncString)args.first()).getValue();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                if (Types.isVncKeyword(name)) {
                    String path = ((VncKeyword)args.first()).getValue();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                if (Types.isVncSymbol(name)) {
                    String path = ((VncSymbol)args.first()).getName();
                    return VncBoolean.of(new ClassPathResource(path).getResource() != null);
                }
                return VncBoolean.False;
            }
            catch (Exception ex) {
                return VncBoolean.False;
            }
        }
    };
    public static VncFunction io_default_charset = new VncFunction("io/default-charset", (VncVal)VncFunction.meta().arglists("(io/default-charset)").doc("Returns the default charset.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            ArityExceptions.assertArity(this, args, 0);
            return new VncString(Charset.defaultCharset().name());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(io_file).add(io_file_Q).add(io_file_path).add(io_file_canonical_path).add(io_file_absolute_path).add(io_file_parent).add(io_file_name).add(io_file_ext_Q).add(io_file_size).add(io_exists_file_Q).add(io_exists_dir_Q).add(io_file_can_read_Q).add(io_file_can_write_Q).add(io_file_can_execute_Q).add(io_file_hidden_Q).add(io_await_for).add(io_watch_dir).add(io_close_watcher).add(io_list_files).add(io_list_file_tree).add(io_list_files_glob_pattern).add(io_delete_file).add(io_delete_file_on_exit).add(io_delete_file_tree).add(io_copy_file).add(io_move_file).add(io_mkdir).add(io_mkdirs).add(io_temp_file).add(io_temp_dir).add(io_tmp_dir).add(io_user_dir).add(io_user_home_dir).add(io_slurp).add(io_slurp_lines).add(io_spit).add(io_download).add(io_internet_avail_Q).add(io_copy_stream).add(io_slurp_stream).add(io_spit_stream).add(io_uri_stream).add(io_wrap_os_with_buffered_writer).add(io_wrap_os_with_print_writer).add(io_wrap_is_with_buffered_reader).add(io_buffered_reader).add(io_buffered_writer).add(io_mime_type).add(io_default_charset).add(io_load_classpath_resource).add(io_classpath_resource_Q).toMap();

    public static String encoding(VncVal enc) {
        return enc == Constants.Nil ? "UTF-8" : (Types.isVncKeyword(enc) ? Coerce.toVncKeyword(enc).getValue() : Coerce.toVncString(enc).getValue());
    }

    public static File convertToFile(VncVal f, String errFormat) {
        if (Types.isVncString(f)) {
            return new File(((VncString)f).getValue());
        }
        if (Types.isVncJavaObject(f, File.class)) {
            return (File)((VncJavaObject)f).getDelegate();
        }
        if (Types.isVncJavaObject(f, Path.class)) {
            return ((Path)((VncJavaObject)f).getDelegate()).toFile();
        }
        throw new VncException(String.format(errFormat, Types.getType(f)));
    }

    public static void validateReadableFile(File file) {
        if (!file.isFile()) {
            throw new VncException(String.format("'%s' is not a file", file.getPath()));
        }
        if (!file.canRead()) {
            throw new VncException(String.format("The file '%s' has no read permission", file.getPath()));
        }
    }

    public static void validateReadableDirectory(File file) {
        if (!file.isDirectory()) {
            throw new VncException(String.format("'%s' is not a directory", file.getPath()));
        }
        if (!file.canRead()) {
            throw new VncException(String.format("The directory '%s' has no read permission", file.getPath()));
        }
    }

    private static void updateDownloadProgress(VncFunction fn, long percentage, VncKeyword status) {
        try {
            fn.apply(VncList.of(new VncLong(percentage), status));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static TimeUnit toTimeUnit(VncKeyword unit) {
        switch (unit.getValue()) {
            case "milliseconds": {
                return TimeUnit.MILLISECONDS;
            }
            case "seconds": {
                return TimeUnit.SECONDS;
            }
            case "minutes": {
                return TimeUnit.MINUTES;
            }
            case "hours": {
                return TimeUnit.HOURS;
            }
            case "days": {
                return TimeUnit.DAYS;
            }
        }
        throw new VncException("Invalid time-unit " + unit.getValue() + ". Use one of {:milliseconds, :seconds, :minutes, :hours, :days}");
    }

    static /* synthetic */ void access$100(VncFunction x0, long x1, VncKeyword x2) {
        IOFunctions.updateDownloadProgress(x0, x1, x2);
    }
}

