/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.INamespaceAware;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ArityExceptions;
import java.util.Arrays;
import java.util.List;

public class VncKeyword
extends VncString
implements IVncFunction,
INamespaceAware {
    public static final VncKeyword TYPE = new VncKeyword(":core/keyword");
    private static final long serialVersionUID = -1848883965231344442L;
    private final String qualifiedName;
    private final String simpleName;
    private final String namespace;

    public VncKeyword(String v) {
        this(VncKeyword.parse(v), (VncVal)Constants.Nil);
    }

    public VncKeyword(String v, VncVal meta) {
        this(VncKeyword.parse(v), meta);
    }

    private VncKeyword(String namespace, String simpleName, String qualifiedName, VncVal meta) {
        super(qualifiedName, meta);
        this.namespace = namespace;
        this.simpleName = simpleName;
        this.qualifiedName = qualifiedName;
    }

    private VncKeyword(String[] elements, VncVal meta) {
        super(elements[2], meta);
        this.namespace = elements[0];
        this.simpleName = elements[1];
        this.qualifiedName = elements[2];
    }

    private VncKeyword(VncKeyword other, VncVal meta) {
        super(other.qualifiedName, meta);
        this.qualifiedName = other.qualifiedName;
        this.simpleName = other.simpleName;
        this.namespace = other.namespace;
    }

    private static String[] parse(String name) {
        String qn = name.charAt(0) == ':' ? name.substring(1) : name;
        int pos = qn.indexOf("/");
        String namespace = pos <= 0 ? null : qn.substring(0, pos);
        String simpleName = pos < 0 ? qn : qn.substring(pos + 1);
        String qualifiedName = namespace == null ? simpleName : namespace + "/" + simpleName;
        return new String[]{namespace, simpleName, qualifiedName};
    }

    @Override
    public VncVal apply(VncList args) {
        ArityExceptions.assertArity(this, ArityExceptions.FnType.Keyword, args, 1, 2);
        VncVal first = args.first();
        if (first == Constants.Nil) {
            return args.second();
        }
        if (Types.isVncMap(first)) {
            VncMap map = (VncMap)first;
            if (args.size() == 1) {
                return map.get(this);
            }
            if (VncBoolean.isTrue(map.containsKey(this))) {
                return map.get(this);
            }
            return args.second();
        }
        if (Types.isVncSet(first)) {
            VncSet set = (VncSet)first;
            if (args.size() == 1) {
                return set.contains(this) ? this : Constants.Nil;
            }
            if (set.contains(this)) {
                return this;
            }
            return args.second();
        }
        throw new VncException(String.format("keyword as function does not allow arg %s.", Types.getType(first)));
    }

    @Override
    public VncList getArgLists() {
        return VncList.of(new VncString("(keyword map)"), new VncString("(keyword map default-val)"));
    }

    @Override
    public VncKeyword withMeta(VncVal meta) {
        return new VncKeyword(this, meta);
    }

    public VncKeyword withNamespace(VncSymbol namespace) {
        if (Types.isJavaTypeReference(this)) {
            return this;
        }
        if (namespace.hasNamespace()) {
            throw new VncException(String.format("A namespace '%s' must not be qualified with an other namespace", namespace));
        }
        return this.withNamespace(namespace.getName());
    }

    public VncKeyword withNamespace(String namespace) {
        if (this.hasNamespace()) {
            throw new VncException(String.format("The keyword '%s' is already qualified with a namespace", this.qualifiedName));
        }
        boolean emptyNS = namespace == null || namespace.isEmpty();
        return new VncKeyword(emptyNS ? null : namespace, this.simpleName, emptyNS ? this.simpleName : namespace + "/" + this.simpleName, this.getMeta());
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncString.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncString.TYPE, VncVal.TYPE);
    }

    @Override
    public String getValue() {
        return this.qualifiedName;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public VncSymbol toSymbol() {
        return new VncSymbol(this.qualifiedName);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.KEYWORD;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncKeyword(o)) {
            return this.qualifiedName.compareTo(((VncKeyword)o).qualifiedName);
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.qualifiedName.equals(((VncKeyword)obj).qualifiedName);
    }

    @Override
    public String toString() {
        return ":" + this.getValue();
    }

    @Override
    public String toString(boolean print_readably) {
        return this.toString();
    }

    public boolean hasValue(String value) {
        return value != null && value.contentEquals(this.getValue());
    }
}

