/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.vavr.Streams;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.repackage.io.vavr.control.Option;

public class VncLazySeq
extends VncSequence {
    public static final VncKeyword TYPE = new VncKeyword(":core/lazyseq");
    private static final long serialVersionUID = -1848883965231344442L;
    private final org.repackage.io.vavr.collection.Stream<VncVal> value;

    public VncLazySeq(VncVal meta) {
        this(org.repackage.io.vavr.collection.Stream.empty(), meta);
    }

    public VncLazySeq(org.repackage.io.vavr.collection.Stream<VncVal> stream, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = stream;
    }

    public static VncLazySeq continually(VncFunction fn, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.continually(() -> fn.apply(VncList.empty())), meta);
    }

    public static VncLazySeq iterate(VncFunction fn, VncVal meta) {
        return new VncLazySeq(Streams.iterate(() -> VncLazySeq.toOptional(fn.apply(VncList.empty()))), meta);
    }

    public static VncLazySeq iterate(VncVal seed, VncFunction fn, VncVal meta) {
        return new VncLazySeq(Streams.iterate(seed, (? super T v) -> VncLazySeq.toOptional(fn.apply(VncList.of(v)))), meta);
    }

    public static VncLazySeq cons(VncVal head, VncFunction tailFn, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.cons(head, () -> {
            VncVal v = tailFn.apply(VncList.empty());
            return v == Constants.Nil ? org.repackage.io.vavr.collection.Stream.empty() : ((VncLazySeq)v).lazyStream();
        }), meta);
    }

    public static VncLazySeq cons(VncVal head, VncLazySeq tail, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.cons(head, () -> tail.value), meta);
    }

    public static VncLazySeq ofAll(VncList list, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.ofAll(list.stream()), meta);
    }

    public static VncLazySeq ofAll(VncVector list, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.ofAll(list.stream()), meta);
    }

    public static VncLazySeq fill(int n, VncFunction fn, VncVal meta) {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.fill(n, () -> fn.apply(VncList.empty())), meta);
    }

    public org.repackage.io.vavr.collection.Stream<VncVal> lazyStream() {
        return this.value;
    }

    public VncLazySeq scanLeft(VncVal zero, VncFunction fn, VncVal meta) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.scanLeft(zero, (u, v) -> fn.apply(VncList.of(u, v))), meta);
    }

    @Override
    public VncLazySeq emptyWithMeta() {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.empty(), this.getMeta());
    }

    @Override
    public VncLazySeq withVariadicValues(VncVal ... replaceVals) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq withValues(List<? extends VncVal> replaceVals) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq withMeta(VncVal meta) {
        return new VncLazySeq(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSequence.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSequence.TYPE, VncVal.TYPE);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.toJavaStream();
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.value.forEach((? super T v) -> action.accept((VncVal)v));
    }

    @Override
    public VncLazySeq filter(Predicate<? super VncVal> predicate) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.filter(predicate), this.getMeta());
    }

    @Override
    public VncLazySeq map(Function<? super VncVal, ? extends VncVal> mapper) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.map(mapper), this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        return this.value.asJava();
    }

    @Override
    public int size() {
        throw new VncException("Getting the size of lazy sequences is not supported");
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public VncVal nth(int idx) {
        return this.value.get(idx);
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        try {
            return this.value.get(idx);
        }
        catch (IndexOutOfBoundsException ex) {
            return defaultVal;
        }
    }

    @Override
    public VncVal first() {
        return this.isEmpty() ? Constants.Nil : (VncVal)this.value.head();
    }

    @Override
    public VncVal second() {
        return (VncVal)this.value.drop(1).head();
    }

    @Override
    public VncVal third() {
        return (VncVal)this.value.drop(2).head();
    }

    @Override
    public VncVal fourth() {
        return (VncVal)this.value.drop(3).head();
    }

    @Override
    public VncVal last() {
        throw new VncException("Getting the last element of a lazy sequence is not supported");
    }

    @Override
    public VncLazySeq rest() {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.drop(1), this.getMeta());
    }

    @Override
    public VncLazySeq butlast() {
        throw new VncException("Getting all but the last element of a lazy sequence is not supported");
    }

    @Override
    public VncLazySeq drop(int n) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.drop(n), this.getMeta());
    }

    @Override
    public VncLazySeq dropWhile(Predicate<? super VncVal> predicate) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.dropWhile(predicate), this.getMeta());
    }

    @Override
    public VncLazySeq take(int n) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.take(n), this.getMeta());
    }

    @Override
    public VncLazySeq takeWhile(Predicate<? super VncVal> predicate) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.takeWhile(predicate), this.getMeta());
    }

    @Override
    public VncLazySeq reverse() {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.reverse(), this.getMeta());
    }

    @Override
    public VncLazySeq shuffle() {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.shuffle(), this.getMeta());
    }

    @Override
    public VncLazySeq slice(int start, int end) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.subSequence(start, end), this.getMeta());
    }

    @Override
    public VncLazySeq slice(int start) {
        return new VncLazySeq((org.repackage.io.vavr.collection.Stream<VncVal>)this.value.subSequence(start), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value, this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value, this.getMeta());
    }

    @Override
    public VncLazySeq addAtStart(VncVal val) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq addAllAtStart(VncSequence list, boolean reverseAdd) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq addAtEnd(VncVal val) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq addAllAtEnd(VncSequence list) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq setAt(int idx, VncVal val) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public VncLazySeq removeAt(int idx) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.LAZYSEQ;
    }

    @Override
    public boolean isVncList() {
        return false;
    }

    @Override
    public Object convertToJavaObject() {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public int compareTo(VncVal o) {
        throw new VncException("Not supported for lazy sequences");
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncLazySeq other = (VncLazySeq)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.value.hasDefiniteSize() ? "(" + Printer.join(this, " ", true) + ")" : "(...)";
    }

    @Override
    public String toString(boolean print_readably) {
        return this.value.hasDefiniteSize() ? "(" + Printer.join(this, " ", print_readably) + ")" : "(...)";
    }

    public VncList realize() {
        return new VncList(this.value.toList(), this.getMeta());
    }

    public VncList realize(int n) {
        return new VncList(this.value.slice(0, n).toList(), this.getMeta());
    }

    public static VncLazySeq empty() {
        return new VncLazySeq(org.repackage.io.vavr.collection.Stream.empty(), (VncVal)Constants.Nil);
    }

    private static Option<VncVal> toOptional(VncVal val) {
        return val == Constants.Nil ? Option.none() : Option.of(val);
    }
}

