/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class VncMutableSet
extends VncSet {
    public static final VncKeyword TYPE = new VncKeyword(":core/mutable-map");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Set<VncVal> value = ConcurrentHashMap.newKeySet();

    public VncMutableSet() {
        this((Collection<? extends VncVal>)null, (VncVal)null);
    }

    public VncMutableSet(VncVal meta) {
        this((Collection<? extends VncVal>)null, meta);
    }

    public VncMutableSet(Collection<? extends VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        if (val != null) {
            this.value.addAll(val);
        }
    }

    public static VncMutableSet ofAll(Iterable<? extends VncVal> iter) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        for (VncVal vncVal : iter) {
            set.add(vncVal);
        }
        return new VncMutableSet(set, null);
    }

    public static VncMutableSet ofAll(Iterable<? extends VncVal> iter, VncVal meta) {
        ConcurrentHashMap.KeySetView set = ConcurrentHashMap.newKeySet();
        for (VncVal vncVal : iter) {
            set.add(vncVal);
        }
        return new VncMutableSet(set, meta);
    }

    public static VncMutableSet of(VncVal ... mvs) {
        return new VncMutableSet(Arrays.asList(mvs), null);
    }

    @Override
    public VncMutableSet emptyWithMeta() {
        return new VncMutableSet(this.getMeta());
    }

    @Override
    public VncMutableSet withValues(Collection<? extends VncVal> replaceVals) {
        return new VncMutableSet(replaceVals, this.getMeta());
    }

    @Override
    public VncMutableSet withValues(Collection<? extends VncVal> replaceVals, VncVal meta) {
        return new VncMutableSet(replaceVals, meta);
    }

    @Override
    public VncMutableSet withMeta(VncVal meta) {
        return new VncMutableSet(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSet.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSet.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public VncMutableSet add(VncVal val) {
        this.value.add(val);
        return this;
    }

    @Override
    public VncMutableSet addAll(VncSet val) {
        if (Types.isVncMutableSet(val)) {
            this.value.addAll(((VncMutableSet)val).value);
        } else {
            val.forEach(v -> this.value.add((VncVal)v));
        }
        return this;
    }

    @Override
    public VncMutableSet addAll(VncSequence seq) {
        for (VncVal v : seq) {
            this.value.add(v);
        }
        return this;
    }

    @Override
    public VncMutableSet remove(VncVal val) {
        this.value.remove(val);
        return this;
    }

    @Override
    public VncMutableSet removeAll(VncSet val) {
        if (Types.isVncMutableSet(val)) {
            this.value.removeAll(((VncMutableSet)val).value);
        } else {
            val.forEach(v -> this.value.remove(v));
        }
        return this;
    }

    @Override
    public VncMutableSet removeAll(VncSequence seq) {
        for (VncVal v : seq) {
            this.value.remove(v);
        }
        return this;
    }

    @Override
    public boolean contains(VncVal val) {
        return this.value.contains(val);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : this.value.iterator();
    }

    @Override
    public Stream<VncVal> stream() {
        return this.value.stream();
    }

    @Override
    public Set<VncVal> getJavaSet() {
        return Collections.unmodifiableSet(this.value);
    }

    @Override
    public List<VncVal> getJavaList() {
        return Collections.unmodifiableList(new ArrayList<VncVal>(this.value));
    }

    @Override
    public VncList toVncList() {
        return VncList.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.ofAll(this.stream(), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public void clear() {
        this.value.clear();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MUTABLESET;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncMutableSet(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncMutableSet)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncMutableSet other = (VncMutableSet)obj;
        return this.value.equals(other.value);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return "#{" + Printer.join(this.stream(), " ", print_readably) + "}";
    }
}

