/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncLazySeq;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyVector;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.EmptyIterator;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import com.github.jlangch.venice.impl.util.StreamUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VncTinyList
extends VncList {
    public static final VncKeyword TYPE = new VncKeyword(":core/list");
    public static final VncTinyList EMPTY = new VncTinyList();
    public static final int MAX_ELEMENTS = 4;
    private static final long serialVersionUID = -1848883965231344442L;
    private final int len;
    private final VncVal first;
    private final VncVal second;
    private final VncVal third;
    private final VncVal fourth;

    public VncTinyList() {
        this(null);
    }

    public VncTinyList(VncVal meta) {
        super(meta);
        this.len = 0;
        this.first = Constants.Nil;
        this.second = Constants.Nil;
        this.third = Constants.Nil;
        this.fourth = Constants.Nil;
    }

    private VncTinyList(int len, VncVal first, VncVal second, VncVal third, VncVal fourth, VncVal meta) {
        super(meta);
        this.len = len;
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static VncTinyList of(VncVal ... mvs) {
        switch (mvs.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new VncTinyList(1, mvs[0], Constants.Nil, Constants.Nil, Constants.Nil, null);
            }
            case 2: {
                return new VncTinyList(2, mvs[0], mvs[1], Constants.Nil, Constants.Nil, null);
            }
            case 3: {
                return new VncTinyList(3, mvs[0], mvs[1], mvs[2], Constants.Nil, null);
            }
            case 4: {
                return new VncTinyList(4, mvs[0], mvs[1], mvs[2], mvs[3], null);
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    public static VncTinyList ofArr(VncVal[] mvs, VncVal meta) {
        switch (mvs.length) {
            case 0: {
                return new VncTinyList(meta);
            }
            case 1: {
                return new VncTinyList(1, mvs[0], Constants.Nil, Constants.Nil, Constants.Nil, meta);
            }
            case 2: {
                return new VncTinyList(2, mvs[0], mvs[1], Constants.Nil, Constants.Nil, meta);
            }
            case 3: {
                return new VncTinyList(3, mvs[0], mvs[1], mvs[2], Constants.Nil, meta);
            }
            case 4: {
                return new VncTinyList(4, mvs[0], mvs[1], mvs[2], mvs[3], meta);
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList emptyWithMeta() {
        return new VncTinyList(this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals) {
        return replaceVals.size() < 4 ? VncTinyList.ofArr(replaceVals.toArray(new VncVal[0]), this.getMeta()) : VncList.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncList withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return replaceVals.size() < 4 ? VncTinyList.ofArr(replaceVals.toArray(new VncVal[0]), meta) : VncList.ofList(replaceVals, meta);
    }

    @Override
    public VncList withMeta(VncVal meta) {
        return new VncTinyList(this.len, this.first, this.second, this.third, this.fourth, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSequence.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSequence.TYPE, VncVal.TYPE);
    }

    @Override
    public Iterator<VncVal> iterator() {
        return this.isEmpty() ? EmptyIterator.empty() : new MappingIterator(this);
    }

    @Override
    public Stream<VncVal> stream() {
        return StreamUtil.stream(this.iterator());
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        this.iterator().forEachRemaining(action);
    }

    @Override
    public VncList filter(Predicate<? super VncVal> predicate) {
        ArrayList<VncVal> list = new ArrayList<VncVal>(this.len);
        if (this.len > 0) {
            if (predicate.test(this.first)) {
                list.add(this.first);
            }
            if (this.len > 1) {
                if (predicate.test(this.second)) {
                    list.add(this.second);
                }
                if (this.len > 2) {
                    if (predicate.test(this.third)) {
                        list.add(this.third);
                    }
                    if (this.len > 3 && predicate.test(this.fourth)) {
                        list.add(this.fourth);
                    }
                }
            }
        }
        return VncList.ofList(list, this.getMeta());
    }

    @Override
    public VncList map(Function<? super VncVal, ? extends VncVal> mapper) {
        ArrayList<VncVal> list = new ArrayList<VncVal>(this.len);
        if (this.len > 0) {
            list.add(mapper.apply(this.first));
            if (this.len > 1) {
                list.add(mapper.apply(this.second));
                if (this.len > 2) {
                    list.add(mapper.apply(this.third));
                    if (this.len > 3) {
                        list.add(mapper.apply(this.fourth));
                    }
                }
            }
        }
        return VncList.ofList(list, this.getMeta());
    }

    @Override
    public List<VncVal> getJavaList() {
        ArrayList<VncVal> list = new ArrayList<VncVal>(this.len);
        if (this.len > 0) {
            list.add(this.first);
            if (this.len > 1) {
                list.add(this.second);
                if (this.len > 2) {
                    list.add(this.third);
                    if (this.len > 3) {
                        list.add(this.fourth);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.len) {
            throw new VncException(String.format("nth: index %d out of range for a list of size %d. %s", idx, this.len, this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.first)));
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        if (idx < 0 || idx >= this.len) {
            return defaultVal;
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        return defaultVal;
    }

    @Override
    public VncVal first() {
        return this.first;
    }

    @Override
    public VncVal second() {
        return this.second;
    }

    @Override
    public VncVal third() {
        return this.third;
    }

    @Override
    public VncVal fourth() {
        return this.fourth;
    }

    @Override
    public VncVal last() {
        switch (this.len) {
            case 0: {
                return Constants.Nil;
            }
            case 1: {
                return this.first;
            }
            case 2: {
                return this.second;
            }
            case 3: {
                return this.third;
            }
            case 4: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList rest() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyList(this.getMeta());
            }
            case 2: {
                return new VncTinyList(1, this.second, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyList(2, this.second, this.third, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyList(3, this.second, this.third, this.fourth, Constants.Nil, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList butlast() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyList(this.getMeta());
            }
            case 2: {
                return new VncTinyList(1, this.first, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyList(2, this.first, this.second, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyList(3, this.first, this.second, this.third, Constants.Nil, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.len) {
            return EMPTY;
        }
        return this.slice(n);
    }

    @Override
    public VncList dropWhile(Predicate<? super VncVal> predicate) {
        List<VncVal> list = this.getJavaList();
        for (int i = 0; i < list.size(); ++i) {
            boolean drop = predicate.test(list.get(i));
            if (drop) continue;
            return VncList.ofList(list.subList(i, list.size()), this.getMeta());
        }
        return new VncTinyList(this.getMeta());
    }

    @Override
    public VncList take(int n) {
        return this.slice(0, n);
    }

    @Override
    public VncList takeWhile(Predicate<? super VncVal> predicate) {
        List<VncVal> list = this.getJavaList();
        for (int i = 0; i < list.size(); ++i) {
            boolean take = predicate.test(list.get(i));
            if (take) continue;
            return VncList.ofList(list.subList(0, i), this.getMeta());
        }
        return this;
    }

    @Override
    public VncList reverse() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyList(1, this.first, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyList(2, this.second, this.first, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyList(3, this.third, this.second, this.first, Constants.Nil, this.getMeta());
            }
            case 4: {
                return new VncTinyList(4, this.fourth, this.third, this.second, this.first, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncList shuffle() {
        List<VncVal> list = this.getJavaList();
        Collections.shuffle(list);
        return VncTinyList.ofAll(list, this.getMeta());
    }

    @Override
    public VncList slice(int start, int end) {
        if (start < 0) {
            throw new IllegalStateException("List index out of range");
        }
        if (start >= this.len || end <= start) {
            return EMPTY;
        }
        int len_ = Math.min(end, this.len) - start;
        VncVal[] vals = new VncVal[len_];
        for (int ii = 0; ii < len_; ++ii) {
            vals[ii] = this.nth(ii + start);
        }
        return VncTinyList.ofArr(vals, this.getMeta());
    }

    @Override
    public VncList slice(int start) {
        if (start < 0) {
            throw new IllegalStateException("List index out of range");
        }
        if (start >= this.len) {
            return EMPTY;
        }
        if (start == 0) {
            return this;
        }
        int len_ = this.len - start;
        VncVal[] vals = new VncVal[len_];
        for (int ii = 0; ii < len_; ++ii) {
            vals[ii] = this.nth(ii + start);
        }
        return VncTinyList.ofArr(vals, this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return this;
    }

    @Override
    public VncVector toVncVector() {
        switch (this.len) {
            case 0: {
                return new VncTinyVector(this.getMeta());
            }
            case 1: {
                return VncTinyVector.of(this.first).withMeta(this.getMeta());
            }
            case 2: {
                return VncTinyVector.of(this.first, this.second).withMeta(this.getMeta());
            }
            case 3: {
                return VncTinyVector.of(this.first, this.second, this.third).withMeta(this.getMeta());
            }
            case 4: {
                return VncTinyVector.of(this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("List length out of range");
    }

    @Override
    public VncList addAtStart(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyList(1, val, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 1: {
                return new VncTinyList(2, val, this.first, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyList(3, val, this.first, this.second, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyList(4, val, this.first, this.second, this.third, this.getMeta());
            }
            case 4: {
                return VncList.of(val, this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("List length out of range");
    }

    @Override
    public VncList addAllAtStart(VncSequence list, boolean reverseAdd) {
        if (!(list instanceof VncLazySeq)) {
            int otherLen = list.size();
            if (otherLen == 0) {
                return this;
            }
            if (otherLen + this.len <= 4 && !(list instanceof VncLazySeq)) {
                int ii;
                VncVal[] vals = new VncVal[otherLen + this.len];
                if (reverseAdd) {
                    for (ii = 0; ii < otherLen; ++ii) {
                        vals[ii] = list.nth(otherLen - ii - 1);
                    }
                } else {
                    for (ii = 0; ii < otherLen; ++ii) {
                        vals[ii] = list.nth(ii);
                    }
                }
                for (ii = 0; ii < this.len; ++ii) {
                    vals[ii + otherLen] = this.nth(ii);
                }
                return VncList.of(vals);
            }
        }
        VncSequence seq = reverseAdd ? list.reverse() : list;
        return VncList.ofAll(seq, this.getMeta()).addAllAtEnd(this);
    }

    @Override
    public VncList addAtEnd(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyList(1, val, Constants.Nil, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 1: {
                return new VncTinyList(2, this.first, val, Constants.Nil, Constants.Nil, this.getMeta());
            }
            case 2: {
                return new VncTinyList(3, this.first, this.second, val, Constants.Nil, this.getMeta());
            }
            case 3: {
                return new VncTinyList(4, this.first, this.second, this.third, val, this.getMeta());
            }
            case 4: {
                return VncList.of(this.first, this.second, this.third, this.fourth, val).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("List length out of range");
    }

    @Override
    public VncList addAllAtEnd(VncSequence list) {
        if (!(list instanceof VncLazySeq)) {
            int otherLen = list.size();
            if (otherLen == 0) {
                return this;
            }
            if (otherLen + this.len <= 4) {
                int ii;
                VncVal[] vals = new VncVal[otherLen + this.len];
                for (ii = 0; ii < this.len; ++ii) {
                    vals[ii] = this.nth(ii);
                }
                for (ii = 0; ii < otherLen; ++ii) {
                    vals[ii + this.len] = list.nth(ii);
                }
                return VncList.of(vals);
            }
        }
        return VncList.ofAll(this, this.getMeta()).addAllAtEnd(list);
    }

    @Override
    public VncList setAt(int idx, VncVal val) {
        if (idx < 0 || idx >= this.len) {
            throw new IllegalStateException("List index out of range");
        }
        VncVal[] vals = new VncVal[this.len];
        for (int ii = 0; ii < this.len; ++ii) {
            vals[ii] = this.nth(ii);
        }
        vals[idx] = val;
        return VncList.of(vals);
    }

    @Override
    public VncList removeAt(int idx) {
        int ii;
        if (idx < 0 || idx >= this.len) {
            throw new IllegalStateException("List index out of range");
        }
        if (this.len == 1) {
            return this.emptyWithMeta();
        }
        VncVal[] vals = new VncVal[this.len - 1];
        for (ii = 0; ii < idx; ++ii) {
            vals[ii] = this.nth(ii);
        }
        for (ii = idx + 1; ii < this.len; ++ii) {
            vals[ii - 1] = this.nth(ii);
        }
        return VncTinyList.ofArr(vals, this.getMeta());
    }

    @Override
    public Object convertToJavaObject() {
        return this.stream().map((? super T v) -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncVector)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.len;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.third == null ? 0 : this.third.hashCode());
        result = 31 * result + (this.fourth == null ? 0 : this.fourth.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncTinyList other = (VncTinyList)obj;
        if (this.len != other.len) {
            return false;
        }
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        if (this.third == null ? other.third != null : !this.third.equals(other.third)) {
            return false;
        }
        return !(this.fourth == null ? other.fourth != null : !this.fourth.equals(other.fourth));
    }

    @Override
    public String toString() {
        return "(" + Printer.join(this, " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this, " ", print_readably) + ")";
    }

    private static class MappingIterator
    implements Iterator<VncVal> {
        private int index;
        private final VncTinyList value;

        public MappingIterator(VncTinyList value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.value.len;
        }

        @Override
        public VncVal next() {
            return this.value.nth(this.index++);
        }

        public String toString() {
            return "MappingIterator()";
        }
    }
}

