/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.impl.specialforms.SpecialFormsDoc;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.stream.Collectors;

public class ArityExceptions {
    public static void assertArity(VncFunction fn, VncList args, int expectedArity) {
        int arity = args.size();
        if (expectedArity != arity) {
            throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
        }
    }

    public static void assertArity(VncFunction fn, VncList args, int expectedArity1, int expectedArity2) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity) {
            return;
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
    }

    public static void assertArity(VncFunction fn, VncList args, int expectedArity1, int expectedArity2, int expectedArity3) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity || expectedArity3 == arity) {
            return;
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
    }

    public static void assertArity(VncFunction fn, VncList args, int expectedArity1, int expectedArity2, int expectedArity3, int expectedArity4) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity || expectedArity3 == arity || expectedArity4 == arity) {
            return;
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
    }

    public static void assertArity(VncFunction fn, VncList args, int expectedArity1, int expectedArity2, int expectedArity3, int expectedArity4, int expectedArity5) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity || expectedArity3 == arity || expectedArity4 == arity || expectedArity5 == arity) {
            return;
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
    }

    public static void assertArities(VncFunction fn, VncList args, int ... expectedArities) {
        int arity = args.size();
        if (expectedArities.length == 1) {
            if (arity == expectedArities[0]) {
                return;
            }
        } else {
            for (int a : expectedArities) {
                if (a != arity) continue;
                return;
            }
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
    }

    public static void assertArity(IVncFunction fn, FnType fnType, VncList args, int expectedArity1, int expectedArity2) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity) {
            return;
        }
        if (fn instanceof VncFunction) {
            throw new ArityException(ArityExceptions.formatArityExMsg(((VncFunction)fn).getQualifiedName(), ArityExceptions.toFnType((VncFunction)fn), arity, fn.getArgLists()));
        }
        if (fn instanceof VncKeyword) {
            throw new ArityException(ArityExceptions.formatArityExMsg(fn.toString(), fnType, arity, fn.getArgLists()));
        }
        if (fn instanceof VncMap) {
            throw new ArityException(ArityExceptions.formatArityExMsg("map", fnType, arity, fn.getArgLists()));
        }
        if (fn instanceof VncSet) {
            throw new ArityException(ArityExceptions.formatArityExMsg("set", fnType, arity, fn.getArgLists()));
        }
        if (fn instanceof VncVector) {
            throw new ArityException(ArityExceptions.formatArityExMsg("vector", fnType, arity, fn.getArgLists()));
        }
        throw new ArityException(ArityExceptions.formatArityExMsg("unnamed", fnType, arity, fn.getArgLists()));
    }

    public static void assertArity(String fnName, FnType fnType, VncList args, int expectedArity1) {
        int arity = args.size();
        if (expectedArity1 == arity) {
            return;
        }
        if (fnType == FnType.SpecialForm) {
            VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(fnName));
            throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity, fn.getArgLists()));
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity));
    }

    public static void assertArity(String fnName, FnType fnType, VncList args, int expectedArity1, int expectedArity2) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity) {
            return;
        }
        if (fnType == FnType.SpecialForm) {
            VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(fnName));
            throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity, fn.getArgLists()));
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity));
    }

    public static void assertArity(String fnName, FnType fnType, VncList args, int expectedArity1, int expectedArity2, int expectedArity3) {
        int arity = args.size();
        if (expectedArity1 == arity || expectedArity2 == arity || expectedArity3 == arity) {
            return;
        }
        if (fnType == FnType.SpecialForm) {
            VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(fnName));
            throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity, fn.getArgLists()));
        }
        throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity));
    }

    public static void assertMinArity(VncFunction fn, VncList args, int minArity) {
        int arity = args.size();
        if (arity < minArity) {
            throw new ArityException(ArityExceptions.formatArityExMsg(fn.getQualifiedName(), ArityExceptions.toFnType(fn), arity, fn.getArgLists()));
        }
    }

    public static void assertMinArity(String fnName, FnType fnType, VncList args, int minArity) {
        int arity = args.size();
        if (arity < minArity) {
            if (fnType == FnType.SpecialForm) {
                VncFunction fn = (VncFunction)SpecialFormsDoc.ns.get(new VncSymbol(fnName));
                throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity, fn.getArgLists()));
            }
            throw new ArityException(ArityExceptions.formatArityExMsg(fnName, fnType, arity));
        }
    }

    public static String formatArityExMsg(String fnName, FnType fnType, int arity) {
        return ArityExceptions.formatArityExMsg(fnName, fnType, arity, VncList.empty());
    }

    public static String formatArityExMsg(String fnName, FnType fnType, int arity, VncList argList) {
        return String.format("Wrong number of args (%d) passed to %s %s.%s", arity, ArityExceptions.toString(fnType), fnName, ArityExceptions.formatArgList(argList));
    }

    public static String formatArityExMsg(String fnName, FnType fnType, int arity, int expectedArgs, VncList argList) {
        return String.format("Wrong number of args (%d) passed to %s %s. Expected %d arg%s.%s", arity, ArityExceptions.toString(fnType), fnName, expectedArgs, expectedArgs == 1 ? "" : "s", ArityExceptions.formatArgList(argList));
    }

    public static String formatVariadicArityExMsg(String fnName, FnType fnType, int arity, int fixedArgsCount, VncList argList) {
        return String.format("Wrong number of args (%d) passed to the variadic %s %s that requires at least %d arg%s.%s", arity, ArityExceptions.toString(fnType), fnName, fixedArgsCount, fixedArgsCount == 1 ? "" : "s", ArityExceptions.formatArgList(argList));
    }

    private static String formatArgList(VncList argList) {
        return argList.isEmpty() ? "" : String.format("\n\n[Arg List]\n%s", argList.stream().map(it -> "    " + it.toString()).collect(Collectors.joining("\n")));
    }

    private static FnType toFnType(VncFunction fn) {
        return fn.isMacro() ? FnType.Macro : FnType.Function;
    }

    private static String toString(FnType fnType) {
        FnType type = fnType == null ? FnType.Function : fnType;
        switch (type) {
            case Function: {
                return "function";
            }
            case Macro: {
                return "macro";
            }
            case SpecialForm: {
                return "special form";
            }
            case Collection: {
                return "collection (as function)";
            }
            case Keyword: {
                return "keyword (as function)";
            }
        }
        return "function";
    }

    public static enum FnType {
        Function,
        Macro,
        SpecialForm,
        Collection,
        Keyword;

    }
}

